/****************************************************************************
** $Id:  cmds/cmdgriponlyrotate.h
** AutoQ3D a qt 3d model editor program
**
** Copyright (C) 2005-2007 -Gonzalo Reynaga Garcia. <gonzaloreynaga@yahoo.com>
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public Licence
** as published by the Free Software Foundation; either version 2 
** of the License, or (at your option) any later option.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
** 
*****************************************************************************/

#ifndef CMDGRIPONLYROTATE_H
#define CMDGRIPONLYROTATE_H
#include "cmds.h"


void cmds::cmdgriponlyrotate(){
	int i,j,k;
	d3line *DLV;
	d3triangle *DTV;
	DLV=DataLV->data();
	DTV=DataTV->data();
	double var[4];
	var[0]=var[1]=var[2]=0;
	if((SecCmd==tr("**Cancel**")||SecCmd=="")&&!PopViewMode){
			SendText(SecCmd);
			CmdCancel();
			return;
	}

	switch(step){
		
		case 0:
				SendText(tr("--Grip-Rotate--"));instruction=tr("Rotate [Base point/Copy/Reference]:");emit instru(instruction);
				tempdataI[0]=0;tempdataF[0]=0;tempdataF[1]=0;tempdataF[2]=0;tempdataF[3]=1;tempdataF[4]=0;
				for(i=0;i<DataSV.size();i++){
					if(DataSV[i].type==1){
						DataSLV.resize(DataSLV.size()+1);j=DataSLV.size()-1;
						DataSLV[j].v1[0]=DLV[DataSV[i].index].v1[0]-currentpoint->v[0];
						DataSLV[j].v2[0]=DLV[DataSV[i].index].v2[0]-currentpoint->v[0];
						DataSLV[j].v1[1]=DLV[DataSV[i].index].v1[1]-currentpoint->v[1];
						DataSLV[j].v2[1]=DLV[DataSV[i].index].v2[1]-currentpoint->v[1];
						DataSLV[j].v1[2]=DLV[DataSV[i].index].v1[2];
						DataSLV[j].v2[2]=DLV[DataSV[i].index].v2[2];
						DataSLV[j].c1[0]=DLV[DataSV[i].index].c1[0];DataSLV[j].c2[0]=DLV[DataSV[i].index].c2[0];
						DataSLV[j].c1[1]=DLV[DataSV[i].index].c1[1];DataSLV[j].c2[1]=DLV[DataSV[i].index].c2[1];
						DataSLV[j].c1[2]=DLV[DataSV[i].index].c1[2];DataSLV[j].c2[2]=DLV[DataSV[i].index].c2[2];
						
					}
					if(DataSV[i].type==2){
						DataSTV.resize(DataSTV.size()+1);j=DataSTV.size()-1;k=DataSV[i].index;
						DataSTV[j].v1[0]=DTV[k].v1[0]-currentpoint->v[0];
						DataSTV[j].v2[0]=DTV[k].v2[0]-currentpoint->v[0];
						DataSTV[j].v3[0]=DTV[k].v3[0]-currentpoint->v[0];
						DataSTV[j].v1[1]=DTV[k].v1[1]-currentpoint->v[1];
						DataSTV[j].v2[1]=DTV[k].v2[1]-currentpoint->v[1];
						DataSTV[j].v3[1]=DTV[k].v3[1]-currentpoint->v[1];
						DataSTV[j].v1[2]=DTV[k].v1[2];
						DataSTV[j].v2[2]=DTV[k].v2[2];
						DataSTV[j].v3[2]=DTV[k].v3[2];
						DataSTV[j].texture=DTV[k].texture;
						DataSTV[j].t1[0]=DTV[k].t1[0];DataSTV[j].t1[1]=DTV[k].t1[1];
						DataSTV[j].t2[0]=DTV[k].t2[0];DataSTV[j].t2[1]=DTV[k].t2[1];
						DataSTV[j].t3[0]=DTV[k].t3[0];DataSTV[j].t3[1]=DTV[k].t3[1];
						DataSTV[j].c1[0]=DTV[k].c1[0];DataSTV[j].c2[0]=DTV[k].c2[0];DataSTV[j].c3[0]=DTV[k].c3[0];
						DataSTV[j].c1[1]=DTV[k].c1[1];DataSTV[j].c2[1]=DTV[k].c2[1];DataSTV[j].c3[1]=DTV[k].c3[1];
						DataSTV[j].c1[2]=DTV[k].c1[2];DataSTV[j].c2[2]=DTV[k].c2[2];DataSTV[j].c3[2]=DTV[k].c3[2];
						DataSTV[j].n1[0]=DTV[k].n1[0];DataSTV[j].n2[0]=DTV[k].n2[0];DataSTV[j].n3[0]=DTV[k].n3[0];
						DataSTV[j].n1[1]=DTV[k].n1[1];DataSTV[j].n2[1]=DTV[k].n2[1];DataSTV[j].n3[1]=DTV[k].n3[1];
						DataSTV[j].n1[2]=DTV[k].n1[2];DataSTV[j].n2[2]=DTV[k].n2[2];DataSTV[j].n3[2]=DTV[k].n3[2];
					}
				}
				rtlines->v[0]=currentpoint->v[0];rtlines->v[1]=currentpoint->v[1];rtlines->v[2]=0;
				rtcolor[0]=currentcolor[0];rtcolor[1]=currentcolor[1];rtcolor[2]=currentcolor[2];
				rtlines[0].find=1;
				step++;
				emit SetMouseMode(MOUSEMODE_PICKPOINT);
				return;
		break;
		
		case 1:
			if(CmdSelectPopView()){return;}
			if(CmdCheckSnap()){return;}
			
			if(!SecCmd.compare(tr("c","Copy"))||!SecCmd.compare(tr("C","Copy"))){
				tempdataI[0]=1;
				SendText(tr("Copy"));
				return;
			}
			
			if(!SecCmd.compare(tr("r"))||!SecCmd.compare(tr("R"))){
				SendText(tr("Reference"));emit instru(tr("Rotate (Reference):"));
				DataSLV.resize(0);DataSTV.resize(0);
				rtlines[0].find=0;
				step=3;
				return;
			}
			
			if(!SecCmd.compare(tr("b"))||!SecCmd.compare(tr("B"))){
				SendText(tr("Base point"));emit instru(tr("Rotate (Base point):"));
				DataSLV.resize(0);DataSTV.resize(0);
				rtlines[0].find=0;
				step=2;
				return;
			}
			
			if(!SecCmd.compare("setCmdData")){
				if(currentdata.format>2){
						SendText(tr("Data reject"));
						return;
				}
				
				if(currentdata.format==0){/*Global*/
					var[0]=currentdata.v[0]-GriPoint->v[0];var[1]=currentdata.v[1]-GriPoint->v[1];
					var[2]=sqrt(var[0]*var[0]+var[1]*var[1]);
				}
					
				if(currentdata.format==1){/*Relativa ("@")*/
					var[0]=currentdata.v[0];var[1]=currentdata.v[1];
					var[2]=sqrt(var[0]*var[0]+var[1]*var[1]);
				}
				
				if(currentdata.format==2){
					var[0]=cosf(currentdata.v[0]*M_PI/180.0);var[1]=sinf(currentdata.v[0]*M_PI/180.0);
					var[2]=1;
				}
				if(var[2]){
				if(tempdataI[0]){/*//////Copy?(y/n)/////*/
					for(i=0;i<DataSLV.size();i++){
						j=DataLV->size();DataLV->resize(j+1);DLV=DataLV->data();
						DLV[j].v1[0]=GriPoint->v[0]+(DataSLV[i].v1[0]*var[0]-DataSLV[i].v1[1]*var[1])/var[2];
						DLV[j].v1[1]=GriPoint->v[1]+(DataSLV[i].v1[1]*var[0]+DataSLV[i].v1[0]*var[1])/var[2];
						DLV[j].v1[2]=DataSLV[i].v1[2];
						DLV[j].v2[0]=GriPoint->v[0]+(DataSLV[i].v2[0]*var[0]-DataSLV[i].v2[1]*var[1])/var[2];
						DLV[j].v2[1]=GriPoint->v[1]+(DataSLV[i].v2[1]*var[0]+DataSLV[i].v2[0]*var[1])/var[2];
						DLV[j].v2[2]=DataSLV[i].v2[2];
						DLV[j].c1[0]=DataSLV[i].c1[0];DLV[j].c1[1]=DataSLV[i].c1[1];DLV[j].c1[2]=DataSLV[i].c1[2];
						DLV[j].c2[0]=DataSLV[i].c2[0];DLV[j].c2[1]=DataSLV[i].c2[1];DLV[j].c2[2]=DataSLV[i].c2[2];
					}
					
					for(j=0;j<DataSTV.size();j++){
						i=DataTV->size();DataTV->resize(i+1);DTV=DataTV->data();
						
						DTV[i].v1[0]=GriPoint->v[0]+(DataSTV[j].v1[0]*var[0]-DataSTV[j].v1[1]*var[1])/var[2];
						DTV[i].v1[1]=GriPoint->v[1]+(DataSTV[j].v1[1]*var[0]+DataSTV[j].v1[0]*var[1])/var[2];
						DTV[i].v1[2]=DataSTV[j].v1[2];
						
						DTV[i].v2[0]=GriPoint->v[0]+(DataSTV[j].v2[0]*var[0]-DataSTV[j].v2[1]*var[1])/var[2];
						DTV[i].v2[1]=GriPoint->v[1]+(DataSTV[j].v2[1]*var[0]+DataSTV[j].v2[0]*var[1])/var[2];
						DTV[i].v2[2]=DataSTV[j].v2[2];
						
						DTV[i].v3[0]=GriPoint->v[0]+(DataSTV[j].v3[0]*var[0]-DataSTV[j].v3[1]*var[1])/var[2];
						DTV[i].v3[1]=GriPoint->v[1]+(DataSTV[j].v3[1]*var[0]+DataSTV[j].v3[0]*var[1])/var[2];
						DTV[i].v3[2]=DataSTV[j].v3[2];
						
						
						DTV[i].n1[0]=((DataSTV[j].v1[0]+DataSTV[j].n1[0])*var[0]-(DataSTV[j].v1[1]+DataSTV[j].n1[1])*var[1])/var[2];
						DTV[i].n1[1]=((DataSTV[j].v1[1]+DataSTV[j].n1[1])*var[0]+(DataSTV[j].v1[0]+DataSTV[j].n1[0])*var[1])/var[2];
						DTV[i].n1[2]=DataSTV[j].v1[2]+DataSTV[j].n1[2];
						
						DTV[i].n2[0]=((DataSTV[j].v2[0]+DataSTV[j].n2[0])*var[0]-(DataSTV[j].v2[1]+DataSTV[j].n2[1])*var[1])/var[2];
						DTV[i].n2[1]=((DataSTV[j].v2[1]+DataSTV[j].n2[1])*var[0]+(DataSTV[j].v2[0]+DataSTV[j].n2[0])*var[1])/var[2];
						DTV[i].n2[2]=DataSTV[j].v2[2]+DataSTV[j].n2[2];
						
						DTV[i].n3[0]=((DataSTV[j].v3[0]+DataSTV[j].n3[0])*var[0]-(DataSTV[j].v3[1]+DataSTV[j].n3[1])*var[1])/var[2];
						DTV[i].n3[1]=((DataSTV[j].v3[1]+DataSTV[j].n3[1])*var[0]+(DataSTV[j].v3[0]+DataSTV[j].n3[0])*var[1])/var[2];
						DTV[i].n3[2]=DataSTV[j].v3[2]+DataSTV[j].n3[2];
		DTV[i].n1[0]-=DTV[i].v1[0];DTV[i].n1[1]-=DTV[i].v1[1];DTV[i].n1[2]-=DTV[i].v1[2];
		DTV[i].n2[0]-=DTV[i].v2[0];DTV[i].n2[1]-=DTV[i].v2[1];DTV[i].n2[2]-=DTV[i].v2[2];
		DTV[i].n3[0]-=DTV[i].v3[0];DTV[i].n3[1]-=DTV[i].v3[1];DTV[i].n3[2]-=DTV[i].v3[2];
						
				var[3]=sqrt(DTV[i].n1[0]*DTV[i].n1[0]+DTV[i].n1[1]*DTV[i].n1[1]+DTV[i].n1[2]*DTV[i].n1[2]);
				DTV[i].n1[0]/=var[3];DTV[i].n1[1]/=var[3];DTV[i].n1[2]/=var[3];
				var[3]=sqrt(DTV[i].n2[0]*DTV[i].n2[0]+DTV[i].n2[1]*DTV[i].n2[1]+DTV[i].n2[2]*DTV[i].n2[2]);
				DTV[i].n2[0]/=var[3];DTV[i].n2[1]/=var[3];DTV[i].n2[2]/=var[3];
				var[3]=sqrt(DTV[i].n3[0]*DTV[i].n3[0]+DTV[i].n3[1]*DTV[i].n3[1]+DTV[i].n3[2]*DTV[i].n3[2]);
				DTV[i].n3[0]/=var[3];DTV[i].n3[1]/=var[3];DTV[i].n3[2]/=var[3];
						
						
						DTV[i].texture=DataSTV[j].texture;
						DTV[i].t1[0]=DataSTV[j].t1[0];DTV[i].t1[1]=DataSTV[j].t1[1];
						DTV[i].t2[0]=DataSTV[j].t2[0];DTV[i].t2[1]=DataSTV[j].t2[1];
						DTV[i].t3[0]=DataSTV[j].t3[0];DTV[i].t3[1]=DataSTV[j].t3[1];
						
						DTV[i].c1[0]=DataSTV[j].c1[0];DTV[i].c1[1]=DataSTV[j].c1[1];DTV[i].c1[2]=DataSTV[j].c1[2];
						DTV[i].c2[0]=DataSTV[j].c2[0];DTV[i].c2[1]=DataSTV[j].c2[1];DTV[i].c2[2]=DataSTV[j].c2[2];
						DTV[i].c3[0]=DataSTV[j].c3[0];DTV[i].c3[1]=DataSTV[j].c3[1];DTV[i].c3[2]=DataSTV[j].c3[2];
					}
	
				}else{
					for(i=0,j=0,k=0;i<DataSV.size();i++){
					if(DataSV[i].type==1){
						DLV[DataSV[i].index].v1[0]=GriPoint->v[0]+(DataSLV[j].v1[0]*var[0]-DataSLV[j].v1[1]*var[1])/var[2];
						DLV[DataSV[i].index].v1[1]=GriPoint->v[1]+(DataSLV[j].v1[1]*var[0]+DataSLV[j].v1[0]*var[1])/var[2];
						DLV[DataSV[i].index].v2[0]=GriPoint->v[0]+(DataSLV[j].v2[0]*var[0]-DataSLV[j].v2[1]*var[1])/var[2];
						DLV[DataSV[i].index].v2[1]=GriPoint->v[1]+(DataSLV[j].v2[1]*var[0]+DataSLV[j].v2[0]*var[1])/var[2];
						j++;
					}
					if(DataSV[i].type==2){
		/*SendText(QString("Sel %1,Tri %2").arg(i).arg(DataSV[i].index));
		SendText(QString("%1,%2,%3").arg(DTV[DataSV[i].index].v2[0]).arg(DTV[DataSV[i].index].v2[1]).arg(DTV[DataSV[i].index].v2[2]));*/
						DTV[DataSV[i].index].v1[0]=GriPoint->v[0]+(DataSTV[k].v1[0]*var[0]-DataSTV[k].v1[1]*var[1])/var[2];
						DTV[DataSV[i].index].v1[1]=GriPoint->v[1]+(DataSTV[k].v1[1]*var[0]+DataSTV[k].v1[0]*var[1])/var[2];

						DTV[DataSV[i].index].v2[0]=GriPoint->v[0]+(DataSTV[k].v2[0]*var[0]-DataSTV[k].v2[1]*var[1])/var[2];
						DTV[DataSV[i].index].v2[1]=GriPoint->v[1]+(DataSTV[k].v2[1]*var[0]+DataSTV[k].v2[0]*var[1])/var[2];

						DTV[DataSV[i].index].v3[0]=GriPoint->v[0]+(DataSTV[k].v3[0]*var[0]-DataSTV[k].v3[1]*var[1])/var[2];
						DTV[DataSV[i].index].v3[1]=GriPoint->v[1]+(DataSTV[k].v3[1]*var[0]+DataSTV[k].v3[0]*var[1])/var[2];
		/*SendText(QString("%1,%2,%3").arg(DTV[DataSV[i].index].v2[0]).arg(DTV[DataSV[i].index].v2[1]).arg(DTV[DataSV[i].index].v2[2]));*/
			
	DTV[DataSV[i].index].n1[0]=((DataSTV[k].v1[0]+DataSTV[k].n1[0])*var[0]-(DataSTV[k].v1[1]+DataSTV[k].n1[1])*var[1])/var[2];
	DTV[DataSV[i].index].n1[1]=((DataSTV[k].v1[1]+DataSTV[k].n1[1])*var[0]+(DataSTV[k].v1[0]+DataSTV[k].n1[0])*var[1])/var[2];
	DTV[DataSV[i].index].n1[2]=DataSTV[k].v1[2]+DataSTV[k].n1[2];

	DTV[DataSV[i].index].n2[0]=((DataSTV[k].v2[0]+DataSTV[k].n2[0])*var[0]-(DataSTV[k].v2[1]+DataSTV[k].n2[1])*var[1])/var[2];
	DTV[DataSV[i].index].n2[1]=((DataSTV[k].v2[1]+DataSTV[k].n2[1])*var[0]+(DataSTV[k].v2[0]+DataSTV[k].n2[0])*var[1])/var[2];
	DTV[DataSV[i].index].n2[2]=DataSTV[k].v2[2]+DataSTV[k].n2[2];

	DTV[DataSV[i].index].n3[0]=((DataSTV[k].v3[0]+DataSTV[k].n3[0])*var[0]-(DataSTV[k].v3[1]+DataSTV[k].n3[1])*var[1])/var[2];
	DTV[DataSV[i].index].n3[1]=((DataSTV[k].v3[1]+DataSTV[k].n3[1])*var[0]+(DataSTV[k].v3[0]+DataSTV[k].n3[0])*var[1])/var[2];
	DTV[DataSV[i].index].n3[2]=DataSTV[k].v3[2]+DataSTV[k].n3[2];
	
	DTV[DataSV[i].index].n1[0]-=DTV[DataSV[i].index].v1[0];
	DTV[DataSV[i].index].n1[1]-=DTV[DataSV[i].index].v1[1];
	DTV[DataSV[i].index].n1[2]-=DTV[DataSV[i].index].v1[2];
	
	DTV[DataSV[i].index].n2[0]-=DTV[DataSV[i].index].v2[0];
	DTV[DataSV[i].index].n2[1]-=DTV[DataSV[i].index].v2[1];
	DTV[DataSV[i].index].n2[2]-=DTV[DataSV[i].index].v2[2];
	
	DTV[DataSV[i].index].n3[0]-=DTV[DataSV[i].index].v3[0];
	DTV[DataSV[i].index].n3[1]-=DTV[DataSV[i].index].v3[1];
	DTV[DataSV[i].index].n3[2]-=DTV[DataSV[i].index].v3[2];
		
var[3]=sqrt(DTV[DataSV[i].index].n1[0]*DTV[DataSV[i].index].n1[0]+DTV[DataSV[i].index].n1[1]*DTV[DataSV[i].index].n1[1]+DTV[DataSV[i].index].n1[2]*DTV[DataSV[i].index].n1[2]);
DTV[DataSV[i].index].n1[0]/=var[3];DTV[DataSV[i].index].n1[1]/=var[3];DTV[DataSV[i].index].n1[2]/=var[3];
var[3]=sqrt(DTV[DataSV[i].index].n2[0]*DTV[DataSV[i].index].n2[0]+DTV[DataSV[i].index].n2[1]*DTV[DataSV[i].index].n2[1]+DTV[DataSV[i].index].n2[2]*DTV[DataSV[i].index].n2[2]);
DTV[DataSV[i].index].n2[0]/=var[3];DTV[DataSV[i].index].n2[1]/=var[3];DTV[DataSV[i].index].n2[2]/=var[3];
var[3]=sqrt(DTV[DataSV[i].index].n3[0]*DTV[DataSV[i].index].n3[0]+DTV[DataSV[i].index].n3[1]*DTV[DataSV[i].index].n3[1]+DTV[DataSV[i].index].n3[2]*DTV[DataSV[i].index].n3[2]);
DTV[DataSV[i].index].n3[0]/=var[3];DTV[DataSV[i].index].n3[1]/=var[3];DTV[DataSV[i].index].n3[2]/=var[3];
	
						k++;
					}
					}
				CmdCancel();
				}
				}
			
			/*DataSV.resize(0);*/
			
			return;
			}
			
		break;
		case 2: /*SET BASE POINT STATE*/
			if(CmdSelectPopView()){return;}
			if(CmdCheckSnap()){return;}
			
			if(!SecCmd.compare("setCmdData")){
				if(currentdata.format>1){
						SendText(tr("Data reject"));
						return;
				}
				if(currentdata.format==0){
					GriPoint->v[0]=currentdata.v[0];GriPoint->v[1]=currentdata.v[1];GriPoint->v[2]=currentdata.v[2];
				}
				if(currentdata.format==1){
					GriPoint->v[0]+=currentdata.v[0];GriPoint->v[1]+=currentdata.v[1];GriPoint->v[2]+=currentdata.v[2];
				}
				var[0]=tempdataF[3];var[1]=tempdataF[4];var[2]=sqrt(var[0]*var[0]+var[1]*var[1]);
				if(var[2]){
				for(i=0;i<DataSV.size();i++){
					if(DataSV[i].type==1){
						DataSLV.resize(DataSLV.size()+1);j=DataSLV.size()-1;k=DataSV[i].index;
						DataSLV[j].v1[2]=DLV[k].v1[2];
						DataSLV[j].v2[2]=DLV[k].v2[2];
						DataSLV[j].v1[0]=((DLV[k].v1[0]-GriPoint->v[0])*var[0]-(DLV[k].v1[1]-GriPoint->v[1])*var[1])/var[2];
						DataSLV[j].v1[1]=((DLV[k].v1[1]-GriPoint->v[1])*var[0]+(DLV[k].v1[0]-GriPoint->v[0])*var[1])/var[2];
						DataSLV[j].v2[0]=((DLV[k].v2[0]-GriPoint->v[0])*var[0]-(DLV[k].v2[1]-GriPoint->v[1])*var[1])/var[2];
						DataSLV[j].v2[1]=((DLV[k].v2[1]-GriPoint->v[1])*var[0]+(DLV[k].v2[0]-GriPoint->v[0])*var[1])/var[2];
						
						DataSLV[j].c1[0]=DLV[k].c1[0];DataSLV[j].c2[0]=DLV[k].c2[0];
						DataSLV[j].c1[1]=DLV[k].c1[1];DataSLV[j].c2[1]=DLV[k].c2[1];
						DataSLV[j].c1[2]=DLV[k].c1[2];DataSLV[j].c2[2]=DLV[k].c2[2];
						
					}
					if(DataSV[i].type==2){
						DataSTV.resize(DataSTV.size()+1);j=DataSTV.size()-1;k=DataSV[i].index;
						DataSTV[j].v1[2]=DTV[k].v1[2];
						DataSTV[j].v2[2]=DTV[k].v2[2];
						DataSTV[j].v3[2]=DTV[k].v3[2];
						DataSTV[j].v1[0]=((DTV[k].v1[0]-GriPoint->v[0])*var[0]-(DTV[k].v1[1]-GriPoint->v[1])*var[1])/var[2];
						DataSTV[j].v1[1]=((DTV[k].v1[1]-GriPoint->v[1])*var[0]+(DTV[k].v1[0]-GriPoint->v[0])*var[1])/var[2];
						DataSTV[j].v2[0]=((DTV[k].v2[0]-GriPoint->v[0])*var[0]-(DTV[k].v2[1]-GriPoint->v[1])*var[1])/var[2];
						DataSTV[j].v2[1]=((DTV[k].v2[1]-GriPoint->v[1])*var[0]+(DTV[k].v2[0]-GriPoint->v[0])*var[1])/var[2];
						DataSTV[j].v3[0]=((DTV[k].v3[0]-GriPoint->v[0])*var[0]-(DTV[k].v3[1]-GriPoint->v[1])*var[1])/var[2];
						DataSTV[j].v3[1]=((DTV[k].v3[1]-GriPoint->v[1])*var[0]+(DTV[k].v3[0]-GriPoint->v[0])*var[1])/var[2];

		DataSTV[j].n1[0]=((DTV[k].v1[0]+DTV[k].n1[0]-GriPoint->v[0])*var[0]-(DTV[k].v1[1]+DTV[k].n1[1]-GriPoint->v[1])*var[1])/var[2];
		DataSTV[j].n1[1]=((DTV[k].v1[1]+DTV[k].n1[1]-GriPoint->v[1])*var[0]+(DTV[k].v1[0]+DTV[k].n1[0]-GriPoint->v[0])*var[1])/var[2];
		DataSTV[j].n1[2]=DTV[k].v1[2]+DTV[k].n1[2]-GriPoint->v[2];
		DataSTV[j].n2[0]=((DTV[k].v2[0]+DTV[k].n2[0]-GriPoint->v[0])*var[0]-(DTV[k].v2[1]+DTV[k].n2[1]-GriPoint->v[1])*var[1])/var[2];
		DataSTV[j].n2[1]=((DTV[k].v2[1]+DTV[k].n2[1]-GriPoint->v[1])*var[0]+(DTV[k].v2[0]+DTV[k].n2[0]-GriPoint->v[0])*var[1])/var[2];
		DataSTV[j].n2[2]=DTV[k].v2[2]+DTV[k].n2[2]-GriPoint->v[2];
		DataSTV[j].n3[0]=((DTV[k].v3[0]+DTV[k].n3[0]-GriPoint->v[0])*var[0]-(DTV[k].v3[1]+DTV[k].n3[1]-GriPoint->v[1])*var[1])/var[2];
		DataSTV[j].n3[1]=((DTV[k].v3[1]+DTV[k].n3[1]-GriPoint->v[1])*var[0]+(DTV[k].v3[0]+DTV[k].n3[0]-GriPoint->v[0])*var[1])/var[2];
		DataSTV[j].n3[2]=DTV[k].v3[2]+DTV[k].n3[2]-GriPoint->v[2];
		
	DataSTV[j].n1[0]+=GriPoint->v[0]-DTV[k].v1[0];DataSTV[j].n1[1]+=GriPoint->v[1]-DTV[k].v1[1];DataSTV[j].n1[2]+=GriPoint->v[2]-DTV[k].v1[2];
	DataSTV[j].n2[0]+=GriPoint->v[0]-DTV[k].v2[0];DataSTV[j].n2[1]+=GriPoint->v[1]-DTV[k].v2[1];DataSTV[j].n2[2]+=GriPoint->v[2]-DTV[k].v2[2];
	DataSTV[j].n3[0]+=GriPoint->v[0]-DTV[k].v3[0];DataSTV[j].n3[1]+=GriPoint->v[1]-DTV[k].v3[1];DataSTV[j].n3[2]+=GriPoint->v[2]-DTV[k].v3[2];
		
				var[3]=sqrt(DataSTV[j].n1[0]*DataSTV[j].n1[0]+DataSTV[j].n1[1]*DataSTV[j].n1[1]+DataSTV[j].n1[2]*DataSTV[j].n1[2]);
				DataSTV[j].n1[0]/=var[3];DataSTV[j].n1[1]/=var[3];DataSTV[j].n1[2]/=var[3];
				var[3]=sqrt(DataSTV[j].n2[0]*DataSTV[j].n2[0]+DataSTV[j].n2[1]*DataSTV[j].n2[1]+DataSTV[j].n2[2]*DataSTV[j].n2[2]);
				DataSTV[j].n2[0]/=var[3];DataSTV[j].n2[1]/=var[3];DataSTV[j].n2[2]/=var[3];
				var[3]=sqrt(DataSTV[j].n3[0]*DataSTV[j].n3[0]+DataSTV[j].n3[1]*DataSTV[j].n3[1]+DataSTV[j].n3[2]*DataSTV[j].n3[2]);
				DataSTV[j].n3[0]/=var[3];DataSTV[j].n3[1]/=var[3];DataSTV[j].n3[2]/=var[3];
	
						DataSTV[j].texture=DTV[k].texture;
						DataSTV[j].t1[0]=DTV[k].t1[0];DataSTV[j].t1[1]=DTV[k].t1[1];
						DataSTV[j].t2[0]=DTV[k].t2[0];DataSTV[j].t2[1]=DTV[k].t2[1];
						DataSTV[j].t3[0]=DTV[k].t3[0];DataSTV[j].t3[1]=DTV[k].t3[1];
						DataSTV[j].c1[0]=DTV[k].c1[0];DataSTV[j].c1[1]=DTV[k].c1[1];DataSTV[j].c1[2]=DTV[k].c1[2];
						DataSTV[j].c2[0]=DTV[k].c2[0];DataSTV[j].c2[1]=DTV[k].c2[1];DataSTV[j].c2[2]=DTV[k].c2[2];
						DataSTV[j].c3[0]=DTV[k].c3[0];DataSTV[j].c3[1]=DTV[k].c3[1];DataSTV[j].c3[2]=DTV[k].c3[2];
					}
				}
				rtlines->v[0]=GriPoint->v[0];rtlines->v[1]=GriPoint->v[1];rtlines->v[2]=0;
				rtcolor[0]=currentcolor[0];rtcolor[1]=currentcolor[1];rtcolor[2]=currentcolor[2];rtlines[0].find=1;
				}
			emit instru(instruction);
			step=1;
			return;
			}
		break;
		case 3: /*REFERENCE (3-4)*/
			if(CmdSelectPopView()){return;}
			if(CmdCheckSnap()){return;}
			
			if(!SecCmd.compare("setCmdData")){
				if(currentdata.format>2){
						SendText(tr("Data reject"));
						return;
				}
				
				if(currentdata.format==0){
					tempdataF[1]=currentdata.v[0];tempdataF[2]=currentdata.v[1];
					rtlines->v[0]=tempdataF[1];rtlines->v[1]=tempdataF[2];rtlines->v[2]=0;rtlines[0].find=1;
					step++;
				}
				if(currentdata.format==1){
					tempdataF[1]=currentdata.v[0]+GriPoint->v[0];tempdataF[2]=currentdata.v[1]+GriPoint->v[1];
					rtlines->v[0]=tempdataF[1];rtlines->v[1]=tempdataF[2];rtlines->v[2]=0;rtlines[0].find=1;
					step++;
				}
				
				if(currentdata.format==2){
					var[0]=cosf(-currentdata.v[0]*M_PI/180.0);var[1]=sinf(-currentdata.v[0]*M_PI/180.0);var[2]=1.0;
					tempdataF[3]=var[0];tempdataF[4]=var[1];
					for(i=0;i<DataSV.size();i++){
					if(DataSV[i].type==1){
						DataSLV.resize(DataSLV.size()+1);j=DataSLV.size()-1;k=DataSV[i].index;
						DataSLV[j].v1[2]=DLV[k].v1[2];
						DataSLV[j].v2[2]=DLV[k].v2[2];
						DataSLV[j].v1[0]=((DLV[k].v1[0]-GriPoint->v[0])*var[0]-(DLV[k].v1[1]-GriPoint->v[1])*var[1])/var[2];
						DataSLV[j].v1[1]=((DLV[k].v1[1]-GriPoint->v[1])*var[0]+(DLV[k].v1[0]-GriPoint->v[0])*var[1])/var[2];
						DataSLV[j].v2[0]=((DLV[k].v2[0]-GriPoint->v[0])*var[0]-(DLV[k].v2[1]-GriPoint->v[1])*var[1])/var[2];
						DataSLV[j].v2[1]=((DLV[k].v2[1]-GriPoint->v[1])*var[0]+(DLV[k].v2[0]-GriPoint->v[0])*var[1])/var[2];
						
						DataSLV[j].c1[0]=DLV[k].c1[0];DataSLV[j].c2[0]=DLV[k].c2[0];
						DataSLV[j].c1[1]=DLV[k].c1[1];DataSLV[j].c2[1]=DLV[k].c2[1];
						DataSLV[j].c1[2]=DLV[k].c1[2];DataSLV[j].c2[2]=DLV[k].c2[2];
						
					}
					if(DataSV[i].type==2){
						DataSTV.resize(DataSTV.size()+1);j=DataSTV.size()-1;k=DataSV[i].index;
						DataSTV[j].v1[2]=DTV[k].v1[2];
						DataSTV[j].v2[2]=DTV[k].v2[2];
						DataSTV[j].v3[2]=DTV[k].v3[2];
						DataSTV[j].v1[0]=((DTV[k].v1[0]-GriPoint->v[0])*var[0]-(DTV[k].v1[1]-GriPoint->v[1])*var[1])/var[2];
						DataSTV[j].v1[1]=((DTV[k].v1[1]-GriPoint->v[1])*var[0]+(DTV[k].v1[0]-GriPoint->v[0])*var[1])/var[2];
						DataSTV[j].v2[0]=((DTV[k].v2[0]-GriPoint->v[0])*var[0]-(DTV[k].v2[1]-GriPoint->v[1])*var[1])/var[2];
						DataSTV[j].v2[1]=((DTV[k].v2[1]-GriPoint->v[1])*var[0]+(DTV[k].v2[0]-GriPoint->v[0])*var[1])/var[2];
						DataSTV[j].v3[0]=((DTV[k].v3[0]-GriPoint->v[0])*var[0]-(DTV[k].v3[1]-GriPoint->v[1])*var[1])/var[2];
						DataSTV[j].v3[1]=((DTV[k].v3[1]-GriPoint->v[1])*var[0]+(DTV[k].v3[0]-GriPoint->v[0])*var[1])/var[2];

				
	DataSTV[j].n1[0]=((DTV[k].v1[0]+DTV[k].n1[0]-GriPoint->v[0])*var[0]-(DTV[k].v1[1]+DTV[k].n1[1]-GriPoint->v[1])*var[1])/var[2];
	DataSTV[j].n1[1]=((DTV[k].v1[1]+DTV[k].n1[1]-GriPoint->v[1])*var[0]+(DTV[k].v1[0]+DTV[k].n1[0]-GriPoint->v[0])*var[1])/var[2];
	DataSTV[j].n1[2]=DTV[k].v1[2]+DTV[k].n1[2];

	DataSTV[j].n2[0]=((DTV[k].v2[0]+DTV[k].n2[0]-GriPoint->v[0])*var[0]-(DTV[k].v2[1]+DTV[k].n2[1]-GriPoint->v[1])*var[1])/var[2];
	DataSTV[j].n2[1]=((DTV[k].v2[1]+DTV[k].n2[1]-GriPoint->v[1])*var[0]+(DTV[k].v2[0]+DTV[k].n2[0]-GriPoint->v[0])*var[1])/var[2];
	DataSTV[j].n2[2]=DTV[k].v2[2]+DTV[k].n2[2];

	DataSTV[j].n3[0]=((DTV[k].v3[0]+DTV[k].n3[0]-GriPoint->v[0])*var[0]-(DTV[k].v3[1]+DTV[k].n3[1]-GriPoint->v[1])*var[1])/var[2];
	DataSTV[j].n3[1]=((DTV[k].v3[1]+DTV[k].n3[1]-GriPoint->v[1])*var[0]+(DTV[k].v3[0]+DTV[k].n3[0]-GriPoint->v[0])*var[1])/var[2];
	DataSTV[j].n3[2]=DTV[k].v3[2]+DTV[k].n3[2];
	
	DataSTV[j].n1[0]-=DataSTV[j].v1[0];DataSTV[j].n1[1]-=DataSTV[j].v1[1];DataSTV[j].n1[2]-=DataSTV[j].v1[2];
	DataSTV[j].n2[0]-=DataSTV[j].v2[0];DataSTV[j].n2[1]-=DataSTV[j].v2[1];DataSTV[j].n2[2]-=DataSTV[j].v2[2];
	DataSTV[j].n3[0]-=DataSTV[j].v3[0];DataSTV[j].n3[1]-=DataSTV[j].v3[1];DataSTV[j].n3[2]-=DataSTV[j].v3[2];
		
var[3]=sqrt(DataSTV[j].n1[0]*DataSTV[j].n1[0]+DataSTV[j].n1[1]*DataSTV[j].n1[1]+DataSTV[j].n1[2]*DataSTV[j].n1[2]);
	DataSTV[j].n1[0]/=var[3];DataSTV[j].n1[1]/=var[3];DataSTV[j].n1[2]/=var[3];
var[3]=sqrt(DataSTV[j].n2[0]*DataSTV[j].n2[0]+DataSTV[j].n2[1]*DataSTV[j].n2[1]+DataSTV[j].n2[2]*DataSTV[j].n2[2]);
	DataSTV[j].n2[0]/=var[3];DataSTV[j].n2[1]/=var[3];DataSTV[j].n2[2]/=var[3];
var[3]=sqrt(DataSTV[j].n3[0]*DataSTV[j].n3[0]+DataSTV[j].n3[1]*DataSTV[j].n3[1]+DataSTV[j].n3[2]*DataSTV[j].n3[2]);
	DataSTV[j].n3[0]/=var[3];DataSTV[j].n3[1]/=var[3];DataSTV[j].n3[2]/=var[3];
	
	
						DataSTV[j].texture=DTV[k].texture;
						DataSTV[j].t1[0]=DTV[k].t1[0];DataSTV[j].t1[1]=DTV[k].t1[1];
						DataSTV[j].t2[0]=DTV[k].t2[0];DataSTV[j].t2[1]=DTV[k].t2[1];
						DataSTV[j].t3[0]=DTV[k].t3[0];DataSTV[j].t3[1]=DTV[k].t3[1];
						DataSTV[j].c1[0]=DTV[k].c1[0];DataSTV[j].c1[1]=DTV[k].c1[1];DataSTV[j].c1[2]=DTV[k].c1[2];
						DataSTV[j].c2[0]=DTV[k].c2[0];DataSTV[j].c2[1]=DTV[k].c2[1];DataSTV[j].c2[2]=DTV[k].c2[2];
						DataSTV[j].c3[0]=DTV[k].c3[0];DataSTV[j].c3[1]=DTV[k].c3[1];DataSTV[j].c3[2]=DTV[k].c3[2];
					}
					}
					rtlines->v[0]=GriPoint->v[0];rtlines->v[1]=GriPoint->v[1];rtlines->v[2]=0;
					rtcolor[0]=currentcolor[0];rtcolor[1]=currentcolor[1];rtcolor[2]=currentcolor[2];rtlines[0].find=1;
				emit instru(instruction);
				step=1;
				return;
				}
			return;
			}
		
		
		
		break;
		case 4:/*REFERENCE (3-4)*/
			if(CmdSelectPopView()){return;}
			if(CmdCheckSnap()){return;}
			
			if(!SecCmd.compare("setCmdData")){
				if(currentdata.format>2){
						SendText(tr("Data reject"));
						return;
				}
				
				if(currentdata.format==0){
					var[0]=currentdata.v[0]-tempdataF[1];var[1]=tempdataF[2]-currentdata.v[1];
					var[2]=sqrt(var[0]*var[0]+var[1]*var[1]);
				}
				
				if(currentdata.format==1){
					var[0]=currentdata.v[0]+GriPoint->v[0]-tempdataF[1];var[1]=tempdataF[2]-currentdata.v[1]-GriPoint->v[1];
					var[2]=sqrt(var[0]*var[0]+var[1]*var[1]);
				}
				if(currentdata.format==2){
					var[0]=cosf(-currentdata.v[0]*M_PI/180.0);var[1]=sinf(-currentdata.v[0]*M_PI/180.0);var[2]=1;
				}
				
				if(var[2]){
					tempdataF[3]=var[0];tempdataF[4]=var[1];
					for(i=0;i<DataSV.size();i++){
					if(DataSV[i].type==1){
						DataSLV.resize(DataSLV.size()+1);j=DataSLV.size()-1;k=DataSV[i].index;
						DataSLV[j].v1[2]=DLV[k].v1[2];
						DataSLV[j].v2[2]=DLV[k].v2[2];
						DataSLV[j].v1[0]=((DLV[k].v1[0]-GriPoint->v[0])*var[0]-(DLV[k].v1[1]-GriPoint->v[1])*var[1])/var[2];
						DataSLV[j].v1[1]=((DLV[k].v1[1]-GriPoint->v[1])*var[0]+(DLV[k].v1[0]-GriPoint->v[0])*var[1])/var[2];
						DataSLV[j].v2[0]=((DLV[k].v2[0]-GriPoint->v[0])*var[0]-(DLV[k].v2[1]-GriPoint->v[1])*var[1])/var[2];
						DataSLV[j].v2[1]=((DLV[k].v2[1]-GriPoint->v[1])*var[0]+(DLV[k].v2[0]-GriPoint->v[0])*var[1])/var[2];
						
						DataSLV[j].c1[0]=DLV[k].c1[0];DataSLV[j].c2[0]=DLV[k].c2[0];
						DataSLV[j].c1[1]=DLV[k].c1[1];DataSLV[j].c2[1]=DLV[k].c2[1];
						DataSLV[j].c1[2]=DLV[k].c1[2];DataSLV[j].c2[2]=DLV[k].c2[2];
						
					}
					if(DataSV[i].type==2){
						DataSTV.resize(DataSTV.size()+1);j=DataSTV.size()-1;k=DataSV[i].index;
						DataSTV[j].v1[2]=DTV[k].v1[2];
						DataSTV[j].v2[2]=DTV[k].v2[2];
						DataSTV[j].v3[2]=DTV[k].v3[2];
						DataSTV[j].v1[0]=((DTV[k].v1[0]-GriPoint->v[0])*var[0]-(DTV[k].v1[1]-GriPoint->v[1])*var[1])/var[2];
						DataSTV[j].v1[1]=((DTV[k].v1[1]-GriPoint->v[1])*var[0]+(DTV[k].v1[0]-GriPoint->v[0])*var[1])/var[2];
						DataSTV[j].v2[0]=((DTV[k].v2[0]-GriPoint->v[0])*var[0]-(DTV[k].v2[1]-GriPoint->v[1])*var[1])/var[2];
						DataSTV[j].v2[1]=((DTV[k].v2[1]-GriPoint->v[1])*var[0]+(DTV[k].v2[0]-GriPoint->v[0])*var[1])/var[2];
						DataSTV[j].v3[0]=((DTV[k].v3[0]-GriPoint->v[0])*var[0]-(DTV[k].v3[1]-GriPoint->v[1])*var[1])/var[2];
						DataSTV[j].v3[1]=((DTV[k].v3[1]-GriPoint->v[1])*var[0]+(DTV[k].v3[0]-GriPoint->v[0])*var[1])/var[2];
						
	DataSTV[j].n1[0]=((DTV[k].v1[0]+DTV[k].n1[0]-GriPoint->v[0])*var[0]-(DTV[k].v1[1]+DTV[k].n1[1]-GriPoint->v[1])*var[1])/var[2];
	DataSTV[j].n1[1]=((DTV[k].v1[1]+DTV[k].n1[1]-GriPoint->v[1])*var[0]+(DTV[k].v1[0]+DTV[k].n1[0]-GriPoint->v[0])*var[1])/var[2];
	DataSTV[j].n1[2]=DTV[k].v1[2]+DTV[k].n1[2];

	DataSTV[j].n2[0]=((DTV[k].v2[0]+DTV[k].n2[0]-GriPoint->v[0])*var[0]-(DTV[k].v2[1]+DTV[k].n2[1]-GriPoint->v[1])*var[1])/var[2];
	DataSTV[j].n2[1]=((DTV[k].v2[1]+DTV[k].n2[1]-GriPoint->v[1])*var[0]+(DTV[k].v2[0]+DTV[k].n2[0]-GriPoint->v[0])*var[1])/var[2];
	DataSTV[j].n2[2]=DTV[k].v2[2]+DTV[k].n2[2];

	DataSTV[j].n3[0]=((DTV[k].v3[0]+DTV[k].n3[0]-GriPoint->v[0])*var[0]-(DTV[k].v3[1]+DTV[k].n3[1]-GriPoint->v[1])*var[1])/var[2];
	DataSTV[j].n3[1]=((DTV[k].v3[1]+DTV[k].n3[1]-GriPoint->v[1])*var[0]+(DTV[k].v3[0]+DTV[k].n3[0]-GriPoint->v[0])*var[1])/var[2];
	DataSTV[j].n3[2]=DTV[k].v3[2]+DTV[k].n3[2];
	
	DataSTV[j].n1[0]-=DataSTV[j].v1[0];DataSTV[j].n1[1]-=DataSTV[j].v1[1];DataSTV[j].n1[2]-=DataSTV[j].v1[2];
	DataSTV[j].n2[0]-=DataSTV[j].v2[0];DataSTV[j].n2[1]-=DataSTV[j].v2[1];DataSTV[j].n2[2]-=DataSTV[j].v2[2];
	DataSTV[j].n3[0]-=DataSTV[j].v3[0];DataSTV[j].n3[1]-=DataSTV[j].v3[1];DataSTV[j].n3[2]-=DataSTV[j].v3[2];
		
var[3]=sqrt(DataSTV[j].n1[0]*DataSTV[j].n1[0]+DataSTV[j].n1[1]*DataSTV[j].n1[1]+DataSTV[j].n1[2]*DataSTV[j].n1[2]);
	DataSTV[j].n1[0]/=var[3];DataSTV[j].n1[1]/=var[3];DataSTV[j].n1[2]/=var[3];
var[3]=sqrt(DataSTV[j].n2[0]*DataSTV[j].n2[0]+DataSTV[j].n2[1]*DataSTV[j].n2[1]+DataSTV[j].n2[2]*DataSTV[j].n2[2]);
	DataSTV[j].n2[0]/=var[3];DataSTV[j].n2[1]/=var[3];DataSTV[j].n2[2]/=var[3];
var[3]=sqrt(DataSTV[j].n3[0]*DataSTV[j].n3[0]+DataSTV[j].n3[1]*DataSTV[j].n3[1]+DataSTV[j].n3[2]*DataSTV[j].n3[2]);
	DataSTV[j].n3[0]/=var[3];DataSTV[j].n3[1]/=var[3];DataSTV[j].n3[2]/=var[3];
	
						DataSTV[j].texture=DTV[k].texture;
						DataSTV[j].t1[0]=DTV[k].t1[0];DataSTV[j].t1[1]=DTV[k].t1[1];
						DataSTV[j].t2[0]=DTV[k].t2[0];DataSTV[j].t2[1]=DTV[k].t2[1];
						DataSTV[j].t3[0]=DTV[k].t3[0];DataSTV[j].t3[1]=DTV[k].t3[1];
						DataSTV[j].c1[0]=DTV[k].c1[0];DataSTV[j].c1[1]=DTV[k].c1[1];DataSTV[j].c1[2]=DTV[k].c1[2];
						DataSTV[j].c2[0]=DTV[k].c2[0];DataSTV[j].c2[1]=DTV[k].c2[1];DataSTV[j].c2[2]=DTV[k].c2[2];
						DataSTV[j].c3[0]=DTV[k].c3[0];DataSTV[j].c3[1]=DTV[k].c3[1];DataSTV[j].c3[2]=DTV[k].c3[2];
					}
					}
					rtlines->v[0]=GriPoint->v[0];rtlines->v[1]=GriPoint->v[1];rtlines->v[2]=0;
					rtcolor[0]=currentcolor[0];rtcolor[1]=currentcolor[1];rtcolor[2]=currentcolor[2];rtlines[0].find=1;
				emit instru(instruction);
				step=1;
				return;
				}
			return;
			}
		
		break;
	}
	
	SendText(SecCmd);
	SendText(tr("**Secondary Command not found**"));
}


#endif
