/****************************************************************************
** $Id:  dialogs/picktex.cpp
** AutoQ3D a qt 3d model editor program
**
** Copyright (C) 2005-2007 -Gonzalo Reynaga Garcia. <gonzaloreynaga@yahoo.com>
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public Licence
** as published by the Free Software Foundation; either version 2 
** of the License, or (at your option) any later option.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
** 
*****************************************************************************/

#include "picktex.h"


PixLabel::PixLabel( QWidget* parent,float* num)
	:QLabel(parent){
	coords=num;
	setMouseTracking (TRUE);

}

PixLabel::~PixLabel()
{
  
}

void PixLabel::mouseMoveEvent(QMouseEvent* e){
	float upix,vpix;
	upix=(float)(e->x())/((float)width()-1);
	vpix=1.0-((float)e->y())/((float)height()-1);
	emit showMessage(QString("%1,%2").arg(upix).arg(vpix));
}

void PixLabel::mousePressEvent(QMouseEvent* e){
	if(e->button()==Qt::LeftButton){
		coords[0]=((float)e->x())/((float)width()-1);
		coords[1]=1.0-((float)e->y())/((float)height()-1);
		emit ClickAccept();
	}
	if(e->button()==Qt::RightButton){
		emit ClickReject();
	}

}


PickTex::PickTex( QWidget* parent,Qt::WFlags fl,QString pname,float *refe)
    : QDialog( parent,fl )
{
	coords=refe;
	flag=0;
	setAttribute(Qt::WA_DeleteOnClose);
	Form1Layout = new QVBoxLayout(this); 
	setMouseTracking(TRUE);
	setCursor(Qt::CrossCursor);
	pixmapLabel1 = new PixLabel(this,coords);
	pixmapLabel1->setPixmap(QPixmap(pname));
	pixmapLabel1->setScaledContents( TRUE );
	pixmapLabel1->setMargin(0);
	Form1Layout->addWidget( pixmapLabel1 );
    
	/*clearWState( WState_Polished );*/
	status = new QLabel;
	status->setFrameStyle( QFrame::WinPanel | QFrame::Sunken );
	status->setFixedHeight( fontMetrics().height() + 4 );
	Form1Layout->addWidget( status );
	connect( pixmapLabel1, SIGNAL(showMessage(QString)) , this, SLOT(showMessage(QString) ));
	connect( pixmapLabel1, SIGNAL(ClickAccept()) , this, SLOT(accept() ));
	connect( pixmapLabel1, SIGNAL(ClickReject()) , this, SLOT(reject() ));
	
}

void PickTex::showMessage(QString str){
	status->setText(str);
}

void PickTex::CloseEvent(QCloseEvent*){

}



PickTex::~PickTex()
{
  
}
