/****************************************************************************
** $Id:  fgui/glapparea.h
** AutoQ3D a qt 3d model editor program
**
** Copyright (C) 2005-2007 -Gonzalo Reynaga Garcia. <gonzaloreynaga@yahoo.com>
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public Licence
** as published by the Free Software Foundation; either version 2 
** of the License, or (at your option) any later option.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
** 
*****************************************************************************/

#ifndef GLAPPAREA_H
#define GLAPPAREA_H
#include <QLayout>
#include <QGLWidget>
#include <QMouseEvent>
#include <QPixmap>
#include <QPainter>
#include <QBitmap>
#include <QAction>
#include <QCursor>
#include <QMenu>
#include <QMessageBox>


#include "../extra/primitives.h"
#include "../cmds/cmds.h"
#include "../extra/matrixa.h"
#include "../extra/mousedefines.h"

class QAction;

class GLAppArea : public QGLWidget
{
    Q_OBJECT

public:

	GLAppArea( QWidget* parent,QStringList*);
	~GLAppArea();
	foundP *rtlines;
	foundP *GriPoint;
	float *rtcolor;
	float *rtcolor1;
	float *cscalarf;
	int *cscalari;
	float *currentcolor;
	foundP *currentpoint;
	int *MouseMode;
	int *GripEditMode;
	foundP *SnaPoint;
	int *SnapMode;
	int *SnapFlags;
	float zNear;
	float zFar;
	int ShowNormals;
	float NS;
	int RenderMode;
	float BackColor[3];
	int *ucsicon;
	int *View;
	

public slots:
	void UpdateMouseMove();
	void setDataL(QVector<d3line> *,QVector<d3triangle> *,QVector<tselect> *,QVector<d3line> *,QVector<d3triangle>*,int*);
	tselect search(int, int,int,int); /*Its a function that select a object in x,y,dx,dy*/
	foundP searchP(int, int,int,int); /*returns the grip point coords in x,y,dx,yx */
	void Load1Texture(QString file,GLuint *tex);
	void LoadAllTextures();
	void ZoomVar(float var);
	void DeleteAllTextures();
	void PublicUpdate();
	void ViewMode(int);

protected:

	virtual void initializeGL();
	virtual void paintGL();
	virtual void resizeGL( int w, int h );
	

protected slots:
	virtual void mousePressEvent ( QMouseEvent * e );
	virtual void mouseMoveEvent ( QMouseEvent * e );
	virtual void mouseReleaseEvent ( QMouseEvent *);
	

private slots:
	void searchSnap(tselect,int,int);/*returns the grip point coords in x,y,dx,yx of object tselect*/
	void searchWindow(); /*Select the objects within selectionRect without clones*/

signals:
	void SendText(QString);
	void UpdateAll();
	void message(const QString&, int );
	void setCmdData(dataformat);
	void processcmd(QString);


private:
	QVector<d3line> *DataLV;
	QVector<d3line> *DataSLV;
	QVector<d3triangle> *DataTV;
	QVector<d3triangle> *DataSTV;
	QVector<tselect> *DataSV;

	QRect rotrect;
	QRect selectionRect;
	QRect transright;
	float ViewPortScale;
	float tempdataF[1];
	int EnableSelWin;
	int TextureAnt;
	GLuint Texture[100];
	QStringList* strlist;
	int RenderModeAnt;

};


#endif // GLAPPAREA_H




