/****************************************************************************
** $Id:  cmds/cmddrawline.h
** AutoQ3D a qt 3d model editor program
**
** Copyright (C) 2005-2007 -Gonzalo Reynaga Garcia. <gonzaloreynaga@yahoo.com>
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public Licence
** as published by the Free Software Foundation; either version 2 
** of the License, or (at your option) any later option.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
** 
*****************************************************************************/

#ifndef CMDDRAWLINE_H
#define CMDDRAWLINE_H
#include "cmds.h"


void cmds::cmddrawline(){
	int i;
	d3line *DLV;
	DLV=DataLV->data();

	if((SecCmd==tr("**Cancel**")||SecCmd==""||SecCmd=="MouseRButton")&&!PopViewMode){
			SendText(tr("**Cancel**"));
			CmdCancel();
			return;
	}

	switch(step){
		
		case 0:
			/*/////////*/
		
				SendText(currentcmd);
				instruction=tr("pickpoint 1:");emit instru(instruction);
				emit SetMouseMode(MOUSEMODE_PICKPOINT);
				step++;
				return;
			
		break;

		case 1:
			if(CmdSelectPopView()){return;}
			if(CmdCheckSnap()){return;}
			
			if(!SecCmd.compare("setCmdData")){
				if(currentdata.format>1){
						SendText(tr("Data reject"));
						return;
				}
				rtlines[0].v[0]=currentdata.v[0];rtlines[0].v[1]=currentdata.v[1];rtlines[0].v[2]=currentdata.v[2];
				rtcolor[0]=currentcolor[0];rtcolor[1]=currentcolor[1];rtcolor[2]=currentcolor[2];
				rtlines[0].find=1;
				tempdataF[0]=rtlines[0].v[0];tempdataF[1]=rtlines[0].v[1];tempdataF[2]=rtlines[0].v[2];
				tempdataF[3]=currentcolor[0];tempdataF[4]=currentcolor[1];tempdataF[5]=currentcolor[2];
				/*/////////*/
				instruction=tr("pickpoint 2 or [Undo]:");emit instru(instruction);
				step++;
				return;
			}
		break;
		
		case 2:
			if(CmdSelectPopView()){return;}
			if(CmdCheckSnap()){return;}
			
			if(!SecCmd.compare(tr("U","Undo"))||!SecCmd.compare(tr("u","Undo"))){
					SendText(SecCmd);
					instruction=tr("pickpoint 1:");emit instru(instruction);
					rtlines[0].find=0;SecCmd="BlankCommand";step--;
			return;
			}
			
			if(!SecCmd.compare("setCmdData")){
				if(currentdata.format>1){
						SendText(tr("Data reject"));
						return;
				}
				i=DataLV->size();
				DataLV->resize(i+1);DLV=DataLV->data();
				if(currentdata.format==0){
					DLV[i].v1[0]=rtlines[0].v[0];DLV[i].v1[1]=rtlines[0].v[1];DLV[i].v1[2]=rtlines[0].v[2];
					DLV[i].v2[0]=currentdata.v[0];DLV[i].v2[1]=currentdata.v[1];DLV[i].v2[2]=currentdata.v[2];
					rtlines[0].v[0]=currentdata.v[0];rtlines[0].v[1]=currentdata.v[1];rtlines[0].v[2]=currentdata.v[2];
				}
				
				if(currentdata.format==1){
					DLV[i].v1[0]=rtlines[0].v[0];DLV[i].v1[1]=rtlines[0].v[1];DLV[i].v1[2]=rtlines[0].v[2];
					DLV[i].v2[0]=rtlines[0].v[0]+currentdata.v[0];DLV[i].v2[1]=rtlines[0].v[1]+currentdata.v[1];DLV[i].v2[2]=rtlines[0].v[2]+currentdata.v[2];
					rtlines[0].v[0]=rtlines[0].v[0]+currentdata.v[0];rtlines[0].v[1]=rtlines[0].v[1]+currentdata.v[1];rtlines[0].v[2]=rtlines[0].v[2]+currentdata.v[2];
				}
				
				DLV[i].c1[0]=rtcolor[0];DLV[i].c1[1]=rtcolor[1];DLV[i].c1[2]=rtcolor[2];
				DLV[i].c2[0]=currentcolor[0];DLV[i].c2[1]=currentcolor[1];DLV[i].c2[2]=currentcolor[2];
				
				
				rtcolor[0]=currentcolor[0];rtcolor[1]=currentcolor[1];rtcolor[2]=currentcolor[2];

				instruction=tr("Next point or [Close/Undo]:");emit instru(instruction);
				step++;
			return;
			}
		break;
		

	
	
	
	}
		if(step>2){
			if(CmdSelectPopView()){return;}
			if(CmdCheckSnap()){return;}
			
			if(!SecCmd.compare(tr("U","Undo"))||!SecCmd.compare(tr("u","Undo"))){
					SendText(SecCmd);
					i=DataLV->size()-1;
					rtlines[0].v[0]=DLV[i].v1[0];rtlines[0].v[1]=DLV[i].v1[1];rtlines[0].v[2]=DLV[i].v1[2];
					rtcolor[0]=DLV[i].c1[0];rtcolor[1]=DLV[i].c1[1];rtcolor[2]=DLV[i].c1[2];
					DataLV->resize(i);DLV=DataLV->data();step--;
					SecCmd="BlankCommand";
			return;
			}
			
			if(!SecCmd.compare(tr("C","Close"))||!SecCmd.compare(tr("c","Close"))){
					SendText(SecCmd);
					i=DataLV->size();
					DataLV->resize(i+1);DLV=DataLV->data();
					DLV[i].v1[0]=rtlines[0].v[0];DLV[i].v1[1]=rtlines[0].v[1];DLV[i].v1[2]=rtlines[0].v[2];
					DLV[i].v2[0]=tempdataF[0];DLV[i].v2[1]=tempdataF[1];DLV[i].v2[2]=tempdataF[2];
					DLV[i].c1[0]=rtcolor[0];DLV[i].c1[1]=rtcolor[1];DLV[i].c1[2]=rtcolor[2];
					DLV[i].c2[0]=tempdataF[3];DLV[i].c2[1]=tempdataF[4];DLV[i].c2[2]=tempdataF[5];
					CmdCancel();
			return;
			}
			
			if(!SecCmd.compare("setCmdData")){
				if(currentdata.format>1){
						SendText(tr("Data reject"));
						return;
				}
				i=DataLV->size();
				DataLV->resize(i+1);DLV=DataLV->data();
				if(currentdata.format==0){
					DLV[i].v1[0]=rtlines[0].v[0];DLV[i].v1[1]=rtlines[0].v[1];DLV[i].v1[2]=rtlines[0].v[2];
					DLV[i].v2[0]=currentdata.v[0];DLV[i].v2[1]=currentdata.v[1];DLV[i].v2[2]=currentdata.v[2];
					rtlines[0].v[0]=currentdata.v[0];rtlines[0].v[1]=currentdata.v[1];rtlines[0].v[2]=currentdata.v[2];
				}
				
				if(currentdata.format==1){
					DLV[i].v1[0]=rtlines[0].v[0];DLV[i].v1[1]=rtlines[0].v[1];DLV[i].v1[2]=rtlines[0].v[2];
					DLV[i].v2[0]=rtlines[0].v[0]+currentdata.v[0];DLV[i].v2[1]=rtlines[0].v[1]+currentdata.v[1];DLV[i].v2[2]=rtlines[0].v[2]+currentdata.v[2];
					rtlines[0].v[0]=rtlines[0].v[0]+currentdata.v[0];rtlines[0].v[1]=rtlines[0].v[1]+currentdata.v[1];rtlines[0].v[2]=rtlines[0].v[2]+currentdata.v[2];
				}
				DLV[i].c1[0]=rtcolor[0];DLV[i].c1[1]=rtcolor[1];DLV[i].c1[2]=rtcolor[2];
				DLV[i].c2[0]=currentcolor[0];DLV[i].c2[1]=currentcolor[1];DLV[i].c2[2]=currentcolor[2];
				
				
				rtcolor[0]=currentcolor[0];rtcolor[1]=currentcolor[1];rtcolor[2]=currentcolor[2];
				step++;
			return;
			}
		}
	
	
	
	
	
	SendText(SecCmd);
	SendText(tr("**Secondary Command not found**"));
}


#endif
