/****************************************************************************
** $Id:  cmds/cmddrawpoly.h
** AutoQ3D a qt 3d model editor program
**
** Copyright (C) 2005-2007 -Gonzalo Reynaga Garcia. <gonzaloreynaga@yahoo.com>
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public Licence
** as published by the Free Software Foundation; either version 2 
** of the License, or (at your option) any later option.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
** 
*****************************************************************************/

#ifndef CMDDRAWPOLY_H
#define CMDDRAWPOLY_H
#include "cmds.h"


void cmds::cmddrawpoly(){
	int i,j=0,k;
	float incf;
	float currangle;
	double var[4];
	d3line *DLV;
	DLV=DataLV->data();

	if((SecCmd==tr("**Cancel**")||SecCmd=="MouseRButton")&&!PopViewMode){
			SendText(tr("**Cancel**"));
			CmdCancel();
			return;
	}

	switch(step){
		
		case 0:
			/*/////////*/
		
				SendText(currentcmd);
				instruction=tr("Specify center:");emit instru(instruction);
				tempdataF[4]=8.0;
				emit SetMouseMode(MOUSEMODE_PICKPOINT);
				step++;
				return;
			
		break;

		case 1:
			if(CmdSelectPopView()){return;}
			if(CmdCheckSnap()){return;}
			
			if(!SecCmd.compare("setCmdData")){
				if(currentdata.format>1){
						SendText(tr("Data reject"));
						return;
				}
				rtlines[0].v[0]=currentdata.v[0];rtlines[0].v[1]=currentdata.v[1];rtlines[0].v[2]=currentdata.v[2];
				rtcolor[0]=currentcolor[0];rtcolor[1]=currentcolor[1];rtcolor[2]=currentcolor[2];
				rtlines[0].find=1;
				tempdataF[0]=rtlines[0].v[0];tempdataF[1]=rtlines[0].v[1];tempdataF[2]=rtlines[0].v[2];
				/*/////////*/
				instruction=tr("Specify radius:");emit instru(instruction);
				step++;
				return;
			}
		break;
		
		case 2:
			if(CmdSelectPopView()){return;}
			if(CmdCheckSnap()){return;}
			
			
			if(!SecCmd.compare("setCmdData")){
			
				if(currentdata.format==0){
					tempdataF[3]=sqrt((tempdataF[0]-currentdata.v[0])*(tempdataF[0]-currentdata.v[0])+(tempdataF[1]-currentdata.v[1])*(tempdataF[1]-currentdata.v[1])+(tempdataF[2]-currentdata.v[2])*(tempdataF[2]-currentdata.v[2]));
					if(tempdataF[3]){}else{SendText(tr("Data reject, radius=1"));tempdataF[3]=1;}
					tempdataF[0]=tempdataF[0]-currentdata.v[0];tempdataF[1]=tempdataF[1]-currentdata.v[1];tempdataF[2]=tempdataF[2]-currentdata.v[2];
				}
				
				if(currentdata.format==1){
					tempdataF[3]=sqrt((currentdata.v[0])*(currentdata.v[0])+(currentdata.v[1])*(currentdata.v[1])+(currentdata.v[2])*(currentdata.v[2]));
					if(tempdataF[3]){}else{tempdataF[3]=1;}
					tempdataF[0]=currentdata.v[0];tempdataF[1]=currentdata.v[1];tempdataF[2]=currentdata.v[2];
				}
				if(currentdata.format==2){
					tempdataF[3]=currentdata.v[0];
					if(tempdataF[3]){}else{SendText(tr("Data reject, radius=1"));tempdataF[3]=1;}
					tempdataF[0]=tempdataF[3];tempdataF[1]=0.0;tempdataF[2]=0.0;
				
				}
				rtlines[0].find=0;
				instruction=QString(tr("Poly Segments<%1>:")).arg(tempdataF[4]);emit instru(instruction);
				step++;
			return;
			}
		break;
		
		case 3:
			if(CmdSelectPopView()){return;}
			if(CmdCheckSnap()){return;}
			
			if(!SecCmd.compare("")){
				var[2]=1.0;var[3]=0.0;
				
				for(i=DataLV->size(),incf=1.0;incf<tempdataF[4];incf=incf+1.0){/*tempdataF[4];incf=incf+1.0){*/
					currangle=360.0*incf/tempdataF[4];
					var[0]=cosf(currangle*M_PI/180.0);var[1]=sinf(currangle*M_PI/180.0);
					
							j=DataLV->size();DataLV->resize(j+1);DLV=DataLV->data();
							DLV[j].v2[0]=rtlines[0].v[0]+(tempdataF[1]*var[1]-tempdataF[0]*var[0]);
							DLV[j].v2[1]=rtlines[0].v[1]-(tempdataF[1]*var[0]+tempdataF[0]*var[1]);
							DLV[j].v2[2]=tempdataF[2];
							DLV[j].c1[0]=currentcolor[0];DLV[j].c1[1]=currentcolor[1];DLV[j].c1[2]=currentcolor[2];

							DLV[j].v1[0]=rtlines[0].v[0]+(tempdataF[1]*var[3]-tempdataF[0]*var[2]);
							DLV[j].v1[1]=rtlines[0].v[1]-(tempdataF[1]*var[2]+tempdataF[0]*var[3]);
							DLV[j].v1[2]=tempdataF[2];
							DLV[j].c2[0]=currentcolor[0];DLV[j].c2[1]=currentcolor[1];DLV[j].c2[2]=currentcolor[2];
							
					var[2]=var[0];var[3]=var[1];
					
				}

				if(tempdataF[4]>1){
							k=DataLV->size();DataLV->resize(k+1);DLV=DataLV->data();
							DLV[k].v2[0]=DLV[i].v1[0];DLV[k].v2[1]=DLV[i].v1[1];DLV[k].v2[2]=DLV[i].v1[2];
							DLV[k].c1[0]=currentcolor[0];DLV[k].c1[1]=currentcolor[1];DLV[k].c1[2]=currentcolor[2];
							DLV[k].v1[0]=DLV[j].v2[0];DLV[k].v1[1]=DLV[j].v2[1];DLV[k].v1[2]=DLV[j].v2[2];
							DLV[k].c2[0]=currentcolor[0];DLV[k].c2[1]=currentcolor[1];DLV[k].c2[2]=currentcolor[2];
				}
				
				CmdCancel();
				return;
			
			}
			
			if(!SecCmd.compare("setCmdData")){
				if(currentdata.format==2){
					tempdataF[4]=currentdata.v[0];
					instruction=QString(tr("Poly Segments<%1>:")).arg(tempdataF[4]);emit instru(instruction);
				
				}
			
			
			return;
			
			}
		break;
		

	
	
	
	}
	
	
	
	
	
	SendText(SecCmd);
	SendText(tr("**Secondary Command not found**"));
}


#endif
