/****************************************************************************
** $Id:  cmds/cmdtexsp.h
** AutoQ3D a qt 3d model editor program
**
** Copyright (C) 2005-2007 -Gonzalo Reynaga Garcia. <gonzaloreynaga@yahoo.com>
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public Licence
** as published by the Free Software Foundation; either version 2 
** of the License, or (at your option) any later option.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
** 
*****************************************************************************/

#ifndef CMDTEXSP_H
#define CMDTEXSP_H
#include "cmds.h"


void cmds::cmdtexsp(){
	int i,k;
	double var[3];
	d3triangle *DTV;
	DTV=DataTV->data();

	if((SecCmd==tr("**Cancel**")||SecCmd==""||SecCmd=="MouseRButton")&&!PopViewMode){
			SendText(tr("**Cancel**"));
			CmdCancel();
			return;
	}

	switch(step){
		
		case 0:
			/*/////////*/
		
				SendText(tr("--Texture Spherify--"));
				
				for(i=0;i<DataSV.size();i++){
					
					if(DataSV[i].type==2){
						k=DataSV[i].index;
						
						var[2]=sqrt(DTV[k].n1[0]*DTV[k].n1[0]+DTV[k].n1[1]*DTV[k].n1[1]);
						if(var[2]){
							var[1]=DTV[k].n1[1]/var[2];
							if(DTV[k].n1[0]<0.0){
								DTV[k].t1[0]=1.0-(var[1]+1.0)/4.0;
							}else{
								DTV[k].t1[0]=(var[1]+1.0)/4.0;
							}
			
						}else{
							DTV[k].t1[0]=0.0;
						}
		
						if((DTV[k].n1[0]*DTV[k].n1[0])<(DTV[k].n1[1]*DTV[k].n1[1])){
							var[2]=sqrt(DTV[k].n1[1]*DTV[k].n1[1]+DTV[k].n1[2]*DTV[k].n1[2]);
						}else{
							var[2]=sqrt(DTV[k].n1[0]*DTV[k].n1[0]+DTV[k].n1[2]*DTV[k].n1[2]);
						}
							
						if(var[2]){
							var[1]=DTV[k].n1[2]/var[2];
							DTV[k].t1[1]=(var[1]+1.0)/2.0;							
						}else{
							DTV[k].t1[1]=0.5;
						}
						
						/*****************************************************/
						
						var[2]=sqrt(DTV[k].n2[0]*DTV[k].n2[0]+DTV[k].n2[1]*DTV[k].n2[1]);
						if(var[2]){
							var[1]=DTV[k].n2[1]/var[2];
							if(DTV[k].n2[0]<0.0){
								DTV[k].t2[0]=1.0-(var[1]+1.0)/4.0;
							}else{
								DTV[k].t2[0]=(var[1]+1.0)/4.0;
							}
							
						}else{
							DTV[k].t2[0]=0.0;
						}
						
						if((DTV[k].n2[0]*DTV[k].n2[0])<(DTV[k].n2[1]*DTV[k].n2[1])){
							var[2]=sqrt(DTV[k].n2[1]*DTV[k].n2[1]+DTV[k].n2[2]*DTV[k].n2[2]);
						}else{
							var[2]=sqrt(DTV[k].n2[0]*DTV[k].n2[0]+DTV[k].n2[2]*DTV[k].n2[2]);
						}
							
						if(var[2]){
							var[1]=DTV[k].n2[2]/var[2];
							DTV[k].t2[1]=(var[1]+1.0)/2.0;							
						}else{
							DTV[k].t2[1]=0.5;
						}
						
						/******************************************************************/
	
						var[2]=sqrt(DTV[k].n3[0]*DTV[k].n3[0]+DTV[k].n3[1]*DTV[k].n3[1]);
						if(var[2]){
							var[1]=DTV[k].n3[1]/var[2];
							if(DTV[k].n3[0]<0.0){
								DTV[k].t3[0]=1.0-(var[1]+1.0)/4.0;
							}else{
								DTV[k].t3[0]=(var[1]+1.0)/4.0;
							}
							
						}else{
							DTV[k].t3[0]=0.0;
						}
		
		
		
						if((DTV[k].n3[0]*DTV[k].n3[0])<(DTV[k].n3[1]*DTV[k].n3[1])){
							var[2]=sqrt(DTV[k].n3[1]*DTV[k].n3[1]+DTV[k].n3[2]*DTV[k].n3[2]);
						}else{
							var[2]=sqrt(DTV[k].n3[0]*DTV[k].n3[0]+DTV[k].n3[2]*DTV[k].n3[2]);
						}
							
						if(var[2]){
							var[1]=DTV[k].n3[2]/var[2];
							DTV[k].t3[1]=(var[1]+1.0)/2.0;							
						}else{
							DTV[k].t3[1]=0.5;
						}
						
		if((DTV[k].n1[0]+DTV[k].n2[0]+DTV[k].n3[0])>=0.0){
			if(DTV[k].t1[0]<0.0){DTV[k].t1[0]=0.0;}
			if(DTV[k].t1[0]>0.90){DTV[k].t1[0]=0.0;}
			if(DTV[k].t2[0]<0.0){DTV[k].t2[0]=0.0;}
			if(DTV[k].t2[0]>0.90){DTV[k].t2[0]=0.0;}
			if(DTV[k].t3[0]<0.0){DTV[k].t3[0]=0.0;}
			if(DTV[k].t3[0]>0.90){DTV[k].t3[0]=0.0;}
		
		}else{
			if(DTV[k].t1[0]<0.1){DTV[k].t1[0]=1.0;}
			if(DTV[k].t1[0]>1.0){DTV[k].t1[0]=1.0;}
			if(DTV[k].t2[0]<0.1){DTV[k].t2[0]=1.0;}
			if(DTV[k].t2[0]>1.0){DTV[k].t2[0]=1.0;}
			if(DTV[k].t3[0]<0.1){DTV[k].t3[0]=1.0;}
			if(DTV[k].t3[0]>1.0){DTV[k].t3[0]=1.0;}
		}
						
					
						
						
						
					
					
					}
				
				
				}

				CmdCancel();
				return;
			
		break;
	}
	
	
	
	
	
	SendText(SecCmd);
	SendText(tr("**Secondary Command not found**"));
}


#endif
