/****************************************************************************
** $Id:  dialogs/picktex.h
** AutoQ3D a qt 3d model editor program
**
** Copyright (C) 2005-2007 -Gonzalo Reynaga Garcia. <gonzaloreynaga@yahoo.com>
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public Licence
** as published by the Free Software Foundation; either version 2 
** of the License, or (at your option) any later option.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
** 
*****************************************************************************/

#ifndef PICKTEX_H
#define PICKTEX_H

#include <QVariant>
#include <QDialog>
#include <QMouseEvent>
#include <QVBoxLayout>
#include <QLabel>
#include <QPixmap>

class QVBoxLayout;
class QHBoxLayout;
class QGridLayout;
class QLabel;
class PixLabel;

class PixLabel : public QLabel
{
    Q_OBJECT

public:
	PixLabel( QWidget* parent = 0,float* num=0);
    ~PixLabel();

 protected:
	float *coords;

signals:
	void showMessage(QString);
    void ClickAccept(void);
	void ClickReject(void);

protected slots:
	virtual void mouseMoveEvent(QMouseEvent*);
	virtual void mousePressEvent(QMouseEvent*);
protected slots:

};


class PickTex : public QDialog
{
    Q_OBJECT

public:
	PickTex( QWidget* parent = 0, Qt::WFlags fl = 0,QString pname=0,float* num=0);
    ~PickTex();

    QLabel* pixmapLabel1;
    QLabel* status;
    float upix;
    float vpix;
    QString pixname;
	int flag;


protected:
    QVBoxLayout* Form1Layout;
	float *coords;
    
protected slots:
	virtual void CloseEvent(QCloseEvent*);
	void showMessage(QString str);

protected slots:

};

#endif // FORM1_H
