/****************************************************************************
** $Id:  fgui/cadform.cpp
** AutoQ3D a qt 3d model editor program
**
** Copyright (C) 2005-2007 -Gonzalo Reynaga Garcia. <gonzaloreynaga@yahoo.com>
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public Licence
** as published by the Free Software Foundation; either version 2
** of the License, or (at your option) any later option.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
**
*****************************************************************************/


#include "cadform.h"
#include "md2/cadformmd2.h"
#include "dxf/cadformdxf.h"


CadForm::CadForm()
{
	numDoc=0;
	ucsicon=1;
	*MouseMode=MOUSEMODE_SELECT;
	View[0]=3;
	filename="";
	currentcolor[0]=0.5;currentcolor[1]=0.5;currentcolor[2]=1.0;
	DataLV.resize(0);
	DataTV.resize(0);
	QSettings settings("AutoQ3D-Community","AutoQ3D-Community");
	ProgramPath = settings.value("MainWindow/ProgramPath","/usr/share/AutoQ3D-Community").toString()+"/";

	proc = new QProcess(this);
	ws = new QWorkspace;
	Label1 = new QLabel(tr("Command:") );
	ecmd= new EditCmd;
	hcmd=new cmds();
	QWidget *WhVc=new QWidget;
	QVBoxLayout *hVc=new QVBoxLayout;
	QHBoxLayout *hHL=new QHBoxLayout;
	QSplitter *s1 = new QSplitter( Qt::Vertical);
	QVBoxLayout *vboxLayout=new QVBoxLayout;


	QAction * ViewPortNewAction;
	ViewPortNewAction= new QAction( QIcon(ProgramPath+"images/filenew.png"),tr("&New Viewport"),this);
	ViewPortNewAction->setStatusTip(tr("New Viewport"));
	connect( ViewPortNewAction, SIGNAL( triggered() ) , this, SLOT( newViewPort() ) );

	QAction * fileOpenAction;
	fileOpenAction= new QAction(QIcon(ProgramPath+"images/fileopen.png"),tr("&Open..."),this);
	fileOpenAction->setStatusTip(tr("Open file"));
	connect( fileOpenAction, SIGNAL( triggered() ) , this, SLOT( OpenFile() ) );

	QAction * fileSaveAction;
	fileSaveAction = new QAction(QIcon(ProgramPath+"images/filesave.png"), tr("&Save"),this);
	fileSaveAction->setStatusTip(tr("Save file"));
	connect( fileSaveAction, SIGNAL( triggered() ) , this, SLOT( SaveFile() ) );

	QAction * fileCloseAction;
	fileCloseAction = new QAction( QIcon(ProgramPath+"images/doclose.png"),tr("&Close"),this);
	fileCloseAction->setStatusTip(tr("Close file"));
	connect( fileCloseAction, SIGNAL( triggered() ) , this, SLOT( CloseFile() ) );

	QAction * fileSaveAsAction;
	fileSaveAsAction = new QAction( QIcon(ProgramPath+"images/filesaveas.png"), tr("Save &As..."), this );
	fileSaveAsAction->setStatusTip(tr("Save as..."));
	connect( fileSaveAsAction, SIGNAL( triggered() ) , this, SLOT(SaveAsFile()  ) );

	QAction * WinTileAction;
	WinTileAction = new QAction( QIcon(ProgramPath+"images/tile.png"), tr("&Tile"),this );
	WinTileAction->setStatusTip(tr("Tile"));
	connect( WinTileAction, SIGNAL( triggered() ) , this, SLOT( Tile() ) );

	QAction * WinCasAction;
	WinCasAction = new QAction( QIcon(ProgramPath+"images/cascade.png"), tr("&Cascade"), this );
	WinCasAction->setStatusTip(tr("Cascade"));
	connect( WinCasAction, SIGNAL( triggered() ) , this, SLOT( Cascade() ) );

	QAction * InsertMD2Action;
	InsertMD2Action= new QAction( "MD2",this);
	InsertMD2Action->setStatusTip(tr("Insert MD2 model"));
	connect( InsertMD2Action, SIGNAL( triggered() ) , this, SLOT( InsertMD2() ) );

	QAction * InsertDXFAction;
	InsertDXFAction= new QAction("DXF",this);
	InsertDXFAction->setStatusTip(tr("Insert DXF model"));
	connect( InsertDXFAction, SIGNAL( triggered() ) , this, SLOT( InsertDXF() ) );

	QAction * ExportDXFAction;
	ExportDXFAction= new QAction( "DXF",  this);
	ExportDXFAction->setStatusTip(tr("Export DXF model"));
	connect( ExportDXFAction, SIGNAL( triggered() ) , this, SLOT( ExportDXF() ) );

	QAction * InsertQ3DAction;
	InsertQ3DAction= new QAction("3DQ", this);
	InsertQ3DAction->setStatusTip(tr("Insert 3DQ model"));
	connect( InsertQ3DAction, SIGNAL( triggered() ) , this, SLOT( InsertQ3DFile() ) );

	QAction * SettingsProgAction;
	SettingsProgAction= new QAction(tr("&Program Settings..."), this);
	SettingsProgAction->setStatusTip(tr("Program Settings"));
	connect( SettingsProgAction, SIGNAL( triggered() ) , this, SLOT( SettingsProg() ) );

	QAction * QuitAction;
	QuitAction = new QAction( QIcon(ProgramPath+"images/fileclose.png"),tr("&Quit"), this);
	QuitAction->setStatusTip(tr("Quit"));
	QuitAction->setShortcut(tr("CTRL+Q"));
	connect( QuitAction, SIGNAL( triggered() ) , qApp, SLOT(closeAllWindows()  ));

	QAction * FnueveAction;
	FnueveAction = new QAction( QIcon(ProgramPath+"images/snap.png"),tr("&Snap"), this);
	FnueveAction->setShortcut(tr("F9"));addAction(FnueveAction);
	connect( FnueveAction, SIGNAL( triggered() ) , this, SLOT(sendsnapcmd()  ));

	QAction * CancelAction;
	CancelAction = new QAction(this);
	CancelAction->setShortcut(tr("Escape"));addAction(CancelAction);
	connect( CancelAction, SIGNAL( triggered() ) , this, SLOT(sendCancel()  ));

	QAction * TexDocsAction;
	TexDocsAction= new QAction( QIcon(ProgramPath+"images/texdocs.png"),tr("&Texture files"),this);
	TexDocsAction->setStatusTip(tr("Texture files"));
	connect( TexDocsAction, SIGNAL( triggered() ) , this, SLOT( TexDocs() ) );
	/*//Draw Actions BEGIN//////////////////////////////////////////////////////////////////////////////////////////////*/
	QAction * DrawLineAction;
	DrawLineAction= new QAction( QIcon(ProgramPath+"images/trails.png"),tr("&Line"),this);
	DrawLineAction->setStatusTip(tr("Draw Line"));
	connect( DrawLineAction, SIGNAL( triggered() ) , this, SLOT( DrawLine() ) );

	QAction * DrawPolyAction;
	DrawPolyAction= new QAction(QIcon(ProgramPath+"images/polygon.png"),tr("&Polygon"),this);
	DrawPolyAction->setStatusTip(tr("Draw polygon"));
	connect( DrawPolyAction, SIGNAL( triggered() ) , this, SLOT( DrawPoly() ) );

	QAction * DrawTriangleAction;
	DrawTriangleAction= new QAction( QIcon(ProgramPath+"images/triangles.png"),tr("&Triangle"),this);
	DrawTriangleAction->setStatusTip(tr("Draw Triangle"));
	connect( DrawTriangleAction, SIGNAL( triggered() ) , this, SLOT( DrawTriangle() ) );

	QAction * DrawCubeAction;
	DrawCubeAction= new QAction( QIcon(ProgramPath+"images/rectangle.png"),tr("&Box"),this);
	DrawCubeAction->setStatusTip(tr("Draw box"));
	connect( DrawCubeAction, SIGNAL( triggered() ) , this, SLOT( DrawCube() ) );

	QAction * DrawArrayAction;
	DrawArrayAction= new QAction(QIcon(ProgramPath+"images/array.png"),tr("&Array"),this);
	DrawArrayAction->setStatusTip(tr("Draw Array"));
	connect( DrawArrayAction, SIGNAL( triggered() ) , this, SLOT( DrawArray() ) );

	QAction * DrawRevolveAction;
	DrawRevolveAction= new QAction( QIcon(ProgramPath+"images/revolve.png"),tr("&Revolve"),this);
	DrawRevolveAction->setStatusTip(tr("Draw Revolve"));
	connect( DrawRevolveAction, SIGNAL( triggered() ) , this, SLOT( Drawrevolve() ) );

	QAction * DrawExtrudeAction;
	DrawExtrudeAction= new QAction( QIcon(ProgramPath+"images/extrude.png"),tr("&Extrude"),this);
	DrawExtrudeAction->setStatusTip(tr("Draw Extrude"));
	connect( DrawExtrudeAction, SIGNAL( triggered() ) , this, SLOT( DrawExtrude() ) );
	/*//Draw Actions END//////////////////////////////////////////////////////////////////////////////////////////////*/
	/*//View Actions BEGIN//////////////////////////////////////////////////////////////////////////////////////////////*/
	QAction * DrawZoomAction;
	DrawZoomAction= new QAction( QIcon(ProgramPath+"images/viewmag2.png"),tr("&Zoom"),this);
	DrawZoomAction->setStatusTip(tr("View Zoom"));
	connect( DrawZoomAction, SIGNAL( triggered() ) , this, SLOT( ViewZoom() ) );

	QAction * DrawPanAction;
	DrawPanAction= new QAction( QIcon(ProgramPath+"images/pan.png"),tr("&Pan"),this);
	DrawPanAction->setStatusTip(tr("View Pan"));
	connect( DrawPanAction, SIGNAL( triggered() ) , this, SLOT( ViewPan() ) );

	QAction * RotateViewAction;
	RotateViewAction= new QAction( QIcon(ProgramPath+"images/rotateview.png"),tr("&Rotate view"),this);
	RotateViewAction->setStatusTip(tr("Rotate View"));
	connect( RotateViewAction, SIGNAL( triggered() ) , this, SLOT( ViewRotateView() ) );

	ViewGroupAction= new QAction( QIcon(ProgramPath+"images/vtop.png"),tr("&Top"),this);
	ViewGroupAction->setStatusTip(tr("Top View"));
	connect( ViewGroupAction, SIGNAL( triggered() ) , this, SLOT( ViewTop() ) );

	QAction * ViewTopAction;
	ViewTopAction= new QAction( QIcon(ProgramPath+"images/vtop.png"),tr("&Top"),this);
	ViewTopAction->setStatusTip(tr("Top View"));
	connect( ViewTopAction, SIGNAL( triggered() ) , this, SLOT( ViewTop() ) );

	QAction * ViewRightAction;
	ViewRightAction= new QAction( QIcon(ProgramPath+"images/vright.png"),tr("&Right"),this);
	ViewRightAction->setStatusTip(tr("Right View"));
	connect( ViewRightAction, SIGNAL( triggered() ) , this, SLOT( ViewRight() ) );

	QAction * ViewFrontAction;
	ViewFrontAction= new QAction( QIcon(ProgramPath+"images/vfront.png"),tr("&Front"),this);
	ViewFrontAction->setStatusTip("Front View");
	connect( ViewFrontAction, SIGNAL( triggered() ) , this, SLOT( ViewFront() ) );

	QAction * ViewIsoAction;
	ViewIsoAction= new QAction( QIcon(ProgramPath+"images/visometric.png"),tr("&Isometric"),this);
	ViewIsoAction->setStatusTip(tr("Isometric View"));
	connect( ViewIsoAction, SIGNAL( triggered() ) , this, SLOT( ViewIsometric() ) );

	QAction * DistAction;
	DistAction= new QAction(QIcon(ProgramPath+"images/dist.png"),tr("&Distance"),this);
	DistAction->setStatusTip(tr("Distance"));
	connect( DistAction, SIGNAL( triggered() ) , this, SLOT( ViewDist() ) );

	/*//View Actions END//////////////////////////////////////////////////////////////////////////////////////////////*/
	/*//Modify Actions BEGIN//////////////////////////////////////////////////////////////////////////////////////////////*/
	QAction * ModUndoAction;
	ModUndoAction= new QAction( QIcon(ProgramPath+"images/undo.png"),tr("&Undo"),this);
	ModUndoAction->setStatusTip(tr("Undo"));
	connect( ModUndoAction, SIGNAL( triggered() ) , this, SLOT( ModUndo() ) );


	QAction * ModPropertiesAction;
	ModPropertiesAction= new QAction( QIcon(ProgramPath+"images/vopts.png"),tr("&Properties"),this);
	ModPropertiesAction->setStatusTip(tr("Properties"));
	connect( ModPropertiesAction, SIGNAL( triggered() ) , this, SLOT( ModProperties() ) );

	QAction * ModEraseAction;
	ModEraseAction= new QAction( QIcon(ProgramPath+"images/erase.png"),tr("&Erase"),this);
	ModEraseAction->setStatusTip(tr("Erase"));
	ModEraseAction->setShortcut(tr("Delete"));
	connect( ModEraseAction, SIGNAL( triggered() ) , this, SLOT( ModErase() ) );

	QAction * ModRotate3dAction;
	ModRotate3dAction= new QAction( QIcon(ProgramPath+"images/rotate3d.png"),tr("&Rotate 3d"),this);
	ModRotate3dAction->setStatusTip(tr("Rotate 3d"));
	connect( ModRotate3dAction, SIGNAL( triggered() ) , this, SLOT( ModRotate3d() ) );

	QAction * ModSliceAction;
	ModSliceAction= new QAction(QIcon(ProgramPath+"images/slice.png"),tr("S&lice"),this);
	ModSliceAction->setStatusTip(tr("Slice"));
	connect( ModSliceAction, SIGNAL( triggered() ) , this, SLOT( ModSlice() ) );

	QAction * ModTexSpherical;
	ModTexSpherical= new QAction(QIcon(ProgramPath+"images/spherical.png"),tr("&Spherical"),this);
	ModTexSpherical->setStatusTip(tr("Spherical UV"));
	connect( ModTexSpherical, SIGNAL( triggered() ) , this, SLOT( ModTexSpherical() ) );

	QAction * ModTexProject;
	ModTexProject= new QAction(QIcon(ProgramPath+"images/texxyz.png"),tr("&Project"),this);
	ModTexProject->setStatusTip(tr("Project"));
	connect( ModTexProject, SIGNAL( triggered() ) , this, SLOT( ModTexProject() ) );

	ModNormAction= new QAction( QIcon(ProgramPath+"images/mnormals.png"),tr("&Mean normals"),this);
	ModNormAction->setStatusTip(tr("Mean normals"));
	connect( ModNormAction, SIGNAL( triggered() ) , this, SLOT( ModMnormals() ) );

	QAction * ModSwitchAction;
	ModSwitchAction= new QAction( QIcon(ProgramPath+"images/switch.png"),tr("S&witch"),this);
	ModSwitchAction->setStatusTip(tr("Switch"));
	connect( ModSwitchAction, SIGNAL( triggered() ) , this, SLOT( ModSwitch() ) );

	QAction * ModFlipAction;
	ModFlipAction= new QAction( QIcon(ProgramPath+"images/flip.png"),tr("&Flip"),this);
	ModFlipAction->setStatusTip(tr("Flip triangles"));
	connect( ModFlipAction, SIGNAL( triggered() ) , this, SLOT( ModFlip() ) );

	QAction * ModTrinormalsAction;
	ModTrinormalsAction= new QAction( QIcon(ProgramPath+"images/trinorm.png"),tr("&Normals Triangle"),this);
	ModTrinormalsAction->setStatusTip(tr("Normals Triangle"));
	connect( ModTrinormalsAction, SIGNAL( triggered() ) , this, SLOT( ModTrinormals() ) );

	QAction * ModMnormalsAction;
	ModMnormalsAction= new QAction( QIcon(ProgramPath+"images/mnormals.png"),tr("&Mean normals"),this);
	ModMnormalsAction->setStatusTip(tr("Mean normals"));
	connect( ModMnormalsAction, SIGNAL( triggered() ) , this, SLOT( ModMnormals() ) );

	/*//Modify Actions END//////////////////////////////////////////////////////////////////////////////////////////////*/
	QAction * HelpAction;
	HelpAction= new QAction(tr("&Help"),this);
	HelpAction->setStatusTip(tr("Help"));
	connect( HelpAction, SIGNAL( triggered() ) , this, SLOT( HelpFun() ) );

	QAction * HelpOnlineAction;
	HelpOnlineAction= new QAction(tr("Help &Online"),this);
	HelpOnlineAction->setStatusTip(tr("Help Online"));
	connect( HelpOnlineAction, SIGNAL( triggered() ) , this, SLOT( HelpOnlineFun() ) );

	QAction * AboutAction;
	AboutAction= new QAction(tr("&About"),this);
	AboutAction->setStatusTip(tr("About"));
	connect( AboutAction, SIGNAL( triggered() ) , this, SLOT( AboutFun() ) );

	QAction * ViewportPropAction;
	ViewportPropAction = new QAction(QIcon(ProgramPath+"images/vwprop.png"), tr("&Viewport Properties"), this);
	ViewportPropAction->setStatusTip(tr("Viewport Properties"));
	ViewportPropAction->setShortcut(tr("Key_F10"));
	connect( ViewportPropAction, SIGNAL( triggered() ) , this, SLOT( ViewportProp() ) );

	QPixmap pix( 16, 16 );pix.fill( 0x8080ff);
	ActionColor = new QAction( pix, tr("&Color..."), this);
	ViewportPropAction->setStatusTip(tr("Color"));
	connect( ActionColor, SIGNAL( triggered() ), this, SLOT( currentColor() ) );

	QAction * ShowTriangAction;
	ShowTriangAction= new QAction( "Triangles",this);
	ShowTriangAction->setStatusTip(tr("Show Triangles"));
	ShowTriangAction->setShortcut(tr("CTRL+T"));
	connect( ShowTriangAction, SIGNAL( triggered() ) , this, SLOT( ShowTriang() ) );

	QAction * ShowLinesAction;
	ShowLinesAction= new QAction( "Lines",this);
	ShowLinesAction->setStatusTip(tr("Show Lines"));
	ShowLinesAction->setShortcut(tr("CTRL+L"));
	connect( ShowLinesAction, SIGNAL( triggered() ) , this, SLOT( ShowLines() ) );

 /*/MENU PRINCIPAL///////////////////////////////*/
//////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////*/

	QMenu *InsertItems = new QMenu( this );
	QMenu *ExportItems = new QMenu( this );
	QMenu *TextureUV = new QMenu( this );
	QMenu *PredefViews = new QMenu( this );
	QMenu *Showsubmenu = new QMenu( this );

	QMenu *file;
	file = menuBar()->addMenu(tr("&File"));
	file->addAction(fileOpenAction);
	file->addAction(fileSaveAction);
	file->addAction(fileSaveAsAction);
	file->addAction(fileCloseAction);
	file->addAction(TexDocsAction);
	file->addSeparator();
	InsertItems=file->addMenu(tr("&Insert"));
    			InsertItems->addAction(InsertMD2Action);
			InsertItems->addAction(InsertDXFAction);
			InsertItems->addAction(InsertQ3DAction);
	ExportItems=file->addMenu(tr("&Export"));
			ExportItems->addAction(ExportDXFAction );
	file->addSeparator();
  	file->addAction(SettingsProgAction);
	file->addSeparator();
	file->addAction(QuitAction);

	QMenu *drawmenu;
	drawmenu = menuBar()->addMenu(tr("&Draw"));
	drawmenu->addAction(DrawLineAction);
	drawmenu->addAction(DrawTriangleAction);
	drawmenu->addAction(DrawPolyAction);
	drawmenu->addAction(DrawCubeAction);
	drawmenu->addSeparator();
	drawmenu->addAction(DrawArrayAction);
	drawmenu->addAction(DrawRevolveAction);
	drawmenu->addAction(DrawExtrudeAction);

	QMenu *view;
	view = menuBar()->addMenu(tr("&View"));
	view->addAction(DrawZoomAction);
	view->addAction(DrawPanAction);
	view->addAction(RotateViewAction);
	view->addSeparator();
	Showsubmenu=view->addMenu(tr("Show"));
		Showsubmenu->addAction(ShowTriangAction);
		Showsubmenu->addAction(ShowLinesAction);
	view->addSeparator();
	PredefViews=view->addMenu(tr("Pr&edefined Views"));
		PredefViews->addAction(ViewTopAction);
		PredefViews->addAction(ViewRightAction);
		PredefViews->addAction(ViewFrontAction);
		PredefViews->addAction(ViewIsoAction);
	view->addSeparator();
	view->addAction(DistAction);

	QMenu *viewport;
	viewport = menuBar()->addMenu(tr("V&iewport"));
	viewport->addAction(ViewPortNewAction);
	viewport->addAction(ViewportPropAction);

	QMenu *modify;
	modify = menuBar()->addMenu(tr("&Modify"));
	modify->addAction(ModUndoAction);
	modify->addSeparator();
	modify->addAction(ModPropertiesAction);
	modify->addAction(ModEraseAction);
	modify->addAction(ModRotate3dAction);
	modify->addAction(FnueveAction);
	modify->addSeparator();
	modify->addAction(ModSliceAction);
	modify->addSeparator();
	TextureUV=modify->addMenu(tr("&Texture UV"));
    		TextureUV->addAction(ModTexProject);
		TextureUV->addAction(ModTexSpherical);
	modify->addSeparator();
	modify->addAction(ModFlipAction);
	modify->addAction(ModSwitchAction);
	modify->addAction(ModTrinormalsAction);
	modify->addAction(ModMnormalsAction);

	QMenu *windowsMenu;
	windowsMenu = menuBar()->addMenu(tr("&Windows"));
	windowsMenu->addAction(WinTileAction);
	windowsMenu->addAction(WinCasAction);

	QMenu *HelpMenu;
	HelpMenu = menuBar()->addMenu(tr("&Help"));
	HelpMenu->addAction(HelpAction);
	HelpMenu->addAction(HelpOnlineAction);
	HelpMenu->addAction(AboutAction);



/*//TOOLBAR//////////////////////////////////////////////*/
//////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////*/
	QMenu *NormPop = new QMenu( this );


	QToolBar *ToolB;
	ToolB = addToolBar(tr("File"));
	ToolB->setIconSize(QSize(16,16));
	ToolB->addAction(fileOpenAction);
	ToolB->addAction(fileSaveAction);

	QToolBar *DrawTool;
	DrawTool = addToolBar(tr("Draw"));
	DrawTool->setIconSize(QSize(16,16));
	DrawTool->addAction(DrawLineAction);
	DrawTool->addAction(DrawTriangleAction);
	DrawTool->addAction(DrawPolyAction);
	DrawTool->addAction(DrawCubeAction);
	DrawTool->addAction(DrawArrayAction);
	DrawTool->addAction(DrawRevolveAction);
	DrawTool->addAction(DrawExtrudeAction);

	QToolBar *ToolMod;
	ToolMod = addToolBar(tr("Modify"));
	ToolMod->setIconSize(QSize(16,16));
	ToolMod->addAction(ModUndoAction);
	ToolMod->addAction(ActionColor);
	ToolMod->addAction(ModPropertiesAction);
	ToolMod->addAction(ModEraseAction);
	ToolMod->addAction(ModRotate3dAction);
	ToolMod->addAction(ModSliceAction);
		NormPop->addAction(ModFlipAction);
		NormPop->addAction(ModSwitchAction);
		NormPop->addAction(ModTrinormalsAction);
		NormPop->addAction(ModMnormalsAction);
		ModNormAction->setMenu(NormPop);
	ToolMod->addAction(ModNormAction);

	QToolBar *ViewTool;
	ViewTool = addToolBar(tr("View"));
	ViewTool->setIconSize(QSize(16,16));
	ViewTool->addAction(DrawZoomAction);
	ViewTool->addAction(DrawPanAction);
	ViewTool->addAction(RotateViewAction);
	ViewGroupAction->setMenu(PredefViews);
	ViewTool->addAction(ViewGroupAction);
	ViewTool->addAction(DistAction);

	QToolBar *ViewportTool;
	ViewportTool = addToolBar(tr("Viewport"));
	ViewportTool->setIconSize(QSize(16,16));
	ViewportTool->addAction(ViewPortNewAction);
	ViewportTool->addAction(ViewportPropAction);



/*/////////////////////////////////////////////////////*/



	hcmd->setGeometry( 0,0,100, 20 );


	QPalette newPalette = palette();
	newPalette.setColor(QPalette::Background, QColor::QColor(170,170,255));
	newPalette.setColor(QPalette::Foreground, QColor::QColor(0,0,0));
	newPalette.setColor(QPalette::Base, QColor::QColor(170,170,255));



	hHL->addWidget(Label1);
	hHL->addWidget(ecmd);
	hVc->addWidget(hcmd);
	hHL->setMargin(0);hHL->setSpacing(0);
	hVc->setMargin(0);hVc->setSpacing(0);
	WhVc->setLayout(hVc);


	s1->addWidget(ws);
	s1->addWidget(WhVc);

	ws->setScrollBarsEnabled( TRUE );


	Label1->setPalette(newPalette);
	ecmd->setPalette(newPalette);


	vboxLayout->addWidget(s1);
	vboxLayout->addLayout(hHL);
	vboxLayout->setMargin(0);
	vboxLayout->setSpacing(0);

	hcmd->setWindowIcon( QPixmap(ProgramPath+"images/console.png"));
	hcmd->setGeometry( 0,0,100, 20 );
	hcmd->currentcolor=currentcolor;
	hcmd->ucsicon=&ucsicon;
	hcmd->setDataL(&DataLV,&DataTV,View,MouseMode);




	QWidget *vb=new QWidget(this);
	vb->setLayout(vboxLayout);

	setCentralWidget(vb);

	connect( ecmd, SIGNAL(returnPressed()) , this, SLOT(sendCmd()  ));
	connect( ecmd, SIGNAL( lostFocus() ) , ecmd, SLOT(setFocus()  ));
	connect( hcmd, SIGNAL( instru(const QString&) ), Label1, SLOT( setText(const QString& )) );
	connect( hcmd, SIGNAL( SetMouseMode(int )), this, SLOT( SetMouseMode(int )) );
	connect( hcmd, SIGNAL( ZoomVar(float )), this, SLOT( ZoomVar(float )) );

	/*/CURSOR//////////////////////////////////////////////////////////////////*/
	QBitmap curb1(32,32);
	QBitmap curb2(32,32);
	curb1.fill(QColor(255,255,255));
	curb2.fill(QColor(255,255,255));
	QPainter p;

	p.begin( &curb1 );p.drawLine(16,0,16,31);p.drawLine(0,16,31,16);p.end();
	gencursor[MOUSEMODE_PICKPOINT]=QCursor(curb2,curb1);
	p.begin( &curb1 );p.setBrush(Qt::NoBrush);p.drawRect(13, 13,6,6 );p.end();
	gencursor[MOUSEMODE_SELECT]=QCursor(curb2,curb1);
	gencursor[MOUSEMODE_ZOOM]=QCursor(QBitmap(ProgramPath+"images/zoomi.png"),QBitmap(ProgramPath+"images/zoomim.png"));
	gencursor[MOUSEMODE_PAN]=QCursor(QBitmap(ProgramPath+"images/pani.png"),QBitmap(ProgramPath+"images/panm.png"));
	gencursor[MOUSEMODE_ROTATE]=QCursor(QBitmap(ProgramPath+"images/rotatei.png"),QBitmap(ProgramPath+"images/rotatem.png"));

	/*///////////////////////////////////////////////////////////////////*/

	ecmd->setFocus();
	statusBar()->showMessage(tr("Ready"),2000);
	setWindowTitle("AutoQ3D");
	setWindowIcon( QPixmap(ProgramPath+"AutoQ3D.png") );

	hcmd->setMinimumSize(hcmd->minimumSizeHint().width(),50);
	hcmd->setSizePolicy(QSizePolicy(QSizePolicy::Minimum,QSizePolicy::Ignored));
	setGeometry( 30,30,780, 550 );
	newViewPort();
}


/*/////////////////////////////////////////////////////*/
/*/////////////////////////////////////////////////////*/
void CadForm::closeEvent(QCloseEvent*)
{
	exit();
}
/*/////////////////////////////////////////////////////*/
/*/////////////////////////////////////////////////////*/
void CadForm::exit()
{
	/*QSettings settings;
	settings.writeEntry( APP_KEY + "ProgramPath",ProgramPath );*/

	QApplication::exit( 0 );
}



CadForm::~CadForm(){


}


void CadForm::ZoomVar(float var){
	GLApp *win=(GLApp*)ws->activeWindow();
	if(win){
		win->GLThisArea->ZoomVar(var);
	}

}

/*/////////////////////////////////////////////////////*/
/*/////////////////////////////////////////////////////*/
void CadForm::SetMouseMode(int mmode){

	int i;
	MouseMode[0]=mmode;

	QWidgetList windoL=ws->windowList(QWorkspace::CreationOrder);
	if ( windoL.count() ) {
        	for (i = 0; i < int(windoL.count()); i++) {
			GLApp *win =(GLApp*) windoL.at( i );
			win->GLThisArea->setCursor(gencursor[mmode]);
			win->GLThisArea->UpdateMouseMove();
		}
	}


}
/*/////////////////////////////////////////////////////*/
/*/////////////////////////////////////////////////////*/
void CadForm::AboutFun(){
	About* w = new About;
	w->exec();
	w->setAttribute(Qt::WA_DeleteOnClose);
	w->close();

}
/*/////////////////////////////////////////////////////*/
/*/////////////////////////////////////////////////////*/
void CadForm::TexDocs(){
	int i;
	QString filedir(filename);
	filedir.truncate(filedir.lastIndexOf( "/" ));


	TexForm* w = new TexForm( 0,0,hcmd->StrTex,filedir);
	if(w->exec()){
		hcmd->StrTex.clear();
		for(i=0;i<w->srtlist2.count();i++){
			hcmd->StrTex<<w->srtlist2.at(i);
			/*hcmd->SendText(*w->srtlist2.at(i));*/
		}

			QWidgetList windoL=ws->windowList(QWorkspace::CreationOrder);
		if ( windoL.count() ) {
	        	for (i = 0; i < windoL.count(); i++) {
				GLApp *win =(GLApp*) windoL.at( i );
				win->GLThisArea->makeCurrent();
				win->GLThisArea->DeleteAllTextures();
				win->GLThisArea->LoadAllTextures();
				win->GLThisArea->updateGL();

			}
		}

	}
	w->setAttribute(Qt::WA_DeleteOnClose);
	w->close();
	ecmd->setFocus();

}
/*/////////////////////////////////////////////////////*/
/*/////////////////////////////////////////////////////*/

void CadForm::currentColor(){

	QColor col = QColorDialog::getColor( QColor ( (int)round(currentcolor[0]*255.0), (int)round(currentcolor[1]*255.0), (int)round(currentcolor[2]*255.0)), this );
	if ( !col.isValid() )
	return;

	QPixmap pix( 16, 16 );pix.fill( col );
	ActionColor->setIcon( pix );
	currentcolor[0]=(float)col.red()/255.0;currentcolor[1]=(float)col.green()/255.0;currentcolor[2]=(float)col.blue()/255.0;

}
/*/////////////////////////////////////////////////////*/
/*/////////////////////////////////////////////////////*/
void CadForm::DrawLine(){hcmd->processcmd(tr("line"));}
void CadForm::DrawTriangle(){hcmd->processcmd(tr("triangle"));}
void CadForm::DrawPoly(){hcmd->processcmd(tr("polygon"));}
void CadForm::DrawCube(){hcmd->processcmd(tr("box"));}
void CadForm::Drawrevolve(){hcmd->processcmd(tr("revolve"));}
void CadForm::DrawArray(){hcmd->processcmd(tr("array"));}
void CadForm::DrawExtrude(){hcmd->processcmd(tr("extrude"));}
void CadForm::ModTexProject(){hcmd->processcmd(tr("tex"));}
void CadForm::ModTexSpherical(){hcmd->processcmd(tr("sptex"));}

void CadForm::ViewZoom(){hcmd->processcmd(tr("'zoom"));}
void CadForm::ViewPan(){hcmd->processcmd(tr("'pan"));}
void CadForm::ViewRotateView(){hcmd->processcmd(tr("'rotateview"));}
void CadForm::ViewDist(){hcmd->processcmd(tr("dist"));}

void CadForm::ModProperties(){hcmd->processcmd(tr("properties"));}
void CadForm::ModErase(){hcmd->processcmd(tr("erase"));}
void CadForm::ModRotate3d(){hcmd->processcmd(tr("rotate3d"));}
void CadForm::ModSlice(){hcmd->processcmd(tr("slice"));}
void CadForm::sendsnapcmd(){hcmd->processcmd(tr("'snap"));}
void CadForm::ModUndo(){hcmd->processcmd(tr("undo"));}
void CadForm::ShowTriang(){hcmd->processcmd(tr("'str"));UpdateAll();}
void CadForm::ShowLines(){hcmd->processcmd(tr("'sln"));UpdateAll();}

void CadForm::ViewTop(){
	ViewGroupAction->disconnect();
	ViewGroupAction->setIcon(QIcon(ProgramPath+"images/vtop.png"));ViewGroupAction->setStatusTip(tr("View Top"));ViewGroupAction->setText(tr("Top"));
	GLApp *win=(GLApp*)ws->activeWindow();
	if(win){
		win->GLThisArea->ViewMode(0);
		connect( ViewGroupAction, SIGNAL( triggered() ) , this, SLOT( ViewTop() ) );
	}
}
void CadForm::ViewRight(){
	ViewGroupAction->disconnect();
	ViewGroupAction->setIcon(QIcon(ProgramPath+"images/vright.png"));ViewGroupAction->setStatusTip(tr("View Right"));ViewGroupAction->setText(tr("Right"));
	GLApp *win=(GLApp*)ws->activeWindow();
	if(win){
		win->GLThisArea->ViewMode(1);
		connect( ViewGroupAction, SIGNAL( triggered() ) , this, SLOT( ViewRight() ) );
	}
}
void CadForm::ViewFront(){
	ViewGroupAction->disconnect();
	ViewGroupAction->setIcon(QIcon(ProgramPath+"images/vfront.png"));ViewGroupAction->setStatusTip(tr("View Front"));ViewGroupAction->setText(tr("Front"));
	GLApp *win=(GLApp*)ws->activeWindow();
	if(win){
		win->GLThisArea->ViewMode(2);
		connect( ViewGroupAction, SIGNAL( triggered() ) , this, SLOT( ViewFront() ) );
	}
}
void CadForm::ViewIsometric(){
	ViewGroupAction->disconnect();
	ViewGroupAction->setIcon(QIcon(ProgramPath+"images/visometric.png"));ViewGroupAction->setStatusTip(tr("View Isometric"));ViewGroupAction->setText(tr("Isometric"));
	GLApp *win=(GLApp*)ws->activeWindow();
	if(win){
		win->GLThisArea->ViewMode(3);
		connect( ViewGroupAction, SIGNAL( triggered() ) , this, SLOT( ViewIsometric() ) );
	}
}

void CadForm::ModSwitch(){
	ModNormAction->disconnect();
	ModNormAction->setIcon(QIcon(ProgramPath+"images/switch.png"));ModNormAction->setStatusTip(tr("Switch"));ModNormAction->setText(tr("Switch"));
	hcmd->processcmd(tr("switch"));
	connect( ModNormAction, SIGNAL( triggered() ) , this, SLOT( ModSwitch() ) );

}
void CadForm::ModTrinormals(){
	ModNormAction->disconnect();
	ModNormAction->setIcon(QIcon(ProgramPath+"images/trinorm.png"));ModNormAction->setStatusTip(tr("Normals Triangle"));ModNormAction->setText(tr("Normals Triangle"));
	hcmd->processcmd(tr("trinormals"));
	connect( ModNormAction, SIGNAL( triggered() ) , this, SLOT( ModTrinormals() ) );

}
void CadForm::ModMnormals(){
	ModNormAction->disconnect();
	ModNormAction->setIcon(QIcon(ProgramPath+"images/mnormals.png"));ModNormAction->setStatusTip(tr("Mean normals"));ModNormAction->setText(tr("Mean normals"));
	hcmd->processcmd(tr("mnormals"));
	connect( ModNormAction, SIGNAL( triggered() ) , this, SLOT( ModMnormals() ) );

}

void CadForm::ModFlip(){
	ModNormAction->disconnect();
	ModNormAction->setIcon(QIcon(ProgramPath+"images/flip.png"));ModNormAction->setStatusTip(tr("Flip triangles"));ModNormAction->setText(tr("Flip"));
	hcmd->processcmd(tr("flip"));
	connect( ModNormAction, SIGNAL( triggered() ) , this, SLOT( ModFlip() ) );

}
/*/////////////////////////////////////////////////////*/
/*/////////////////////////////////////////////////////*/

void CadForm::UpdateAll(){

	int i;
	QWidgetList windoL=ws->windowList(QWorkspace::CreationOrder);
	if ( windoL.count() ) {
        	for (i = 0; i < int(windoL.count()); i++) {
			GLApp *win =(GLApp*) windoL.at( i );
			win->GLThisArea->updateGL();
		}
	}

}


/*/////////////////////////////////////////////////////*/
/*/////////////////////////////////////////////////////*/
GLApp* CadForm::newViewPort()
{
	sendCancel();
	hcmd->SendText(tr("--New Viewport--"));
	GLApp* w = new GLApp(0, Qt::Widget,&hcmd->StrTex);
	ws->addWindow(w);
	w->setAttribute(Qt::WA_DeleteOnClose);
	connect( w->GLThisArea, SIGNAL( setCmdData(dataformat) ) ,hcmd, SLOT(setCmdData(dataformat)  ));
	connect( w->GLThisArea, SIGNAL( processcmd(QString) ) ,hcmd, SLOT(processcmd(QString)  ));
	connect( w->GLThisArea, SIGNAL( SendText(QString) ) ,hcmd, SLOT(SendText(QString)  ));
	connect( w->GLThisArea, SIGNAL( UpdateAll() ) ,this, SLOT(UpdateAll()  ));
	connect( w->GLThisArea, SIGNAL( message(const QString&, int) ), statusBar(), SLOT( showMessage(const QString&, int )) );

	w->GLThisArea->setDataL(&DataLV,&DataTV,&hcmd->DataSV,&hcmd->DataSLV,&hcmd->DataSTV,MouseMode);
	w->GLThisArea->rtlines=hcmd->rtlines;
	w->GLThisArea->GriPoint=hcmd->GriPoint;
	w->GLThisArea->currentpoint=hcmd->currentpoint;
	w->GLThisArea->ucsicon=&ucsicon;
	w->GLThisArea->SnaPoint=hcmd->SnaPoint;
	w->GLThisArea->SnapMode=hcmd->SnapMode;
	w->GLThisArea->SnapFlags=hcmd->SnapFlags;
	w->GLThisArea->rtcolor=hcmd->rtcolor;
	w->GLThisArea->rtcolor1=hcmd->rtcolor1;
	w->GLThisArea->GripEditMode=hcmd->GripEditMode;
	w->GLThisArea->currentcolor=currentcolor;
	w->GLThisArea->cscalarf=hcmd->cscalarf;
	w->GLThisArea->cscalari=hcmd->cscalari;
	w->GLThisArea->View=View;

	w->setWindowTitle(QString::QString(tr("ViewPort-%1")).arg(numDoc++));w->setWindowIcon( QPixmap(ProgramPath+"images/document.png") );
	w->show();
	QWidgetList windoL=ws->windowList(QWorkspace::CreationOrder);
	if ( windoL.count()==1){
		w->showMaximized();
	}else{

		ws->tile();
	}


	UpdateAll();
	SetMouseMode(MOUSEMODE_SELECT);
	return w;
}



/*/////////////////////////////////////////////////////*/
/*/////////////////////////////////////////////////////*/


void CadForm::OpenFile()
{
	sendCancel();
	int i=0;
	int temp1,temp2;
	QWidgetList windoL=ws->windowList(QWorkspace::CreationOrder);
	if ( windoL.count() ) {
        	for (i = 0; i < int(windoL.count()); i++) {
			GLApp *win =(GLApp*) windoL.at( i );
			win->close();
		}
	}
	DataLV.resize(0);DataTV.resize(0);hcmd->DataSV.resize(0);

	QString fn = QFileDialog::getOpenFileName(this,QString(""),filename,"3D model(*.3dq)" );
	float version;
	QString tempo;
	int numlines,numtriangles,numtextures;
	i=0;
	if ( !fn.isEmpty() ) {

	QFile f( fn );

	if ( !f.open( QIODevice::ReadOnly ) ){

		QMessageBox::critical( this,tr("Fatal error"),QString(tr("Open failed")),tr("OK") );
		f.close();

	}else{
		filename=fn;

		QTextStream t(&f);
		if(!sscanf(t.readLine().toAscii(),"ver3data=%f",&version)){
			f.close();
			QMessageBox::critical( this,tr("Fatal error"),QString(tr("Open failed")),tr("OK") );
			return;
		}

        if(version==1.0){
		   sscanf(t.readLine().toAscii(),"numlines=%d",&numlines);
		   sscanf(t.readLine().toAscii(),"numtriangles=%d",&numtriangles);
		   sscanf(t.readLine().toAscii(),"numtextures=%d",&numtextures);
		   /*sscanf(t.readLine(),"numtextures=%d",&numtextures);*/
		   setWindowTitle("AutoQ3D--"+filename);
		   QString filedir(filename);
		   filedir.truncate(filedir.lastIndexOf( "/" ));
		   hcmd->StrTex.clear();
		   for(i=0;i<numtextures;i++){
			   hcmd->StrTex+=filedir+"/"+t.readLine();
		   }

		   /*while(!t.atEnd()){*/
		   for(i=0;i<numlines;i++){
			   DataLV.resize(i+1);
			   sscanf(t.readLine().toAscii(),"%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f",&DataLV[i].v1[0],&DataLV[i].v1[1],&DataLV[i].v1[2],&DataLV[i].v2[0],&DataLV[i].v2[1],&DataLV[i].v2[2],&DataLV[i].c1[0],&DataLV[i].c1[1],&DataLV[i].c1[2],&DataLV[i].c2[0],&DataLV[i].c2[1],&DataLV[i].c2[2]);
		   }

		   for(i=0;i<numtriangles;i++){
			   DataTV.resize(i+1);
		 	   sscanf(t.readLine().toAscii(),"%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%d,%f,%f,%f,%f,%f,%f",&DataTV[i].v1[0],&DataTV[i].v1[1],&DataTV[i].v1[2],&DataTV[i].v2[0],&DataTV[i].v2[1],&DataTV[i].v2[2],&DataTV[i].v3[0],&DataTV[i].v3[1],&DataTV[i].v3[2],&DataTV[i].c1[0],&DataTV[i].c1[1],&DataTV[i].c1[2],&DataTV[i].c2[0],&DataTV[i].c2[1],&DataTV[i].c2[2],&DataTV[i].c3[0],&DataTV[i].c3[1],&DataTV[i].c3[2],&DataTV[i].n1[0],&DataTV[i].n1[1],&DataTV[i].n1[2],&DataTV[i].n2[0],&DataTV[i].n2[1],&DataTV[i].n2[2],&DataTV[i].n3[0],&DataTV[i].n3[1],&DataTV[i].n3[2],&DataTV[i].texture,&DataTV[i].t1[0],&DataTV[i].t1[1],&DataTV[i].t2[0],&DataTV[i].t2[1],&DataTV[i].t3[0],&DataTV[i].t3[1]);
		   }
        }

        if(version==2.0){
		   sscanf(t.readLine().toAscii(),"numlines=%d",&numlines);
		   sscanf(t.readLine().toAscii(),"numtriangles=%d",&numtriangles);
		   sscanf(t.readLine().toAscii(),"numtextures=%d",&numtextures);
		   /*sscanf(t.readLine(),"numtextures=%d",&numtextures);*/
		   setWindowTitle("AutoQ3D--"+filename);
		   QString filedir(filename);
		   filedir.truncate(filedir.lastIndexOf( "/" ));
		   hcmd->StrTex.clear();

		   while(!t.atEnd()){

              tempo=t.readLine();

              if(!tempo.compare("[TEXTURES]")){
                  tempo=t.readLine();
                  while(tempo.compare("[END]")){
                      hcmd->StrTex+=filedir+"/"+tempo;
                      tempo=t.readLine();
                  }
              }


              if(!tempo.compare("[LINES]")){
                 tempo=t.readLine();
                  while(tempo.compare("[END]")){
                      i=DataLV.size();DataLV.resize(i+1);
                      sscanf(tempo.toAscii(),"%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f",&DataLV[i].v1[0],&DataLV[i].v1[1],&DataLV[i].v1[2],&DataLV[i].v2[0],&DataLV[i].v2[1],&DataLV[i].v2[2],&DataLV[i].c1[0],&DataLV[i].c1[1],&DataLV[i].c1[2],&DataLV[i].c2[0],&DataLV[i].c2[1],&DataLV[i].c2[2]);
                      tempo=t.readLine();
                  }
              }

              if(!tempo.compare("[TRIANGLES]")){
                 tempo=t.readLine();
                  while(tempo.compare("[END]")){
                      i=DataTV.size();DataTV.resize(i+1);
		              sscanf(tempo.toAscii(),"%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%d,%f,%f,%f,%f,%f,%f",&DataTV[i].v1[0],&DataTV[i].v1[1],&DataTV[i].v1[2],&DataTV[i].v2[0],&DataTV[i].v2[1],&DataTV[i].v2[2],&DataTV[i].v3[0],&DataTV[i].v3[1],&DataTV[i].v3[2],&DataTV[i].c1[0],&DataTV[i].c1[1],&DataTV[i].c1[2],&DataTV[i].c2[0],&DataTV[i].c2[1],&DataTV[i].c2[2],&DataTV[i].c3[0],&DataTV[i].c3[1],&DataTV[i].c3[2],&DataTV[i].n1[0],&DataTV[i].n1[1],&DataTV[i].n1[2],&DataTV[i].n2[0],&DataTV[i].n2[1],&DataTV[i].n2[2],&DataTV[i].n3[0],&DataTV[i].n3[1],&DataTV[i].n3[2],&DataTV[i].texture,&DataTV[i].t1[0],&DataTV[i].t1[1],&DataTV[i].t2[0],&DataTV[i].t2[1],&DataTV[i].t3[0],&DataTV[i].t3[1]);
                      tempo=t.readLine();
                  }
              }
              if(!tempo.compare("[TEXT]")){
                 tempo=t.readLine();
                  while(tempo.compare("[END]")){
                      tempo=t.readLine();
                  }
              }

           }
        }

        if(version==3.0){
		   sscanf(t.readLine().toAscii(),"numlines=%d",&numlines);
		   sscanf(t.readLine().toAscii(),"numtriangles=%d",&numtriangles);
		   sscanf(t.readLine().toAscii(),"numtextures=%d",&numtextures);
		   /*sscanf(t.readLine(),"numtextures=%d",&numtextures);*/
		   setWindowTitle("AutoQ3D--"+filename);
		   QString filedir(filename);
		   filedir.truncate(filedir.lastIndexOf( "/" ));
		   hcmd->StrTex.clear();

		   while(!t.atEnd()){

              tempo=t.readLine();
              if(!tempo.compare("[GROUP]")){
                  tempo=t.readLine();
                  while(tempo.compare("[END]")){
                      tempo=t.readLine();
                  }
              }
              if(!tempo.compare("[TEXTURES]")){
                  tempo=t.readLine();
                  while(tempo.compare("[END]")){
                      hcmd->StrTex+=filedir+"/"+tempo;
                      tempo=t.readLine();
                  }
              }


              if(!tempo.compare("[LINES]")){
                 tempo=t.readLine();
                  while(tempo.compare("[END]")){
                      i=DataLV.size();DataLV.resize(i+1);
                      sscanf(tempo.toAscii(),"%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%d,%d",&DataLV[i].v1[0],&DataLV[i].v1[1],&DataLV[i].v1[2],&DataLV[i].v2[0],&DataLV[i].v2[1],&DataLV[i].v2[2],&DataLV[i].c1[0],&DataLV[i].c1[1],&DataLV[i].c1[2],&DataLV[i].c2[0],&DataLV[i].c2[1],&DataLV[i].c2[2],&temp1,&temp2);
                      tempo=t.readLine();
                  }
              }

              if(!tempo.compare("[TRIANGLES]")){
                 tempo=t.readLine();
                  while(tempo.compare("[END]")){
                      i=DataTV.size();DataTV.resize(i+1);
		              sscanf(tempo.toAscii(),"%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%d,%f,%f,%f,%f,%f,%f,%d",&DataTV[i].v1[0],&DataTV[i].v1[1],&DataTV[i].v1[2],&DataTV[i].v2[0],&DataTV[i].v2[1],&DataTV[i].v2[2],&DataTV[i].v3[0],&DataTV[i].v3[1],&DataTV[i].v3[2],&DataTV[i].c1[0],&DataTV[i].c1[1],&DataTV[i].c1[2],&DataTV[i].c2[0],&DataTV[i].c2[1],&DataTV[i].c2[2],&DataTV[i].c3[0],&DataTV[i].c3[1],&DataTV[i].c3[2],&DataTV[i].n1[0],&DataTV[i].n1[1],&DataTV[i].n1[2],&DataTV[i].n2[0],&DataTV[i].n2[1],&DataTV[i].n2[2],&DataTV[i].n3[0],&DataTV[i].n3[1],&DataTV[i].n3[2],&DataTV[i].texture,&DataTV[i].t1[0],&DataTV[i].t1[1],&DataTV[i].t2[0],&DataTV[i].t2[1],&DataTV[i].t3[0],&DataTV[i].t3[1],&temp1);
                      tempo=t.readLine();
                  }
              }
              if(!tempo.compare("[TEXT]")){
                 tempo=t.readLine();
                  while(tempo.compare("[END]")){
                      tempo=t.readLine();
                  }
              }

           }
        }


		f.close();

		newViewPort();
		ecmd->setFocus();

	}


    }else {
	statusBar()->showMessage(tr("Loading aborted"), 2000 );
    }
}

/*/////////////////////////////////////////////////////*/
/*/////////////////////////////////////////////////////*/
void CadForm::SaveFile()
{
	int i;
	QString tempo;
	if (filename.isEmpty()){SaveAsFile();return;}

	QFile f(filename);
	if ( !f.open( QIODevice::WriteOnly ) ) {QMessageBox::critical(this,tr("Information"),QString(tr("Could not write to %1")).arg(filename), tr("&OK"));return;}

	QTextStream stream( &f );stream<<"ver3data=3.0\nnumlines="<<DataLV.size()<<"\nnumtriangles="<<DataTV.size()<<"\nnumtextures="<<hcmd->StrTex.count()<<"\n";

	stream<<"[TEXTURES]\n";
	for(QStringList::Iterator it=hcmd->StrTex.begin();it!=hcmd->StrTex.end();++it){
		tempo=*it;
		tempo.remove( 0,tempo.lastIndexOf( "/" )+1);
		stream<<tempo<<"\n";
	}
	stream<<"[END]\n[LINES]\n";
	for(i=0;i<DataLV.size();i++){
		stream<<DataLV[i].v1[0]<<","<<DataLV[i].v1[1]<<","<<DataLV[i].v1[2]<<","<<DataLV[i].v2[0]<<","<<DataLV[i].v2[1]<<","<<DataLV[i].v2[2]<<","<<DataLV[i].c1[0]<<","<<DataLV[i].c1[1]<<","<<DataLV[i].c1[2]<<","<<DataLV[i].c2[0]<<","<<DataLV[i].c2[1]<<","<<DataLV[i].c2[2]<<",0,0\n";
	}
	stream<<"[END]\n[TRIANGLES]\n";
	for(i=0; i<DataTV.size();i++){
		stream<<DataTV[i].v1[0]<<","<<DataTV[i].v1[1]<<","<<DataTV[i].v1[2]<<","<<DataTV[i].v2[0]<<","<<DataTV[i].v2[1]<<","<<DataTV[i].v2[2]<<","<<DataTV[i].v3[0]<<","<<DataTV[i].v3[1]<<","<<DataTV[i].v3[2]<<","<<DataTV[i].c1[0]<<","<<DataTV[i].c1[1]<<","<<DataTV[i].c1[2]<<","<<DataTV[i].c2[0]<<","<<DataTV[i].c2[1]<<","<<DataTV[i].c2[2]<<","<<DataTV[i].c3[0]<<","<<DataTV[i].c3[1]<<","<<DataTV[i].c3[2]<<","<<DataTV[i].n1[0]<<","<<DataTV[i].n1[1]<<","<<DataTV[i].n1[2]<<","<<DataTV[i].n2[0]<<","<<DataTV[i].n2[1]<<","<<DataTV[i].n2[2]<<","<<DataTV[i].n3[0]<<","<<DataTV[i].n3[1]<<","<<DataTV[i].n3[2]<<","<<DataTV[i].texture<<","<<DataTV[i].t1[0]<<","<<DataTV[i].t1[1]<<","<<DataTV[i].t2[0]<<","<<DataTV[i].t2[1]<<","<<DataTV[i].t3[0]<<","<<DataTV[i].t3[1]<<",0\n";
	}
	stream<<"[END]\n";


	f.close();
	setWindowTitle("AutoQ3D--"+filename);
	hcmd->SendText(tr("--Save file--"));
}

/*/////////////////////////////////////////////////////*/
/*/////////////////////////////////////////////////////*/
void CadForm::SaveAsFile()
{
	QString fn = QFileDialog::getSaveFileName( this,QString(""),filename, QString("") );
	if ( !fn.isEmpty() ) {
	if((int)(fn.length()-4)==fn.lastIndexOf(".3dq")){
		filename = fn;
		}else{
			filename = fn+".3dq";
		}
		SaveFile();
	} else {
		statusBar()->showMessage( tr("Saving aborted"), 2000 );
	}

}
/*/////////////////////////////////////////////////////*/
/*/////////////////////////////////////////////////////*/





/*/////////////////////////////////////////////////////*/
/*/////////////////////////////////////////////////////*/
void CadForm::sendCmd(){
	dataformat info;int i;
	QStringList nums=ecmd->text().split(",");
	QString currstr[3];
	info.v[0]=0;info.v[1]=0;info.v[2]=0;
	info.format=0;

	if(nums.count()>1){
		for(i=0;i<nums.count();i++){
			currstr[i]=nums.at(i);
			if(currstr[0].startsWith("@")){
				info.format=1;
				currstr[0].remove(0,1);
			}
			info.v[i]=currstr[i].toFloat();
		}
		hcmd->SendText(ecmd->text());
		ecmd->setText("");
		hcmd->setCmdData(info);

	}else{
		nums=ecmd->text().split("<");
		if(nums.count()==2){
			currstr[0]=nums.at(0);
			currstr[1]=nums.at(1);
			if(currstr[0].startsWith("@")){
				info.format=1;
				currstr[0].remove(0,1);
			}
			info.v[0]=currstr[0].toFloat()*cosf(currstr[1].toFloat()*M_PI/180.0);
			info.v[1]=currstr[0].toFloat()*sinf(currstr[1].toFloat()*M_PI/180.0);
			hcmd->SendText(ecmd->text());
			ecmd->setText("");
			hcmd->setCmdData(info);

		}else{

			QDoubleValidator *vale=new QDoubleValidator(this);
			QString str(ecmd->text());
			int temp=0;
			if(vale->validate(str,temp)==QValidator::Acceptable){
				info.format=2;
				info.v[0]=ecmd->text().toFloat();
				hcmd->SendText(ecmd->text());
				ecmd->setText("");
				hcmd->setCmdData(info);
				UpdateAll();
				return;
			}

		hcmd->processcmd(ecmd->text());ecmd->setText("");
		}
	}
	UpdateAll();

}

void CadForm::InsertQ3DFile(){
	int i=0,j=0;
	QWidgetList windoL=ws->windowList(QWorkspace::CreationOrder);

	QString fn = QFileDialog::getOpenFileName(this,QString(tr("Insert 3dq file")),filename,tr("3D model(*.3dq)") );
	float version;
	QString tempo;
	int numtexold;
	int numlines,numtriangles,numtextures;
	i=0;
	if ( !fn.isEmpty() ) {

	QFile f( fn );

	if ( !f.open( QIODevice::ReadOnly ) ){

		QMessageBox::critical( this,tr("Fatal error"),QString(tr("Open failed")),tr("OK") );
		f.close();

	}else{
		filename=fn;

		QTextStream t(&f);
		if(!sscanf(t.readLine().toAscii(),"ver3data=%f",&version)){
			f.close();
			QMessageBox::critical( this,tr("Fatal error"),QString(tr("Open failed")),tr("OK") );
			return;
		}

        if(version==1.0){
		   sscanf(t.readLine().toAscii(),"numlines=%d",&numlines);
		   sscanf(t.readLine().toAscii(),"numtriangles=%d",&numtriangles);
		   sscanf(t.readLine().toAscii(),"numtextures=%d",&numtextures);
		   /*sscanf(t.readLine(),"numtextures=%d",&numtextures);*/
		   setWindowTitle("AutoQ3D--"+filename);
		   QString filedir(filename);
		   filedir.truncate(filedir.lastIndexOf( "/" ));
		   numtexold=hcmd->StrTex.count();
		   for(i=0;i<numtextures;i++){
			   hcmd->StrTex+=filedir+"/"+t.readLine();
		   }

		   /*while(!t.atEnd()){*/
		   for(i=0;i<numlines;i++){
			   j=DataLV.size();DataLV.resize(j+1);
			   sscanf(t.readLine().toAscii(),"%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f",&DataLV[j].v1[0],&DataLV[j].v1[1],&DataLV[j].v1[2],&DataLV[j].v2[0],&DataLV[j].v2[1],&DataLV[j].v2[2],&DataLV[j].c1[0],&DataLV[j].c1[1],&DataLV[j].c1[2],&DataLV[j].c2[0],&DataLV[j].c2[1],&DataLV[j].c2[2]);
		   }

		   for(i=0;i<numtriangles;i++){
			   j=DataTV.size();DataTV.resize(j+1);
		 	   sscanf(t.readLine().toAscii(),"%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%d,%f,%f,%f,%f,%f,%f",&DataTV[j].v1[0],&DataTV[j].v1[1],&DataTV[j].v1[2],&DataTV[j].v2[0],&DataTV[j].v2[1],&DataTV[j].v2[2],&DataTV[j].v3[0],&DataTV[j].v3[1],&DataTV[j].v3[2],&DataTV[j].c1[0],&DataTV[j].c1[1],&DataTV[j].c1[2],&DataTV[j].c2[0],&DataTV[j].c2[1],&DataTV[j].c2[2],&DataTV[j].c3[0],&DataTV[j].c3[1],&DataTV[j].c3[2],&DataTV[j].n1[0],&DataTV[j].n1[1],&DataTV[j].n1[2],&DataTV[j].n2[0],&DataTV[j].n2[1],&DataTV[j].n2[2],&DataTV[j].n3[0],&DataTV[j].n3[1],&DataTV[j].n3[2],&DataTV[j].texture,&DataTV[j].t1[0],&DataTV[j].t1[1],&DataTV[j].t2[0],&DataTV[j].t2[1],&DataTV[j].t3[0],&DataTV[j].t3[1]);
			if(DataTV[j].texture){
				DataTV[j].texture+=numtexold;
			}
		   }
        }

        if(version==2.0){
		   sscanf(t.readLine().toAscii(),"numlines=%d",&numlines);
		   sscanf(t.readLine().toAscii(),"numtriangles=%d",&numtriangles);
		   sscanf(t.readLine().toAscii(),"numtextures=%d",&numtextures);
		   /*sscanf(t.readLine(),"numtextures=%d",&numtextures);*/
		   setWindowTitle("AutoQ3D--"+filename);
		   QString filedir(filename);
		   filedir.truncate(filedir.lastIndexOf( "/" ));
		   numtexold=hcmd->StrTex.count();

		   while(!t.atEnd()){

              tempo=t.readLine();

              if(!tempo.compare("[TEXTURES]")){
                  tempo=t.readLine();
                  while(tempo.compare("[END]")){
                      hcmd->StrTex+=filedir+"/"+tempo;
                      tempo=t.readLine();
                  }
              }


              if(!tempo.compare("[LINES]")){
                 tempo=t.readLine();
                  while(tempo.compare("[END]")){
                      i=DataLV.size();DataLV.resize(i+1);
                      sscanf(tempo.toAscii(),"%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f",&DataLV[i].v1[0],&DataLV[i].v1[1],&DataLV[i].v1[2],&DataLV[i].v2[0],&DataLV[i].v2[1],&DataLV[i].v2[2],&DataLV[i].c1[0],&DataLV[i].c1[1],&DataLV[i].c1[2],&DataLV[i].c2[0],&DataLV[i].c2[1],&DataLV[i].c2[2]);
                      tempo=t.readLine();
                  }
              }

              if(!tempo.compare("[TRIANGLES]")){
                 tempo=t.readLine();
                  while(tempo.compare("[END]")){
                      i=DataTV.size();DataTV.resize(i+1);
		              sscanf(tempo.toAscii(),"%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%d,%f,%f,%f,%f,%f,%f",&DataTV[i].v1[0],&DataTV[i].v1[1],&DataTV[i].v1[2],&DataTV[i].v2[0],&DataTV[i].v2[1],&DataTV[i].v2[2],&DataTV[i].v3[0],&DataTV[i].v3[1],&DataTV[i].v3[2],&DataTV[i].c1[0],&DataTV[i].c1[1],&DataTV[i].c1[2],&DataTV[i].c2[0],&DataTV[i].c2[1],&DataTV[i].c2[2],&DataTV[i].c3[0],&DataTV[i].c3[1],&DataTV[i].c3[2],&DataTV[i].n1[0],&DataTV[i].n1[1],&DataTV[i].n1[2],&DataTV[i].n2[0],&DataTV[i].n2[1],&DataTV[i].n2[2],&DataTV[i].n3[0],&DataTV[i].n3[1],&DataTV[i].n3[2],&DataTV[i].texture,&DataTV[i].t1[0],&DataTV[i].t1[1],&DataTV[i].t2[0],&DataTV[i].t2[1],&DataTV[i].t3[0],&DataTV[i].t3[1]);
			if(DataTV[i].texture){
				DataTV[i].texture+=numtexold;
			}
                      tempo=t.readLine();
                  }
              }
              if(!tempo.compare("[TEXT]")){
                 tempo=t.readLine();
                  while(tempo.compare("[END]")){
                      tempo=t.readLine();
                  }
              }

           }
        }

		f.close();
		for (i = 0; i < windoL.count(); i++) {
				GLApp *win =(GLApp*) windoL.at( i );
				win->GLThisArea->makeCurrent();
				win->GLThisArea->DeleteAllTextures();
				win->GLThisArea->LoadAllTextures();
				win->GLThisArea->updateGL();
		}

	}


    }else {
	statusBar()->showMessage( tr("Loading aborted"), 2000 );
    }
}
/*/////////////////////////////////////////////////////*/
/*/////////////////////////////////////////////////////*/

void CadForm::ViewportProp(){

	GLApp *win =(GLApp*)ws->activeWindow();
	QString str;

	if(win){
		Viewprop* w = new Viewprop(this,0,win->GLThisArea->RenderMode,win->GLThisArea->BackColor);
		w->EFar->setText(QString("%1").arg(win->GLThisArea->zFar));
		w->ENear->setText(QString("%1").arg(win->GLThisArea->zNear));
		w->NSize->setText(QString("%1").arg(win->GLThisArea->NS));
		w->chBN->setChecked(win->GLThisArea->ShowNormals);
		if(w->exec()){
			str=w->EFar->text();win->GLThisArea->zFar=str.toFloat();
			str=w->ENear->text();win->GLThisArea->zNear=str.toFloat();
			str=w->NSize->text();win->GLThisArea->NS=str.toFloat();
			win->GLThisArea->ShowNormals=w->chBN->isChecked();
			win->GLThisArea->RenderMode=w->ShadeMode;
			win->GLThisArea->BackColor[0]=w->bcolor.red()/255.0;
			win->GLThisArea->BackColor[1]=w->bcolor.green()/255.0;
			win->GLThisArea->BackColor[2]=w->bcolor.blue()/255.0;
			win->GLThisArea->makeCurrent();
			win->GLThisArea->qglClearColor(w->bcolor);
			win->GLThisArea->PublicUpdate();

		}
		w->setAttribute(Qt::WA_DeleteOnClose);
		w->close();
	}
}
/*/////////////////////////////////////////////////////*/
/*/////////////////////////////////////////////////////*/
void CadForm::sendCancel(){
	hcmd->processcmd(tr("**Cancel**"));
	ecmd->setText("");
	UpdateAll();

}
/*/////////////////////////////////////////////////////*/
/*/////////////////////////////////////////////////////*/
void CadForm::Tile()
{
	ws->tile();
}

/*/////////////////////////////////////////////////////*/
/*/////////////////////////////////////////////////////*/

void CadForm::Cascade()
{
	ws->cascade();
}

void CadForm::CloseFile(){
	int i=0;
	QWidgetList windoL=ws->windowList(QWorkspace::CreationOrder);
	if ( windoL.count() ) {
        	for (i = 0; i < int(windoL.count()); i++) {
			GLApp *win =(GLApp*) windoL.at( i );
			win->close();
		}
	}
	DataLV.resize(0);DataTV.resize(0);hcmd->DataSV.resize(0);
	newViewPort();
}

void CadForm::SettingsProg(){
	PrgSettings* w = new PrgSettings;
	w->exec();
	w->setAttribute(Qt::WA_DeleteOnClose);
	w->close();

}


void CadForm::HelpFun(){
	HelpWindow *help = new HelpWindow(tr("qref.htm"),ProgramPath, 0);
	help->setWindowTitle(tr("Help"));
	help->show();
}

void CadForm::HelpOnlineFun(){
#ifdef Q_WS_WIN


	if(proc->state()==QProcess::Running)
		proc->kill();

	if (proc->execute("rundll32 url.dll,FileProtocolHandler http://autoq3d.ecuadra.com") ) {
		QMessageBox::critical( 0,tr("Fatal error"),tr("Could not start web browser"),tr("Quit") );
	}
#endif

#ifdef Q_WS_MAC
	QString url("http://autoq3d.ecuadra.com");
	OSStatus err;
	ICInstance inst;
	long int startSel;
	long int endSel;

	err = ICStart(&inst, 'STKA'); // put your app creator code here
	if (err == noErr){
#if !TARGET_CARBON
        err = ICFindConfigFile(inst, 0, NULL);
#endif
        if (err == noErr){
		ConstStr255Param hint = 0;
		startSel = 0;
		endSel = url.length();
		err = ICLaunchURL(inst, hint, url, endSel, &startSel, &endSel);
		if (err != noErr)
			QMessageBox::critical( 0,tr("Fatal error"),tr("ICLaunchURL error"),tr("Quit") );
		}
		ICStop(inst);
		return true;
	}else{
		QMessageBox::critical( 0,tr("Fatal error"),tr("ICStart error"),tr("Quit") );
		return false;
	}
#endif

#ifdef Q_WS_X11
	QString env=getenv("DESKTOP_LAUNCH");

	if(proc->state()==QProcess::Running)
		proc->kill();

	if(!env.compare("kde-open")){

		if (proc->execute("kfmclient openURL http://autoq3d.ecuadra.com") ) {
			QMessageBox::critical( 0,tr("Fatal error"),tr("Could not start web browser"),tr("Quit") );
		}

	}else{
		proc->start("gconftool-2 --get /desktop/gnome/applications/browser/exec");
		if(!proc->waitForFinished())
			return;
		proc->execute(proc->readAll()+" http://autoq3d.ecuadra.com");
	}
#endif

}





