/****************************************************************************
** $Id:  cmds/cmdgrippointnormal.h
** AutoQ3D a qt 3d model editor program
**
** Copyright (C) 2005-2007 -Gonzalo Reynaga Garcia. <gonzaloreynaga@yahoo.com>
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public Licence
** as published by the Free Software Foundation; either version 2 
** of the License, or (at your option) any later option.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
** 
*****************************************************************************/

#ifndef CMDGRIPPOINTNROMAL_H
#define CMDGRIPPOINTNORMAL_H
#include "cmds.h"
#include "../dialogs/picktex.h"


void cmds::cmdgrippointnormal(){
	int i,idx=-1;
	double var[1];
	d3line *DLV;
	d3triangle *DTV;
	DLV=DataLV->data();
	DTV=DataTV->data();
	if((SecCmd==tr("**Cancel**")||SecCmd=="")&&!PopViewMode){
			SendText(SecCmd);
			CmdCancel();
			return;
	}

	switch(step){
		
		case 0:
				SendText(tr("--Point-Normal--"));instruction=tr("Point Normal:");emit instru(instruction);
				for(i=0;i<DataSV.size();i++){
					if(DataSV[i].type==2){
						idx=1;
						i=DataSV.size();
					}
				}
				
				if(idx==-1){
					SendText(tr("**Error** no triangles selected"));
					CmdCancel();
					return;
				}
				step++;
				return;
				
		break;
		
		case 1:
			if(!SecCmd.compare("setCmdData")){
				if(currentdata.format>1){
						SendText(tr("Data reject"));
						return;
				}
				if(currentdata.format==0){
				
				GriPoint[0].find=0;
				var[0]=sqrt(currentdata.v[0]*currentdata.v[0]+currentdata.v[1]*currentdata.v[1]+currentdata.v[2]*currentdata.v[2]);
				if(!var[0])
					return;
				tempdataF[0]=currentdata.v[0]/var[0];tempdataF[1]=currentdata.v[1]/var[0];tempdataF[2]=currentdata.v[2]/var[0];
						for(i=0;i<DataSV.size();i++){
					
						if(DataSV[i].type==2){
							if((DTV[DataSV[i].index].v1[0]==GriPoint->v[0])&&(DTV[DataSV[i].index].v1[1]==GriPoint->v[1])&&(DTV[DataSV[i].index].v1[2]==GriPoint->v[2])){
								DTV[DataSV[i].index].n1[0]=tempdataF[0];DTV[DataSV[i].index].n1[1]=tempdataF[1];
								DTV[DataSV[i].index].n1[2]=tempdataF[2];
							}
							if((DTV[DataSV[i].index].v2[0]==GriPoint->v[0])&&(DTV[DataSV[i].index].v2[1]==GriPoint->v[1])&&(DTV[DataSV[i].index].v2[2]==GriPoint->v[2])){
								DTV[DataSV[i].index].n2[0]=tempdataF[0];DTV[DataSV[i].index].n2[1]=tempdataF[1];
								DTV[DataSV[i].index].n2[2]=tempdataF[2];
							}
							if((DTV[DataSV[i].index].v3[0]==GriPoint->v[0])&&(DTV[DataSV[i].index].v3[1]==GriPoint->v[1])&&(DTV[DataSV[i].index].v3[2]==GriPoint->v[2])){
								DTV[DataSV[i].index].n3[0]=tempdataF[0];DTV[DataSV[i].index].n3[1]=tempdataF[1];
								DTV[DataSV[i].index].n3[2]=tempdataF[2];
							}
						
						}
						}
			
				/*DataSV.resize(0);*/

				CmdCancel();
				return;
				}
			}
			
		break;
	}
	
	SendText(SecCmd);
	SendText(tr("**Secondary Command not found**"));
}


#endif
