/****************************************************************************
** $Id:  dialogs/viewprop.h
** AutoQ3D a qt 3d model editor program
**
** Copyright (C) 2005-2007 -Gonzalo Reynaga Garcia. <gonzaloreynaga@yahoo.com>
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public Licence
** as published by the Free Software Foundation; either version 2 
** of the License, or (at your option) any later option.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
** 
*****************************************************************************/

#ifndef VIEWPROP_H
#define VIEWPROP_H

#include <QVariant>
#include <QDialog>
#include <QColorDialog>
#include <QValidator>
#include <QGroupBox>
#include <QRadioButton>
#include <QPalette>



class QVBoxLayout;
class QHBoxLayout;
class QGridLayout;
class QPushButton;
class QLabel;
class QLineEdit;
class QCheckBox;

class Viewprop : public QDialog
{
    Q_OBJECT

public:
	Viewprop( QWidget* parent = 0, Qt::WFlags fl = 0 ,int shade=0, float *pbc=NULL);
    ~Viewprop();

    QPushButton* OkBtn;
    QLabel* Label2;
    QLineEdit* EFar;
    QLineEdit* ENear;
    QLabel* Label3;
    QPushButton* CancelBtn;
    QCheckBox* chBW;
    QLineEdit* NSize;
    QLabel* Label1;
    QCheckBox* chBN;
	QCheckBox* chGR;
    QGroupBox *groupShadeBox;
    QRadioButton *radio1;
    QRadioButton *radio2;
    QRadioButton *radio3;
    QLabel *LBackColor;
    QPushButton* BtnBackColor;
    int ShadeMode;
    float BackColor[3];
    QColor bcolor;

protected:
    QVBoxLayout* ViewpropLayout;
    QGridLayout* layout1;

protected slots:
	void Radio1Click();
	void Radio2Click();
	void Radio3Click();
	void ChangeBackColor();

private:

};

#endif // VIEWPROP_H
