/****************************************************************************
** $Id:  fgui/cadform.h
** AutoQ3D a qt 3d model editor program
**
** Copyright (C) 2005-2007 -Gonzalo Reynaga Garcia. <gonzaloreynaga@yahoo.com>
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public Licence
** as published by the Free Software Foundation; either version 2 
** of the License, or (at your option) any later option.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
** 
*****************************************************************************/

#ifndef CADFORM_H
#define CADFORM_H

#include <QMainWindow>
#include <QtGui>
#include <QRegExp>
#include <QProcess>

#include "../cmds/cmds.h"
#include "editcmd.h"
#include "glapp.h"
#include "../extra/mousedefines.h"
#include "../dialogs/viewprop.h"
#include "../dialogs/texform.h"
#include "../dialogs/helpwindow.h"
#include "../dialogs/about.h"
#include "../dialogs/prgsettings.h"
#include "../extra/primitives.h"



class QWorkspace;
class QLabel;


class CadForm: public QMainWindow
{
    Q_OBJECT
public:

    QString ProgramPath;
    EditCmd *ecmd;

    CadForm();
    ~CadForm();

private slots:
	virtual void OpenFile();
	virtual void SaveFile();
	virtual void SaveAsFile();
	virtual void SettingsProg();
	virtual void UpdateAll();
	void TexDocs();

	virtual void exit();
	virtual void Tile();
	virtual void Cascade();
	GLApp* newViewPort();
	void SetMouseMode(int mmode);
	
	void InsertMD2();
	void InsertDXF();
	void InsertQ3DFile();
	void ExportDXF();
	
	void CloseFile();
	void sendCancel();
	void currentColor();
	void sendCmd();
	void sendsnapcmd();
	void ViewportProp();
	void DrawLine();
	void DrawPoly();
	void DrawTriangle();
	void DrawCube();
	void Drawrevolve();
	void DrawArray();
	void DrawExtrude();
	void ViewZoom();
	void ViewPan();
	void ViewRotateView();
	void ViewDist();
	void ModProperties();
	void ModErase();
	void ModRotate3d();
	void ModSlice();
	void ModSwitch();
	void ModFlip();
	void ModTrinormals();
	void ModMnormals();
	void AboutFun();
	void ZoomVar(float var);
	void ModTexProject();
	void ModTexSpherical();
	void ModUndo();
	void ViewTop();
	void ViewRight();
	void ViewFront();
	void ViewIsometric();
	void HelpFun();
	void HelpOnlineFun();
	void ShowTriang();
	void ShowLines();
	




public slots:
	virtual void closeEvent( QCloseEvent * );

private:
	QString filename;
	QWorkspace* ws;
	cmds *hcmd;
	QLabel *Label1;
	QAction *ActionColor;
	QAction * ModNormAction;
	QAction * ViewGroupAction;
	QAction *ModPlaneAllAction;
	QProcess *proc;
	
	QCursor gencursor[7];
	QVector<d3line> DataLV;
	QVector<d3triangle> DataTV;
	float currentcolor[3];
	int MouseMode[1];
	int numDoc;
	int ucsicon;
	int View[1];

};


#endif
