/****************************************************************************
** $Id:  cmds/cmdmeannormals.h
** AutoQ3D a qt 3d model editor program
**
** Copyright (C) 2005-2007 -Gonzalo Reynaga Garcia. <gonzaloreynaga@yahoo.com>
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public Licence
** as published by the Free Software Foundation; either version 2 
** of the License, or (at your option) any later option.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
** 
*****************************************************************************/

#ifndef CMDMEANNORMALS_H
#define CMDMEANNORMALS_H
#include "cmds.h"

int cmds::equal(d3triangle* tri1,int tp1,d3triangle* tri2,int tp2){
	if(tp1==1&&tp2==1){if((tri1->v1[0]==tri2->v1[0])&&(tri1->v1[1]==tri2->v1[1])&&(tri1->v1[2]==tri2->v1[2]))return 1;}
	if(tp1==1&&tp2==2){if((tri1->v1[0]==tri2->v2[0])&&(tri1->v1[1]==tri2->v2[1])&&(tri1->v1[2]==tri2->v2[2]))return 1;}
	if(tp1==1&&tp2==3){if((tri1->v1[0]==tri2->v3[0])&&(tri1->v1[1]==tri2->v3[1])&&(tri1->v1[2]==tri2->v3[2]))return 1;}
	if(tp1==2&&tp2==1){if((tri1->v2[0]==tri2->v1[0])&&(tri1->v2[1]==tri2->v1[1])&&(tri1->v2[2]==tri2->v1[2]))return 1;}
	if(tp1==2&&tp2==2){if((tri1->v2[0]==tri2->v2[0])&&(tri1->v2[1]==tri2->v2[1])&&(tri1->v2[2]==tri2->v2[2]))return 1;}
	if(tp1==2&&tp2==3){if((tri1->v2[0]==tri2->v3[0])&&(tri1->v2[1]==tri2->v3[1])&&(tri1->v2[2]==tri2->v3[2]))return 1;}
	if(tp1==3&&tp2==1){if((tri1->v3[0]==tri2->v1[0])&&(tri1->v3[1]==tri2->v1[1])&&(tri1->v3[2]==tri2->v1[2]))return 1;}
	if(tp1==3&&tp2==2){if((tri1->v3[0]==tri2->v2[0])&&(tri1->v3[1]==tri2->v2[1])&&(tri1->v3[2]==tri2->v2[2]))return 1;}
	if(tp1==3&&tp2==3){if((tri1->v3[0]==tri2->v3[0])&&(tri1->v3[1]==tri2->v3[1])&&(tri1->v3[2]==tri2->v3[2]))return 1;}
	
	return 0;
}

void cmds::cmdmeannormals(){
	int i,j,k,w,n;
	double var[1];
	QVector<tselect> findn;
	QVector<int> flagn;
	d3triangle *DTV;
	DTV=DataTV->data();
	if((SecCmd==tr("**Cancel**"))&&!PopViewMode){
			SendText(SecCmd);
			CmdCancel();
			return;
	}
	
	flagn.resize(DataSV.size());
	
	for(i=0,flagn.resize(DataSV.size());i<DataSV.size();i++){
		flagn[i]=0x07;
	}
	
	switch(step){
		
		case 0:
			SendText(tr("---Mean Normals---"));
			for(i=0,n=0,findn.resize(0);i<DataSV.size();i++,n=0,findn.resize(0)){
				if(DataSV[i].type==2){
					k=DataSV[i].index;
					tempdataTRI[0].v1[0]=DTV[k].v1[0];tempdataTRI[0].v1[1]=DTV[k].v1[1];tempdataTRI[0].v1[2]=DTV[k].v1[2];
					tempdataTRI[0].v2[0]=DTV[k].v2[0];tempdataTRI[0].v2[1]=DTV[k].v2[1];tempdataTRI[0].v2[2]=DTV[k].v2[2];
					tempdataTRI[0].v3[0]=DTV[k].v3[0];tempdataTRI[0].v3[1]=DTV[k].v3[1];tempdataTRI[0].v3[2]=DTV[k].v3[2];
					
					tempdataTRI[0].n1[0]=0;tempdataTRI[0].n1[1]=0;tempdataTRI[0].n1[2]=0;
					tempdataTRI[0].n2[0]=0;tempdataTRI[0].n2[1]=0;tempdataTRI[0].n2[2]=0;
					tempdataTRI[0].n3[0]=0;tempdataTRI[0].n3[1]=0;tempdataTRI[0].n3[2]=0;
					
					
					for(j=0;j<DataSV.size();j++){
						if(DataSV[j].type==2){
							k=DataSV[j].index;
						if(flagn[j]&0x01){
							if(equal(tempdataTRI,1,&DTV[k],1)){
								tempdataTRI[0].n1[0]+=DTV[k].n1[0];
								tempdataTRI[0].n1[1]+=DTV[k].n1[1];flagn[j]&=0x06;
								tempdataTRI[0].n1[2]+=DTV[k].n1[2];findn.resize(n+1);findn[n].index=k;findn[n++].type=11;
							}
							if(equal(tempdataTRI,2,&DTV[k],1)){
								tempdataTRI[0].n2[0]+=DTV[k].n1[0];
								tempdataTRI[0].n2[1]+=DTV[k].n1[1];flagn[j]&=0x06;
								tempdataTRI[0].n2[2]+=DTV[k].n1[2];findn.resize(n+1);findn[n].index=k;findn[n++].type=21;
							}
							if(equal(tempdataTRI,3,&DTV[k],1)){
								tempdataTRI[0].n3[0]+=DTV[k].n1[0];
								tempdataTRI[0].n3[1]+=DTV[k].n1[1];flagn[j]&=0x06;
								tempdataTRI[0].n3[2]+=DTV[k].n1[2];findn.resize(n+1);findn[n].index=k;findn[n++].type=31;
							}
						}
						if(flagn[j]&0x02){
							if(equal(tempdataTRI,1,&DTV[k],2)){
								tempdataTRI[0].n1[0]+=DTV[k].n2[0];
								tempdataTRI[0].n1[1]+=DTV[k].n2[1];flagn[j]&=0x05;
								tempdataTRI[0].n1[2]+=DTV[k].n2[2];findn.resize(n+1);findn[n].index=k;findn[n++].type=12;
							}
							if(equal(tempdataTRI,2,&DTV[k],2)){
								tempdataTRI[0].n2[0]+=DTV[k].n2[0];
								tempdataTRI[0].n2[1]+=DTV[k].n2[1];flagn[j]&=0x05;
								tempdataTRI[0].n2[2]+=DTV[k].n2[2];findn.resize(n+1);findn[n].index=k;findn[n++].type=22;
							}
							if(equal(tempdataTRI,3,&DTV[k],2)){
								tempdataTRI[0].n3[0]+=DTV[k].n2[0];
								tempdataTRI[0].n3[1]+=DTV[k].n2[1];flagn[j]&=0x05;
								tempdataTRI[0].n3[2]+=DTV[k].n2[2];findn.resize(n+1);findn[n].index=k;findn[n++].type=32;
							}
						}
						if(flagn[j]&0x04){
							if(equal(tempdataTRI,1,&DTV[k],3)){
								tempdataTRI[0].n1[0]+=DTV[k].n3[0];
								tempdataTRI[0].n1[1]+=DTV[k].n3[1];flagn[j]&=0x03;
								tempdataTRI[0].n1[2]+=DTV[k].n3[2];findn.resize(n+1);findn[n].index=k;findn[n++].type=13;
							}
							
							if(equal(tempdataTRI,2,&DTV[k],3)){
								tempdataTRI[0].n2[0]+=DTV[k].n3[0];
								tempdataTRI[0].n2[1]+=DTV[k].n3[1];flagn[j]&=0x03;
								tempdataTRI[0].n2[2]+=DTV[k].n3[2];findn.resize(n+1);findn[n].index=k;findn[n++].type=23;
							}
							
							if(equal(tempdataTRI,3,&DTV[k],3)){
								tempdataTRI[0].n3[0]+=DTV[k].n3[0];
								tempdataTRI[0].n3[1]+=DTV[k].n3[1];flagn[j]&=0x03;
								tempdataTRI[0].n3[2]+=DTV[k].n3[2];findn.resize(n+1);findn[n].index=k;findn[n++].type=33;
							}
						}
							
					}
					}
	var[0]=sqrt(tempdataTRI[0].n1[0]*tempdataTRI[0].n1[0]+tempdataTRI[0].n1[1]*tempdataTRI[0].n1[1]+tempdataTRI[0].n1[2]*tempdataTRI[0].n1[2]);
				tempdataTRI[0].n1[0]/=var[0];tempdataTRI[0].n1[1]/=var[0];tempdataTRI[0].n1[2]/=var[0];
	var[0]=sqrt(tempdataTRI[0].n2[0]*tempdataTRI[0].n2[0]+tempdataTRI[0].n2[1]*tempdataTRI[0].n2[1]+tempdataTRI[0].n2[2]*tempdataTRI[0].n2[2]);
				tempdataTRI[0].n2[0]/=var[0];tempdataTRI[0].n2[1]/=var[0];tempdataTRI[0].n2[2]/=var[0];
	var[0]=sqrt(tempdataTRI[0].n3[0]*tempdataTRI[0].n3[0]+tempdataTRI[0].n3[1]*tempdataTRI[0].n3[1]+tempdataTRI[0].n3[2]*tempdataTRI[0].n3[2]);
				if(var[0]){tempdataTRI[0].n3[0]/=var[0];tempdataTRI[0].n3[1]/=var[0];tempdataTRI[0].n3[2]/=var[0];}
					
					for(w=0;w<findn.size();w++){
						switch(findn[w].type){
							case 11:
								DTV[findn[w].index].n1[0]=tempdataTRI[0].n1[0];
								DTV[findn[w].index].n1[1]=tempdataTRI[0].n1[1];
								DTV[findn[w].index].n1[2]=tempdataTRI[0].n1[2];
							break;
							case 12:
								DTV[findn[w].index].n2[0]=tempdataTRI[0].n1[0];
								DTV[findn[w].index].n2[1]=tempdataTRI[0].n1[1];
								DTV[findn[w].index].n2[2]=tempdataTRI[0].n1[2];
							break;
							case 13:
								DTV[findn[w].index].n3[0]=tempdataTRI[0].n1[0];
								DTV[findn[w].index].n3[1]=tempdataTRI[0].n1[1];
								DTV[findn[w].index].n3[2]=tempdataTRI[0].n1[2];
							break;
							case 21:
								DTV[findn[w].index].n1[0]=tempdataTRI[0].n2[0];
								DTV[findn[w].index].n1[1]=tempdataTRI[0].n2[1];
								DTV[findn[w].index].n1[2]=tempdataTRI[0].n2[2];
							break;
							case 22:
								DTV[findn[w].index].n2[0]=tempdataTRI[0].n2[0];
								DTV[findn[w].index].n2[1]=tempdataTRI[0].n2[1];
								DTV[findn[w].index].n2[2]=tempdataTRI[0].n2[2];
							break;
							case 23:
								DTV[findn[w].index].n3[0]=tempdataTRI[0].n2[0];
								DTV[findn[w].index].n3[1]=tempdataTRI[0].n2[1];
								DTV[findn[w].index].n3[2]=tempdataTRI[0].n2[2];
							break;
							case 31:
								DTV[findn[w].index].n1[0]=tempdataTRI[0].n3[0];
								DTV[findn[w].index].n1[1]=tempdataTRI[0].n3[1];
								DTV[findn[w].index].n1[2]=tempdataTRI[0].n3[2];
							break;
							case 32:
								DTV[findn[w].index].n2[0]=tempdataTRI[0].n3[0];
								DTV[findn[w].index].n2[1]=tempdataTRI[0].n3[1];
								DTV[findn[w].index].n2[2]=tempdataTRI[0].n3[2];
							break;
							case 33:
								DTV[findn[w].index].n3[0]=tempdataTRI[0].n3[0];
								DTV[findn[w].index].n3[1]=tempdataTRI[0].n3[1];
								DTV[findn[w].index].n3[2]=tempdataTRI[0].n3[2];
							break;
					
					
					
					
						}
					
					}
			
				}/*if(DataSV[i].type==2){*/
			}/*for(i=0;i<DataSV.size();i++){*/
			CmdCancel();
			return;
		break;

	}
	
	SendText(SecCmd);
	SendText(tr("**Secondary Command not found**"));
}


#endif
