/****************************************************************************
** $Id:  cmds/cmds.cpp
** AutoQ3D a qt 3d model editor program
**
** Copyright (C) 2005-2007 -Gonzalo Reynaga Garcia. <gonzaloreynaga@yahoo.com>
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public Licence
** as published by the Free Software Foundation; either version 2 
** of the License, or (at your option) any later option.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
** 
*****************************************************************************/


#include "cmds.h"

#include "cmddrawline.h"
#include "cmddrawtriangle.h"
#include "cmdzoom.h"
#include "cmdpan.h"
#include "cmdrotateview.h"
#include "cmdpopzoom.h"
#include "cmdpoppan.h"
#include "cmdpoprotateview.h"
#include "cmdgriponlymove.h"
#include "cmdgriponlyscale.h"
#include "cmdgriponlymirror.h"
#include "cmdgriponlystretch.h"
#include "cmdgriponlyrotate.h"
#include "cmdquickerase.h"
#include "cmdshowproperties.h"
#include "cmdrotate3d.h"
#include "cmdextrude.h"
#include "cmdarray.h"
#include "cmdmeannormals.h"
#include "cmdslice.h"
#include "cmdcube.h"
#include "cmddist.h"
#include "cmdswitch.h"
#include "cmdtrinormals.h"
#include "cmdsnap.h"
#include "cmdrevolve.h"
#include "cmddrawpoly.h"
#include "cmdgrippointcolor.h"
#include "cmdgrippointtexture.h"
#include "cmdgrippointnormal.h"
#include "cmdflip.h"
#include "cmdtex.h"
#include "cmdtexsp.h"
#include "cmdundo.h"
#include "cmducsicon.h"
#include "cmdshow.h"


cmds::cmds( QWidget* parent)
    :  QTextEdit(parent)
{		
	Props= new ProperDiag(0);
	DataSTV.resize(0);
	DataSLV.resize(0);
	DataSV.resize(0);

	step=0;
	Array_NItems=4;
	undoidx=0;
	undocnt=0;
	cscalarf[0]=1;
	PopStep=0;
	PopViewMode=0;
	CommandActive=0;
	SnapFlags[0]=0;
	GripEditMode[0]=0;
	SnapMode[0]=0;
	SnaPoint->find=0;
	tempdataI[0]=0;
	rtlines[0].find=0;
	rtlines[1].find=0;
	GriPoint[0].find=0;
	SecCmd="BlankCommand";


	QPalette newPalette = QPalette();
	newPalette.setColor(QPalette::Background, QColor::QColor(170,170,255));
	newPalette.setColor(QPalette::Foreground, QColor::QColor(0,0,0));
	newPalette.setColor(QPalette::Base, QColor::QColor(170,170,255));

	setPalette(newPalette);
	
	cmdlist[tr("l")]=			CMDDRAWLINE;
	cmdlist[tr("line")]=			CMDDRAWLINE;
	cmdlist[tr("pl")]=			CMDDRAWLINE;
	cmdlist[tr("polyline")]=		CMDDRAWLINE;
	cmdlist[tr("tri")]=			CMDDRAWTRIANGLE;
	cmdlist[tr("triangle")]=		CMDDRAWTRIANGLE;
	cmdlist[tr("**Cancel**")]=		CMDCANCEL;
	cmdlist["MouseRButton"]=		CMDSCANCEL;
	cmdlist[tr("z")]=			CMDZOOM;
	cmdlist[tr("zoom")]=			CMDZOOM;
	cmdlist[tr("'z")]=			CMDZOOM;
	cmdlist[tr("'zoom")]=			CMDZOOM;
	cmdlist[tr("p")]=			CMDPAN;
	cmdlist[tr("pan")]=			CMDPAN;
	cmdlist[tr("'p")]=			CMDPAN;
	cmdlist[tr("'pan")]=			CMDPAN;
	cmdlist[tr("rtv")]=			CMDROTATEVIEW;
	cmdlist[tr("rotateview")]=		CMDROTATEVIEW;
	cmdlist[tr("'rtv")]=			CMDROTATEVIEW;
	cmdlist[tr("'rotateview")]=		CMDROTATEVIEW;
	cmdlist["gripmove"]=			CMDGRIPONLYMOVE;
	cmdlist["gripscale"]=			CMDGRIPONLYSCALE;
	cmdlist["gripmirror"]=			CMDGRIPONLYMIRROR;
	cmdlist["gripstretch"]=			CMDGRIPONLYSTRETCH;
	cmdlist["griprotate"]=			CMDGRIPONLYROTATE;
	cmdlist[tr("e","Command erase")]=	CMDQUICKERASE;
	cmdlist[tr("erase","Command erase")]=	CMDQUICKERASE;
	cmdlist[tr("proper")]=			CMDSHOWPROPERTIES;
	cmdlist[tr("properties")]=		CMDSHOWPROPERTIES;
	cmdlist[tr("rotate3d")]=		CMDROTATE3D;
	cmdlist[tr("extrude")]=			CMDEXTRUDE;
	cmdlist[tr("array")]=			CMDARRAY;
	cmdlist[tr("mnormals")]=		CMDMEANNORMALS;
	cmdlist[tr("slice")]=			CMDSLICE;
	cmdlist[tr("box")]=		CMDCUBE;
	cmdlist[tr("dist")]=			CMDDIST;
	cmdlist[tr("switch")]=			CMDSWITCH;
	cmdlist[tr("trinormals")]=		CMDTRINORMALS;
	cmdlist[tr("snap")]=			CMDSNAP;
	cmdlist[tr("'snap")]=			CMDSNAP;
	cmdlist[tr("revolve")]=			CMDREVOLVE;
	cmdlist[tr("poly")]=			CMDDRAWPOLY;
	cmdlist[tr("polygon")]=			CMDDRAWPOLY;
	cmdlist["grippointcolor"]=		CMDGRIPPOINTCOLOR;
	cmdlist["grippointtexture"]=		CMDGRIPPOINTTEXTURE;
	cmdlist["grippointnormal"]=		CMDGRIPPOINTNORMAL;
	cmdlist[tr("flip")]=			CMDFLIP;
	cmdlist[tr("tex")]=			CMDTEX;
	cmdlist[tr("texsp")]=			CMDTEXSP;
	cmdlist[tr("sptex")]=			CMDTEXSP;
	cmdlist[tr("u")]=			CMDUNDO;
	cmdlist[tr("undo")]=			CMDUNDO;
	cmdlist[tr("ucsicon")]=			CMDUCSICON;
	cmdlist[tr("str")]=			SHOWTRIANGLES;
	cmdlist[tr("sln")]=			SHOWLINES;
	cmdlist[tr("'str")]=			SHOWTRIANGLES;
	cmdlist[tr("'sln")]=			SHOWLINES;

	

}

void cmds::setDataL(QVector<d3line> *Info,QVector<d3triangle> *Infotri,int *eview,int *mousei){
	DataLV=Info;
	DataTV=Infotri;
	View=eview;
	MouseMode=mousei;
}

cmds::~cmds()
{

}


void cmds::SendText(QString str)
{
	append(str);
	verticalScrollBar()->setValue(verticalScrollBar()->maximum());

}



void cmds::processcmd(QString str){


	
	if(CommandActive){
		SecCmd=str;
	}else{
		if(!cmdlist.value(str,0)){
			if(!str.compare("setCmdData")){
				append(	tr("Command not found"));
				verticalScrollBar()->setValue(verticalScrollBar()->maximum());
				return;
			}
			append(str);
			append(tr("Command not found"));
			verticalScrollBar()->setValue(verticalScrollBar()->maximum());
			return;
		}
		currentcmd=str;
		SecCmd="BlankCommand";
		CommandActive=1;
	}
	
	
		switch(cmdlist[currentcmd]){
			case CMDCANCEL:
				DataSV.resize(0);
				append(tr("**Cancel**"));
				verticalScrollBar()->setValue(verticalScrollBar()->maximum());
				CmdCancel();
				
			break;
			case CMDSCANCEL:
				CmdCancel();
			break;
			case CMDDRAWLINE:
				CmdStoreUndo();
				cmddrawline();
			break;
			case CMDDRAWTRIANGLE:
				CmdStoreUndo();
				cmddrawtriangle();
			break;
			case CMDZOOM:
				cmdzoom();
			break;
			case CMDPAN:
				cmdpan();
			break;
			case CMDROTATEVIEW:
				cmdrotateview();
			break;
			case CMDGRIPONLYMOVE:
				CmdStoreUndo();
				cmdgriponlymove();
			break;
			case CMDGRIPONLYSCALE:
				CmdStoreUndo();
				cmdgriponlyscale();
			break;
			case CMDGRIPONLYMIRROR:
				CmdStoreUndo();
				cmdgriponlymirror();
			break;
			case CMDQUICKERASE:
				CmdStoreUndo();
				SendText(tr("erase"));
				cmdquickerase();
			break;
			case CMDGRIPONLYSTRETCH:
				CmdStoreUndo();
				cmdgriponlystretch();
			break;
			case CMDGRIPONLYROTATE:
				CmdStoreUndo();
				cmdgriponlyrotate();
			break;
			case CMDSHOWPROPERTIES:
				CmdStoreUndo();
				cmdshowproperties();
			break;
			case CMDROTATE3D:
				CmdStoreUndo();
				cmdrotate3d();
			break;
			case CMDEXTRUDE:
				CmdStoreUndo();
				cmdextrude();
			break;
			case CMDARRAY:
				CmdStoreUndo();
				cmdarray();
			break;
			case CMDMEANNORMALS:
				CmdStoreUndo();
				cmdmeannormals();
			break;
			case CMDSLICE:
				CmdStoreUndo();
				cmdslice();
			break;
			case CMDCUBE:
				CmdStoreUndo();
				cmdcube();
			break;
			case CMDDIST:
				cmddist();
			break;
			case CMDSWITCH:
				CmdStoreUndo();
				cmdswitch();
			break;
			case CMDTRINORMALS:
				CmdStoreUndo();
				cmdtrinormals();
			break;
			case CMDSNAP:
				cmdsnap();
			break;
			case CMDREVOLVE:
				CmdStoreUndo();
				cmdrevolve();
			break;
			case CMDDRAWPOLY:
				CmdStoreUndo();
				cmddrawpoly();
			break;
			case CMDGRIPPOINTCOLOR:
				CmdStoreUndo();
				cmdgrippointcolor();
			break;
			case CMDGRIPPOINTTEXTURE:
				CmdStoreUndo();
				cmdgrippointtexture();
			break;
			case CMDGRIPPOINTNORMAL:
				CmdStoreUndo();
				cmdgrippointnormal();
			break;
			case CMDFLIP:
				CmdStoreUndo();
				cmdflip();
			break;
			case CMDTEX:
				CmdStoreUndo();
				cmdtex();
			break;
			case CMDTEXSP:
				CmdStoreUndo();
				cmdtexsp();
			break;
			case CMDUNDO:
				cmdundo();
			break;
			case CMDUCSICON:
				cmducsicon();
			break;
			case SHOWTRIANGLES:
				cmdshowtriangles();
				CommandActive=0;
				SecCmd="BlankCommand";
			break;
			case SHOWLINES:
				cmdshowlines();
				CommandActive=0;
				SecCmd="BlankCommand";
			break;
			
		}
	
}

void cmds::setCmdData(dataformat data){

	currentdata=data;
	processcmd("setCmdData");
	verticalScrollBar()->setValue(verticalScrollBar()->maximum());
}

void cmds::CmdCancel(){
			rtlines[0].find=0;
			rtlines[1].find=0;
			emit SetMouseMode(MOUSEMODE_SELECT);
			emit instru(tr("Command:"));
			CommandActive=0;
			step=0;SecCmd="BlankCommand";
			GripEditMode[0]=0;
			DataSLV.resize(0);
			DataSTV.resize(0);
			GriPoint->find=0;
			GriPoint->v[0]=GriPoint->v[1]=GriPoint->v[2]=0.0;
			SnaPoint->find=0;
}

int cmds::CmdSelectPopView(){
			
			if(PopViewMode==1){cmdpopzoom();return 1;}
			if(PopViewMode==2){cmdpoppan();return 1;}
			if(PopViewMode==3){cmdpoprotateview();return 1;}
			
			if(!SecCmd.compare(tr("'z"))||!SecCmd.compare(tr("'zoom"))){
				PopViewMode=1;cmdpopzoom();return 1;
			}
			
			if(!SecCmd.compare(tr("'p"))||!SecCmd.compare(tr("'pan"))){
				PopViewMode=2;cmdpoppan();return 1;
			}
			if(!SecCmd.compare(tr("'rtv"))||!SecCmd.compare(tr("'rotateview"))){
				PopViewMode=3;cmdpoprotateview();return 1;
			}
			if(!SecCmd.compare(tr("'str"))){
				cmdshowtriangles();return 1;
			}
			if(!SecCmd.compare(tr("'sln"))){
				cmdshowlines();return 1;
			}
			
	
	return 0;
}


int cmds::CmdCheckSnap(){
			if(!SecCmd.compare(tr("'snap"))){
				if(SnapMode[0]==0){
					SendText(tr("--Snap ON (endpoint)--"));
					SnapMode[0]=1;
				}else{
					SnapMode[0]=0;
					SendText(tr("--Snap OFF--"));
				}
				return 1;
			}
			if(!SecCmd.compare(tr("end"))||!SecCmd.compare(tr("END"))){
				SnapMode[0]=1;
				SendText(tr("end of"));
				return 1;
			}
			
			if(!SecCmd.compare(tr("mid"))||!SecCmd.compare(tr("MID"))){
				SnapMode[0]=2;
				SendText(tr("mid of"));
				return 1;
			}
			if(!SecCmd.compare(tr("gri"))||!SecCmd.compare(tr("GRI"))){
				SnapMode[0]=3;
				SendText(tr("grid snap"));
				return 1;
			}
			
	return 0;
}

void cmds::CmdStoreUndo(){
	if(!step){
		UndoDataLV[undoidx]=*DataLV;
		UndoDataTV[undoidx++]=*DataTV;
		undoidx%=UNDOLIMIT;
		if(undocnt<UNDOLIMIT)
			undocnt++;
	}
}
