/****************************************************************************
** $Id:  cmds/cmdshowproperties.h
** AutoQ3D a qt 3d model editor program
**
** Copyright (C) 2005-2007 -Gonzalo Reynaga Garcia. <gonzaloreynaga@yahoo.com>
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public Licence
** as published by the Free Software Foundation; either version 2 
** of the License, or (at your option) any later option.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
** 
*****************************************************************************/

#ifndef CMDSHOWPROPERTIES_H
#define CMDSHOWPROPERTIES_H
#include "cmds.h"


void cmds::cmdshowproperties(){
	int i;
	int constant;
	d3line *DLV;
	double var[3];
	d3triangle *DTV;
	DLV=DataLV->data();
	DTV=DataTV->data();

	if((SecCmd==tr("**Cancel**")||SecCmd==""||SecCmd=="MouseRButton")&&!PopViewMode){
			SendText(tr("**Cancel**"));
			CmdCancel();
			return;
	}

	switch(step){
		
		case 0:
			/*/////////*/
				SendText(currentcmd);
				for(i=0,constant=0;i<DataSV.size();i++){
					if(DataSV[i].type==1){
						if(constant==2){constant=-1;i=DataSV.size();
						}else{constant=1;}
					}
					if(DataSV[i].type==2){
						if(constant==1||constant==-1){constant=-1;i=DataSV.size();
						}else{constant=2;}
					}
				}
				if(constant==0){
					CmdCancel();
				}
				if(constant==-1){
					SendText(tr("Only the same object type"));
					CmdCancel();
				}
				if(constant==1){
					QPixmap pixmap( 20, 20 );
					QTableWidgetItem *selitem;
					Props->setWindowTitle(QString(tr("%1 Lines selected")).arg(DataSV.size()));
					/*if(DataSV.size()==1){*/
						Props->color1=QColor((int)(DLV[DataSV[0].index].c1[0]*255),(int)(DLV[DataSV[0].index].c1[1]*255),(int)(DLV[DataSV[0].index].c1[2]*255));
						pixmap.fill(Props->color1);
						selitem=Props->table1->item(0,1);selitem->setIcon(pixmap);
						Props->color2=QColor((int)(DLV[DataSV[0].index].c2[0]*255),(int)(DLV[DataSV[0].index].c2[1]*255),(int)(DLV[DataSV[0].index].c2[2]*255));
						pixmap.fill(Props->color2);
						selitem=Props->table1->item(4,1);selitem->setIcon(pixmap);
						selitem=Props->table1->item(1,1);selitem->setText(QString("%1").arg(DLV[DataSV[0].index].v1[0]));
						selitem=Props->table1->item(2,1);selitem->setText(QString("%1").arg(DLV[DataSV[0].index].v1[1]));
						selitem=Props->table1->item(3,1);selitem->setText(QString("%1").arg(DLV[DataSV[0].index].v1[2]));
						selitem=Props->table1->item(5,1);selitem->setText(QString("%1").arg(DLV[DataSV[0].index].v2[0]));
						selitem=Props->table1->item(6,1);selitem->setText(QString("%1").arg(DLV[DataSV[0].index].v2[1]));
						selitem=Props->table1->item(7,1);selitem->setText(QString("%1").arg(DLV[DataSV[0].index].v2[2]));
					/*}*/
					if(Props->exec()){
						
						if((Props->color1.red()!=(int)(DLV[DataSV[0].index].c1[0]*255))||(Props->color1.green()!=(int)(DLV[DataSV[0].index].c1[1]*255))||(Props->color1.blue()!=(int)(DLV[DataSV[0].index].c1[2]*255))){
							for(i=0;i<DataSV.size();i++){
							DLV[DataSV[i].index].c1[0]=Props->color1.red()/255.0;
							DLV[DataSV[i].index].c1[1]=Props->color1.green()/255.0;
							DLV[DataSV[i].index].c1[2]=Props->color1.blue()/255.0;
							}
						}
						if((Props->color2.red()!=(int)(DLV[DataSV[0].index].c2[0]*255))||(Props->color2.green()!=(int)(DLV[DataSV[0].index].c2[1]*255))||(Props->color2.blue()!=(int)(DLV[DataSV[0].index].c2[2]*255))){
							for(i=0;i<DataSV.size();i++){
							DLV[DataSV[i].index].c2[0]=Props->color2.red()/255.0;
							DLV[DataSV[i].index].c2[1]=Props->color2.green()/255.0;
							DLV[DataSV[i].index].c2[2]=Props->color2.blue()/255.0;
							}
						}
						selitem=Props->table1->item(1,1);
						if(selitem->text().compare(QString("%1").arg(DLV[DataSV[0].index].v1[0]))){
							for(i=0;i<DataSV.size();i++){
							DLV[DataSV[i].index].v1[0]=selitem->text().toFloat();
							}
						}
						selitem=Props->table1->item(2,1);
						if(selitem->text().compare(QString("%1").arg(DLV[DataSV[0].index].v1[1]))){
							for(i=0;i<DataSV.size();i++){
							DLV[DataSV[i].index].v1[1]=selitem->text().toFloat();
							}
						}
						selitem=Props->table1->item(3,1);
						if(selitem->text().compare(QString("%1").arg(DLV[DataSV[0].index].v1[2]))){
							for(i=0;i<DataSV.size();i++){
							DLV[DataSV[i].index].v1[2]=selitem->text().toFloat();
							}
						}
						selitem=Props->table1->item(5,1);
						if(selitem->text().compare(QString("%1").arg(DLV[DataSV[0].index].v2[0]))){
							for(i=0;i<DataSV.size();i++){
							DLV[DataSV[i].index].v2[0]=selitem->text().toFloat();
							}
						}
						selitem=Props->table1->item(6,1);
						if(selitem->text().compare(QString("%1").arg(DLV[DataSV[0].index].v2[1]))){
							for(i=0;i<DataSV.size();i++){
							DLV[DataSV[i].index].v2[1]=selitem->text().toFloat();
							}
						}
						selitem=Props->table1->item(7,1);
						if(selitem->text().compare(QString("%1").arg(DLV[DataSV[0].index].v2[2]))){
							for(i=0;i<DataSV.size();i++){
							DLV[DataSV[i].index].v2[2]=selitem->text().toFloat();
							}
						}
					
					}
					CmdCancel();
				}
				if(constant==2){
					Props->showTriangleMode(TRUE);
					QPixmap pixmap( 20, 20 );
					QTableWidgetItem *selitem;
					QString tempo;
					Props->setWindowTitle(QString(tr("%1 Triangles selected")).arg(DataSV.size()));
					/*if(DataSV.size()==1){*/
						Props->color1=QColor((int)(DTV[DataSV[0].index].c1[0]*255),(int)(DTV[DataSV[0].index].c1[1]*255),(int)(DTV[DataSV[0].index].c1[2]*255));
						pixmap.fill(Props->color1);
						selitem=Props->table1->item(0,1);selitem->setIcon(pixmap);
						Props->color2=QColor((int)(DTV[DataSV[0].index].c2[0]*255),(int)(DTV[DataSV[0].index].c2[1]*255),(int)(DTV[DataSV[0].index].c2[2]*255));
						pixmap.fill(Props->color2);
						selitem=Props->table1->item(4,1);selitem->setIcon(pixmap);
						Props->color3=QColor((int)(DTV[DataSV[0].index].c3[0]*255),(int)(DTV[DataSV[0].index].c3[1]*255),(int)(DTV[DataSV[0].index].c3[2]*255));
						pixmap.fill(Props->color3);
						selitem=Props->table1->item(8,1);selitem->setIcon(pixmap);
						selitem=Props->table1->item(1,1);selitem->setText(QString("%1").arg(DTV[DataSV[0].index].v1[0]));
						selitem=Props->table1->item(2,1);selitem->setText(QString("%1").arg(DTV[DataSV[0].index].v1[1]));
						selitem=Props->table1->item(3,1);selitem->setText(QString("%1").arg(DTV[DataSV[0].index].v1[2]));
						selitem=Props->table1->item(5,1);selitem->setText(QString("%1").arg(DTV[DataSV[0].index].v2[0]));
						selitem=Props->table1->item(6,1);selitem->setText(QString("%1").arg(DTV[DataSV[0].index].v2[1]));
						selitem=Props->table1->item(7,1);selitem->setText(QString("%1").arg(DTV[DataSV[0].index].v2[2]));
						selitem=Props->table1->item(9,1);selitem->setText(QString("%1").arg(DTV[DataSV[0].index].v3[0]));
						selitem=Props->table1->item(10,1);selitem->setText(QString("%1").arg(DTV[DataSV[0].index].v3[1]));
						selitem=Props->table1->item(11,1);selitem->setText(QString("%1").arg(DTV[DataSV[0].index].v3[2]));

						selitem=Props->table1->item(1,3);selitem->setText(QString("%1").arg(DTV[DataSV[0].index].texture));
						selitem=Props->table1->item(4,3);selitem->setText(QString("%1").arg(DTV[DataSV[0].index].t1[0]));
						selitem=Props->table1->item(5,3);selitem->setText(QString("%1").arg(DTV[DataSV[0].index].t1[1]));
						selitem=Props->table1->item(7,3);selitem->setText(QString("%1").arg(DTV[DataSV[0].index].t2[0]));
						selitem=Props->table1->item(8,3);selitem->setText(QString("%1").arg(DTV[DataSV[0].index].t2[1]));
						selitem=Props->table1->item(10,3);selitem->setText(QString("%1").arg(DTV[DataSV[0].index].t3[0]));
						selitem=Props->table1->item(11,3);selitem->setText(QString("%1").arg(DTV[DataSV[0].index].t3[1]));

						selitem=Props->table1->item(1,5);selitem->setText(QString("%1").arg(DTV[DataSV[0].index].n1[0]));
						selitem=Props->table1->item(2,5);selitem->setText(QString("%1").arg(DTV[DataSV[0].index].n1[1]));
						selitem=Props->table1->item(3,5);selitem->setText(QString("%1").arg(DTV[DataSV[0].index].n1[2]));
						selitem=Props->table1->item(5,5);selitem->setText(QString("%1").arg(DTV[DataSV[0].index].n2[0]));
						selitem=Props->table1->item(6,5);selitem->setText(QString("%1").arg(DTV[DataSV[0].index].n2[1]));
						selitem=Props->table1->item(7,5);selitem->setText(QString("%1").arg(DTV[DataSV[0].index].n2[2]));
						selitem=Props->table1->item(9,5);selitem->setText(QString("%1").arg(DTV[DataSV[0].index].n3[0]));
						selitem=Props->table1->item(10,5);selitem->setText(QString("%1").arg(DTV[DataSV[0].index].n3[1]));
						selitem=Props->table1->item(11,5);selitem->setText(QString("%1").arg(DTV[DataSV[0].index].n3[2]));
			
						if((DTV[DataSV[0].index].texture>0)&&(DTV[DataSV[0].index].texture<=StrTex.count()))
							tempo=StrTex.at(DTV[DataSV[0].index].texture-1);
						else
							tempo="";
						Props->pixname=tempo;
						tempo.remove( 0,tempo.lastIndexOf( "/" )+1);
						Props->StrTex=StrTex;
						selitem=Props->table1->item(0,3);selitem->setText(tempo);
					/*}*/
					/*if(DataSV.size()==1){*/
				
					if(Props->exec()){
						selitem=Props->table1->item(1,3);
						if(selitem->text().compare(QString("%1").arg(DTV[DataSV[0].index].texture))){
							for(i=0;i<DataSV.size();i++){
							DTV[DataSV[i].index].texture=selitem->text().toInt();
							if(DTV[DataSV[i].index].texture<0||DTV[DataSV[i].index].texture>StrTex.count())
								DTV[DataSV[i].index].texture=0;
							}
						}
						if((Props->color1.red()!=(int)(DTV[DataSV[0].index].c1[0]*255))||(Props->color1.green()!=(int)(DTV[DataSV[0].index].c1[1]*255))||(Props->color1.blue()!=(int)(DTV[DataSV[0].index].c1[2]*255))){
							for(i=0;i<DataSV.size();i++){
							DTV[DataSV[i].index].c1[0]=Props->color1.red()/255.0;
							DTV[DataSV[i].index].c1[1]=Props->color1.green()/255.0;
							DTV[DataSV[i].index].c1[2]=Props->color1.blue()/255.0;
							}
						}
						if((Props->color2.red()!=(int)(DTV[DataSV[0].index].c2[0]*255))||(Props->color2.green()!=(int)(DTV[DataSV[0].index].c2[1]*255))||(Props->color2.blue()!=(int)(DTV[DataSV[0].index].c2[2]*255))){
							for(i=0;i<DataSV.size();i++){
							DTV[DataSV[i].index].c2[0]=Props->color2.red()/255.0;
							DTV[DataSV[i].index].c2[1]=Props->color2.green()/255.0;
							DTV[DataSV[i].index].c2[2]=Props->color2.blue()/255.0;
							}
						}
						if((Props->color3.red()!=(int)(DTV[DataSV[0].index].c3[0]*255))||(Props->color3.green()!=(int)(DTV[DataSV[0].index].c3[1]*255))||(Props->color3.blue()!=(int)(DTV[DataSV[0].index].c3[2]*255))){
							for(i=0;i<DataSV.size();i++){
							DTV[DataSV[i].index].c3[0]=Props->color3.red()/255.0;
							DTV[DataSV[i].index].c3[1]=Props->color3.green()/255.0;
							DTV[DataSV[i].index].c3[2]=Props->color3.blue()/255.0;
							}
						}
												
						selitem=Props->table1->item(1,1);
						if(selitem->text().compare(QString("%1").arg(DTV[DataSV[0].index].v1[0]))){
							for(i=0;i<DataSV.size();i++){
							DTV[DataSV[i].index].v1[0]=selitem->text().toFloat();
							}
						}
						selitem=Props->table1->item(2,1);
						if(selitem->text().compare(QString("%1").arg(DTV[DataSV[0].index].v1[1]))){
							for(i=0;i<DataSV.size();i++){
							DTV[DataSV[i].index].v1[1]=selitem->text().toFloat();
							}
						}
						selitem=Props->table1->item(3,1);
						if(selitem->text().compare(QString("%1").arg(DTV[DataSV[0].index].v1[2]))){
							for(i=0;i<DataSV.size();i++){
							DTV[DataSV[i].index].v1[2]=selitem->text().toFloat();
							}
						}
						selitem=Props->table1->item(5,1);
						if(selitem->text().compare(QString("%1").arg(DTV[DataSV[0].index].v2[0]))){
							for(i=0;i<DataSV.size();i++){
							DTV[DataSV[i].index].v2[0]=selitem->text().toFloat();
							}
						}
						selitem=Props->table1->item(6,1);
						if(selitem->text().compare(QString("%1").arg(DTV[DataSV[0].index].v2[1]))){
							for(i=0;i<DataSV.size();i++){
							DTV[DataSV[i].index].v2[1]=selitem->text().toFloat();
							}
						}
						selitem=Props->table1->item(7,1);
						if(selitem->text().compare(QString("%1").arg(DTV[DataSV[0].index].v2[2]))){
							for(i=0;i<DataSV.size();i++){
							DTV[DataSV[i].index].v2[2]=selitem->text().toFloat();
							}
						}
						selitem=Props->table1->item(9,1);
						if(selitem->text().compare(QString("%1").arg(DTV[DataSV[0].index].v3[0]))){
							for(i=0;i<DataSV.size();i++){
							DTV[DataSV[i].index].v3[0]=selitem->text().toFloat();
							}
						}
						selitem=Props->table1->item(10,1);
						if(selitem->text().compare(QString("%1").arg(DTV[DataSV[0].index].v3[1]))){
							for(i=0;i<DataSV.size();i++){
							DTV[DataSV[i].index].v3[1]=selitem->text().toFloat();
							}
						}
						selitem=Props->table1->item(11,1);
						if(selitem->text().compare(QString("%1").arg(DTV[DataSV[0].index].v3[2]))){
							for(i=0;i<DataSV.size();i++){
							DTV[DataSV[i].index].v3[2]=selitem->text().toFloat();
							}
						}
						selitem=Props->table1->item(1,5);var[0]=selitem->text().toFloat()*selitem->text().toFloat();
						selitem=Props->table1->item(2,5);var[0]+=selitem->text().toFloat()*selitem->text().toFloat();
						selitem=Props->table1->item(3,5);var[0]+=selitem->text().toFloat()*selitem->text().toFloat();
						var[0]=sqrt(var[0]);
						
						selitem=Props->table1->item(5,5);var[1]=selitem->text().toFloat()*selitem->text().toFloat();
						selitem=Props->table1->item(6,5);var[1]+=selitem->text().toFloat()*selitem->text().toFloat();
						selitem=Props->table1->item(7,5);var[1]+=selitem->text().toFloat()*selitem->text().toFloat();
						var[1]=sqrt(var[1]);
						
						selitem=Props->table1->item(9,5);var[2]=selitem->text().toFloat()*selitem->text().toFloat();
						selitem=Props->table1->item(10,5);var[2]+=selitem->text().toFloat()*selitem->text().toFloat();
						selitem=Props->table1->item(11,5);var[2]+=selitem->text().toFloat()*selitem->text().toFloat();
						var[1]=sqrt(var[1]);
						
						selitem=Props->table1->item(1,5);
						if(selitem->text().compare(QString("%1").arg(DTV[DataSV[0].index].n1[0]))){
							for(i=0;i<DataSV.size();i++){
							DTV[DataSV[i].index].n1[0]=selitem->text().toFloat()/var[0];
							}
						}
						selitem=Props->table1->item(2,5);
						if(selitem->text().compare(QString("%1").arg(DTV[DataSV[0].index].n1[1]))){
							for(i=0;i<DataSV.size();i++){
							DTV[DataSV[i].index].n1[1]=selitem->text().toFloat()/var[0];
							}
						}
						selitem=Props->table1->item(3,5);
						if(selitem->text().compare(QString("%1").arg(DTV[DataSV[0].index].n1[2]))){
							for(i=0;i<DataSV.size();i++){
							DTV[DataSV[i].index].n1[2]=selitem->text().toFloat()/var[0];
							}
						}
						selitem=Props->table1->item(5,5);
						if(selitem->text().compare(QString("%1").arg(DTV[DataSV[0].index].n2[0]))){
							for(i=0;i<DataSV.size();i++){
							DTV[DataSV[i].index].n2[0]=selitem->text().toFloat()/var[1];
							}
						}
						selitem=Props->table1->item(6,5);
						if(selitem->text().compare(QString("%1").arg(DTV[DataSV[0].index].n2[1]))){
							for(i=0;i<DataSV.size();i++){
							DTV[DataSV[i].index].n2[1]=selitem->text().toFloat()/var[1];
							}
						}
						selitem=Props->table1->item(7,5);
						if(selitem->text().compare(QString("%1").arg(DTV[DataSV[0].index].n2[2]))){
							for(i=0;i<DataSV.size();i++){
							DTV[DataSV[i].index].n2[2]=selitem->text().toFloat()/var[1];
							}
						}
						selitem=Props->table1->item(9,5);
						if(selitem->text().compare(QString("%1").arg(DTV[DataSV[0].index].n3[0]))){
							for(i=0;i<DataSV.size();i++){
							DTV[DataSV[i].index].n3[0]=selitem->text().toFloat()/var[2];
							}
						}
						selitem=Props->table1->item(10,5);
						if(selitem->text().compare(QString("%1").arg(DTV[DataSV[0].index].n3[1]))){
							for(i=0;i<DataSV.size();i++){
							DTV[DataSV[i].index].n3[1]=selitem->text().toFloat()/var[2];
							}
						}
						selitem=Props->table1->item(11,5);
						if(selitem->text().compare(QString("%1").arg(DTV[DataSV[0].index].n3[2]))){
							for(i=0;i<DataSV.size();i++){
							DTV[DataSV[i].index].n3[2]=selitem->text().toFloat()/var[2];
							}
						}
						selitem=Props->table1->item(4,3);
						if(selitem->text().compare(QString("%1").arg(DTV[DataSV[0].index].t1[0]))){
							for(i=0;i<DataSV.size();i++){
							DTV[DataSV[i].index].t1[0]=selitem->text().toFloat();
							}
						}
						selitem=Props->table1->item(5,3);
						if(selitem->text().compare(QString("%1").arg(DTV[DataSV[0].index].t1[1]))){
							for(i=0;i<DataSV.size();i++){
							DTV[DataSV[i].index].t1[1]=selitem->text().toFloat();
							}
						}
						selitem=Props->table1->item(7,3);
						if(selitem->text().compare(QString("%1").arg(DTV[DataSV[0].index].t2[0]))){
							for(i=0;i<DataSV.size();i++){
							DTV[DataSV[i].index].t2[0]=selitem->text().toFloat();
							}
						}
						selitem=Props->table1->item(8,3);
						if(selitem->text().compare(QString("%1").arg(DTV[DataSV[0].index].t2[1]))){
							for(i=0;i<DataSV.size();i++){
							DTV[DataSV[i].index].t2[1]=selitem->text().toFloat();
							}
						}
						selitem=Props->table1->item(10,3);
						if(selitem->text().compare(QString("%1").arg(DTV[DataSV[0].index].t3[0]))){
							for(i=0;i<DataSV.size();i++){
							DTV[DataSV[i].index].t3[0]=selitem->text().toFloat();
							}
						}
						selitem=Props->table1->item(11,3);
						if(selitem->text().compare(QString("%1").arg(DTV[DataSV[0].index].t3[1]))){
							for(i=0;i<DataSV.size();i++){
							DTV[DataSV[i].index].t3[1]=selitem->text().toFloat();
							}
						}
					
					}
					Props->showTriangleMode(FALSE);
					CmdCancel();
				}
				/*instruction="pickpoint 1:";emit instru(instruction);
				emit SetMouseMode(MOUSEMODE_PICKPOINT);*/
				
				/*CmdCancel();*/
				/*step++;*/
				return;
			
		break;

	
	
	
	}
	
	
	
	
	
	SendText(SecCmd);
	SendText(tr("**Secondary Command not found**"));
}


#endif
