/****************************************************************************
** $Id:  cmds/cmducsicon.h
** AutoQ3D a qt 3d model editor program
**
** Copyright (C) 2005-2007 -Gonzalo Reynaga Garcia. <gonzaloreynaga@yahoo.com>
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public Licence
** as published by the Free Software Foundation; either version 2 
** of the License, or (at your option) any later option.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
** 
*****************************************************************************/

#ifndef CMDUCSICON_H
#define CMDUCSICON_H
#include "cmds.h"
#include <math.h>


void cmds::cmducsicon(){

	if((SecCmd==tr("**Cancel**")||SecCmd=="MouseRButton")&&!PopViewMode){
			SendText(tr("**Cancel**"));
			CmdCancel();
			return;
	}

	switch(step){
		
		case 0:
			/*/////////*/
		
				SendText(currentcmd);
				
				if(*ucsicon){
					instruction=tr("UCS icon [On/oFf]<On>:");emit instru(instruction);
				}else{
					instruction=tr("UCS icon [On/oFf]<oFf>:");emit instru(instruction);
				}
				emit SetMouseMode(MOUSEMODE_PICKPOINT);
				step++;
				return;
			
		break;

		case 1:
			if(!SecCmd.compare(tr("o"))||!SecCmd.compare(tr("O"))){
				*ucsicon=1;
				CmdCancel();
				return;
			}
			if(!SecCmd.compare(tr("f"))||!SecCmd.compare(tr("F"))){
				*ucsicon=0;
				CmdCancel();
				return;
			}
		break;
		
	
	}
	
	
	
	
	
	SendText(SecCmd);
	SendText(tr("**Secondary Command not found**"));
}


#endif
