/****************************************************************************
** $Id:  dialogs/texformsel.cpp
** AutoQ3D a qt 3d model editor program
**
** Copyright (C) 2005-2007 -Gonzalo Reynaga Garcia. <gonzaloreynaga@yahoo.com>
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public Licence
** as published by the Free Software Foundation; either version 2 
** of the License, or (at your option) any later option.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
** 
*****************************************************************************/

#include "texformsel.h"



TexFormSel::TexFormSel( QWidget* parent,Qt::WFlags flags,QStringList strlistin,int sel)
    : QDialog( parent,flags )
{	
	int i=1;
	QString tempo;
	StrTex=strlistin;
	selitemnum=sel;
	QVBoxLayout* Form1Layout;
	QHBoxLayout* layout1;
	
	Form1Layout = new QVBoxLayout(this);
	
	iconV=new QListWidget;
	layout1 = new QHBoxLayout;
	cancelbot = new QPushButton(tr("Cancel"));
	okbot = new QPushButton(tr("OK"));
	layout1->addWidget( okbot);
	layout1->addWidget( cancelbot);
	
	Form1Layout->addWidget(iconV);
	Form1Layout->addLayout( layout1 );
	
	resize( QSize(428, 287).expandedTo(minimumSizeHint()) );
	
	iconV->setSelectionMode(QAbstractItemView::SingleSelection);
	iconV->setViewMode(QListView::IconMode);
	iconV->setIconSize(QSize(70,70));

	if(sel)
		selitem=StrTex.at(sel-1);
	QPixmap bitmm(64,64);bitmm.fill(Qt::white);
	QListWidgetItem *item = new QListWidgetItem(QString("#0"),iconV);
	item->setIcon(QIcon(bitmm));
		for(QStringList::Iterator it=StrTex.begin();it!=StrTex.end();++it){
			QPixmap bitmm(*it);
			tempo=*it;tempo.remove( 0,tempo.lastIndexOf("/" )+1);
			QListWidgetItem *item = new QListWidgetItem(QString("#%1-").arg(i++)+tempo,iconV);
			item->setIcon(QIcon(bitmm.scaled(64,64)));
		}
		iconV->show();
	iconV->setCurrentRow(sel);
	setWindowTitle(tr("Set Texture Files"));
	connect(okbot,SIGNAL(clicked()),this,SLOT(okpress()));
	connect(cancelbot,SIGNAL(clicked()),this,SLOT(cancelpress()));

}

TexFormSel::~TexFormSel()
{

}

void TexFormSel::okpress(){
	
	QString tempo;
	selitemnum=iconV->currentRow();
	if(iconV->currentRow())
		selitem=StrTex.at(iconV->currentRow()-1);
	else
		selitem="";
	
	accept();
	close();
}



void TexFormSel::cancelpress(){
	reject();
	close();

}






