/****************************************************************************
** $Id:  dialogs/viewprop.cpp
** AutoQ3D a qt 3d model editor program
**
** Copyright (C) 2005-2007 -Gonzalo Reynaga Garcia. <gonzaloreynaga@yahoo.com>
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public Licence
** as published by the Free Software Foundation; either version 2 
** of the License, or (at your option) any later option.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
** 
*****************************************************************************/

#include "viewprop.h"

#include <qvariant.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qcheckbox.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qimage.h>
#include <qpixmap.h>

/*
 *  Constructs a Viewprop as a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'.
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
Viewprop::Viewprop( QWidget* parent, Qt::WFlags fl ,int shade,float *pbc)
    : QDialog( parent, fl )
{
    ViewpropLayout = new QVBoxLayout(this); 
    
	
	EFar = new QLineEdit;
	ENear = new QLineEdit;
	Label2 = new QLabel(  tr("Near depth clipping plane") );
	Label3 = new QLabel(  tr("Far depth clipping plane") );
	LBackColor = new QLabel(tr("BackGround Color:"));
	BtnBackColor = new QPushButton;
	
	
	groupShadeBox = new QGroupBox(tr("Shade Mode"));
	radio1 = new QRadioButton(tr("&Smooth"));
	radio2 = new QRadioButton(tr("&WireFrame"));
	radio3 = new QRadioButton(tr("&Hide"));
	ShadeMode=shade;
	BackColor[0]=pbc[0];BackColor[1]=pbc[1];BackColor[2]=pbc[2];
	bcolor.setRed((int)(BackColor[0]*255.0));
	bcolor.setGreen((int)(BackColor[1]*255.0));
	bcolor.setBlue((int)(BackColor[2]*255.0));
	
	QPalette newPalette = QPalette();
	newPalette.setColor(QPalette::Button, bcolor);
	

	BtnBackColor->setPalette(newPalette);
	
	if(shade==0){
		radio2->setChecked(true);
	}
	
	if(shade==1){
		radio1->setChecked(true);
	}
	
	if(shade==2){
		radio3->setChecked(true);
	}
	
	QHBoxLayout *hBackColor = new QHBoxLayout;
	hBackColor->addWidget(LBackColor);
	hBackColor->addWidget(BtnBackColor);
	hBackColor->addStretch(1);
	
	QHBoxLayout *hshadebox = new QHBoxLayout;
	hshadebox->addWidget(radio1);
	hshadebox->addWidget(radio2);
	hshadebox->addWidget(radio3);
	hshadebox->addStretch(1);
	groupShadeBox->setLayout(hshadebox);
	
	
	

	NSize = new QLineEdit;
	Label1 = new QLabel(tr("Normal size"));
	chBN = new QCheckBox(tr("Show Normals"));
	chGR = new QCheckBox(tr("Show Grid"));
	Label1->setAlignment(Qt::AlignRight);

	OkBtn = new QPushButton(tr("OK"));
	CancelBtn = new QPushButton(tr("Cancel"));

	QHBoxLayout *buttonLayout = new QHBoxLayout;
	buttonLayout->addStretch(1);
	buttonLayout->addWidget(OkBtn);
	buttonLayout->addWidget(CancelBtn);


	QHBoxLayout *NSizeLayout = new QHBoxLayout;
	NSizeLayout->addWidget(Label1,Qt::AlignRight);
	NSizeLayout->addWidget(NSize);
	NSizeLayout->addStretch(1);

	layout1 = new QGridLayout;
	layout1->addWidget(Label2,0,0,Qt::AlignBottom);
    layout1->addWidget(Label3,0,1,Qt::AlignBottom);
	layout1->addWidget(ENear,1,0,Qt::AlignTop);
    layout1->addWidget(EFar,1,1,Qt::AlignTop);
	
	
	ViewpropLayout->addWidget(groupShadeBox);
	ViewpropLayout->addLayout(hBackColor);
	ViewpropLayout->addWidget(chGR);
	ViewpropLayout->addWidget(chBN);
	ViewpropLayout->addStretch(1);
	ViewpropLayout->addLayout(NSizeLayout);
	ViewpropLayout->addLayout(layout1);
	ViewpropLayout->addStretch(1);
	ViewpropLayout->addLayout(buttonLayout);
	
	setWindowTitle(tr("Viewport Properties"));
	
	EFar->setValidator(new QDoubleValidator(EFar));
	ENear->setValidator(new QDoubleValidator(ENear));
	NSize->setValidator(new QDoubleValidator(NSize));
   
    
    resize( QSize(327, 202).expandedTo(minimumSizeHint()) );
	connect( OkBtn, SIGNAL( clicked() ) , this, SLOT( accept() ) );
	connect( CancelBtn, SIGNAL( clicked() ) , this, SLOT( reject() ) );
	
	connect( radio1, SIGNAL( clicked() ) , this, SLOT( Radio1Click() ) );
	connect( radio2, SIGNAL( clicked() ) , this, SLOT( Radio2Click() ) );
	connect( radio3, SIGNAL( clicked() ) , this, SLOT( Radio3Click() ) );
	connect( BtnBackColor, SIGNAL( clicked() ) , this, SLOT( ChangeBackColor() ) );
}

void Viewprop::Radio1Click(){
	ShadeMode=1;
}
void Viewprop::Radio2Click(){
	ShadeMode=0;
}
void Viewprop::Radio3Click(){
	ShadeMode=2;
}

void Viewprop::ChangeBackColor(){
	bcolor=QColorDialog::getColor(QColor((int)(BackColor[0]*255),(int)(BackColor[1]*255),(int)(BackColor[2]*255)), this );	
	if(bcolor.isValid()){
		QPalette newPalette = QPalette();
		newPalette.setColor(QPalette::Button, bcolor);
		BtnBackColor->setPalette(newPalette);
	}
}
/*
 *  Destroys the object and frees any allocated resources
 */
Viewprop::~Viewprop()
{
    // no need to delete child widgets, Qt does it all for us
}


