/****************************************************************************
** $Id:  main.cpp
** AutoQ3D a qt 3d model editor program
**
** Copyright (C) 2005-2007 -Gonzalo Reynaga Garcia. <gonzaloreynaga@yahoo.com>
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public Licence
** as published by the Free Software Foundation; either version 2
** of the License, or (at your option) any later option.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
**
*****************************************************************************/

#include <QApplication>
#include <QTranslator>
#include <QSettings>
#include <QString>
#include <QVariant>

#include "fgui/cadform.h"

int main(int argc, char *argv[])
{

	QApplication a( argc, argv );
    QTranslator translator;
    QString progpath;
    QSettings settings("AutoQ3D-Community","AutoQ3D-Community");
	int language = settings.value("MainWindow/Language").toInt();
    	progpath=settings.value("MainWindow/ProgramPath","/usr/share/AutoQ3D-Community").toString()+"/";
	translator.load("");
    switch(language){
    	case 1:
		translator.load(progpath+"lan_sp");
	break;

    }

    a.installTranslator(&translator);
    CadForm * mw = new CadForm();
    mw->show();
	mw->ecmd->setFocus();
    a.connect( &a, SIGNAL(lastWindowClosed()), &a, SLOT(quit()) );
    int res = a.exec();
    return res;
}
