/*
 * Created on Aug 8, 2007
 * Created by Paul Gardner
 * Copyright (C) 2007 Aelitis, All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * AELITIS, SAS au capital de 63.529,40 euros
 * 8 Allee Lenotre, La Grille Royale, 78600 Le Mesnil le Roi, France.
 *
 */


package com.aelitis.azureus.core.speedmanager.impl;

import java.util.Random;

import com.aelitis.azureus.core.speedmanager.SpeedManager;


public class 
TestPingSourceRandom 
	extends TestPingSourceImpl
{
	private Random	random	= new Random();
	
	protected
	TestPingSourceRandom(
		SpeedManagerAlgorithmProviderAdapter	adapter )
	{
		super( adapter );
	}
	
	protected void 
	updateSources(
		testSource[] sources )
	{
		for (int i=0;i<sources.length;i++){
			
			sources[i].setRTT( random.nextInt( 500 ));
		}
	}
}
