/*
 * Created on 25 January 2007
 * Created by Allan Crooks
 * Copyright (C) 2007 Aelitis, All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * AELITIS, SAS au capital de 46,603.30 euros
 * 8 Allee Lenotre, La Grille Royale, 78600 Le Mesnil le Roi, France.
 */
package org.gudy.azureus2.plugins.ui.menus;

/**
 * Helper class to allow plugins to register their own menus. If you want to
 * add menus to be available in tables, you should use the <tt>TableManager</tt>
 * class. 
 *
 * @author amc1
 * @see org.gudy.azureus2.plugins.local.ui.tables.TableManager TableManager
 * @since 3.0.0.7
 */
public interface MenuManager {
	
	/**
	 * The menu used for tables - this value cannot be used directly to create
	 * menus used by tables, you need to use the <tt>TableManager</tt> class
	 * to create such menu items.
	 * 
	 * @see org.gudy.azureus2.plugins.local.ui.tables.TableManager TableManager
	 */
	public static final String MENU_TABLE = "table";
	
	/**
	 * The menu used for the system tray icon.
	 */
	public static final String MENU_SYSTRAY = "systray";
	
	/**
	 * The menu used on download bars.
	 */
	public static final String MENU_DOWNLOAD_BAR = "downloadbar";
	
	/**
	 * The "Plugins" menu on the menu bar.
	 */
	public static final String MENU_MENUBAR = "mainmenu";
	
	/**
	 * The "transfers bar". 
	 * 
	 * @since 3.0.1.3
	 */
	public static final String MENU_TRANSFERSBAR = "transfersbar";
	
	/**
	 * The "Torrents" menu.
	 * 
	 * @since 3.0.2
	 */
	public static final String MENU_TORRENT_MENU = "torrentmenu";
	
	/**
	 * All menus which are Download specific, such as download bars, the Torrent
	 * menu, torrent tables etc.
	 * 
	 * @since 3.0.2
	 */
	public static final String MENU_DOWNLOAD_CONTEXT = "download_context";
	
	/**
	 * Creates a menu item for the appropriate menu.
	 * 
	 * @param menuID The <tt>MENU_</tt> identifier as defined above. 
	 * @param resource_key ID of the menu, which is also used to retrieve the
	 *                     textual name from the plugin language file.
	 * @return The newly created menu item.
	 */
    public MenuItem addMenuItem(String menuID, String resource_key);
    
    /**
     * Creates a menu item as a sub-item of the given menu item.
     * 
     * @param parent The MenuItem to add this new item to. The parent MenuItem
     *               must have its style attribute to be set to "menu".
     * @param resource_key ID of the menu, which is also used to retrieve the
	 *                     textual name from the plugin language file.
	 * @return The newly created menu item.
     */
    public MenuItem addMenuItem(MenuItem parent, String resource_key);
}
