/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.rating;

import com.aelitis.azureus.plugins.rating.ui.RatingColumn;
import com.aelitis.azureus.plugins.rating.ui.RatingImageUtil;
import com.aelitis.azureus.plugins.rating.ui.RatingWindow;
import com.aelitis.azureus.plugins.rating.updater.RatingsUpdater;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginListener;
import org.gudy.azureus2.plugins.config.ConfigParameter;
import org.gudy.azureus2.plugins.config.ConfigParameterListener;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.ui.UIInstance;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.UIManagerListener;
import org.gudy.azureus2.plugins.ui.config.Parameter;
import org.gudy.azureus2.plugins.ui.config.PluginConfigUIFactory;
import org.gudy.azureus2.plugins.ui.menus.MenuItem;
import org.gudy.azureus2.plugins.ui.menus.MenuItemListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.plugins.ui.tables.TableContextMenuItem;
import org.gudy.azureus2.plugins.ui.tables.TableManager;
import org.gudy.azureus2.plugins.ui.tables.TableRow;
import org.gudy.azureus2.ui.swt.plugins.UISWTInstance;

public class RatingPlugin
implements Plugin,
ConfigParameterListener,
PluginListener {
    private static final String COLUMN_ID_RATING = "RatingColumn";
    private PluginInterface pluginInterface;
    private UISWTInstance swt_ui;
    private LoggerChannel log;
    private String nick;
    private RatingsUpdater updater;

    public void initialize(PluginInterface pluginInterface) {
        this.pluginInterface = pluginInterface;
        this.log = pluginInterface.getLogger().getChannel("Rating Plugin");
        pluginInterface.getUIManager().addUIListener(new UIManagerListener(){

            public void UIAttached(UIInstance instance) {
                if (instance instanceof UISWTInstance) {
                    UISWTInstance swt = (UISWTInstance)instance;
                    RatingPlugin.this.initialise(swt);
                }
            }

            public void UIDetached(UIInstance instance) {
            }
        });
    }

    protected void initialise(UISWTInstance _swt) {
        this.swt_ui = _swt;
        RatingImageUtil.init(_swt.getDisplay());
        this.nick = this.pluginInterface.getPluginconfig().getPluginStringParameter("nick", "Anonymous");
        this.addPluginConfig();
        this.updater = new RatingsUpdater(this);
        this.pluginInterface.addListener((PluginListener)this);
        this.addMyTorrentsColumn();
        this.addMyTorrentsMenu();
    }

    public void closedownComplete() {
    }

    public void closedownInitiated() {
    }

    public void initializationComplete() {
        this.updater.initialize();
    }

    private void addPluginConfig() {
        PluginConfigUIFactory factory = this.pluginInterface.getPluginConfigUIFactory();
        Parameter[] parameters = new Parameter[]{factory.createStringParameter("nick", "rating.config.nick", "")};
        parameters[0].addConfigParameterListener((ConfigParameterListener)this);
        this.pluginInterface.addConfigUIParameters(parameters, "rating.config.title");
    }

    private void addMyTorrentsColumn() {
        RatingColumn ratingColumn = new RatingColumn(this);
        this.addRatingColumnToTable("MyTorrents", ratingColumn);
        this.addRatingColumnToTable("MySeeders", ratingColumn);
    }

    private void addRatingColumnToTable(String tableID, RatingColumn ratingColumn) {
        UIManager uiManager = this.pluginInterface.getUIManager();
        TableManager tableManager = uiManager.getTableManager();
        TableColumn activityColumn = tableManager.createColumn(tableID, COLUMN_ID_RATING);
        activityColumn.setAlignment(1);
        activityColumn.setPosition(5);
        activityColumn.setWidth(95);
        activityColumn.setRefreshInterval(-1);
        activityColumn.setType(2);
        activityColumn.addListeners((Object)ratingColumn);
        tableManager.addColumn(activityColumn);
    }

    private void addMyTorrentsMenu() {
        MenuItemListener listener = new MenuItemListener(){

            public void selected(MenuItem _menu, Object _target) {
                Download download = (Download)((TableRow)_target).getDataSource();
                if (download == null || download.getTorrent() == null) {
                    return;
                }
                if (RatingPlugin.this.swt_ui != null) {
                    new RatingWindow(RatingPlugin.this, download);
                }
            }
        };
        TableContextMenuItem menu1 = this.pluginInterface.getUIManager().getTableManager().addContextMenuItem("MyTorrents", "RatingPlugin.contextmenu.manageRating");
        TableContextMenuItem menu2 = this.pluginInterface.getUIManager().getTableManager().addContextMenuItem("MySeeders", "RatingPlugin.contextmenu.manageRating");
        menu1.addListener(listener);
        menu2.addListener(listener);
    }

    public void configParameterChanged(ConfigParameter param) {
        this.nick = this.pluginInterface.getPluginconfig().getPluginStringParameter("nick", "Anonymous");
    }

    public UISWTInstance getUI() {
        return this.swt_ui;
    }

    public PluginInterface getPluginInterface() {
        return this.pluginInterface;
    }

    public String getNick() {
        return this.nick;
    }

    public void logInfo(String text) {
        this.log.log(1, text);
    }

    public void logError(String text) {
        this.log.log(3, text);
    }

    public void logError(String text, Throwable t) {
        this.log.log(text, t);
    }

    public RatingsUpdater getUpdater() {
        return this.updater;
    }
}

