/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.instancemanager.impl;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreLifecycleAdapter;
import com.aelitis.azureus.core.instancemanager.AZInstance;
import com.aelitis.azureus.core.instancemanager.AZInstanceManager;
import com.aelitis.azureus.core.instancemanager.AZInstanceManagerListener;
import com.aelitis.azureus.core.instancemanager.AZInstanceTracked;
import com.aelitis.azureus.core.instancemanager.impl.AZMyInstanceImpl;
import com.aelitis.azureus.core.instancemanager.impl.AZOtherInstanceImpl;
import com.aelitis.azureus.core.instancemanager.impl.AZPortClashHandler;
import com.aelitis.net.udp.mc.MCGroup;
import com.aelitis.net.udp.mc.MCGroupAdapter;
import com.aelitis.net.udp.mc.MCGroupFactory;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SHA1Simple;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadManagerImpl;

public class AZInstanceManagerImpl
implements AZInstanceManager,
MCGroupAdapter {
    private static final LogIDs LOGID = LogIDs.NET;
    private String MC_GROUP_ADDRESS = "239.255.067.250";
    private int MC_GROUP_PORT = 16680;
    private int MC_CONTROL_PORT = 0;
    private static final int MT_VERSION = 1;
    private static final int MT_ALIVE = 1;
    private static final int MT_BYE = 2;
    private static final int MT_REQUEST = 3;
    private static final int MT_REPLY = 4;
    private static final int MT_REQUEST_SEARCH = 1;
    private static final int MT_REQUEST_TRACK = 2;
    private static final long ALIVE_PERIOD = 1800000L;
    private static AZInstanceManagerImpl singleton;
    private List listeners = new ArrayList();
    private static AEMonitor class_mon;
    private AzureusCore core;
    private MCGroup mc_group;
    private long search_id_next;
    private List requests = new ArrayList();
    private AZMyInstanceImpl my_instance;
    private Map other_instances = new HashMap();
    private volatile Map tcp_lan_to_ext = new HashMap();
    private volatile Map udp_lan_to_ext = new HashMap();
    private volatile Map tcp_ext_to_lan = new HashMap();
    private volatile Map udp_ext_to_lan = new HashMap();
    private volatile Set lan_addresses = new HashSet();
    private volatile Set ext_addresses = new HashSet();
    private AESemaphore initial_search_sem = new AESemaphore("AZInstanceManager:initialSearch");
    private AEMonitor this_mon = new AEMonitor("AZInstanceManager");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AZInstanceManager getSingleton(AzureusCore core) {
        try {
            class_mon.enter();
            if (singleton == null) {
                singleton = new AZInstanceManagerImpl(core);
            }
        }
        finally {
            class_mon.exit();
        }
        return singleton;
    }

    protected AZInstanceManagerImpl(AzureusCore _core) {
        this.core = _core;
        this.my_instance = new AZMyInstanceImpl(this.core, this);
        new AZPortClashHandler(this);
    }

    public void initialize() {
        try {
            this.mc_group = MCGroupFactory.getSingleton(this, this.MC_GROUP_ADDRESS, this.MC_GROUP_PORT, this.MC_CONTROL_PORT, null);
            this.core.addLifecycleListener(new AzureusCoreLifecycleAdapter(){

                public void stopping(AzureusCore core) {
                    AZInstanceManagerImpl.this.sendByeBye();
                }
            });
            SimpleTimer.addPeriodicEvent(1800000L, new TimerEventPerformer(){

                public void perform(TimerEvent event) {
                    AZInstanceManagerImpl.this.checkTimeouts();
                    AZInstanceManagerImpl.this.sendAlive();
                }
            });
        }
        catch (Throwable e) {
            this.initial_search_sem.releaseForever();
            Debug.printStackTrace(e);
        }
        new AEThread("AZInstanceManager:initialSearch", true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void runSupport() {
                try {
                    AZInstanceManagerImpl.this.search();
                    AZInstanceManagerImpl.this.addAddresses(AZInstanceManagerImpl.this.my_instance);
                }
                finally {
                    AZInstanceManagerImpl.this.initial_search_sem.releaseForever();
                }
            }
        }.start();
    }

    public void trace(String str) {
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, str));
        }
    }

    public void log(Throwable e) {
        Debug.printStackTrace(e);
    }

    public boolean isInitialized() {
        return this.initial_search_sem.isReleasedForever();
    }

    protected void sendAlive() {
        this.sendMessage(1);
    }

    protected void sendByeBye() {
        this.sendMessage(2);
    }

    protected void sendMessage(int type) {
        this.sendMessage(type, null);
    }

    protected void sendMessage(int type, Map body) {
        this.sendMessage(type, body, null);
    }

    protected void sendMessage(int type, Map body, InetSocketAddress member) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ver", new Long(1L));
        map.put("type", new Long(type));
        HashMap originator = new HashMap();
        map.put("orig", originator);
        this.my_instance.encode(originator);
        if (body != null) {
            map.put("body", body);
        }
        try {
            byte[] data = BEncoder.encode(map);
            if (member == null) {
                this.mc_group.sendToGroup(data);
            } else {
                this.mc_group.sendToMember(member, data);
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void received(NetworkInterface network_interface, InetAddress local_address, InetSocketAddress originator, byte[] data, int length) {
        block10: {
            try {
                String originator_id;
                Map map = BDecoder.decode(new BufferedInputStream(new ByteArrayInputStream(data, 0, length)));
                long version = (Long)map.get("ver");
                long type = (Long)map.get("type");
                AZOtherInstanceImpl instance = AZOtherInstanceImpl.decode(originator.getAddress(), (Map)map.get("orig"));
                if (type == 1L) {
                    this.checkAdd(instance);
                    break block10;
                }
                if (type == 2L) {
                    this.checkRemove(instance);
                    break block10;
                }
                this.checkAdd(instance);
                Map body = (Map)map.get("body");
                if (type == 3L) {
                    Map reply;
                    String originator_id2 = instance.getID();
                    if (!originator_id2.equals(this.my_instance.getID()) && (reply = this.requestReceived(instance, body)) != null) {
                        reply.put("oid", originator_id2.getBytes());
                        reply.put("rid", body.get("rid"));
                        this.sendMessage(4, reply, originator);
                    }
                    break block10;
                }
                if (type != 4L || !(originator_id = new String((byte[])body.get("oid"))).equals(this.my_instance.getID())) break block10;
                long req_id = (Long)body.get("rid");
                try {
                    this.this_mon.enter();
                    for (int i = 0; i < this.requests.size(); ++i) {
                        request req = (request)this.requests.get(i);
                        if (req.getID() != req_id) continue;
                        req.addReply(instance, body);
                    }
                }
                finally {
                    this.this_mon.exit();
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    protected Map requestReceived(AZInstance instance, Map body) {
        long type = (Long)body.get("type");
        if (type == 1L) {
            return new HashMap();
        }
        if (type == 2L) {
            byte[] hash = (byte[])body.get("hash");
            boolean seed = ((Long)body.get("seed")).intValue() == 1;
            List dms = this.core.getGlobalManager().getDownloadManagers();
            Iterator it = dms.iterator();
            DownloadManager matching_dm = null;
            try {
                while (it.hasNext()) {
                    DownloadManager dm = (DownloadManager)it.next();
                    TOTorrent torrent = dm.getTorrent();
                    if (torrent == null) continue;
                    byte[] sha1_hash = (byte[])dm.getData("AZInstanceManager::sha1_hash");
                    if (sha1_hash == null) {
                        sha1_hash = new SHA1Simple().calculateHash(torrent.getHash());
                        dm.setData("AZInstanceManager::sha1_hash", sha1_hash);
                    }
                    if (!Arrays.equals(hash, sha1_hash)) continue;
                    matching_dm = dm;
                    break;
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            if (matching_dm == null) {
                return null;
            }
            int dm_state = matching_dm.getState();
            if (dm_state == 100 || dm_state == 70) {
                return null;
            }
            try {
                this.informTracked(new trackedInstance(instance, DownloadManagerImpl.getDownloadStatic(matching_dm), seed));
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            HashMap<String, Long> reply = new HashMap<String, Long>();
            reply.put("seed", new Long(matching_dm.isDownloadComplete() ? 1L : 0L));
            return reply;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AZOtherInstanceImpl checkAdd(AZOtherInstanceImpl inst) {
        if (inst.getID().equals(this.my_instance.getID())) {
            return inst;
        }
        boolean added = false;
        boolean changed = false;
        try {
            this.this_mon.enter();
            AZOtherInstanceImpl existing = (AZOtherInstanceImpl)this.other_instances.get(inst.getID());
            if (existing == null) {
                added = true;
                this.other_instances.put(inst.getID(), inst);
            } else {
                changed = existing.update(inst);
                inst = existing;
            }
        }
        finally {
            this.this_mon.exit();
        }
        if (added) {
            this.informAdded(inst);
        } else if (changed) {
            this.informChanged(inst);
        }
        return inst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkRemove(AZOtherInstanceImpl inst) {
        if (inst.getID().equals(this.my_instance.getID())) {
            return;
        }
        boolean removed = false;
        try {
            this.this_mon.enter();
            removed = this.other_instances.remove(inst.getID()) != null;
        }
        finally {
            this.this_mon.exit();
        }
        if (removed) {
            this.informRemoved(inst);
        }
    }

    public AZInstance getMyInstance() {
        return this.my_instance;
    }

    protected void search() {
        this.sendRequest(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AZInstance[] getOtherInstances() {
        this.initial_search_sem.reserve();
        try {
            this.this_mon.enter();
            AZInstance[] aZInstanceArray = this.other_instances.values().toArray(new AZInstance[this.other_instances.size()]);
            return aZInstanceArray;
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected void addAddresses(AZInstance inst) {
        InetAddress internal_address = inst.getInternalAddress();
        InetAddress external_address = inst.getExternalAddress();
        int tcp = inst.getTrackerClientPort();
        int udp = inst.getDHTPort();
        this.modifyAddresses(internal_address, external_address, tcp, udp, true);
    }

    protected void removeAddresses(AZOtherInstanceImpl inst) {
        List internal_addresses = inst.getInternalAddresses();
        InetAddress external_address = inst.getExternalAddress();
        int tcp = inst.getTrackerClientPort();
        int udp = inst.getDHTPort();
        for (int i = 0; i < internal_addresses.size(); ++i) {
            this.modifyAddresses((InetAddress)internal_addresses.get(i), external_address, tcp, udp, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void modifyAddresses(InetAddress internal_address, InetAddress external_address, int tcp, int udp, boolean add) {
        if (internal_address.isAnyLocalAddress()) {
            try {
                internal_address = InetAddress.getLocalHost();
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        try {
            this.this_mon.enter();
            InetSocketAddress int_tcp = new InetSocketAddress(internal_address, tcp);
            InetSocketAddress ext_tcp = new InetSocketAddress(external_address, tcp);
            InetSocketAddress int_udp = new InetSocketAddress(internal_address, udp);
            InetSocketAddress ext_udp = new InetSocketAddress(external_address, udp);
            this.tcp_ext_to_lan = this.modifyAddress(this.tcp_ext_to_lan, ext_tcp, int_tcp, add);
            this.tcp_lan_to_ext = this.modifyAddress(this.tcp_lan_to_ext, int_tcp, ext_tcp, add);
            this.udp_ext_to_lan = this.modifyAddress(this.udp_ext_to_lan, ext_udp, int_udp, add);
            this.udp_lan_to_ext = this.modifyAddress(this.udp_lan_to_ext, int_udp, ext_udp, add);
            if (!this.lan_addresses.contains(internal_address)) {
                HashSet<InetAddress> new_lan_addresses = new HashSet<InetAddress>(this.lan_addresses);
                new_lan_addresses.add(internal_address);
                this.lan_addresses = new_lan_addresses;
            }
            if (!this.ext_addresses.contains(external_address)) {
                HashSet<InetAddress> new_ext_addresses = new HashSet<InetAddress>(this.ext_addresses);
                new_ext_addresses.add(external_address);
                this.ext_addresses = new_ext_addresses;
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected Map modifyAddress(Map map, InetSocketAddress key, InetSocketAddress value, boolean add) {
        InetSocketAddress old_value = (InetSocketAddress)map.get(key);
        boolean same = old_value != null && old_value.equals(value);
        HashMap<InetSocketAddress, InetSocketAddress> new_map = map;
        if (add) {
            if (!same) {
                new_map = new HashMap<InetSocketAddress, InetSocketAddress>(map);
                new_map.put(key, value);
            }
        } else if (same) {
            new_map = new HashMap(map);
            new_map.remove(key);
        }
        return new_map;
    }

    public InetSocketAddress getLANAddress(InetSocketAddress external_address, boolean is_tcp) {
        Map map;
        Map map2 = map = is_tcp ? this.tcp_ext_to_lan : this.udp_ext_to_lan;
        if (map.size() == 0) {
            return null;
        }
        return (InetSocketAddress)map.get(external_address);
    }

    public InetSocketAddress getExternalAddress(InetSocketAddress lan_address, boolean is_tcp) {
        Map map;
        Map map2 = map = is_tcp ? this.tcp_lan_to_ext : this.udp_lan_to_ext;
        if (map.size() == 0) {
            return null;
        }
        return (InetSocketAddress)map.get(lan_address);
    }

    public boolean isLANAddress(InetAddress address) {
        if (address.isLoopbackAddress()) {
            return true;
        }
        return this.lan_addresses.contains(address);
    }

    public boolean isExternalAddress(InetAddress address) {
        return this.ext_addresses.contains(address);
    }

    public AZInstanceTracked[] track(Download download) {
        if (this.mc_group == null || download.getTorrent() == null || this.getOtherInstances().length == 0) {
            return new AZInstanceTracked[0];
        }
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("hash", new SHA1Simple().calculateHash(download.getTorrent().getHash()));
        body.put("seed", new Long(download.isComplete() ? 1L : 0L));
        Map replies = this.sendRequest(2, body);
        AZInstanceTracked[] res = new AZInstanceTracked[replies.size()];
        Iterator it = replies.entrySet().iterator();
        int pos = 0;
        while (it.hasNext()) {
            Map.Entry entry2 = it.next();
            AZInstance inst = (AZInstance)entry2.getKey();
            Map reply = (Map)entry2.getValue();
            boolean seed = ((Long)reply.get("seed")).intValue() == 1;
            res[pos++] = new trackedInstance(inst, download, seed);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkTimeouts() {
        AZOtherInstanceImpl inst;
        long now = SystemTime.getCurrentTime();
        ArrayList<AZOtherInstanceImpl> removed = new ArrayList<AZOtherInstanceImpl>();
        try {
            this.this_mon.enter();
            Iterator it = this.other_instances.values().iterator();
            while (it.hasNext()) {
                inst = (AZOtherInstanceImpl)it.next();
                if (!((double)(now - inst.getAliveTime()) > 4500000.0)) continue;
                removed.add(inst);
                it.remove();
            }
        }
        finally {
            this.this_mon.exit();
        }
        for (int i = 0; i < removed.size(); ++i) {
            inst = (AZOtherInstanceImpl)removed.get(i);
            this.informRemoved(inst);
        }
    }

    protected void informRemoved(AZOtherInstanceImpl inst) {
        this.removeAddresses(inst);
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                ((AZInstanceManagerListener)this.listeners.get(i)).instanceLost(inst);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    protected void informAdded(AZInstance inst) {
        this.addAddresses(inst);
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                ((AZInstanceManagerListener)this.listeners.get(i)).instanceFound(inst);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    protected void informChanged(AZInstance inst) {
        this.addAddresses(inst);
        if (inst == this.my_instance) {
            this.sendAlive();
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                ((AZInstanceManagerListener)this.listeners.get(i)).instanceChanged(inst);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    protected void informTracked(AZInstanceTracked inst) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                ((AZInstanceManagerListener)this.listeners.get(i)).instanceTracked(inst);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    protected Map sendRequest(int type) {
        return new request(type, new HashMap()).getReplies();
    }

    protected Map sendRequest(int type, Map body) {
        return new request(type, body).getReplies();
    }

    public void addListener(AZInstanceManagerListener l) {
        this.listeners.add(l);
    }

    public void removeListener(AZInstanceManagerListener l) {
        this.listeners.remove(l);
    }

    static {
        class_mon = new AEMonitor("AZInstanceManager:class");
    }

    protected static class trackedInstance
    implements AZInstanceTracked {
        private AZInstance instance;
        private Download download;
        private boolean seed;

        protected trackedInstance(AZInstance _instance, Download _download, boolean _seed) {
            this.instance = _instance;
            this.download = _download;
            this.seed = _seed;
        }

        public AZInstance getInstance() {
            return this.instance;
        }

        public Download getDownload() {
            return this.download;
        }

        public boolean isSeed() {
            return this.seed;
        }
    }

    protected class request {
        private long id;
        private Set reply_instances = new HashSet();
        private Map replies = new HashMap();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected request(int type, Map body) {
            try {
                AZInstanceManagerImpl.this.this_mon.enter();
                this.id = AZInstanceManagerImpl.this.search_id_next++;
                AZInstanceManagerImpl.this.requests.add(this);
            }
            finally {
                AZInstanceManagerImpl.this.this_mon.exit();
            }
            body.put("type", new Long(type));
            body.put("rid", new Long(this.id));
            AZInstanceManagerImpl.this.sendMessage(3, body);
        }

        protected long getID() {
            return this.id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void addReply(AZInstance instance, Map body) {
            try {
                AZInstanceManagerImpl.this.this_mon.enter();
                if (!this.reply_instances.contains(instance.getID())) {
                    this.reply_instances.add(instance.getID());
                    this.replies.put(instance, body);
                }
            }
            finally {
                AZInstanceManagerImpl.this.this_mon.exit();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Map getReplies() {
            try {
                Thread.sleep(2500L);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                AZInstanceManagerImpl.this.this_mon.enter();
                AZInstanceManagerImpl.this.requests.remove(this);
                Map map = this.replies;
                return map;
            }
            finally {
                AZInstanceManagerImpl.this.this_mon.exit();
            }
        }
    }
}

