/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.piecepicker.impl;

import com.aelitis.azureus.core.peermanager.piecepicker.EndGameModeChunk;
import com.aelitis.azureus.core.peermanager.piecepicker.PiecePicker;
import com.aelitis.azureus.core.peermanager.piecepicker.priority.PiecePriorityShaper;
import com.aelitis.azureus.core.peermanager.piecepicker.util.BitFlags;
import com.aelitis.azureus.core.peermanager.unchoker.UnchokerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.disk.DiskManagerListener;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.disk.impl.DiskManagerFileInfoImpl;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceList;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerListener;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.peer.PEPeerManagerListener;
import org.gudy.azureus2.core3.peer.PEPiece;
import org.gudy.azureus2.core3.peer.impl.PEPeerControl;
import org.gudy.azureus2.core3.peer.impl.PEPeerTransport;
import org.gudy.azureus2.core3.peer.impl.PEPieceImpl;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.core3.util.SystemTime;

public class PiecePickerImpl
implements PiecePicker {
    private static final LogIDs LOGID = LogIDs.PIECES;
    private static final long TIME_MIN_AVAILABILITY = 974L;
    private static final long TIME_MIN_PRIORITIES = 999L;
    private static final long TIME_AVAIL_REBUILD = 120000L;
    private static final long PRIORITY_W_FIRSTLAST = 1200L;
    private static final long FIRST_PIECE_MIN_NB = 4L;
    private static final long PRIORITY_W_FILE = 1100L;
    private static final long PRIORITY_W_COMPLETION = 1000L;
    private static final long PRIORITY_W_RAREST = 1300L;
    private static final long PRIORITY_W_RARE = 2300L;
    private static final long PRIORITY_W_AGE = 1000L;
    private static final long PRIORITY_DW_AGE = 60000L;
    private static final long PRIORITY_DW_STALE = 120000L;
    private static final long PRIORITY_W_PIECE_DONE = 900L;
    private static final long PRIORITY_W_SAME_PIECE = 500L;
    private static final int REQUESTS_MIN = 2;
    private static final int REQUESTS_MAX = 256;
    private static final int SLOPE_REQUESTS = 4096;
    private static final long END_GAME_MODE_SIZE_TRIGGER = 0x1400000L;
    private static final long END_GAME_MODE_TIMEOUT = 76800L;
    protected static volatile boolean firstPiecePriority = COConfigurationManager.getBooleanParameter("Prioritize First Piece", false);
    protected static volatile boolean completionPriority = COConfigurationManager.getBooleanParameter("Prioritize Most Completed Files", false);
    protected static volatile long paramPriorityChange = Long.MIN_VALUE;
    private final DiskManager diskManager;
    private final PEPeerControl peerControl;
    private final PiecePriorityShaper priorityShaper = null;
    private final DiskManagerListenerImpl diskManagerListener;
    protected final Map peerListeners;
    private final PEPeerManagerListener peerManagerListener;
    protected final int nbPieces;
    protected final DiskManagerPiece[] dmPieces;
    protected final AEMonitor availabilityMon = new AEMonitor("PiecePicker:avail");
    private final AEMonitor endGameModeChunks_mon = new AEMonitor("PiecePicker:EGM");
    protected volatile int nbPiecesDone;
    protected volatile int[] availabilityAsynch;
    protected volatile long availabilityDrift;
    protected volatile int[] availability;
    private long time_last_avail;
    protected volatile long availabilityChange;
    private volatile long availabilityComputeChange;
    private long time_last_rebuild;
    private float globalAvail;
    private float globalAvgAvail;
    private int nbRarestActive;
    private int globalMin;
    private volatile int globalMinOthers;
    protected volatile long filePriorityChange;
    private volatile long priorityParamChange;
    private volatile long priorityFileChange;
    private volatile long priorityAvailChange;
    private long timeLastPriorities;
    private long[] startPriorities;
    protected volatile boolean hasNeededUndonePiece;
    protected volatile long neededUndonePieceChange;
    private volatile boolean endGameMode;
    private volatile boolean endGameModeAbandoned;
    private volatile long timeEndGameModeEntered;
    private List endGameModeChunks;
    private static final int FORCE_PIECE = -1;

    public PiecePickerImpl(PEPeerControl pc) {
        this.peerControl = pc;
        this.diskManager = this.peerControl.getDiskManager();
        this.dmPieces = this.diskManager.getPieces();
        this.nbPieces = this.diskManager.getNbPieces();
        this.nbPiecesDone = 0;
        this.availability = new int[this.nbPieces];
        this.hasNeededUndonePiece = false;
        this.neededUndonePieceChange = Long.MIN_VALUE;
        this.time_last_avail = Long.MIN_VALUE;
        this.availabilityChange = -9223372036854775807L;
        this.availabilityComputeChange = Long.MIN_VALUE;
        this.availabilityDrift = this.nbPieces;
        for (int i = 0; i < this.nbPieces; ++i) {
            if (this.dmPieces[i].isDone()) {
                int n = i;
                this.availability[n] = this.availability[n] + 1;
                ++this.nbPiecesDone;
                continue;
            }
            this.hasNeededUndonePiece |= this.dmPieces[i].calcNeeded();
        }
        if (this.hasNeededUndonePiece) {
            ++this.neededUndonePieceChange;
        }
        this.updateAvailability();
        this.peerListeners = new HashMap();
        this.peerManagerListener = new PEPeerManagerListenerImpl();
        this.peerControl.addListener(this.peerManagerListener);
        this.filePriorityChange = Long.MIN_VALUE;
        this.priorityParamChange = Long.MIN_VALUE;
        this.priorityFileChange = Long.MIN_VALUE;
        this.priorityAvailChange = Long.MIN_VALUE;
        this.timeLastPriorities = Long.MIN_VALUE;
        this.endGameMode = false;
        this.endGameModeAbandoned = false;
        this.timeEndGameModeEntered = 0L;
        this.diskManagerListener = new DiskManagerListenerImpl();
        this.diskManager.addListener(this.diskManagerListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHavePiece(int pieceNumber) {
        try {
            this.availabilityMon.enter();
            if (this.availabilityAsynch == null) {
                this.availabilityAsynch = (int[])this.availability.clone();
            }
            int n = pieceNumber;
            this.availabilityAsynch[n] = this.availabilityAsynch[n] + 1;
            ++this.availabilityChange;
        }
        finally {
            this.availabilityMon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAvailability() {
        int i;
        long now = SystemTime.getCurrentTime();
        if (now >= this.time_last_avail && now < this.time_last_avail + 974L) {
            return;
        }
        if (this.availabilityDrift > 0L || now < this.time_last_rebuild || now - this.time_last_rebuild > 120000L) {
            try {
                this.availabilityMon.enter();
                this.time_last_rebuild = now;
                int[] new_availability = this.recomputeAvailability();
                this.availabilityAsynch = new_availability;
                this.availabilityDrift = 0L;
                ++this.availabilityChange;
            }
            finally {
                this.availabilityMon.exit();
            }
        } else if (this.availabilityComputeChange >= this.availabilityChange) {
            return;
        }
        try {
            this.availabilityMon.enter();
            this.time_last_avail = now;
            this.availabilityComputeChange = this.availabilityChange;
            if (this.availabilityAsynch != null) {
                this.availability = this.availabilityAsynch;
                this.availabilityAsynch = null;
            }
        }
        finally {
            this.availabilityMon.exit();
        }
        int allMin = Integer.MAX_VALUE;
        int rarestMin = Integer.MAX_VALUE;
        for (i = 0; i < this.nbPieces; ++i) {
            int avail = this.availability[i];
            DiskManagerPiece dmPiece = this.dmPieces[i];
            if (avail > 0 && avail < rarestMin && dmPiece.isRequestable()) {
                rarestMin = avail;
            }
            if (avail >= allMin) continue;
            allMin = avail;
        }
        this.globalMin = allMin;
        this.globalMinOthers = rarestMin;
        int total = 0;
        int rarestActive = 0;
        long totalAvail = 0L;
        for (i = 0; i < this.nbPieces; ++i) {
            int avail = this.availability[i];
            DiskManagerPiece dmPiece = this.dmPieces[i];
            if (avail <= 0) continue;
            if (avail > allMin) {
                ++total;
            }
            if (avail <= rarestMin && dmPiece.isRequestable() && this.peerControl.getPiece(i) != null) {
                ++rarestActive;
            }
            totalAvail += (long)avail;
        }
        this.globalAvail = (float)total / (float)this.nbPieces + (float)allMin;
        this.nbRarestActive = rarestActive;
        this.globalAvgAvail = (float)totalAvail / (float)this.nbPieces / (float)(1 + this.peerControl.getNbSeeds() + this.peerControl.getNbPeers());
    }

    private int[] recomputeAvailability() {
        int j;
        if (this.availabilityDrift > 0L && this.availabilityDrift != (long)this.nbPieces && Logger.isEnabled()) {
            Logger.log(new LogEvent((Object)this.diskManager.getTorrent(), LOGID, 0, "Recomputing availabiliy. Drift=" + this.availabilityDrift + ":" + this.peerControl.getDisplayName()));
        }
        List peerTransports = this.peerControl.getPeers();
        int[] newAvailability = new int[this.nbPieces];
        for (j = 0; j < this.nbPieces; ++j) {
            newAvailability[j] = this.dmPieces[j].isDone() ? 1 : 0;
        }
        for (int i = 0; i < peerTransports.size(); ++i) {
            BitFlags peerHavePieces;
            PEPeerTransport pt = (PEPeerTransport)peerTransports.get(i);
            if (pt == null || pt.getPeerState() != 30 || (peerHavePieces = pt.getAvailable()) == null || peerHavePieces.nbSet <= 0) continue;
            for (j = peerHavePieces.start; j <= peerHavePieces.end; ++j) {
                if (!peerHavePieces.flags[j]) continue;
                int n = j;
                newAvailability[n] = newAvailability[n] + 1;
            }
        }
        return newAvailability;
    }

    public int[] getAvailability() {
        return this.availability;
    }

    public int getAvailability(int pieceNumber) {
        return this.availability[pieceNumber];
    }

    public float getMinAvailability() {
        return this.globalAvail;
    }

    public float getAvgAvail() {
        return this.globalAvgAvail;
    }

    protected void checkDownloadablePiece() {
        for (int i = 0; i < this.nbPieces; ++i) {
            if (!this.dmPieces[i].isInteresting()) continue;
            if (!this.hasNeededUndonePiece) {
                this.hasNeededUndonePiece = true;
                ++this.neededUndonePieceChange;
            }
            return;
        }
        if (this.hasNeededUndonePiece) {
            this.hasNeededUndonePiece = false;
            ++this.neededUndonePieceChange;
        }
    }

    public boolean checkDownloadPossible() {
        PEPeerTransport pt;
        int i;
        if (!this.hasNeededUndonePiece) {
            return false;
        }
        ArrayList bestUploaders = new ArrayList();
        List peer_transports = this.peerControl.getPeers();
        long[] upRates = new long[peer_transports.size()];
        Arrays.fill(upRates, -1L);
        for (i = 0; i < peer_transports.size(); ++i) {
            pt = (PEPeerTransport)peer_transports.get(i);
            if (pt.getPeerState() >= 40) continue;
            long upRate = pt.getStats().getSmoothDataReceiveRate();
            UnchokerUtil.updateLargestValueFirstSort(upRate, upRates, pt, bestUploaders, 0);
        }
        this.checkEndGameMode();
        this.computeBasePriorities();
        for (i = 0; i < bestUploaders.size(); ++i) {
            pt = (PEPeerTransport)bestUploaders.get(i);
            if (!pt.isDownloadPossible()) continue;
            int found = 0;
            int maxRequests = 2 + (int)(pt.getStats().getDataReceiveRate() / 4096L);
            if (maxRequests > 256 || maxRequests < 0) {
                maxRequests = 256;
            }
            if (this.endGameMode) {
                maxRequests = 2;
            }
            if (pt.isSnubbed()) {
                maxRequests = 1;
            }
            if (pt.getNbRequests() > maxRequests * 3 / 5) continue;
            while (pt.isDownloadPossible() && pt.getNbRequests() < maxRequests && (found = !this.endGameMode ? this.findPieceToDownload(pt, maxRequests) : this.findPieceInEndGameMode(pt, maxRequests)) > 0) {
            }
        }
        return true;
    }

    private void computeBasePriorities() {
        long now = SystemTime.getCurrentTime();
        if (this.startPriorities != null && (now > this.timeLastPriorities && now < this.time_last_avail + 999L || this.priorityParamChange >= paramPriorityChange && this.priorityFileChange >= this.filePriorityChange && this.priorityAvailChange >= this.availabilityChange)) {
            return;
        }
        this.priorityParamChange = paramPriorityChange;
        this.priorityFileChange = this.filePriorityChange;
        this.priorityAvailChange = this.availabilityChange;
        this.timeLastPriorities = now;
        boolean changedPriority = false;
        boolean foundPieceToDownload = false;
        long[] newPriorities = new long[this.nbPieces];
        try {
            boolean rarestOverride = this.getRarestOverride();
            for (int i = 0; i < this.nbPieces; ++i) {
                int avail = this.availability[i];
                DiskManagerPiece dmPiece = this.dmPieces[i];
                if (dmPiece.isDone()) continue;
                long startPriority = Long.MIN_VALUE;
                long priority = Long.MIN_VALUE;
                DMPieceList pieceList = this.diskManager.getPieceList(dmPiece.getPieceNumber());
                for (int j = 0; j < pieceList.size(); ++j) {
                    DiskManagerFileInfoImpl fileInfo2 = pieceList.get(j).getFile();
                    long length = fileInfo2.getLength();
                    long downloaded = fileInfo2.getDownloaded();
                    if (length <= 0L || downloaded >= length || fileInfo2.isSkipped()) continue;
                    priority = 0L;
                    if (firstPiecePriority && (long)fileInfo2.getNbPieces() > 4L && (i == fileInfo2.getFirstPieceNumber() || i == fileInfo2.getLastPieceNumber())) {
                        priority += 1200L;
                    }
                    if (fileInfo2.isPriority()) {
                        long percent;
                        priority += 1100L;
                        if (completionPriority && (percent = 1000L * downloaded / length) >= 900L) {
                            priority += 1000L * downloaded / this.diskManager.getTotalLength();
                        }
                    }
                    if (priority <= startPriority) continue;
                    startPriority = priority;
                }
                if (startPriority >= 0L) {
                    dmPiece.setNeeded();
                    foundPieceToDownload = true;
                } else {
                    dmPiece.clearNeeded();
                }
                newPriorities[i] = startPriority;
                changedPriority = true;
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        if (foundPieceToDownload) {
            if (!this.hasNeededUndonePiece) {
                this.hasNeededUndonePiece = true;
                ++this.neededUndonePieceChange;
            }
        } else if (this.hasNeededUndonePiece) {
            this.hasNeededUndonePiece = false;
            ++this.neededUndonePieceChange;
        }
        if (changedPriority) {
            this.startPriorities = newPriorities;
        }
    }

    private boolean getRarestOverride() {
        boolean rarestOverride;
        int nbSeeds = this.peerControl.getNbSeeds();
        int nbPeers = this.peerControl.getNbPeers();
        boolean bl = rarestOverride = this.nbPiecesDone < 4 || this.endGameMode || this.nbRarestActive >= nbSeeds + nbPeers;
        if (!rarestOverride && this.nbRarestActive > 1 && this.globalMinOthers > 1) {
            rarestOverride = this.globalMinOthers > this.globalMin || this.globalMinOthers >= 2 * nbSeeds && 2 * this.globalMinOthers >= nbPeers;
        }
        return rarestOverride;
    }

    protected int findPieceToDownload(PEPeerTransport pt, int nbWanted) {
        int pieceNumber = this.getRequestCandidate(pt);
        if (pieceNumber < 0) {
            return 0;
        }
        int peerSpeed = (int)pt.getStats().getDataReceiveRate() / 1000;
        PEPeerControl pc = pt.getControl();
        PEPiece pePiece = pc.getPiece(pieceNumber);
        if (pePiece == null) {
            pePiece = new PEPieceImpl(pt.getManager(), this.dmPieces[pieceNumber], peerSpeed >> 1);
            pc.addPiece(pePiece, pieceNumber);
            if (this.startPriorities != null) {
                pePiece.setResumePriority(this.startPriorities[pieceNumber]);
            }
            if (this.availability[pieceNumber] <= this.globalMinOthers) {
                ++this.nbRarestActive;
            }
        }
        int[] blocksFound = pePiece.getAndMarkBlocks(pt, nbWanted);
        int blockNumber = blocksFound[0];
        int nbBlocks = blocksFound[1];
        if (nbBlocks <= 0) {
            return 0;
        }
        int requested = 0;
        for (int i = 0; i < nbBlocks; ++i) {
            int thisBlock = blockNumber + i;
            if (!pt.request(pieceNumber, thisBlock * 16384, pePiece.getBlockSize(thisBlock))) continue;
            ++requested;
            pt.setLastPiece(pieceNumber);
            if (peerSpeed <= pePiece.getSpeed()) continue;
            pePiece.incSpeed();
        }
        return requested;
    }

    private int getRequestCandidate(PEPeerTransport pt) {
        if (pt == null || pt.getPeerState() != 30) {
            return -1;
        }
        BitFlags peerHavePieces = pt.getAvailable();
        if (peerHavePieces == null || peerHavePieces.nbSet <= 0) {
            return -1;
        }
        int pieceNumber = pt.getReservedPieceNumber();
        if (pieceNumber >= 0) {
            DiskManagerPiece dmPiece = this.dmPieces[pieceNumber];
            if (peerHavePieces.flags[pieceNumber] && dmPiece.isRequestable()) {
                return pieceNumber;
            }
            return -1;
        }
        int peerSpeed = (int)pt.getStats().getDataReceiveRate() / 1000;
        int lastPiece = pt.getLastPiece();
        boolean rarestOverride = this.getRarestOverride();
        long resumeMinAvail = Long.MAX_VALUE;
        long resumeMaxPriority = Long.MIN_VALUE;
        boolean resumeIsRarest = false;
        BitFlags startCandidates = null;
        long startMaxPriority = Long.MIN_VALUE;
        int startMinAvail = Integer.MAX_VALUE;
        boolean startIsRarest = false;
        int avail = 0;
        int startI = peerHavePieces.start;
        int endI = peerHavePieces.end;
        long now = SystemTime.getCurrentTime();
        for (int i = startI; i <= endI; ++i) {
            PEPiece pePiece;
            long priority;
            DiskManagerPiece dmPiece;
            if (!peerHavePieces.flags[i] || !(dmPiece = this.dmPieces[i]).isRequestable() || (priority = this.startPriorities[i]) < 0L) continue;
            avail = this.availability[i];
            if (avail == 0) {
                this.availability[i] = 1;
                avail = 1;
            }
            if ((pePiece = this.peerControl.getPiece(i)) != null) {
                int freeReqs = pePiece.getNbUnrequested();
                if (freeReqs <= 0) {
                    dmPiece.setRequested();
                    continue;
                }
                String peerReserved = pePiece.getReservedBy();
                if (peerReserved != null) {
                    if (!peerReserved.equals(pt.getIp())) continue;
                    pt.setReservedPieceNumber(i);
                    return i;
                }
                int pieceSpeed = pePiece.getSpeed();
                if (pieceSpeed > 0 && i != lastPiece && (peerSpeed < pieceSpeed || pt.isSnubbed()) && avail > 1 && (freeReqs < 3 || pieceSpeed - 1 >= freeReqs * peerSpeed) || (long)avail > resumeMinAvail) continue;
                priority += (long)pieceSpeed;
                priority += i == lastPiece ? 500L : 0L;
                priority += pePiece.getTimeSinceLastActivity() / 120000L;
                long pieceAge = now - pePiece.getCreationTime();
                if (pieceAge > 0L) {
                    priority += 1000L * pieceAge / (60000L * (long)dmPiece.getNbBlocks());
                }
                pePiece.setResumePriority(priority += 900L * (long)dmPiece.getNbWritten() / (long)dmPiece.getNbBlocks());
                if (((long)avail >= resumeMinAvail || rarestOverride && priority < resumeMaxPriority) && (priority <= resumeMaxPriority || resumeIsRarest && !rarestOverride) || !pePiece.hasUnrequestedBlock()) continue;
                pieceNumber = i;
                resumeMinAvail = avail;
                resumeMaxPriority = priority;
                resumeIsRarest = avail <= this.globalMinOthers;
                continue;
            }
            if (avail <= this.globalMinOthers && !rarestOverride) {
                if (!startIsRarest) {
                    if (startCandidates == null) {
                        startCandidates = new BitFlags(this.nbPieces);
                    }
                    startMaxPriority = priority;
                    startMinAvail = avail;
                    startIsRarest = avail <= this.globalMinOthers;
                    startCandidates.setOnly(i);
                    continue;
                }
                if (priority > startMaxPriority) {
                    if (startCandidates == null) {
                        startCandidates = new BitFlags(this.nbPieces);
                    }
                    startMaxPriority = priority;
                    startCandidates.setOnly(i);
                    continue;
                }
                if (priority != startMaxPriority) continue;
                startCandidates.setEnd(i);
                continue;
            }
            if (startIsRarest && !rarestOverride) continue;
            if (priority > startMaxPriority) {
                if (startCandidates == null) {
                    startCandidates = new BitFlags(this.nbPieces);
                }
                startMaxPriority = priority;
                startMinAvail = avail;
                startIsRarest = avail <= this.globalMinOthers;
                startCandidates.setOnly(i);
                continue;
            }
            if (priority != startMaxPriority) continue;
            if (avail < startMinAvail) {
                startMinAvail = avail;
                startIsRarest = avail <= this.globalMinOthers;
                startCandidates.setOnly(i);
                continue;
            }
            if (avail != startMinAvail) continue;
            startCandidates.setEnd(i);
        }
        if (pieceNumber < 0 && (startCandidates == null || startCandidates.nbSet < 1)) {
            return -1;
        }
        boolean resumeIsBetter = false;
        if (pieceNumber >= 0) {
            boolean bl = resumeIsBetter = startCandidates == null || startCandidates.nbSet < 1 || resumeIsRarest || !startIsRarest || rarestOverride || resumeMaxPriority / resumeMinAvail > startMaxPriority / (long)this.globalMinOthers;
            if (resumeIsBetter) {
                return pieceNumber;
            }
        }
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(pt, LOGID, "Starting Piece. resume piece #= " + pieceNumber + " globalMinOthers=" + this.globalMinOthers + " startMaxPriority=" + startMaxPriority + " startMinAvail=" + startMinAvail + " startIsRarest=" + startIsRarest + (pieceNumber > 0 ? " resumeMaxPriority=" + resumeMaxPriority + " resumeMinAvail=" + resumeMinAvail + " resumeIsRarest=" + resumeIsRarest : "") + "  " + this.peerControl.getDisplayName()));
        }
        return this.getPieceToStart(pt, startCandidates);
    }

    protected int getPieceToStart(PEPeerTransport pt, BitFlags startCandidates) {
        int direction;
        int startI;
        if (startCandidates == null || startCandidates.nbSet <= 0) {
            return -1;
        }
        if (startCandidates.nbSet == 1) {
            startI = startCandidates.start;
            direction = 1;
        } else {
            startI = RandomUtils.generateRandomIntBetween(startCandidates.start, startCandidates.end);
            direction = RandomUtils.generateRandomPlusMinus1();
        }
        PEPiece[] pePieces = pt.getControl().getPieces();
        for (int i = startI; i >= startCandidates.start && i <= startCandidates.end; i += direction) {
            if (pePieces[i] != null || !startCandidates.flags[i]) continue;
            return i;
        }
        return -1;
    }

    public boolean hasDownloadablePiece() {
        return this.hasNeededUndonePiece;
    }

    public long getNeededUndonePieceChange() {
        return this.neededUndonePieceChange;
    }

    private void checkEndGameMode() {
        if (this.peerControl.getNbSeeds() + this.peerControl.getNbPeers() < 3) {
            return;
        }
        long now = SystemTime.getCurrentTime();
        if (this.endGameMode || this.endGameModeAbandoned) {
            if (!this.endGameModeAbandoned && now - this.timeEndGameModeEntered > 76800L) {
                this.endGameModeAbandoned = true;
                this.clearEndGameChunks();
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(this.diskManager.getTorrent(), LOGID, "Abandoning end-game mode: " + this.peerControl.getDisplayName()));
                }
            }
            return;
        }
        int active_pieces = 0;
        for (int i = 0; i < this.nbPieces; ++i) {
            DiskManagerPiece dmPiece = this.dmPieces[i];
            if (dmPiece.isEGMIgnored()) continue;
            if (dmPiece.isEGMActive()) {
                ++active_pieces;
                continue;
            }
            return;
        }
        if ((long)(active_pieces * this.diskManager.getPieceLength()) <= 0x1400000L) {
            this.timeEndGameModeEntered = now;
            this.endGameMode = true;
            this.computeEndGameModeChunks();
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(this.diskManager.getTorrent(), LOGID, "Entering end-game mode: " + this.peerControl.getDisplayName()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeEndGameModeChunks() {
        PEPiece[] _pieces = this.peerControl.getPieces();
        if (_pieces == null) {
            return;
        }
        this.endGameModeChunks = new ArrayList();
        try {
            this.endGameModeChunks_mon.enter();
            for (int i = 0; i < this.nbPieces; ++i) {
                int j;
                PEPiece pePiece;
                DiskManagerPiece dmPiece = this.dmPieces[i];
                if (!dmPiece.isInteresting() || (pePiece = _pieces[i]) == null) continue;
                boolean[] written = dmPiece.getWritten();
                if (written == null) {
                    if (dmPiece.isDone()) continue;
                    for (j = 0; j < pePiece.getNbBlocks(); ++j) {
                        this.endGameModeChunks.add(new EndGameModeChunk(pePiece, j));
                    }
                    continue;
                }
                for (j = 0; j < written.length; ++j) {
                    if (written[j]) continue;
                    this.endGameModeChunks.add(new EndGameModeChunk(pePiece, j));
                }
            }
        }
        finally {
            this.endGameModeChunks_mon.exit();
        }
    }

    public boolean isInEndGameMode() {
        return this.endGameMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEndGameChunks(PEPiece pePiece) {
        if (!this.endGameMode) {
            return;
        }
        try {
            this.endGameModeChunks_mon.enter();
            int nbChunks = pePiece.getNbBlocks();
            for (int i = 0; i < nbChunks; ++i) {
                this.endGameModeChunks.add(new EndGameModeChunk(pePiece, i));
            }
        }
        finally {
            this.endGameModeChunks_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEndGameBlocks(PEPiece pePiece) {
        if (!this.endGameMode || pePiece == null) {
            return;
        }
        DiskManagerPiece dmPiece = pePiece.getDMPiece();
        int nbChunks = pePiece.getNbBlocks();
        try {
            this.endGameModeChunks_mon.enter();
            for (int i = 0; i < nbChunks; ++i) {
                if (pePiece.isDownloaded(i) || dmPiece.isWritten(i)) continue;
                this.endGameModeChunks.add(new EndGameModeChunk(pePiece, i));
            }
        }
        finally {
            this.endGameModeChunks_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int findPieceInEndGameMode(PEPeerTransport pt, int wants) {
        if (pt == null || wants <= 0 || pt.getPeerState() != 30) {
            return 0;
        }
        try {
            this.endGameModeChunks_mon.enter();
            int nbChunks = this.endGameModeChunks.size();
            if (nbChunks > 0) {
                int random = RandomUtils.generateRandomIntUpto(nbChunks);
                EndGameModeChunk chunk = (EndGameModeChunk)this.endGameModeChunks.get(random);
                int pieceNumber = chunk.getPieceNumber();
                if (this.dmPieces[pieceNumber].isWritten(chunk.getBlockNumber())) {
                    this.endGameModeChunks.remove(chunk);
                    int n = 0;
                    return n;
                }
                if (pt.isPieceAvailable(pieceNumber)) {
                    PEPiece pePiece = this.peerControl.getPiece(pieceNumber);
                    if (pePiece != null && pt.request(pieceNumber, chunk.getOffset(), chunk.getLength())) {
                        pePiece.setRequested(pt, chunk.getBlockNumber());
                        pt.setLastPiece(pieceNumber);
                        int n = 1;
                        return n;
                    }
                    int n = 0;
                    return n;
                }
            }
        }
        finally {
            this.endGameModeChunks_mon.exit();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromEndGameModeChunks(int pieceNumber, int offset) {
        try {
            this.endGameModeChunks_mon.enter();
            Iterator iter = this.endGameModeChunks.iterator();
            while (iter.hasNext()) {
                EndGameModeChunk chunk = (EndGameModeChunk)iter.next();
                if (!chunk.equals(pieceNumber, offset)) continue;
                iter.remove();
            }
        }
        finally {
            this.endGameModeChunks_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearEndGameChunks() {
        if (!this.endGameMode) {
            return;
        }
        try {
            this.endGameModeChunks_mon.enter();
            this.endGameModeChunks.clear();
            this.endGameMode = false;
        }
        finally {
            this.endGameModeChunks_mon.exit();
        }
    }

    static {
        class ParameterListenerImpl
        implements ParameterListener {
            ParameterListenerImpl() {
            }

            public void parameterChanged(String parameterName) {
                if (parameterName.equals("Prioritize Most Completed Files")) {
                    completionPriority = COConfigurationManager.getBooleanParameter(parameterName, false);
                    ++paramPriorityChange;
                } else if (parameterName.equals("Prioritize First Piece")) {
                    firstPiecePriority = COConfigurationManager.getBooleanParameter(parameterName, false);
                    ++paramPriorityChange;
                }
            }
        }
        ParameterListenerImpl parameterListener = new ParameterListenerImpl();
        COConfigurationManager.addParameterListener("Prioritize Most Completed Files", parameterListener);
        COConfigurationManager.addAndFireParameterListener("Prioritize First Piece", parameterListener);
    }

    private class DiskManagerListenerImpl
    implements DiskManagerListener {
        private DiskManagerListenerImpl() {
        }

        public void stateChanged(int oldState, int newState) {
        }

        public void filePriorityChanged(DiskManagerFileInfo file) {
            int endI;
            int startI;
            ++PiecePickerImpl.this.filePriorityChange;
            boolean foundPieceToDownload = false;
            if (PiecePickerImpl.this.hasNeededUndonePiece) {
                startI = 0;
                endI = PiecePickerImpl.this.nbPieces;
            } else {
                startI = file.getFirstPieceNumber();
                endI = file.getLastPieceNumber() + 1;
            }
            for (int i = startI; i < endI; ++i) {
                DiskManagerPiece dmPiece = PiecePickerImpl.this.dmPieces[i];
                if (dmPiece.isDone()) continue;
                foundPieceToDownload |= dmPiece.calcNeeded();
            }
            if (foundPieceToDownload) {
                if (!PiecePickerImpl.this.hasNeededUndonePiece) {
                    PiecePickerImpl.this.hasNeededUndonePiece = true;
                    ++PiecePickerImpl.this.neededUndonePieceChange;
                }
            } else if (PiecePickerImpl.this.hasNeededUndonePiece) {
                PiecePickerImpl.this.hasNeededUndonePiece = false;
                ++PiecePickerImpl.this.neededUndonePieceChange;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void pieceDoneChanged(DiskManagerPiece dmPiece) {
            int pieceNumber = dmPiece.getPieceNumber();
            if (dmPiece.isDone()) {
                PiecePickerImpl.this.addHavePiece(pieceNumber);
                ++PiecePickerImpl.this.nbPiecesDone;
                if (PiecePickerImpl.this.nbPiecesDone >= PiecePickerImpl.this.nbPieces) {
                    PiecePickerImpl.this.checkDownloadablePiece();
                }
            } else {
                try {
                    PiecePickerImpl.this.availabilityMon.enter();
                    if (PiecePickerImpl.this.availabilityAsynch == null) {
                        PiecePickerImpl.this.availabilityAsynch = (int[])PiecePickerImpl.this.availability.clone();
                    }
                    if (PiecePickerImpl.this.availabilityAsynch[pieceNumber] > 0) {
                        int n = pieceNumber;
                        PiecePickerImpl.this.availabilityAsynch[n] = PiecePickerImpl.this.availabilityAsynch[n] - 1;
                    } else {
                        ++PiecePickerImpl.this.availabilityDrift;
                    }
                    ++PiecePickerImpl.this.availabilityChange;
                }
                finally {
                    PiecePickerImpl.this.availabilityMon.exit();
                }
                --PiecePickerImpl.this.nbPiecesDone;
                if (dmPiece.calcNeeded() && !PiecePickerImpl.this.hasNeededUndonePiece) {
                    PiecePickerImpl.this.hasNeededUndonePiece = true;
                    ++PiecePickerImpl.this.neededUndonePieceChange;
                }
            }
        }

        public void fileAccessModeChanged(DiskManagerFileInfo file, int old_mode, int new_mode) {
        }
    }

    private class PEPeerListenerImpl
    implements PEPeerListener {
        private PEPeerListenerImpl() {
        }

        public void stateChanged(PEPeer peer, int newState) {
        }

        public void sentBadChunk(PEPeer peer, int piece_num, int total_bad_chunks) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addAvailability(PEPeer peer, BitFlags peerHavePieces) {
            if (peerHavePieces == null || peerHavePieces.nbSet <= 0) {
                return;
            }
            try {
                PiecePickerImpl.this.availabilityMon.enter();
                if (PiecePickerImpl.this.availabilityAsynch == null) {
                    PiecePickerImpl.this.availabilityAsynch = (int[])PiecePickerImpl.this.availability.clone();
                }
                for (int i = peerHavePieces.start; i <= peerHavePieces.end; ++i) {
                    if (!peerHavePieces.flags[i]) continue;
                    int n = i;
                    PiecePickerImpl.this.availabilityAsynch[n] = PiecePickerImpl.this.availabilityAsynch[n] + 1;
                }
                ++PiecePickerImpl.this.availabilityChange;
            }
            finally {
                PiecePickerImpl.this.availabilityMon.exit();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeAvailability(PEPeer peer, BitFlags peerHavePieces) {
            if (peerHavePieces == null || peerHavePieces.nbSet <= 0) {
                return;
            }
            try {
                PiecePickerImpl.this.availabilityMon.enter();
                if (PiecePickerImpl.this.availabilityAsynch == null) {
                    PiecePickerImpl.this.availabilityAsynch = (int[])PiecePickerImpl.this.availability.clone();
                }
                for (int i = peerHavePieces.start; i <= peerHavePieces.end; ++i) {
                    if (!peerHavePieces.flags[i]) continue;
                    if (PiecePickerImpl.this.availabilityAsynch[i] > (PiecePickerImpl.this.dmPieces[i].isDone() ? 1 : 0)) {
                        int n = i;
                        PiecePickerImpl.this.availabilityAsynch[n] = PiecePickerImpl.this.availabilityAsynch[n] - 1;
                        continue;
                    }
                    ++PiecePickerImpl.this.availabilityDrift;
                }
                ++PiecePickerImpl.this.availabilityChange;
            }
            finally {
                PiecePickerImpl.this.availabilityMon.exit();
            }
        }
    }

    private class PEPeerManagerListenerImpl
    implements PEPeerManagerListener {
        private PEPeerManagerListenerImpl() {
        }

        public void peerAdded(PEPeerManager manager, PEPeer peer) {
            PEPeerListenerImpl peerListener = (PEPeerListenerImpl)PiecePickerImpl.this.peerListeners.get(peer);
            if (peerListener == null) {
                peerListener = new PEPeerListenerImpl();
                PiecePickerImpl.this.peerListeners.put(peer, peerListener);
            }
            peer.addListener(peerListener);
        }

        public void peerRemoved(PEPeerManager manager, PEPeer peer) {
            PEPeerListenerImpl peerListener = (PEPeerListenerImpl)PiecePickerImpl.this.peerListeners.remove(peer);
            peer.removeListener(peerListener);
        }
    }
}

