/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.piecepicker.util;

import java.util.Arrays;

public class BitFlags {
    public int nbSet;
    public int start;
    public int end;
    public final int length;
    public boolean[] flags;

    public BitFlags(int count) {
        this.length = count;
        this.flags = new boolean[this.length];
        this.start = 0;
        this.end = 0;
        this.nbSet = 0;
    }

    public BitFlags(boolean[] _flags) {
        this.flags = _flags;
        this.length = this.flags.length;
        for (int i = 0; i < this.length; ++i) {
            if (!this.flags[i]) continue;
            ++this.nbSet;
            if (i < this.start) {
                this.start = i;
            }
            this.end = i;
        }
    }

    public void clear() {
        Arrays.fill(this.flags, false);
        this.start = 0;
        this.end = 0;
        this.nbSet = 0;
    }

    public void setStart(int i) {
        this.flags[i] = true;
        ++this.nbSet;
        this.start = i;
    }

    public void set(int i) {
        if (!this.flags[i]) {
            this.flags[i] = true;
            ++this.nbSet;
            if (this.start > i) {
                this.start = i;
            }
            if (this.end < i) {
                this.end = i;
            }
        }
    }

    public void setEnd(int i) {
        this.flags[i] = true;
        ++this.nbSet;
        this.end = i;
    }

    public void setOnly(int i) {
        Arrays.fill(this.flags, this.start, this.end, false);
        this.nbSet = 1;
        this.start = i;
        this.end = i;
        this.flags[i] = true;
    }

    public void setAll() {
        this.start = 0;
        this.end = this.length - 1;
        Arrays.fill(this.flags, this.start, this.end, true);
        this.nbSet = this.length;
    }

    public BitFlags andUnion(BitFlags other) {
        if (other == null) {
            return null;
        }
        int resultSize = Math.max(this.length, other.length);
        BitFlags result = new BitFlags(resultSize);
        if (this.nbSet > 0 && other.nbSet > 0) {
            int i;
            int startI = Math.max(this.start, other.start);
            int endI = Math.min(this.end, other.end);
            for (i = startI; i <= endI; ++i) {
                if (!this.flags[i] || !other.flags[i]) continue;
                result.set(i);
                break;
            }
            while (i <= endI) {
                if (this.flags[i] && other.flags[i]) {
                    result.setEnd(i);
                }
                ++i;
            }
        }
        return result;
    }
}

