/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.unchoker;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.gudy.azureus2.core3.peer.PEPeer;

public class UnchokerUtil {
    private static final Random random = new Random();

    public static boolean isUnchokable(PEPeer peer, boolean allow_snubbed) {
        return peer.getPeerState() == 30 && !peer.isSeed() && peer.isInterested() && (!peer.isSnubbed() || allow_snubbed);
    }

    public static void updateLargestValueFirstSort(long new_value, long[] values, PEPeer new_item, List items, int start_pos) {
        for (int i = start_pos; i < values.length; ++i) {
            if (new_value < values[i]) continue;
            for (int j = values.length - 2; j >= i; --j) {
                values[j + 1] = values[j];
            }
            values[i] = new_value;
            items.add(i, new_item);
            if (items.size() > values.length) {
                items.remove(values.length);
            }
            return;
        }
    }

    public static PEPeer getNextOptimisticPeer(ArrayList all_peers, boolean factor_reciprocated, boolean allow_snubbed) {
        PEPeer peer;
        int i;
        ArrayList<PEPeer> optimistics = new ArrayList<PEPeer>();
        for (i = 0; i < all_peers.size(); ++i) {
            peer = (PEPeer)all_peers.get(i);
            if (!UnchokerUtil.isUnchokable(peer, false) || !peer.isChokedByMe()) continue;
            optimistics.add(peer);
        }
        if (optimistics.isEmpty() && allow_snubbed) {
            for (i = 0; i < all_peers.size(); ++i) {
                peer = (PEPeer)all_peers.get(i);
                if (!UnchokerUtil.isUnchokable(peer, true) || !peer.isChokedByMe()) continue;
                optimistics.add(peer);
            }
        }
        if (optimistics.isEmpty()) {
            return null;
        }
        if (factor_reciprocated) {
            ArrayList ratioed_peers = new ArrayList(optimistics.size());
            long[] ratios = new long[optimistics.size()];
            Arrays.fill(ratios, Long.MIN_VALUE);
            for (int i2 = 0; i2 < optimistics.size(); ++i2) {
                PEPeer peer2 = (PEPeer)optimistics.get(i2);
                long score = peer2.getStats().getTotalDataBytesSent() - peer2.getStats().getTotalDataBytesReceived();
                UnchokerUtil.updateLargestValueFirstSort(score, ratios, peer2, ratioed_peers, 0);
            }
            double factor = 1.0 / (0.8 + 0.2 * Math.pow(random.nextFloat(), -1.0));
            int pos = (int)(factor * (double)ratioed_peers.size());
            return (PEPeer)ratioed_peers.get(pos);
        }
        int rand_pos = new Random().nextInt(optimistics.size());
        peer = (PEPeer)optimistics.get(rand_pos);
        return peer;
    }
}

