/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.utils;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;

public class BTPeerIDByteDecoder {
    static final boolean LOG_UNKNOWN;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected static String decode(byte[] peer_id) {
        int iFirstNonZeroPos;
        byte[] peerID;
        block99: {
            String decoded = null;
            peerID = new byte[peer_id.length];
            System.arraycopy(peer_id, 0, peerID, 0, peer_id.length);
            FileWriter log = null;
            File logFile = FileUtil.getUserFile("identification.log");
            iFirstNonZeroPos = 0;
            try {
                String upnp;
                String bitspirit;
                decoded = BTPeerIDByteDecoder.decodeAzStyle(peerID, "AZ", "Azureus");
                if (decoded != null) {
                    return decoded;
                }
                decoded = BTPeerIDByteDecoder.decodeAzStyle(peerID, "BC", "BitComet");
                if (decoded != null) {
                    return decoded;
                }
                decoded = BTPeerIDByteDecoder.decodeAzStyle(peerID, "LT", "libtorrent");
                if (decoded != null) {
                    return decoded;
                }
                decoded = BTPeerIDByteDecoder.decodeAzStyle(peerID, "lt", "libtorrent");
                if (decoded != null) {
                    return decoded;
                }
                decoded = BTPeerIDByteDecoder.decodeAzStyle(peerID, "TS", "TorrentStorm");
                if (decoded != null) {
                    return decoded;
                }
                decoded = BTPeerIDByteDecoder.decodeAzStyle(peerID, "MT", "MoonlightTorrent");
                if (decoded != null) {
                    return decoded;
                }
                decoded = BTPeerIDByteDecoder.decodeAzStyle(peerID, "XT", "XanTorrent");
                if (decoded != null) {
                    return decoded;
                }
                decoded = BTPeerIDByteDecoder.decodeAzStyle(peerID, "bk", "BitKitten (libtorrent)");
                if (decoded != null) {
                    return decoded;
                }
                decoded = BTPeerIDByteDecoder.decodeAzStyle(peerID, "CT", "CTorrent");
                if (decoded != null) {
                    return decoded;
                }
                decoded = BTPeerIDByteDecoder.decodeAzStyle(peerID, "SN", "ShareNET");
                if (decoded != null) {
                    return decoded;
                }
                decoded = BTPeerIDByteDecoder.decodeAzStyle(peerID, "BB", "BitBuddy");
                if (decoded != null) {
                    return decoded;
                }
                decoded = BTPeerIDByteDecoder.decodeAzStyle(peerID, "SS", "SwarmScope");
                if (decoded != null) {
                    return decoded;
                }
                decoded = BTPeerIDByteDecoder.decodeAzStyle(peerID, "BS", "BTSlave");
                if (decoded != null) {
                    return decoded;
                }
                decoded = BTPeerIDByteDecoder.decodeAzStyle(peerID, "BX", "BittorrentX");
                if (decoded != null) {
                    return decoded;
                }
                decoded = BTPeerIDByteDecoder.decodeAzStyle(peerID, "TN", "Torrent.NET");
                if (decoded != null) {
                    return decoded;
                }
                decoded = BTPeerIDByteDecoder.decodeAzStyle(peerID, "ZT", "ZipTorrent");
                if (decoded != null) {
                    return decoded;
                }
                decoded = BTPeerIDByteDecoder.decodeAzStyle(peerID, "SZ", "Shareaza");
                if (decoded != null) {
                    return decoded;
                }
                decoded = BTPeerIDByteDecoder.decodeAzStyle(peerID, "KT", "KTorrent");
                if (decoded != null) {
                    return decoded;
                }
                decoded = BTPeerIDByteDecoder.decodeAzStyle(peerID, "UT", "\u00b5Torrent");
                if (decoded != null) {
                    return decoded;
                }
                decoded = BTPeerIDByteDecoder.decodeAzStyle(peerID, "TR", "Transmission");
                if (decoded != null) {
                    return decoded;
                }
                decoded = BTPeerIDByteDecoder.decodeTornadoStyle(peerID, "T", "BitTornado");
                if (decoded != null) {
                    return decoded;
                }
                decoded = BTPeerIDByteDecoder.decodeTornadoStyle(peerID, "A", "ABC");
                if (decoded != null) {
                    return decoded;
                }
                decoded = BTPeerIDByteDecoder.decodeMainlineStyle(peerID, "M", "Mainline");
                if (decoded != null) {
                    return decoded;
                }
                decoded = BTPeerIDByteDecoder.decodeSimpleStyle(peerID, 0, "martini", "Martini Man");
                if (decoded != null) {
                    return decoded;
                }
                decoded = BTPeerIDByteDecoder.decodeSimpleStyle(peerID, 0, "oernu", "BTugaXP");
                if (decoded != null) {
                    return decoded;
                }
                decoded = BTPeerIDByteDecoder.decodeSimpleStyle(peerID, 0, "BTDWV-", "Deadman Walking");
                if (decoded != null) {
                    return decoded;
                }
                decoded = BTPeerIDByteDecoder.decodeSimpleStyle(peerID, 0, "PRC.P---", "BitTorrent Plus! II");
                if (decoded != null) {
                    return decoded;
                }
                decoded = BTPeerIDByteDecoder.decodeSimpleStyle(peerID, 0, "P87.P---", "BitTorrent Plus!");
                if (decoded != null) {
                    return decoded;
                }
                decoded = BTPeerIDByteDecoder.decodeSimpleStyle(peerID, 0, "S587Plus", "BitTorrent Plus!");
                if (decoded != null) {
                    return decoded;
                }
                decoded = BTPeerIDByteDecoder.decodeSimpleStyle(peerID, 5, "Azureus", "Azureus 2.0.3.2");
                if (decoded != null) {
                    return decoded;
                }
                decoded = BTPeerIDByteDecoder.decodeSimpleStyle(peerID, 0, "-G3", "G3 Torrent");
                if (decoded != null) {
                    return decoded;
                }
                decoded = BTPeerIDByteDecoder.decodeSimpleStyle(peerID, 0, "-AR", "Arctic Torrent");
                if (decoded != null) {
                    return decoded;
                }
                decoded = BTPeerIDByteDecoder.decodeSimpleStyle(peerID, 4, "btfans", "SimpleBT");
                if (decoded != null) {
                    return decoded;
                }
                decoded = BTPeerIDByteDecoder.decodeSimpleStyle(peerID, 0, "btuga", "BTugaXP");
                if (decoded != null) {
                    return decoded;
                }
                decoded = BTPeerIDByteDecoder.decodeSimpleStyle(peerID, 5, "BTuga", "BTugaXP");
                if (decoded != null) {
                    return decoded;
                }
                decoded = BTPeerIDByteDecoder.decodeSimpleStyle(peerID, 0, "DansClient", "XanTorrent");
                if (decoded != null) {
                    return decoded;
                }
                decoded = BTPeerIDByteDecoder.decodeSimpleStyle(peerID, 0, "Deadman Walking-", "Deadman");
                if (decoded != null) {
                    return decoded;
                }
                decoded = BTPeerIDByteDecoder.decodeSimpleStyle(peerID, 0, "346-", "TorrentTopia");
                if (decoded != null) {
                    return decoded;
                }
                decoded = BTPeerIDByteDecoder.decodeSimpleStyle(peerID, 0, "271-", "GreedBT 2.7.1");
                if (decoded != null) {
                    return decoded;
                }
                decoded = BTPeerIDByteDecoder.decodeSimpleStyle(peerID, 10, "BG", "BTGetit");
                if (decoded != null) {
                    return decoded;
                }
                decoded = BTPeerIDByteDecoder.decodeSimpleStyle(peerID, 0, "OP", "Opera");
                if (decoded != null) {
                    return decoded;
                }
                decoded = BTPeerIDByteDecoder.decodeSimpleStyle(peerID, 0, "a00---0", "Swarmy");
                if (decoded != null) {
                    return decoded;
                }
                decoded = BTPeerIDByteDecoder.decodeSimpleStyle(peerID, 0, "a02---0", "Swarmy");
                if (decoded != null) {
                    return decoded;
                }
                decoded = BTPeerIDByteDecoder.decodeSimpleStyle(peerID, 0, "T00---0", "Teeweety");
                if (decoded != null) {
                    return decoded;
                }
                String burst = new String(peerID, 0, 5, "ISO-8859-1");
                if (burst.equals("Mbrst")) {
                    String major = new String(peerID, 5, 1, "ISO-8859-1");
                    String minor = new String(peerID, 7, 1, "ISO-8859-1");
                    String sub = new String(peerID, 9, 1, "ISO-8859-1");
                    return "Burst! " + major + "." + minor + "." + sub;
                }
                String turbobt = new String(peerID, 0, 7, "ISO-8859-1");
                if (turbobt.equals("turbobt")) {
                    return "TurboBT " + new String(peerID, 7, 5, "ISO-8859-1");
                }
                String btpd = new String(peerID, 0, 4, "ISO-8859-1");
                if (btpd.equals("btpd")) {
                    return "BT Protocol Daemon " + new String(peerID, 5, 3, "ISO-8859-1");
                }
                String plus = new String(peerID, 0, 4, "ISO-8859-1");
                if (plus.equals("Plus")) {
                    String v1 = new String(peerID, 4, 1, "ISO-8859-1");
                    String v2 = new String(peerID, 5, 1, "ISO-8859-1");
                    String v3 = new String(peerID, 6, 1, "ISO-8859-1");
                    return "Plus! " + v1 + "." + v2 + "." + v3;
                }
                String xbt = new String(peerID, 0, 3, "ISO-8859-1");
                if (xbt.equals("XBT")) {
                    String v1 = new String(peerID, 3, 1, "ISO-8859-1");
                    String v2 = new String(peerID, 4, 1, "ISO-8859-1");
                    String v3 = new String(peerID, 5, 1, "ISO-8859-1");
                    return "XBT " + v1 + "." + v2 + "." + v3;
                }
                String bow = new String(peerID, 1, 3, "ISO-8859-1");
                if (bow.equals("BOW")) {
                    String version = new String(peerID, 4, 3, "ISO-8859-1");
                    return "BitsOnWheels " + version;
                }
                String exeem = new String(peerID, 0, 2, "ISO-8859-1");
                if (exeem.equals("eX")) {
                    String user = new String(peerID, 2, 18, "ISO-8859-1");
                    return "eXeem [" + user + "]";
                }
                String shadow = new String(peerID, 0, 1, "ISO-8859-1");
                if (shadow.equals("S")) {
                    try {
                        if (peerID[6] == 45 && peerID[7] == 45 && peerID[8] == 45) {
                            String name = "Shad0w ";
                            for (int i = 1; i < 3; ++i) {
                                String v = new String(peerID, i, 1, "ISO-8859-1");
                                name = name.concat(Integer.parseInt(v, 16) + ".");
                            }
                            String v = new String(peerID, 3, 1, "ISO-8859-1");
                            name = name.concat("" + Integer.parseInt(v, 16));
                            return name;
                        }
                        if (peerID[8] == 0) {
                            String name = "Shad0w ";
                            for (int i = 1; i < 3; ++i) {
                                name = name.concat(String.valueOf(peerID[i]) + ".");
                            }
                            name = name + String.valueOf(peerID[3]);
                            return name;
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if ((bitspirit = new String(peerID, 2, 2, "ISO-8859-1")).equals("BS")) {
                    if (peerID[1] == 0) {
                        return "BitSpirit v1";
                    }
                    if (peerID[1] == 2) {
                        return "BitSpirit v2";
                    }
                }
                if ((upnp = new String(peerID, 0, 1, "ISO-8859-1")).equals("U") && peerID[8] == 45) {
                    String version = new String(peerID, 1, 3, "ISO-8859-1");
                    String name = "UPnP ";
                    for (int i = 0; i < 2; ++i) {
                        name = name.concat(version.charAt(i) + ".");
                    }
                    name = name + version.charAt(2);
                    return name;
                }
                String bitcomet = new String(peerID, 0, 4, "ISO-8859-1");
                if (bitcomet.equals("exbc") || bitcomet.equals("FUTB") || bitcomet.equals("xUTB")) {
                    String name;
                    String lord = new String(peerID, 6, 4, "ISO-8859-1");
                    if (lord.equals("LORD")) {
                        name = "BitLord ";
                        String versionNumber = String.valueOf(peerID[4]);
                        name = name.concat(versionNumber + ".");
                        if (versionNumber.equals("0")) {
                            name = name.concat(String.valueOf(peerID[5] / 10));
                            name = name.concat(String.valueOf(peerID[5] % 10));
                        } else {
                            name = name.concat(String.valueOf(peerID[5] % 10));
                        }
                    } else {
                        name = "BitComet ";
                        if (bitcomet.equals("FUTB")) {
                            name = name.concat("Mod1 ");
                        }
                        if (bitcomet.equals("xUTB")) {
                            name = name.concat("Mod2 ");
                        }
                        name = name.concat(String.valueOf(peerID[4]) + ".");
                        name = name.concat(String.valueOf(peerID[5] / 10));
                        name = name.concat(String.valueOf(peerID[5] % 10));
                    }
                    return name;
                }
                String rufus = new String(peerID, 2, 2, "ISO-8859-1");
                if (rufus.equals("RS")) {
                    String name = "Rufus ";
                    name = name.concat(String.valueOf(peerID[0]) + ".");
                    name = name.concat(String.valueOf(peerID[1] / 10) + ".");
                    name = name.concat(String.valueOf(peerID[1] % 10));
                    return name;
                }
                String mldonkey = new String(peerID, 1, 2, "ISO-8859-1");
                if (mldonkey.equals("ML")) {
                    String name = "mldonkey ";
                    String v1 = new String(peerID, 3, 1, "ISO-8859-1");
                    String v2 = new String(peerID, 5, 1, "ISO-8859-1");
                    String v3 = new String(peerID, 7, 1, "ISO-8859-1");
                    return name + v1 + "." + v2 + "." + v3;
                }
                iFirstNonZeroPos = 20;
                for (int i = 0; i < 20; ++i) {
                    if (peerID[i] == 0) continue;
                    iFirstNonZeroPos = i;
                    break;
                }
                if (iFirstNonZeroPos == 0) {
                    int i;
                    boolean bShareaza = true;
                    for (i = 0; i < 16; ++i) {
                        if (peerID[i] != 0) continue;
                        bShareaza = false;
                        break;
                    }
                    if (bShareaza) {
                        for (i = 16; i < 20; ++i) {
                            if (peerID[i] == (peerID[i % 16] ^ peerID[15 - i % 16])) continue;
                            bShareaza = false;
                            break;
                        }
                        if (bShareaza) {
                            return "Shareaza";
                        }
                    }
                }
                if ((decoded = BTPeerIDByteDecoder.decodeSimpleStyle(peerID, 16, "UDP0", "BitComet UDP")) != null) {
                    return decoded;
                }
                decoded = BTPeerIDByteDecoder.decodeSimpleStyle(peerID, 14, "HTTPBT", "BitComet HTTP");
                if (decoded != null) {
                    return decoded;
                }
                byte three = 3;
                if (iFirstNonZeroPos == 9 && peerID[9] == three && peerID[10] == three && peerID[11] == three) {
                    return "Snark";
                }
                if (iFirstNonZeroPos == 12 && peerID[12] == 97 && peerID[13] == 97) {
                    return "Experimental 3.2.1b2";
                }
                if (iFirstNonZeroPos == 12 && peerID[12] == 0 && peerID[13] == 0) {
                    return "Experimental 3.1";
                }
                if (iFirstNonZeroPos == 12) {
                    return "Mainline";
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                Debug.out("[" + new String(peerID) + "]", e);
            }
            if (LOG_UNKNOWN) {
                log = new FileWriter(logFile, true);
                String text = new String(peerID, 0, 20, "ISO-8859-1");
                text = text.replace('\f', ' ');
                text = text.replace('\n', ' ');
                log.write("[" + text + "] ");
                for (int i = 0; i < 20; ++i) {
                    log.write(i + "=" + peerID[i] + " ");
                }
                log.write("\n");
                Object var24_53 = null;
                try {
                    if (log != null) {
                        log.close();
                    }
                    break block99;
                }
                catch (IOException ignore) {}
                break block99;
                {
                    catch (Exception e) {
                        Debug.out(e.toString());
                        Object var24_54 = null;
                        try {
                            if (log != null) {
                                log.close();
                            }
                            break block99;
                        }
                        catch (IOException ignore) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var24_55 = null;
                    try {
                        if (log != null) {
                            log.close();
                        }
                    }
                    catch (IOException ignore) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        String sPeerID = BTPeerIDByteDecoder.getPrintablePeerID(peerID, iFirstNonZeroPos);
        return MessageText.getString("PeerSocket.unknown") + " " + iFirstNonZeroPos + "[" + sPeerID + "]";
    }

    private static String decodeAzStyle(byte[] id, String ident, String name) {
        try {
            String decoded;
            if (id[0] == 45 && id[7] == 45 && (decoded = new String(id, 1, 2, "ISO-8859-1")).equals(ident)) {
                if (ident.equals("BC")) {
                    String v2 = new String(id, 4, 1, "ISO-8859-1");
                    String v3 = new String(id, 5, 1, "ISO-8859-1");
                    String v4 = new String(id, 6, 1, "ISO-8859-1");
                    return name + " " + v2 + "." + v3 + v4;
                }
                if (ident.equals("KT")) {
                    String v2 = new String(id, 3, 1, "ISO-8859-1");
                    String v3 = new String(id, 4, 1, "ISO-8859-1");
                    String v4 = new String(id, 5, 1, "ISO-8859-1");
                    String v5 = new String(id, 6, 1, "ISO-8859-1");
                    return name + " " + v2 + "." + v3 + (v4.equals("R") ? " RC" + v5 : (v4.equals("D") ? " Dev" : ""));
                }
                if (ident.equals("UT")) {
                    String v2 = new String(id, 3, 1, "ISO-8859-1");
                    String v3 = new String(id, 4, 1, "ISO-8859-1");
                    String v4 = new String(id, 5, 1, "ISO-8859-1");
                    return name + " " + v2 + "." + v3 + "." + v4;
                }
                if (ident.equals("TR")) {
                    String v2 = new String(id, 3, 2, "ISO-8859-1");
                    String v3 = new String(id, 5, 2, "ISO-8859-1");
                    return name + " " + Integer.parseInt(v2) + "." + Integer.parseInt(v3);
                }
                String v1 = new String(id, 3, 1, "ISO-8859-1");
                String v2 = new String(id, 4, 1, "ISO-8859-1");
                String v3 = new String(id, 5, 1, "ISO-8859-1");
                String v4 = new String(id, 6, 1, "ISO-8859-1");
                return name + " " + v1 + "." + v2 + "." + v3 + "." + v4;
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    private static String decodeTornadoStyle(byte[] id, String ident, String name) {
        try {
            String decoded;
            if (id[4] == 45 && id[5] == 45) {
                if (id[6] == 45 && id[7] == 45 && id[8] == 45 && (decoded = new String(id, 0, 1, "ISO-8859-1")).equals(ident)) {
                    int v1 = Integer.parseInt(new String(id, 1, 1, "ISO-8859-1"), 16);
                    int v2 = Integer.parseInt(new String(id, 2, 1, "ISO-8859-1"), 16);
                    int v3 = Integer.parseInt(new String(id, 3, 1, "ISO-8859-1"), 16);
                    return name + " " + v1 + "." + v2 + "." + v3;
                }
                if (id[6] == 48 && (decoded = new String(id, 0, 1, "ISO-8859-1")).equals(ident)) {
                    int v1 = Integer.parseInt(new String(id, 1, 1, "ISO-8859-1"), 16);
                    int v2 = Integer.parseInt(new String(id, 2, 1, "ISO-8859-1"), 16);
                    int v3 = Integer.parseInt(new String(id, 3, 1, "ISO-8859-1"), 16);
                    if (ident.equals("T")) {
                        return name + " LM" + " " + v1 + "." + v2 + "." + v3;
                    }
                    return name + " " + v1 + "." + v2 + "." + v3;
                }
            }
            if (id[4] == 48 && id[5] == 45 && id[6] == 45 && (decoded = new String(id, 0, 1, "ISO-8859-1")).equals(ident)) {
                return "TorrentFlux";
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    private static String decodeSimpleStyle(byte[] id, int start_pos, String ident, String name) {
        try {
            String decoded = new String(id, start_pos, ident.length(), "ISO-8859-1");
            if (decoded.equals(ident)) {
                return name;
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    private static String decodeMainlineStyle(byte[] id, String ident, String name) {
        try {
            String decoded;
            if (id[2] == 45 && id[4] == 45 && id[6] == 45 && id[7] == 45 && (decoded = new String(id, 0, 1, "ISO-8859-1")).equals(ident)) {
                String v1 = new String(id, 1, 1, "ISO-8859-1");
                String v2 = new String(id, 3, 1, "ISO-8859-1");
                String v3 = new String(id, 5, 1, "ISO-8859-1");
                return name + " " + v1 + "." + v2 + "." + v3;
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    protected static String getPrintablePeerID(byte[] peer_id, int iStartAtPos) {
        String sPeerID = "";
        byte[] peerID = new byte[peer_id.length];
        System.arraycopy(peer_id, 0, peerID, 0, peer_id.length);
        try {
            for (int i = iStartAtPos; i < peerID.length; ++i) {
                int b = 0xFF & peerID[i];
                if (b >= 32 && b <= 127) continue;
                peerID[i] = 45;
            }
            sPeerID = new String(peerID, iStartAtPos, peerID.length - iStartAtPos, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException ignore) {
        }
        catch (Exception e) {
            // empty catch block
        }
        return sPeerID;
    }

    static {
        String prop = System.getProperty("log.unknown.peerids");
        LOG_UNKNOWN = prop != null && prop.equals("1");
    }
}

