/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.update.impl;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.update.AzureusRestarter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Properties;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.platform.PlatformManager;
import org.gudy.azureus2.platform.PlatformManagerFactory;

public class AzureusRestarterImpl
implements AzureusRestarter {
    private static final LogIDs LOGID = LogIDs.CORE;
    private static final String MAIN_CLASS = "org.gudy.azureus2.update.Updater";
    private static final String UPDATER_JAR = "Updater.jar";
    public static final String UPDATE_PROPERTIES = "update.properties";
    protected static boolean restarted = false;
    private static String JAVA_EXEC_DIR = System.getProperty("java.home") + System.getProperty("file.separator") + "bin" + System.getProperty("file.separator");
    protected AzureusCore azureus_core;
    protected String classpath_prefix;

    public AzureusRestarterImpl(AzureusCore _azureus_core) {
        this.azureus_core = _azureus_core;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void restart(boolean update_only) {
        block21: {
            if (AzureusRestarterImpl.restarted) {
                Logger.log(new LogEvent(AzureusRestarterImpl.LOGID, 1, "AzureusRestarter: already restarted!!!!"));
                return;
            }
            AzureusRestarterImpl.restarted = true;
            pi = this.azureus_core.getPluginManager().getPluginInterfaceByID("azupdater");
            if (pi == null) {
                Logger.log(new LogAlert(false, 3, "Can't restart, mandatory plugin 'azupdater' not found"));
                return;
            }
            updater_dir = pi.getPluginDirectoryName();
            this.classpath_prefix = updater_dir + File.separator + "Updater.jar";
            app_path = SystemProperties.getApplicationPath();
            while (app_path.endsWith(File.separator)) {
                app_path = app_path.substring(0, app_path.length() - 1);
            }
            user_path = SystemProperties.getUserPath();
            while (user_path.endsWith(File.separator)) {
                user_path = user_path.substring(0, user_path.length() - 1);
            }
            config_override = System.getProperty("azureus.config.path");
            if (config_override == null) {
                config_override = "";
            }
            parameters = new String[]{update_only != false ? "updateonly" : "restart", app_path, user_path, config_override};
            fos = null;
            try {
                restart_properties = new Properties();
                max_mem = Runtime.getRuntime().maxMemory();
                restart_properties.put("max_mem", "" + max_mem);
                restart_properties.put("app_name", SystemProperties.getApplicationName());
                restart_properties.put("app_entry", SystemProperties.getApplicationEntryPoint());
                if (System.getProperty("azureus.nativelauncher") != null || this.isOSX()) {
                    try {
                        cmd = PlatformManagerFactory.getPlatformManager().getApplicationCommandLine();
                        if (cmd != null) {
                            restart_properties.put("app_cmd", cmd);
                        }
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
                fos = new FileOutputStream(new File(user_path, "update.properties"));
                restart_properties.store(fos, "Azureus restart properties");
                var14_15 = null;
                ** if (fos == null) goto lbl-1000
            }
            catch (Throwable var13_21) {
                var14_17 = null;
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
                throw var13_21;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    fos.close();
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
lbl-1000:
            // 2 sources

            {
                break block21;
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                    var14_16 = null;
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                }
            }
        }
        properties = new String[]{"-Duser.dir=\"" + app_path + "\""};
        os = new ByteArrayOutputStream();
        this.restartAzureus(new PrintWriter(os){

            public void println(String str) {
                Logger.log(new LogEvent(LOGID, str));
            }
        }, "org.gudy.azureus2.update.Updater", properties, parameters);
        bytes = os.toByteArray();
        if (bytes.length > 0) {
            Logger.log(new LogEvent(AzureusRestarterImpl.LOGID, "AzureusRestarter: extra log - " + new String(bytes)));
        }
    }

    private String getClassPath() {
        String classPath = System.getProperty("java.class.path");
        classPath = this.classpath_prefix + System.getProperty("path.separator") + classPath;
        return "-classpath \"" + classPath + "\" ";
    }

    private boolean win32NativeRestart(PrintWriter log, String exec) {
        try {
            PlatformManager pm = PlatformManagerFactory.getPlatformManager();
            pm.createProcess(exec, false);
            return true;
        }
        catch (Throwable e) {
            e.printStackTrace(log);
            return false;
        }
    }

    private boolean isOSX() {
        return Constants.isOSX;
    }

    private boolean isLinux() {
        return Constants.isLinux;
    }

    private boolean isSolaris() {
        return Constants.isSolaris;
    }

    public void restartAzureus(PrintWriter log, String mainClass, String[] properties, String[] parameters) {
        if (this.isOSX()) {
            this.restartAzureus_OSX(log, mainClass, properties, parameters);
        } else if (this.isLinux() || this.isSolaris()) {
            this.restartAzureus_Unix(log, mainClass, properties, parameters);
        } else {
            this.restartAzureus_win32(log, mainClass, properties, parameters);
        }
    }

    private void restartAzureus_win32(PrintWriter log, String mainClass, String[] properties, String[] parameters) {
        int i;
        String exec = "\"" + JAVA_EXEC_DIR + "javaw\" " + this.getClassPath() + this.getLibraryPath();
        for (i = 0; i < properties.length; ++i) {
            exec = exec + properties[i] + " ";
        }
        exec = exec + mainClass;
        for (i = 0; i < parameters.length; ++i) {
            exec = exec + " \"" + parameters[i] + "\"";
        }
        if (log != null) {
            log.println("  " + exec);
        }
        if (!this.win32NativeRestart(log, exec)) {
            try {
                log.println("Using java spawn");
                Process p = Runtime.getRuntime().exec(exec);
                log.println("    -> " + p);
            }
            catch (Throwable f) {
                f.printStackTrace(log);
            }
        }
    }

    private void restartAzureus_OSX(PrintWriter log, String mainClass, String[] properties, String[] parameters) {
        int i;
        String exec = "\"" + JAVA_EXEC_DIR + "java\" " + this.getClassPath() + this.getLibraryPath();
        for (i = 0; i < properties.length; ++i) {
            exec = exec + properties[i] + " ";
        }
        exec = exec + mainClass;
        for (i = 0; i < parameters.length; ++i) {
            exec = exec + " \"" + parameters[i] + "\"";
        }
        this.runExternalCommandViaUnixShell(log, exec);
    }

    private void restartAzureus_Unix(PrintWriter log, String mainClass, String[] properties, String[] parameters) {
        int i;
        String exec = "\"" + JAVA_EXEC_DIR + "java\" " + this.getClassPath() + this.getLibraryPath();
        for (i = 0; i < properties.length; ++i) {
            exec = exec + properties[i] + " ";
        }
        exec = exec + mainClass;
        for (i = 0; i < parameters.length; ++i) {
            exec = exec + " \"" + parameters[i] + "\"";
        }
        this.runExternalCommandViaUnixShell(log, exec);
    }

    private String getLibraryPath() {
        String libraryPath = System.getProperty("java.library.path");
        if (libraryPath == null) {
            libraryPath = "";
        } else {
            String temp = "";
            for (int i = 0; i < libraryPath.length(); ++i) {
                char c = libraryPath.charAt(i);
                if (c == '\"') continue;
                temp = temp + c;
            }
            libraryPath = temp;
            while (libraryPath.endsWith(File.separator)) {
                libraryPath = libraryPath.substring(0, libraryPath.length() - 1);
            }
            if (libraryPath.length() > 0) {
                libraryPath = "-Djava.library.path=\"" + libraryPath + "\" ";
            }
        }
        return libraryPath;
    }

    private void runExternalCommandViaUnixShell(PrintWriter log, String command) {
        String[] to_run = new String[]{"/bin/sh", "-c", command};
        if (log != null) {
            log.println("Executing: R:[" + to_run[0] + " " + to_run[1] + " " + to_run[2] + "]");
        }
        try {
            Runtime.getRuntime().exec(to_run);
        }
        catch (Throwable t) {
            if (log != null) {
                log.println(t.getMessage() != null ? t.getMessage() : "<null>");
                log.println(t);
                t.printStackTrace(log);
            }
            t.printStackTrace();
        }
    }
}

