/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.clientid;

import java.util.Properties;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.clientid.ClientIDGenerator;
import org.gudy.azureus2.plugins.torrent.Torrent;

public class ClientIDPlugin
implements Plugin {
    private PluginInterface plugin_interface;
    static final String chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";

    public static void load(final PluginInterface plugin_interface) {
        plugin_interface.getClientIDManager().setGenerator(new ClientIDGenerator(){

            public byte[] generatePeerID(Torrent torrent, boolean for_tracker) {
                return ClientIDPlugin.createPeerID();
            }

            public void generateHTTPProperties(Properties properties) {
                ClientIDPlugin.doHTTPProperties(plugin_interface, properties);
            }

            public String[] filterHTTP(String[] lines_in) {
                return lines_in;
            }
        }, false);
    }

    public void initialize(PluginInterface _plugin_interface) {
        this.plugin_interface = _plugin_interface;
        this.plugin_interface.getPluginProperties().setProperty("plugin.version", "1.0");
        this.plugin_interface.getPluginProperties().setProperty("plugin.name", "Client ID");
    }

    protected static void doHTTPProperties(PluginInterface plugin_interface, Properties properties) {
        String version = "2.3.0.7_B51";
        int pos = version.indexOf(95);
        if (pos != -1) {
            version = version.substring(0, pos);
        }
        String agent = "Azureus " + version;
        if (plugin_interface.getPluginconfig().getBooleanParameter("Tracker Client Send OS and Java Version")) {
            agent = agent + ";" + Constants.OSName;
            agent = agent + ";Java " + Constants.JAVA_VERSION;
        }
        properties.put("User-Agent", agent);
    }

    public static byte[] createPeerID() {
        int i;
        byte[] peerId = new byte[20];
        byte[] version = Constants.VERSION_ID;
        for (i = 0; i < 8; ++i) {
            peerId[i] = version[i];
        }
        for (i = 8; i < 20; ++i) {
            int pos = (int)(Math.random() * (double)chars.length());
            peerId[i] = (byte)chars.charAt(pos);
        }
        return peerId;
    }
}

