/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.extseed.impl;

import com.aelitis.azureus.plugins.extseed.ExternalSeedException;
import com.aelitis.azureus.plugins.extseed.ExternalSeedPlugin;
import com.aelitis.azureus.plugins.extseed.ExternalSeedReader;
import com.aelitis.azureus.plugins.extseed.ExternalSeedReaderListener;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.peers.PeerManager;
import org.gudy.azureus2.plugins.peers.PeerReadRequest;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.utils.Monitor;
import org.gudy.azureus2.plugins.utils.PooledByteBuffer;
import org.gudy.azureus2.plugins.utils.Semaphore;

public abstract class ExternalSeedReaderImpl
implements ExternalSeedReader {
    private ExternalSeedPlugin plugin;
    private Torrent torrent;
    private String status;
    private boolean active;
    private boolean permanent_fail;
    private long last_failed_read;
    private int consec_failures;
    private String user_agent;
    private long peer_manager_change_time;
    private volatile PeerManager current_manager;
    private List requests = new LinkedList();
    private volatile int request_count;
    private Thread request_thread;
    private Semaphore request_sem;
    private Monitor requests_mon;
    private List listeners = new ArrayList();

    protected ExternalSeedReaderImpl(ExternalSeedPlugin _plugin, Torrent _torrent) {
        this.plugin = _plugin;
        this.torrent = _torrent;
        this.requests_mon = this.plugin.getPluginInterface().getUtilities().getMonitor();
        this.request_sem = this.plugin.getPluginInterface().getUtilities().getSemaphore();
        PluginInterface pi = this.plugin.getPluginInterface();
        this.user_agent = pi.getAzureusName();
        try {
            Properties props = new Properties();
            pi.getClientIDManager().getGenerator().generateHTTPProperties(props);
            String ua = props.getProperty("User-Agent");
            if (ua != null) {
                this.user_agent = ua;
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        this.setActive(false);
    }

    public Torrent getTorrent() {
        return this.torrent;
    }

    public String getStatus() {
        return this.status;
    }

    protected void log(String str) {
        this.plugin.log(str);
    }

    protected String getUserAgent() {
        return this.user_agent;
    }

    protected long getSystemTime() {
        return this.plugin.getPluginInterface().getUtilities().getCurrentSystemTime();
    }

    protected int getFailureCount() {
        return this.consec_failures;
    }

    protected long getLastFailTime() {
        return this.last_failed_read;
    }

    public boolean isPermanentlyUnavailable() {
        return this.permanent_fail;
    }

    protected abstract boolean readyToActivate(PeerManager var1);

    protected abstract boolean readyToDeactivate(PeerManager var1);

    public boolean checkActivation(PeerManager peer_manager) {
        long now = this.getSystemTime();
        if (peer_manager == this.current_manager) {
            if (this.peer_manager_change_time > now) {
                this.peer_manager_change_time = now;
            }
            if (peer_manager != null) {
                if (this.active) {
                    if (now - this.peer_manager_change_time > 30000L && this.readyToDeactivate(peer_manager)) {
                        this.setActive(false);
                    }
                } else if (!this.isPermanentlyUnavailable() && now - this.peer_manager_change_time > 30000L && this.readyToActivate(peer_manager)) {
                    this.setActive(true);
                }
            }
        } else {
            this.peer_manager_change_time = now;
            this.current_manager = peer_manager;
            this.setActive(false);
        }
        return this.active;
    }

    public void deactivate(String reason) {
        this.plugin.log(this.getName() + ": deactivating (" + reason + ")");
        this.checkActivation(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setActive(boolean _active) {
        try {
            this.requests_mon.enter();
            this.active = _active;
            this.status = this.active ? "Active" : "Idle";
        }
        finally {
            this.requests_mon.exit();
        }
    }

    public boolean isActive() {
        return this.active;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRequests() {
        try {
            this.requests_mon.enter();
            if (this.request_thread != null) {
                return;
            }
            this.request_thread = Thread.currentThread();
        }
        finally {
            this.requests_mon.exit();
        }
        block12: while (true) {
            try {
                while (true) {
                    PeerReadRequest request2;
                    if (!this.request_sem.reserve(30000L)) {
                        try {
                            this.requests_mon.enter();
                            if (this.requests.size() != 0) continue;
                            this.request_thread = null;
                            break block12;
                        }
                        finally {
                            this.requests_mon.exit();
                            continue;
                        }
                    }
                    try {
                        this.requests_mon.enter();
                        request2 = (PeerReadRequest)this.requests.remove(0);
                        if (!request2.isCancelled()) {
                            --this.request_count;
                        }
                    }
                    finally {
                        this.requests_mon.exit();
                    }
                    if (request2.isCancelled()) {
                        this.informCancelled(request2);
                        continue;
                    }
                    this.processRequest(request2);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    protected abstract byte[] readData(PeerReadRequest var1) throws ExternalSeedException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRequest(PeerReadRequest request2) {
        block14: {
            boolean ok = false;
            try {
                try {
                    byte[] data = this.readData(request2);
                    ok = true;
                    PooledByteBuffer buffer = this.plugin.getPluginInterface().getUtilities().allocatePooledByteBuffer(data);
                    this.informComplete(request2, buffer);
                }
                catch (ExternalSeedException e) {
                    if (e.isPermanentFailure()) {
                        this.permanent_fail = true;
                    }
                    this.status = "Failed: " + Debug.getNestedExceptionMessage(e);
                    this.informFailed(request2);
                    Object var6_8 = null;
                    if (ok) {
                        this.last_failed_read = 0L;
                        this.consec_failures = 0;
                    } else {
                        this.last_failed_read = this.getSystemTime();
                        ++this.consec_failures;
                    }
                    break block14;
                }
                catch (Throwable e) {
                    request2.cancel();
                    this.status = "Failed: " + Debug.getNestedExceptionMessage(e);
                    this.informFailed(request2);
                    Object var6_9 = null;
                    if (ok) {
                        this.last_failed_read = 0L;
                        this.consec_failures = 0;
                    } else {
                        this.last_failed_read = this.getSystemTime();
                        ++this.consec_failures;
                    }
                }
                Object var6_7 = null;
                if (ok) {
                    this.last_failed_read = 0L;
                    this.consec_failures = 0;
                } else {
                    this.last_failed_read = this.getSystemTime();
                    ++this.consec_failures;
                }
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                if (ok) {
                    this.last_failed_read = 0L;
                    this.consec_failures = 0;
                } else {
                    this.last_failed_read = this.getSystemTime();
                    ++this.consec_failures;
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRequest(PeerReadRequest request2) {
        try {
            this.requests_mon.enter();
            if (!this.active) {
                Debug.out("request added when not active!!!!");
            }
            this.requests.add(request2);
            this.request_count = this.requests.size();
            this.request_sem.release();
            if (this.request_thread == null) {
                this.plugin.getPluginInterface().getUtilities().createThread("RequestProcessor", new Runnable(){

                    public void run() {
                        ExternalSeedReaderImpl.this.processRequests();
                    }
                });
            }
        }
        finally {
            this.requests_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelRequest(PeerReadRequest request2) {
        try {
            this.requests_mon.enter();
            if (this.requests.contains(request2) && !request2.isCancelled()) {
                request2.cancel();
                --this.request_count;
            }
        }
        finally {
            this.requests_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAllRequests() {
        try {
            this.requests_mon.enter();
            for (int i = 0; i < this.requests.size(); ++i) {
                PeerReadRequest request2 = (PeerReadRequest)this.requests.get(i);
                if (request2.isCancelled()) continue;
                request2.cancel();
                --this.request_count;
            }
        }
        finally {
            this.requests_mon.exit();
        }
    }

    public int getRequestCount() {
        return this.request_count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getExpiredRequests() {
        ArrayList<PeerReadRequest> res = null;
        try {
            this.requests_mon.enter();
            for (int i = 0; i < this.requests.size(); ++i) {
                PeerReadRequest request2 = (PeerReadRequest)this.requests.get(i);
                if (!request2.isExpired()) continue;
                if (res == null) {
                    res = new ArrayList<PeerReadRequest>();
                }
                res.add(request2);
            }
        }
        finally {
            this.requests_mon.exit();
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getRequests() {
        ArrayList res = null;
        try {
            this.requests_mon.enter();
            res = new ArrayList(this.requests);
        }
        finally {
            this.requests_mon.exit();
        }
        return res;
    }

    protected void informComplete(PeerReadRequest request2, PooledByteBuffer buffer) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                ((ExternalSeedReaderListener)this.listeners.get(i)).requestComplete(request2, buffer);
                continue;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    protected void informCancelled(PeerReadRequest request2) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                ((ExternalSeedReaderListener)this.listeners.get(i)).requestCancelled(request2);
                continue;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    protected void informFailed(PeerReadRequest request2) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                ((ExternalSeedReaderListener)this.listeners.get(i)).requestFailed(request2);
                continue;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public void addListener(ExternalSeedReaderListener l) {
        this.listeners.add(l);
    }

    public void removeListener(ExternalSeedReaderListener l) {
        this.listeners.remove(l);
    }
}

