/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.jpc.cache.impl.messaging;

import com.aelitis.azureus.plugins.jpc.cache.impl.messaging.JPCCacheMessage;
import java.nio.ByteBuffer;
import org.gudy.azureus2.plugins.messaging.Message;
import org.gudy.azureus2.plugins.messaging.MessageException;

public class JPCActive
implements JPCCacheMessage {
    private final String description;
    private final ByteBuffer buffer;
    private final int session_id;

    public JPCActive(int session_id) {
        this.session_id = session_id;
        this.description = this.getID() + " for session id# " + session_id;
        this.buffer = ByteBuffer.allocate(4);
        this.buffer.putInt(session_id);
        this.buffer.flip();
    }

    public int getSessionID() {
        return this.session_id;
    }

    public String getID() {
        return "JPC_ACTIVE";
    }

    public byte getVersion() {
        return 1;
    }

    public int getType() {
        return 0;
    }

    public String getDescription() {
        return this.description;
    }

    public ByteBuffer[] getPayload() {
        return new ByteBuffer[]{this.buffer};
    }

    public void destroy() {
    }

    public Message create(ByteBuffer data) throws MessageException {
        if (data == null) {
            throw new MessageException("[" + this.getID() + ":" + this.getVersion() + "] decode error: data == null");
        }
        if (data.remaining() != 4) {
            throw new MessageException("[" + this.getID() + ":" + this.getVersion() + "] decode error: payload.remaining[" + data.remaining() + "] != 4");
        }
        int id = data.getInt();
        return new JPCActive(id);
    }
}

