/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec;

import java.math.BigInteger;
import org.bouncycastle.math.ec.ECConstants;

public abstract class ECFieldElement
implements ECConstants {
    BigInteger x;
    BigInteger p;

    protected ECFieldElement(BigInteger q, BigInteger x) {
        if (x.compareTo(q) >= 0) {
            throw new IllegalArgumentException("x value too large in field element");
        }
        this.x = x;
        this.p = q;
    }

    public BigInteger toBigInteger() {
        return this.x;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ECFieldElement)) {
            return false;
        }
        ECFieldElement o = (ECFieldElement)other;
        return this.p.equals(o.p) && this.x.equals(o.x);
    }

    public abstract String getFieldName();

    public abstract ECFieldElement add(ECFieldElement var1);

    public abstract ECFieldElement subtract(ECFieldElement var1);

    public abstract ECFieldElement multiply(ECFieldElement var1);

    public abstract ECFieldElement divide(ECFieldElement var1);

    public abstract ECFieldElement negate();

    public abstract ECFieldElement square();

    public abstract ECFieldElement invert();

    public abstract ECFieldElement sqrt();

    public static class Fp
    extends ECFieldElement {
        public String getFieldName() {
            return "Fp";
        }

        public Fp(BigInteger q, BigInteger x) {
            super(q, x);
        }

        public ECFieldElement add(ECFieldElement b) {
            return new Fp(this.p, this.x.add(b.x).mod(this.p));
        }

        public ECFieldElement subtract(ECFieldElement b) {
            return new Fp(this.p, this.x.subtract(b.x).mod(this.p));
        }

        public ECFieldElement multiply(ECFieldElement b) {
            return new Fp(this.p, this.x.multiply(b.x).mod(this.p));
        }

        public ECFieldElement divide(ECFieldElement b) {
            return new Fp(this.p, this.x.multiply(b.x.modInverse(this.p)).mod(this.p));
        }

        public ECFieldElement negate() {
            return new Fp(this.p, this.x.negate().mod(this.p));
        }

        public ECFieldElement square() {
            return new Fp(this.p, this.x.multiply(this.x).mod(this.p));
        }

        public ECFieldElement invert() {
            return new Fp(this.p, this.x.modInverse(this.p));
        }

        public ECFieldElement sqrt() {
            if (this.p.testBit(1)) {
                Fp z = new Fp(this.p, this.x.modPow(this.p.shiftRight(2).add(ONE), this.p));
                return ((ECFieldElement)z).square().equals(this) ? z : null;
            }
            throw new RuntimeException("not done yet");
        }
    }
}

