/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.download.impl;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.category.Category;
import org.gudy.azureus2.core3.category.CategoryManager;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.download.DownloadManagerStateEvent;
import org.gudy.azureus2.core3.download.DownloadManagerStateListener;
import org.gudy.azureus2.core3.download.impl.DownloadManagerImpl;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.peer.PEPeerSource;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncer;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AENetworkClassifier;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.TorrentUtils;

public class DownloadManagerStateImpl
implements DownloadManagerState,
ParameterListener {
    private static final LogIDs LOGID = LogIDs.DISK;
    private static final String RESUME_KEY = "resume";
    private static final String TRACKER_CACHE_KEY = "tracker_cache";
    private static final String ATTRIBUTE_KEY = "attributes";
    private static final File ACTIVE_DIR = FileUtil.getUserFile("active");
    private static final Map default_parameters;
    private static AEMonitor class_mon;
    private static Map state_map;
    private DownloadManagerImpl download_manager;
    private TOTorrent torrent;
    private boolean write_required;
    private Map tracker_response_cache = new HashMap();
    private Category category;
    private List listeners = new ArrayList();
    private List will_be_read_list = new ArrayList();
    private Map parameters;
    private AEMonitor this_mon = new AEMonitor("DownloadManagerState");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DownloadManagerState getDownloadState(DownloadManagerImpl download_manager, TOTorrent original_torrent, TOTorrent target_torrent) throws TOTorrentException {
        byte[] hash = target_torrent.getHash();
        DownloadManagerStateImpl res = null;
        try {
            class_mon.enter();
            HashWrapper hash_wrapper = new HashWrapper(hash);
            res = (DownloadManagerStateImpl)state_map.get(hash_wrapper);
            if (res == null) {
                res = new DownloadManagerStateImpl(download_manager, target_torrent);
                state_map.put(hash_wrapper, res);
            } else {
                if (res.getDownloadManager() == null && download_manager != null) {
                    res.setDownloadManager(download_manager);
                }
                if (original_torrent != null) {
                    res.mergeTorrentDetails(original_torrent);
                }
            }
        }
        finally {
            class_mon.exit();
        }
        return res;
    }

    public static DownloadManagerState getDownloadState(TOTorrent original_torrent) throws TOTorrentException {
        byte[] torrent_hash = original_torrent.getHash();
        TOTorrent saved_state = null;
        File saved_file = DownloadManagerStateImpl.getStateFile(torrent_hash);
        if (saved_file.exists()) {
            try {
                saved_state = TorrentUtils.readFromFile(saved_file, true);
            }
            catch (Throwable e) {
                Debug.out("Failed to load download state for " + saved_file);
            }
        }
        if (saved_state == null) {
            TorrentUtils.copyToFile(original_torrent, saved_file);
            saved_state = TorrentUtils.readFromFile(saved_file, true);
        }
        return DownloadManagerStateImpl.getDownloadState(null, original_torrent, saved_state);
    }

    protected static DownloadManagerState getDownloadState(DownloadManagerImpl download_manager, String torrent_file, byte[] torrent_hash) throws TOTorrentException {
        File saved_file;
        TOTorrent original_torrent = null;
        TOTorrent saved_state = null;
        if (torrent_hash != null && (saved_file = DownloadManagerStateImpl.getStateFile(torrent_hash)).exists()) {
            try {
                saved_state = TorrentUtils.readFromFile(saved_file, true);
            }
            catch (Throwable e) {
                Debug.out("Failed to load download state for " + saved_file);
            }
        }
        if (saved_state == null) {
            original_torrent = TorrentUtils.readFromFile(new File(torrent_file), true);
            torrent_hash = original_torrent.getHash();
            saved_file = DownloadManagerStateImpl.getStateFile(torrent_hash);
            if (saved_file.exists()) {
                try {
                    saved_state = TorrentUtils.readFromFile(saved_file, true);
                }
                catch (Throwable e) {
                    Debug.out("Failed to load download state for " + saved_file);
                }
            }
            if (saved_state == null) {
                TorrentUtils.copyToFile(original_torrent, saved_file);
                saved_state = TorrentUtils.readFromFile(saved_file, true);
            }
        }
        return DownloadManagerStateImpl.getDownloadState(download_manager, original_torrent, saved_state);
    }

    protected static File getStateFile(byte[] torrent_hash) {
        return new File(ACTIVE_DIR, ByteFormatter.encodeString(torrent_hash) + ".dat");
    }

    protected DownloadManagerStateImpl(DownloadManagerImpl _download_manager, TOTorrent _torrent) {
        Category cat;
        String cat_string;
        this.download_manager = _download_manager;
        this.torrent = _torrent;
        String[] map_types = new String[]{RESUME_KEY, TRACKER_CACHE_KEY, ATTRIBUTE_KEY};
        for (int i = 0; i < map_types.length; ++i) {
            String map_type = map_types[i];
            Object attribute_key = this.torrent.getAdditionalProperty(map_type);
            if (attribute_key == null || attribute_key instanceof Map) continue;
            Debug.out("Invalid state entry type for '" + map_type + "'");
            this.torrent.removeAdditionalProperty(map_type);
        }
        this.tracker_response_cache = this.torrent.getAdditionalMapProperty(TRACKER_CACHE_KEY);
        if (this.tracker_response_cache == null) {
            this.tracker_response_cache = new HashMap();
        }
        if ((cat_string = this.getStringAttribute("category")) != null && (cat = CategoryManager.getCategory(cat_string)) != null) {
            this.setCategory(cat);
        }
        this.parameters = this.getMapAttribute("parameters");
        if (this.parameters == null) {
            this.parameters = new HashMap();
        }
        this.addListeners();
    }

    public void parameterChanged(String parameterName) {
        this.informWritten("parameters");
    }

    protected void addListeners() {
        COConfigurationManager.addParameterListener("Max Uploads Seeding", this);
        COConfigurationManager.addParameterListener("enable.seedingonly.maxuploads", this);
    }

    protected void removeListeners() {
        COConfigurationManager.removeParameterListener("Max Uploads Seeding", this);
        COConfigurationManager.removeParameterListener("enable.seedingonly.maxuploads", this);
    }

    public DownloadManager getDownloadManager() {
        return this.download_manager;
    }

    protected void setDownloadManager(DownloadManagerImpl dm) {
        this.download_manager = dm;
    }

    public File getStateFile(String name) {
        try {
            File parent = new File(ACTIVE_DIR, ByteFormatter.encodeString(this.torrent.getHash()));
            return new File(parent, name);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return null;
        }
    }

    public void clearTrackerResponseCache() {
        this.setTrackerResponseCache(new HashMap());
    }

    public Map getTrackerResponseCache() {
        return this.tracker_response_cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTrackerResponseCache(Map value) {
        try {
            boolean changed;
            this.this_mon.enter();
            boolean bl = changed = !BEncoder.mapsAreIdentical(value, this.tracker_response_cache);
            if (changed) {
                this.write_required = true;
                this.tracker_response_cache = value;
                this.torrent.setAdditionalMapProperty(TRACKER_CACHE_KEY, this.tracker_response_cache);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getResumeData() {
        try {
            this.this_mon.enter();
            Map map = this.torrent.getAdditionalMapProperty(RESUME_KEY);
            return map;
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void clearResumeData() {
        this.setResumeData(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResumeData(Map data) {
        try {
            this.this_mon.enter();
            if (data == null) {
                this.torrent.removeAdditionalProperty(RESUME_KEY);
            } else {
                this.torrent.setAdditionalMapProperty(RESUME_KEY, data);
            }
            this.write_required = true;
        }
        finally {
            this.this_mon.exit();
        }
    }

    public TOTorrent getTorrent() {
        return this.torrent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        boolean do_write;
        try {
            this.this_mon.enter();
            do_write = this.write_required;
            this.write_required = false;
        }
        finally {
            this.this_mon.exit();
        }
        if (do_write) {
            try {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(this.torrent, LOGID, "Saving state for download '" + TorrentUtils.getLocalisedName(this.torrent) + "'"));
                }
                TorrentUtils.writeToFile(this.torrent, true);
            }
            catch (Throwable e) {
                Logger.log(new LogEvent((Object)this.torrent, LOGID, "Saving state", e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() {
        try {
            class_mon.enter();
            HashWrapper wrapper = this.torrent.getHashWrapper();
            state_map.remove(wrapper);
            TorrentUtils.delete(this.torrent);
            File dir = new File(ACTIVE_DIR, ByteFormatter.encodeString(wrapper.getBytes()));
            if (dir.exists() && dir.isDirectory()) {
                FileUtil.recursiveDelete(dir);
            }
            this.removeListeners();
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        finally {
            class_mon.exit();
        }
    }

    protected void mergeTorrentDetails(TOTorrent other_torrent) {
        try {
            boolean write = TorrentUtils.mergeAnnounceURLs(other_torrent, this.torrent);
            if (write) {
                TRTrackerAnnouncer client;
                this.save();
                if (this.download_manager != null && (client = this.download_manager.getTrackerClient()) != null) {
                    client.resetTrackerUrl(false);
                }
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    public void setFlag(long flag, boolean set) {
        long new_value;
        long old_value = this.getLongAttribute("flags");
        if (old_value != (new_value = set ? old_value | flag : old_value & (flag ^ 0xFFFFFFFFFFFFFFFFL))) {
            this.setLongAttribute("flags", new_value);
        }
    }

    public boolean getFlag(long flag) {
        long value = this.getLongAttribute("flags");
        return (value & flag) != 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIntParameter(String name) {
        try {
            int n;
            this.this_mon.enter();
            Object value = this.parameters.get(name);
            if (value == null) {
                value = default_parameters.get(name);
                if (value == null) {
                    Debug.out("Unknown parameter '" + name + "' - must be defined in DownloadManagerState");
                    int n2 = 0;
                    return n2;
                }
                if (name == "max.uploads.when.seeding.enabled") {
                    if (COConfigurationManager.getBooleanParameter("enable.seedingonly.maxuploads")) {
                        value = new Boolean(true);
                    }
                } else if (name == "max.uploads.when.seeding") {
                    int def = COConfigurationManager.getIntParameter("Max Uploads Seeding");
                    value = new Integer(def);
                }
            }
            if (value instanceof Boolean) {
                n = (Boolean)value != false ? 1 : 0;
                return n;
            }
            if (value instanceof Integer) {
                n = (Integer)value;
                return n;
            }
            if (value instanceof Long) {
                n = ((Long)value).intValue();
                return n;
            }
            Debug.out("Invalid parameter value for '" + name + "' - " + value);
            n = 0;
            return n;
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIntParameter(String name, int value) {
        Object default_value = default_parameters.get(name);
        if (default_value == null) {
            Debug.out("Unknown parameter '" + name + "' - must be defined in DownloadManagerState");
        }
        try {
            this.this_mon.enter();
            this.parameters = new HashMap(this.parameters);
            this.parameters.put(name, new Long(value));
        }
        finally {
            this.this_mon.exit();
        }
        this.setMapAttribute("parameters", this.parameters);
    }

    public boolean getBooleanParameter(String name) {
        return this.getIntParameter(name) != 0;
    }

    public void setBooleanParameter(String name, boolean value) {
        this.setIntParameter(name, value ? 1 : 0);
    }

    public void setAttribute(String name, String value) {
        if (name.equals("category")) {
            if (value == null) {
                this.setCategory(null);
            } else {
                Category cat = CategoryManager.getCategory(value);
                if (cat == null) {
                    cat = CategoryManager.createCategory(value);
                }
                this.setCategory(cat);
            }
        } else {
            this.setStringAttribute(name, value);
        }
    }

    public String getAttribute(String name) {
        if (name.equals("category")) {
            Category cat = this.getCategory();
            if (cat == null) {
                return null;
            }
            if (cat == CategoryManager.getCategory(2)) {
                return null;
            }
            return cat.getName();
        }
        return this.getStringAttribute(name);
    }

    public Category getCategory() {
        return this.category;
    }

    public void setCategory(Category cat) {
        if (cat == CategoryManager.getCategory(2)) {
            cat = null;
        }
        if (cat == this.category) {
            return;
        }
        if (cat != null && cat.getType() != 0) {
            cat = null;
        }
        Category oldCategory = this.category == null ? CategoryManager.getCategory(2) : this.category;
        this.category = cat;
        if (oldCategory != null) {
            oldCategory.removeManager(this);
        }
        if (this.category != null) {
            this.category.addManager(this);
        }
        if (this.category != null && this.category.getType() == 0) {
            this.setStringAttribute("category", this.category.getName());
        } else {
            this.setStringAttribute("category", null);
        }
    }

    public String getTrackerClientExtensions() {
        return this.getStringAttribute("trackerclientextensions");
    }

    public void setTrackerClientExtensions(String value) {
        this.setStringAttribute("trackerclientextensions", value);
    }

    public String[] getNetworks() {
        List values = this.getListAttributeSupport("networks");
        ArrayList<String> res = new ArrayList<String>();
        for (int i = 0; i < values.size(); ++i) {
            String nw = (String)values.get(i);
            for (int j = 0; j < AENetworkClassifier.AT_NETWORKS.length; ++j) {
                String nn = AENetworkClassifier.AT_NETWORKS[j];
                if (!nn.equals(nw)) continue;
                res.add(nn);
            }
        }
        String[] x = new String[res.size()];
        res.toArray(x);
        return x;
    }

    public boolean isNetworkEnabled(String network) {
        List values = this.getListAttributeSupport("networks");
        return values.contains(network);
    }

    public void setNetworks(String[] networks) {
        if (networks == null) {
            networks = new String[]{};
        }
        ArrayList<String> l = new ArrayList<String>();
        for (int i = 0; i < networks.length; ++i) {
            l.add(networks[i]);
        }
        this.setListAttribute("networks", l);
    }

    public void setNetworkEnabled(String network, boolean enabled) {
        int i;
        List values = this.getListAttributeSupport("networks");
        boolean alreadyEnabled = values.contains(network);
        ArrayList l = new ArrayList();
        if (enabled && !alreadyEnabled) {
            for (i = 0; i < values.size(); ++i) {
                l.add(values.get(i));
            }
            l.add(network);
            this.setListAttribute("networks", l);
        }
        if (!enabled && alreadyEnabled) {
            for (i = 0; i < values.size(); ++i) {
                l.add(values.get(i));
            }
            l.remove(network);
            this.setListAttribute("networks", l);
        }
    }

    public String[] getPeerSources() {
        List values = this.getListAttributeSupport("peersources");
        ArrayList<String> res = new ArrayList<String>();
        for (int i = 0; i < values.size(); ++i) {
            String ps = (String)values.get(i);
            for (int j = 0; j < PEPeerSource.PS_SOURCES.length; ++j) {
                String x = PEPeerSource.PS_SOURCES[j];
                if (!x.equals(ps)) continue;
                res.add(x);
            }
        }
        String[] x = new String[res.size()];
        res.toArray(x);
        return x;
    }

    public boolean isPeerSourceEnabled(String peerSource) {
        List values = this.getListAttributeSupport("peersources");
        return values.contains(peerSource);
    }

    public boolean isPeerSourcePermitted(String peerSource) {
        if (peerSource == "DHT" && !TorrentUtils.getDHTTrackerEnabled()) {
            return false;
        }
        return !(TorrentUtils.getPrivate(this.torrent) ? peerSource == "DHT" || peerSource == "PeerExchange" : !TorrentUtils.getDHTBackupEnabled(this.torrent) && peerSource == "DHT");
    }

    public void setPeerSources(String[] ps) {
        if (ps == null) {
            ps = new String[]{};
        }
        ArrayList<String> l = new ArrayList<String>();
        for (int i = 0; i < ps.length; ++i) {
            String p = ps[i];
            if (!this.isPeerSourcePermitted(p)) continue;
            l.add(ps[i]);
        }
        this.setListAttribute("peersources", l);
    }

    public void setPeerSourceEnabled(String source, boolean enabled) {
        int i;
        if (enabled && !this.isPeerSourcePermitted(source)) {
            return;
        }
        List values = this.getListAttributeSupport("peersources");
        boolean alreadyEnabled = values.contains(source);
        ArrayList l = new ArrayList();
        if (enabled && !alreadyEnabled) {
            for (i = 0; i < values.size(); ++i) {
                l.add(values.get(i));
            }
            l.add(source);
            this.setListAttribute("peersources", l);
        }
        if (!enabled && alreadyEnabled) {
            for (i = 0; i < values.size(); ++i) {
                l.add(values.get(i));
            }
            l.remove(source);
            this.setListAttribute("peersources", l);
        }
    }

    public void setFileLink(File link_source, File link_destination) {
        Map links = this.getFileLinks();
        File existing = (File)links.get(link_source);
        if (link_destination == null ? existing == null : existing != null && existing.equals(link_destination)) {
            return;
        }
        links.put(link_source, link_destination);
        ArrayList<String> list = new ArrayList<String>();
        Iterator it = links.keySet().iterator();
        while (it.hasNext()) {
            File source = (File)it.next();
            File target = (File)links.get(source);
            String str = source + "\n" + (target == null ? "" : target.toString());
            list.add(str);
        }
        this.setListAttribute("filelinks", list);
    }

    public void clearFileLinks() {
        Map links = this.getFileLinks();
        ArrayList<String> list = new ArrayList<String>();
        Iterator it = links.keySet().iterator();
        boolean changed = false;
        while (it.hasNext()) {
            File source = (File)it.next();
            File target = (File)links.get(source);
            if (target != null) {
                changed = true;
            }
            String str = source + "\n";
            list.add(str);
        }
        if (changed) {
            this.setListAttribute("filelinks", list);
        }
    }

    public File getFileLink(File link_source) {
        return (File)this.getFileLinks().get(link_source);
    }

    public Map getFileLinks() {
        List values = this.getListAttributeSupport("filelinks");
        HashMap<File, File> res = new HashMap<File, File>();
        for (int i = 0; i < values.size(); ++i) {
            String entry2 = (String)values.get(i);
            int sep = entry2.indexOf("\n");
            if (sep == -1) continue;
            File target = sep == entry2.length() - 1 ? null : new File(entry2.substring(sep + 1));
            res.put(new File(entry2.substring(0, sep)), target);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getStringAttribute(String attribute_name) {
        this.informWillRead(attribute_name);
        try {
            this.this_mon.enter();
            Map attributes = this.torrent.getAdditionalMapProperty(ATTRIBUTE_KEY);
            if (attributes == null || !(attributes.get(attribute_name) instanceof byte[])) {
                String string = null;
                return string;
            }
            byte[] bytes = (byte[])attributes.get(attribute_name);
            if (bytes == null) {
                String string = null;
                return string;
            }
            String string = new String(bytes, "UTF8");
            return string;
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setStringAttribute(String attribute_name, String attribute_value) {
        boolean changed;
        block12: {
            changed = false;
            try {
                this.this_mon.enter();
                HashMap<String, byte[]> attributes = this.torrent.getAdditionalMapProperty(ATTRIBUTE_KEY);
                if (attributes == null) {
                    if (attribute_value == null) {
                        return;
                    }
                    attributes = new HashMap<String, byte[]>();
                    this.torrent.setAdditionalMapProperty(ATTRIBUTE_KEY, attributes);
                }
                if (attribute_value == null) {
                    if (attributes.containsKey(attribute_name)) {
                        attributes.remove(attribute_name);
                        changed = true;
                    }
                    break block12;
                }
                try {
                    byte[] existing_bytes = (byte[])attributes.get(attribute_name);
                    byte[] new_bytes = attribute_value.getBytes("UTF8");
                    if (existing_bytes == null || !Arrays.equals(existing_bytes, new_bytes)) {
                        attributes.put(attribute_name, new_bytes);
                        changed = true;
                    }
                }
                catch (UnsupportedEncodingException e) {
                    Debug.printStackTrace(e);
                }
            }
            finally {
                this.this_mon.exit();
            }
        }
        if (changed) {
            this.write_required = true;
            this.informWritten(attribute_name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getLongAttribute(String attribute_name) {
        this.informWillRead(attribute_name);
        try {
            this.this_mon.enter();
            Map attributes = this.torrent.getAdditionalMapProperty(ATTRIBUTE_KEY);
            if (attributes == null) {
                long l = 0L;
                return l;
            }
            Long l = (Long)attributes.get(attribute_name);
            if (l == null) {
                long l2 = 0L;
                return l2;
            }
            long l3 = l;
            return l3;
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setLongAttribute(String attribute_name, long attribute_value) {
        boolean changed = false;
        try {
            Long existing_value;
            this.this_mon.enter();
            HashMap<String, Long> attributes = this.torrent.getAdditionalMapProperty(ATTRIBUTE_KEY);
            if (attributes == null) {
                attributes = new HashMap<String, Long>();
                this.torrent.setAdditionalMapProperty(ATTRIBUTE_KEY, attributes);
            }
            if ((existing_value = (Long)attributes.get(attribute_name)) == null || existing_value != attribute_value) {
                attributes.put(attribute_name, new Long(attribute_value));
                changed = true;
            }
        }
        finally {
            this.this_mon.exit();
        }
        if (changed) {
            this.write_required = true;
            this.informWritten(attribute_name);
        }
    }

    public void setListAttribute(String name, String[] values) {
        ArrayList<String> list;
        ArrayList<String> arrayList = list = values == null ? null : new ArrayList<String>();
        if (list != null) {
            for (int i = 0; i < values.length; ++i) {
                list.add(values[i]);
            }
        }
        this.setListAttribute(name, list);
    }

    public String[] getListAttribute(String attribute_name) {
        if (attribute_name == "networks") {
            return this.getNetworks();
        }
        if (attribute_name == "peersources") {
            return this.getPeerSources();
        }
        List l = this.getListAttributeSupport(attribute_name);
        if (l == null) {
            return null;
        }
        String[] res = new String[l.size()];
        for (int i = 0; i < l.size(); ++i) {
            Object o = l.get(i);
            if (!(o instanceof String)) {
                Debug.out("getListAttribute( " + attribute_name + ") - object isnt String - " + o);
                return null;
            }
            res[i] = (String)o;
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List getListAttributeSupport(String attribute_name) {
        this.informWillRead(attribute_name);
        try {
            List values;
            this.this_mon.enter();
            Map attributes = this.torrent.getAdditionalMapProperty(ATTRIBUTE_KEY);
            ArrayList<String> res = new ArrayList<String>();
            if (attributes != null && (values = (List)attributes.get(attribute_name)) != null) {
                for (int i = 0; i < values.size(); ++i) {
                    Object o = values.get(i);
                    if (o instanceof byte[]) {
                        byte[] bytes = (byte[])o;
                        try {
                            res.add(new String(bytes, "UTF8"));
                        }
                        catch (UnsupportedEncodingException e) {
                            Debug.printStackTrace(e);
                        }
                        continue;
                    }
                    if (!(o instanceof String)) continue;
                    res.add((String)o);
                }
            }
            ArrayList<String> arrayList = res;
            return arrayList;
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setListAttribute(String attribute_name, List attribute_value) {
        boolean changed = false;
        try {
            this.this_mon.enter();
            HashMap<String, List> attributes = this.torrent.getAdditionalMapProperty(ATTRIBUTE_KEY);
            if (attributes == null) {
                if (attribute_value == null) {
                    return;
                }
                attributes = new HashMap<String, List>();
                this.torrent.setAdditionalMapProperty(ATTRIBUTE_KEY, attributes);
            }
            if (attribute_value == null) {
                if (attributes.containsKey(attribute_name)) {
                    attributes.remove(attribute_name);
                    changed = true;
                }
            } else {
                List old_value = this.getListAttributeSupport(attribute_name);
                if (old_value == null || old_value.size() != attribute_value.size()) {
                    attributes.put(attribute_name, attribute_value);
                    changed = true;
                } else {
                    boolean bl = changed = !BEncoder.listsAreIdentical(old_value, attribute_value);
                    if (changed) {
                        attributes.put(attribute_name, attribute_value);
                    }
                }
            }
        }
        finally {
            this.this_mon.exit();
        }
        if (changed) {
            this.write_required = true;
            this.informWritten(attribute_name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getMapAttribute(String attribute_name) {
        this.informWillRead(attribute_name);
        try {
            this.this_mon.enter();
            Map attributes = this.torrent.getAdditionalMapProperty(ATTRIBUTE_KEY);
            if (attributes != null) {
                Map value;
                Map map = value = (Map)attributes.get(attribute_name);
                return map;
            }
            Map map = null;
            return map;
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void setMapAttribute(String attribute_name, Map attribute_value) {
        this.setMapAttribute(attribute_name, attribute_value, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setMapAttribute(String attribute_name, Map attribute_value, boolean disable_change_notification) {
        boolean changed = false;
        try {
            this.this_mon.enter();
            HashMap<String, Map> attributes = this.torrent.getAdditionalMapProperty(ATTRIBUTE_KEY);
            if (attributes == null) {
                if (attribute_value == null) {
                    return;
                }
                attributes = new HashMap<String, Map>();
                this.torrent.setAdditionalMapProperty(ATTRIBUTE_KEY, attributes);
            }
            if (attribute_value == null) {
                if (attributes.containsKey(attribute_name)) {
                    attributes.remove(attribute_name);
                    changed = true;
                }
            } else {
                Map old_value = this.getMapAttribute(attribute_name);
                if (old_value == null || old_value.size() != attribute_value.size()) {
                    attributes.put(attribute_name, attribute_value);
                    changed = true;
                } else {
                    boolean bl = changed = !BEncoder.mapsAreIdentical(old_value, attribute_value);
                    if (changed) {
                        attributes.put(attribute_name, attribute_value);
                    }
                }
            }
        }
        finally {
            this.this_mon.exit();
        }
        if (changed && !disable_change_notification) {
            this.write_required = true;
            this.informWritten(attribute_name);
        }
    }

    public static DownloadManagerState getDownloadState(DownloadManager dm) {
        return new nullState(dm);
    }

    protected void informWritten(final String attribute_name) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                ((DownloadManagerStateListener)this.listeners.get(i)).stateChanged(this, new DownloadManagerStateEvent(){

                    public int getType() {
                        return 1;
                    }

                    public Object getData() {
                        return attribute_name;
                    }
                });
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void informWillRead(final String attribute_name) {
        boolean do_it = false;
        try {
            try {
                this.this_mon.enter();
                if (!this.will_be_read_list.contains(attribute_name)) {
                    do_it = true;
                    this.will_be_read_list.add(attribute_name);
                }
            }
            finally {
                this.this_mon.exit();
            }
            if (do_it) {
                for (int i = 0; i < this.listeners.size(); ++i) {
                    try {
                        ((DownloadManagerStateListener)this.listeners.get(i)).stateChanged(this, new DownloadManagerStateEvent(){

                            public int getType() {
                                return 2;
                            }

                            public Object getData() {
                                return attribute_name;
                            }
                        });
                        continue;
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
            }
            Object var6_6 = null;
            if (!do_it) return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (!do_it) throw throwable;
            try {
                this.this_mon.enter();
                this.will_be_read_list.remove(attribute_name);
                throw throwable;
            }
            finally {
                this.this_mon.exit();
            }
        }
        try {
            this.this_mon.enter();
            this.will_be_read_list.remove(attribute_name);
            return;
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void addListener(DownloadManagerStateListener l) {
        this.listeners.add(l);
    }

    public void removeListener(DownloadManagerStateListener l) {
        this.listeners.remove(l);
    }

    static {
        if (!ACTIVE_DIR.exists()) {
            ACTIVE_DIR.mkdirs();
        }
        default_parameters = new HashMap();
        for (int i = 0; i < PARAMETERS.length; ++i) {
            default_parameters.put(PARAMETERS[i][0], PARAMETERS[i][1]);
        }
        class_mon = new AEMonitor("DownloadManagerState:class");
        state_map = new HashMap();
    }

    protected static class nullState
    implements DownloadManagerState {
        protected DownloadManager download_manager;

        protected nullState(DownloadManager _dm) {
            this.download_manager = _dm;
        }

        public TOTorrent getTorrent() {
            return null;
        }

        public File getStateFile(String name) {
            return null;
        }

        public DownloadManager getDownloadManager() {
            return this.download_manager;
        }

        public void clearResumeData() {
        }

        public Map getResumeData() {
            return new HashMap();
        }

        public void setResumeData(Map data) {
        }

        public void clearTrackerResponseCache() {
        }

        public Map getTrackerResponseCache() {
            return new HashMap();
        }

        public void setTrackerResponseCache(Map value) {
        }

        public void setFlag(long flag, boolean set) {
        }

        public boolean getFlag(long flag) {
            return false;
        }

        public int getIntParameter(String name) {
            return 0;
        }

        public void setIntParameter(String name, int value) {
        }

        public boolean getBooleanParameter(String name) {
            return false;
        }

        public void setBooleanParameter(String name, boolean value) {
        }

        public void setAttribute(String name, String value) {
        }

        public String getAttribute(String name) {
            return null;
        }

        public String getTrackerClientExtensions() {
            return null;
        }

        public void setTrackerClientExtensions(String value) {
        }

        public void setListAttribute(String name, String[] values) {
        }

        public String[] getListAttribute(String name) {
            return null;
        }

        public void setMapAttribute(String name, Map value) {
        }

        public Map getMapAttribute(String name) {
            return null;
        }

        public Category getCategory() {
            return null;
        }

        public void setCategory(Category cat) {
        }

        public String[] getNetworks() {
            return new String[0];
        }

        public boolean isNetworkEnabled(String network) {
            return false;
        }

        public void setNetworks(String[] networks) {
        }

        public void setNetworkEnabled(String network, boolean enabled) {
        }

        public String[] getPeerSources() {
            return new String[0];
        }

        public boolean isPeerSourcePermitted(String peerSource) {
            return false;
        }

        public boolean isPeerSourceEnabled(String peerSource) {
            return false;
        }

        public void setPeerSources(String[] networks) {
        }

        public void setPeerSourceEnabled(String source, boolean enabled) {
        }

        public void setFileLink(File link_source, File link_destination) {
        }

        public void clearFileLinks() {
        }

        public File getFileLink(File link_source) {
            return null;
        }

        public Map getFileLinks() {
            return new HashMap();
        }

        public void save() {
        }

        public void delete() {
        }

        public void addListener(DownloadManagerStateListener l) {
        }

        public void removeListener(DownloadManagerStateListener l) {
        }
    }
}

