/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.ipchecker.natchecker;

import com.aelitis.azureus.core.networkmanager.NetworkConnection;
import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.peermanager.messaging.MessageStreamDecoder;
import com.aelitis.azureus.core.peermanager.messaging.MessageStreamEncoder;
import com.aelitis.azureus.core.peermanager.messaging.MessageStreamFactory;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZMessageDecoder;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZMessageEncoder;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.ByteBuffer;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;

public class NatCheckerServer
extends AEThread {
    private static final LogIDs LOGID = LogIDs.NET;
    private static final String incoming_handshake = "NATCHECK_HANDSHAKE";
    private final String check;
    private ServerSocket server;
    private boolean valid = false;
    private boolean bContinue = true;
    private final boolean use_incoming_router;
    private NetworkManager.ByteMatcher matcher;

    public NatCheckerServer(int _port, String _check) {
        super("Nat Checker Server");
        this.check = _check;
        boolean bl = this.use_incoming_router = _port == COConfigurationManager.getIntParameter("TCP.Listen.Port");
        if (this.use_incoming_router) {
            this.matcher = new NetworkManager.ByteMatcher(){

                public int size() {
                    return NatCheckerServer.incoming_handshake.getBytes().length;
                }

                public int minSize() {
                    return this.size();
                }

                public boolean matches(ByteBuffer to_compare) {
                    int old_limit = to_compare.limit();
                    to_compare.limit(to_compare.position() + this.size());
                    boolean matches = to_compare.equals(ByteBuffer.wrap(NatCheckerServer.incoming_handshake.getBytes()));
                    to_compare.limit(old_limit);
                    return matches;
                }

                public boolean minMatches(ByteBuffer to_compare) {
                    return this.matches(to_compare);
                }

                public byte[] getSharedSecret() {
                    return null;
                }
            };
            NetworkManager.getSingleton().requestIncomingConnectionRouting(this.matcher, new NetworkManager.RoutingListener(){

                public void connectionRouted(NetworkConnection connection) {
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "Incoming connection from [" + connection + "] successfully routed to NAT CHECKER"));
                    }
                    try {
                        ByteBuffer msg = ByteBuffer.wrap(NatCheckerServer.this.check.getBytes());
                        while (msg.hasRemaining()) {
                            connection.getTCPTransport().getSocketChannel().write(msg);
                            Thread.sleep(20L);
                        }
                    }
                    catch (Throwable t) {
                        Debug.out("Nat check write failed", t);
                    }
                    connection.close();
                }

                public boolean autoCryptoFallback() {
                    return true;
                }
            }, new MessageStreamFactory(){

                public MessageStreamEncoder createEncoder() {
                    return new AZMessageEncoder();
                }

                public MessageStreamDecoder createDecoder() {
                    return new AZMessageDecoder();
                }
            });
            this.valid = true;
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "NAT tester using central routing for server socket"));
            }
        } else {
            try {
                String bind_ip = COConfigurationManager.getStringParameter("Bind IP", "");
                if (bind_ip.length() < 7) {
                    this.server = new ServerSocket(_port);
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "NAT tester server socket bound to port " + _port));
                    }
                } else {
                    this.server = new ServerSocket(_port, 8, InetAddress.getByName(bind_ip));
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "NAT tester server socket bound to " + bind_ip + ":" + _port));
                    }
                }
                this.valid = true;
            }
            catch (Exception e) {
                this.valid = false;
            }
        }
    }

    public void runSupport() {
        while (this.bContinue) {
            try {
                if (this.use_incoming_router) {
                    Thread.sleep(20L);
                    continue;
                }
                Socket sck = this.server.accept();
                sck.getOutputStream().write(this.check.getBytes());
                sck.close();
            }
            catch (Exception e) {
                this.bContinue = false;
            }
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    public void stopIt() {
        this.bContinue = false;
        if (this.use_incoming_router) {
            NetworkManager.getSingleton().cancelIncomingConnectionRouting(this.matcher);
        } else if (this.server != null) {
            try {
                this.server.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

