/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.logging;

import java.io.PrintStream;
import org.gudy.azureus2.core3.logging.ILogAlertListener;
import org.gudy.azureus2.core3.logging.ILogEventListener;
import org.gudy.azureus2.core3.logging.ILoggerListener;
import org.gudy.azureus2.core3.logging.LGAlertListener;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.impl.FileLogging;
import org.gudy.azureus2.core3.logging.impl.LoggerImpl;
import org.gudy.azureus2.core3.util.Debug;

public class Logger {
    private static final LogIDs LOGID = LogIDs.LOGGER;
    private static LoggerImpl loggerImpl = null;
    private static FileLogging fileLogging = new FileLogging();

    public static boolean isEnabled() {
        return loggerImpl.isEnabled();
    }

    public static void log(LogEvent event) {
        loggerImpl.log(event);
    }

    public static void log(LogAlert alert) {
        loggerImpl.log(alert);
    }

    public static void logTextResource(LogEvent event) {
        loggerImpl.logTextResource(event);
    }

    public static void logTextResource(LogEvent event, String[] params) {
        loggerImpl.logTextResource(event, params);
    }

    public static void logTextResource(LogAlert alert) {
        loggerImpl.logTextResource(alert);
    }

    public static void logTextResource(LogAlert alert, String[] params) {
        loggerImpl.logTextResource(alert, params);
    }

    public static void doRedirects() {
        loggerImpl.doRedirects();
    }

    public static void addListener(ILoggerListener aListener) {
        loggerImpl.addListener(aListener);
    }

    public static void removeListener(ILoggerListener aListener) {
        loggerImpl.removeListener(aListener);
    }

    public static void addListener(ILogEventListener aListener) {
        loggerImpl.addListener(aListener);
    }

    public static void addListener(LGAlertListener aListener) {
        loggerImpl.addListener(aListener);
    }

    public static void addListener(ILogAlertListener aListener) {
        loggerImpl.addListener(aListener);
    }

    public static void removeListener(ILogEventListener aListener) {
        loggerImpl.removeListener(aListener);
    }

    public static void removeListener(LGAlertListener aListener) {
        loggerImpl.removeListener(aListener);
    }

    public static void removeListener(ILogAlertListener aListener) {
        loggerImpl.removeListener(aListener);
    }

    public static PrintStream getOldStdErr() {
        return loggerImpl.getOldStdErr();
    }

    static {
        try {
            loggerImpl = new LoggerImpl();
            loggerImpl.init();
            fileLogging.initialize();
            Logger.log(new LogEvent(LOGID, "**** Logging starts: 2.3.0.7_B51 ****"));
            Logger.log(new LogEvent(LOGID, "java.home=" + System.getProperty("java.home")));
            Logger.log(new LogEvent(LOGID, "java.version=" + System.getProperty("java.version")));
            Logger.log(new LogEvent(LOGID, "os=" + System.getProperty("os.arch") + "/" + System.getProperty("os.name") + "/" + System.getProperty("os.version")));
            Logger.log(new LogEvent(LOGID, "user.dir=" + System.getProperty("user.dir")));
            Logger.log(new LogEvent(LOGID, "user.home=" + System.getProperty("user.home")));
        }
        catch (Throwable t) {
            Debug.out("Error initializing Logger", t);
        }
    }
}

