/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.peer.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.peer.PEPiece;
import org.gudy.azureus2.core3.peer.impl.PEPieceWriteImpl;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.SystemTime;

public class PEPieceImpl
implements PEPiece {
    private static final LogIDs LOGID = LogIDs.PIECES;
    private final DiskManagerPiece dmPiece;
    private final PEPeerManager manager;
    private final int nbBlocks;
    private long creationTime = SystemTime.getCurrentTime();
    private final String[] requested;
    private final boolean[] downloaded;
    private final String[] writers;
    private List writes;
    private String reservedBy;
    private int speed;
    private long resumePriority;
    protected static AEMonitor class_mon = new AEMonitor("PEPiece:class");

    public PEPieceImpl(PEPeerManager _manager, DiskManagerPiece _dm_piece, int _pieceSpeed) {
        this.manager = _manager;
        this.dmPiece = _dm_piece;
        this.speed = _pieceSpeed;
        this.nbBlocks = this.dmPiece.getNbBlocks();
        this.requested = new String[this.nbBlocks];
        boolean[] written = this.dmPiece.getWritten();
        this.downloaded = written == null ? new boolean[this.nbBlocks] : (boolean[])written.clone();
        this.writers = new String[this.nbBlocks];
        this.writes = new ArrayList(0);
    }

    public DiskManagerPiece getDMPiece() {
        return this.dmPiece;
    }

    public long getCreationTime() {
        long now = SystemTime.getCurrentTime();
        if (now >= this.creationTime && this.creationTime > 0L) {
            return this.creationTime;
        }
        this.creationTime = now;
        return now;
    }

    public long getTimeSinceLastActivity() {
        long now = SystemTime.getCurrentTime();
        long lastWriteTime = this.dmPiece.getLastWriteTime();
        if (lastWriteTime > 0L && now >= lastWriteTime) {
            return now - lastWriteTime;
        }
        if (this.creationTime > 0L && now >= this.creationTime) {
            return now - this.creationTime;
        }
        this.creationTime = now;
        return 0L;
    }

    public boolean isRequested(int blockNumber) {
        return this.requested[blockNumber] != null;
    }

    public boolean isDownloaded(int blockNumber) {
        return this.downloaded[blockNumber];
    }

    public void setDownloaded(int offset) {
        this.downloaded[offset / 16384] = true;
        for (int i = 0; i < this.nbBlocks; ++i) {
            if (this.downloaded[i]) continue;
            return;
        }
        this.dmPiece.setDownloaded();
        this.dmPiece.clearRequested();
    }

    public void clearDownloaded(int offset) {
        this.downloaded[offset / 16384] = false;
        this.dmPiece.clearDownloaded();
    }

    public void setWritten(PEPeer peer, int blockNumber) {
        this.writers[blockNumber] = peer.getIp();
        this.dmPiece.setWritten(blockNumber);
    }

    public void clearRequested(int blockNumber) {
        this.requested[blockNumber] = this.downloaded[blockNumber] ? this.writers[blockNumber] : null;
    }

    public void unmarkBlock(int blockNumber) {
        this.requested[blockNumber] = this.downloaded[blockNumber] ? this.writers[blockNumber] : null;
    }

    public boolean hasUnrequestedBlock() {
        boolean[] written = this.dmPiece.getWritten();
        for (int i = 0; i < this.nbBlocks; ++i) {
            if (this.downloaded[i] || this.requested[i] != null || written != null && written[i]) continue;
            return true;
        }
        return false;
    }

    public int[] getAndMarkBlocks(PEPeer peer, int nbWanted) {
        String ip = peer.getIp();
        boolean[] written = this.dmPiece.getWritten();
        int blocksFound = 0;
        for (int i = 0; i < this.nbBlocks; ++i) {
            while (!(blocksFound >= nbWanted || i + blocksFound >= this.nbBlocks || this.downloaded[i + blocksFound] || this.requested[i + blocksFound] != null || written != null && written[i])) {
                this.requested[i + blocksFound] = ip;
                ++blocksFound;
            }
            if (blocksFound <= 0) continue;
            return new int[]{i, blocksFound};
        }
        return new int[]{-1, 0};
    }

    public int getNbRequests() {
        int result = 0;
        for (int i = 0; i < this.nbBlocks; ++i) {
            if (this.downloaded[i] || this.requested[i] == null) continue;
            ++result;
        }
        return result;
    }

    public int getNbUnrequested() {
        int result = 0;
        boolean[] written = this.dmPiece.getWritten();
        for (int i = 0; i < this.nbBlocks; ++i) {
            if (this.downloaded[i] || this.requested[i] != null || written != null && written[i]) continue;
            ++result;
        }
        return result;
    }

    public boolean setRequested(PEPeer peer, int blockNumber) {
        if (!this.downloaded[blockNumber]) {
            this.requested[blockNumber] = peer.getIp();
            return true;
        }
        return false;
    }

    public int getBlockSize(int blockNumber) {
        int length;
        if (blockNumber == this.nbBlocks - 1 && (length = this.dmPiece.getLength()) % 16384 != 0) {
            return length % 16384;
        }
        return 16384;
    }

    public int getBlockNumber(int offset) {
        return offset / 16384;
    }

    public int getNbBlocks() {
        return this.nbBlocks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getPieceWrites() {
        ArrayList result;
        try {
            class_mon.enter();
            result = new ArrayList(this.writes);
        }
        finally {
            class_mon.exit();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getPieceWrites(int blockNumber) {
        ArrayList result;
        try {
            class_mon.enter();
            result = new ArrayList(this.writes);
        }
        finally {
            class_mon.exit();
        }
        Iterator iter = result.iterator();
        while (iter.hasNext()) {
            PEPieceWriteImpl write = (PEPieceWriteImpl)iter.next();
            if (write.getBlockNumber() == blockNumber) continue;
            iter.remove();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getPieceWrites(PEPeer peer) {
        ArrayList result;
        try {
            class_mon.enter();
            result = new ArrayList(this.writes);
        }
        finally {
            class_mon.exit();
        }
        Iterator iter = result.iterator();
        while (iter.hasNext()) {
            PEPieceWriteImpl write = (PEPieceWriteImpl)iter.next();
            if (peer != null && peer.equals(write.getSender())) continue;
            iter.remove();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getPieceWrites(String ip) {
        ArrayList result;
        try {
            class_mon.enter();
            result = new ArrayList(this.writes);
        }
        finally {
            class_mon.exit();
        }
        Iterator iter = result.iterator();
        while (iter.hasNext()) {
            PEPieceWriteImpl write = (PEPieceWriteImpl)iter.next();
            if (write.getSender().equals(ip)) continue;
            iter.remove();
        }
        return result;
    }

    public void reset() {
        this.dmPiece.reset();
        for (int i = 0; i < this.nbBlocks; ++i) {
            this.requested[i] = null;
            this.downloaded[i] = false;
            this.writers[i] = null;
        }
        this.reservedBy = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addWrite(PEPieceWriteImpl write) {
        try {
            class_mon.enter();
            this.writes.add(write);
        }
        finally {
            class_mon.exit();
        }
    }

    public void addWrite(int blockNumber, String sender, byte[] hash, boolean correct) {
        this.addWrite(new PEPieceWriteImpl(blockNumber, sender, hash, correct));
    }

    public String[] getWriters() {
        return this.writers;
    }

    public int getSpeed() {
        return this.speed;
    }

    public void setSpeed(int newSpeed) {
        this.speed = newSpeed;
    }

    public void decSpeed() {
        if (this.speed > 0) {
            --this.speed;
        }
    }

    public void incSpeed() {
        ++this.speed;
    }

    public PEPeerManager getManager() {
        return this.manager;
    }

    public void setReservedBy(String peer) {
        this.reservedBy = peer;
    }

    public String getReservedBy() {
        return this.reservedBy;
    }

    public void reDownloadBlock(int blockNumber) {
        this.downloaded[blockNumber] = false;
        this.requested[blockNumber] = null;
        this.dmPiece.reDownloadBlock(blockNumber);
    }

    public void reDownloadBlocks(String address) {
        for (int i = 0; i < this.writers.length; ++i) {
            String writer = this.writers[i];
            if (writer == null || !writer.equals(address)) continue;
            this.reDownloadBlock(i);
        }
    }

    public void setResumePriority(long p) {
        this.resumePriority = p;
    }

    public long getResumePriority() {
        return this.resumePriority;
    }

    public int getAvailability() {
        return this.manager.getAvailability(this.dmPiece.getPieceNumber());
    }

    public int getNbWritten() {
        return this.dmPiece.getNbWritten();
    }

    public boolean[] getWritten() {
        return this.dmPiece.getWritten();
    }

    public int getPieceNumber() {
        return this.dmPiece.getPieceNumber();
    }

    public int getLength() {
        return this.dmPiece.getLength();
    }

    public boolean isWritten() {
        return this.dmPiece.isWritten();
    }

    public void setRequestable() {
        this.dmPiece.setRequestable();
    }

    public boolean isChecking() {
        return this.dmPiece.isChecking();
    }
}

