/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.stats.transfer.impl;

import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerStats;
import org.gudy.azureus2.core3.global.impl.GlobalManagerAdpater;
import org.gudy.azureus2.core3.stats.transfer.OverallStats;
import org.gudy.azureus2.core3.stats.transfer.YearStatsList;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

public class OverallStatsImpl
extends GlobalManagerAdpater
implements OverallStats,
TimerEventPerformer {
    GlobalManager manager;
    Map statisticsMap;
    Map overallMap;
    long totalDownloaded;
    long totalUploaded;
    long totalUptime;
    long lastDownloaded;
    long lastUploaded;
    long lastUptime;
    long session_start_time = SystemTime.getCurrentTime();
    protected AEMonitor this_mon = new AEMonitor("OverallStats");

    private void load(String filename) {
        this.statisticsMap = FileUtil.readResilientConfigFile(filename);
    }

    private void load() {
        this.load("azureus.statistics");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save(String filename) {
        try {
            this.this_mon.enter();
            FileUtil.writeResilientConfigFile(filename, this.statisticsMap);
        }
        finally {
            this.this_mon.exit();
        }
    }

    private void save() {
        this.save("azureus.statistics");
    }

    private void validateAndLoadValues() {
        this.overallMap = (Map)this.statisticsMap.get("all");
        if (this.overallMap == null) {
            this.overallMap = new HashMap();
            this.overallMap.put("downloaded", new Long(0L));
            this.overallMap.put("uploaded", new Long(0L));
            this.overallMap.put("uptime", new Long(0L));
            this.statisticsMap.put("all", this.overallMap);
        }
        try {
            this.totalDownloaded = (Long)this.overallMap.get("downloaded");
            this.totalUploaded = (Long)this.overallMap.get("uploaded");
            this.totalUptime = (Long)this.overallMap.get("uptime");
            this.lastUptime = SystemTime.getCurrentTime() / 1000L;
        }
        catch (Throwable e) {
            Debug.out("Stats invalid, resetting to 0");
            this.save();
        }
    }

    public OverallStatsImpl(GlobalManager manager) {
        this.manager = manager;
        manager.addListener(this);
        this.load();
        this.validateAndLoadValues();
        SimpleTimer.addPeriodicEvent(60000L, this);
    }

    public String getXMLExport() {
        return null;
    }

    public YearStatsList getYearStats() {
        return null;
    }

    public void setLogLevel(int logLevel) {
    }

    public int getAverageDownloadSpeed() {
        if (this.totalUptime > 1L) {
            return (int)(this.totalDownloaded / this.totalUptime);
        }
        return 0;
    }

    public int getAverageUploadSpeed() {
        if (this.totalUptime > 1L) {
            return (int)(this.totalUploaded / this.totalUptime);
        }
        return 0;
    }

    public long getDownloadedBytes() {
        return this.totalDownloaded;
    }

    public long getUploadedBytes() {
        return this.totalUploaded;
    }

    public long getTotalUpTime() {
        return this.totalUptime;
    }

    public long getSessionUpTime() {
        return (SystemTime.getCurrentTime() - this.session_start_time) / 1000L;
    }

    public void perform(TimerEvent event) {
        this.updateStats();
    }

    public void destroyInitiated() {
        this.updateStats();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStats() {
        try {
            this.this_mon.enter();
            long current_time = SystemTime.getCurrentTime() / 1000L;
            if (current_time < this.lastUptime) {
                this.lastUptime = current_time;
                return;
            }
            GlobalManagerStats stats = this.manager.getStats();
            long current_total_received = stats.getTotalDataBytesReceived() + stats.getTotalProtocolBytesReceived();
            long current_total_sent = stats.getTotalDataBytesSent() + stats.getTotalProtocolBytesSent();
            this.totalDownloaded += current_total_received - this.lastDownloaded;
            this.lastDownloaded = current_total_received;
            this.totalUploaded += current_total_sent - this.lastUploaded;
            this.lastUploaded = current_total_sent;
            long delta = current_time - this.lastUptime;
            if (delta > 100L || delta < 0L) {
                this.lastUptime = current_time;
                return;
            }
            if (this.totalUptime > 315360000L) {
                this.totalUptime = 0L;
            }
            this.totalUptime += delta;
            this.lastUptime = current_time;
            this.overallMap.put("downloaded", new Long(this.totalDownloaded));
            this.overallMap.put("uploaded", new Long(this.totalUploaded));
            this.overallMap.put("uptime", new Long(this.totalUptime));
            this.save();
        }
        finally {
            this.this_mon.exit();
        }
    }
}

