/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.client.impl;

import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncer;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerException;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerFactoryListener;
import org.gudy.azureus2.core3.tracker.client.impl.TRTrackerAnnouncerImpl;
import org.gudy.azureus2.core3.tracker.client.impl.bt.TRTrackerBTAnnouncerImpl;
import org.gudy.azureus2.core3.tracker.client.impl.dht.TRTrackerDHTAnnouncerImpl;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.TorrentUtils;

public class TRTrackerAnnouncerFactoryImpl {
    protected static List listeners = new ArrayList();
    protected static List clients = new ArrayList();
    protected static AEMonitor class_mon = new AEMonitor("TRTrackerClientFactory");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TRTrackerAnnouncer create(TOTorrent torrent, String[] networks) throws TRTrackerAnnouncerException {
        TRTrackerAnnouncerImpl client = TorrentUtils.isDecentralised(torrent) ? new TRTrackerDHTAnnouncerImpl(torrent, networks) : new TRTrackerBTAnnouncerImpl(torrent, networks);
        ArrayList listeners_copy = new ArrayList();
        try {
            class_mon.enter();
            clients.add(client);
            listeners_copy = new ArrayList(listeners);
        }
        finally {
            class_mon.exit();
        }
        for (int i = 0; i < listeners_copy.size(); ++i) {
            try {
                ((TRTrackerAnnouncerFactoryListener)listeners_copy.get(i)).clientCreated(client);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addListener(TRTrackerAnnouncerFactoryListener l) {
        ArrayList clients_copy;
        try {
            class_mon.enter();
            listeners.add(l);
            clients_copy = new ArrayList(clients);
        }
        finally {
            class_mon.exit();
        }
        for (int i = 0; i < clients_copy.size(); ++i) {
            try {
                l.clientCreated((TRTrackerAnnouncer)clients_copy.get(i));
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeListener(TRTrackerAnnouncerFactoryListener l) {
        try {
            class_mon.enter();
            listeners.remove(l);
        }
        finally {
            class_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroy(TRTrackerAnnouncer client) {
        ArrayList listeners_copy = new ArrayList();
        try {
            class_mon.enter();
            clients.remove(client);
            listeners_copy = new ArrayList(listeners);
        }
        finally {
            class_mon.exit();
        }
        for (int i = 0; i < listeners_copy.size(); ++i) {
            try {
                ((TRTrackerAnnouncerFactoryListener)listeners_copy.get(i)).clientDestroyed(client);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }
}

