/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.server.impl.tcp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import org.bouncycastle.util.encoders.Base64;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerPeerImpl;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerProcessor;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerTorrentImpl;
import org.gudy.azureus2.core3.tracker.server.impl.tcp.TRTrackerServerTCP;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.SHA1Hasher;

public abstract class TRTrackerServerProcessorTCP
extends TRTrackerServerProcessor {
    protected static final int SOCKET_TIMEOUT = 5000;
    protected static final char CR = '\r';
    protected static final char FF = '\n';
    protected static final String NL = "\r\n";
    protected static final byte[] HTTP_RESPONSE_START = "HTTP/1.1 200 OK\r\nContent-Type: text/html\r\nServer: Azureus 2.3.0.7_B51\r\nConnection: close\r\nContent-Length: ".getBytes();
    protected static final byte[] HTTP_RESPONSE_END_GZIP = "\r\nContent-Encoding: gzip\r\n\r\n".getBytes();
    protected static final byte[] HTTP_RESPONSE_END_NOGZIP = "\r\n\r\n".getBytes();
    private TRTrackerServerTCP server;
    private String server_url;
    private boolean disable_timeouts = false;

    protected TRTrackerServerProcessorTCP(TRTrackerServerTCP _server) {
        this.server = _server;
        this.server_url = (this.server.isSSL() ? "https" : "http") + "://" + this.server.getHost() + ":" + this.server.getPort();
    }

    protected boolean areTimeoutsDisabled() {
        return this.disable_timeouts;
    }

    protected void setTimeoutsDisabled(boolean d) {
        this.disable_timeouts = d;
    }

    protected TRTrackerServerTCP getServer() {
        return this.server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void processRequest(String input_header, String lowercase_input_header, String url_path, String client_ip_address, boolean announce_and_scrape_only, InputStream is, OutputStream os) throws IOException {
        int request_type;
        boolean gzip_reply;
        TRTrackerServerTorrentImpl specific_torrent;
        Map root;
        String str;
        block65: {
            block62: {
                block64: {
                    String user;
                    block63: {
                        str = url_path;
                        root = null;
                        specific_torrent = null;
                        gzip_reply = false;
                        if (str.startsWith("/announce?")) {
                            request_type = 1;
                            str = str.substring(10);
                            break block62;
                        }
                        if (str.startsWith("/scrape?")) {
                            request_type = 2;
                            str = str.substring(8);
                            break block62;
                        }
                        if (str.equals("/scrape")) {
                            request_type = 3;
                            str = "";
                            break block62;
                        }
                        if (announce_and_scrape_only) {
                            throw new Exception("Tracker only supports announce and scrape functions");
                        }
                        this.setTaskState("external request");
                        this.disable_timeouts = true;
                        user = this.doAuthentication(url_path, input_header, os, false);
                        if (user != null) break block63;
                        this.setTaskState("final os flush");
                        os.flush();
                        return;
                    }
                    if (!this.handleExternalRequest(client_ip_address, user, str, input_header, is, os)) break block64;
                    this.setTaskState("final os flush");
                    os.flush();
                    return;
                }
                os.write("HTTP/1.1 404 Not Found\r\n\r\n".getBytes());
                os.flush();
                this.setTaskState("final os flush");
                os.flush();
                return;
            }
            if (this.doAuthentication(url_path, input_header, os, true) != null) break block65;
            this.setTaskState("final os flush");
            os.flush();
            return;
        }
        try {
            int e_pos;
            int enc_pos = lowercase_input_header.indexOf("accept-encoding:");
            if (enc_pos != -1 && (e_pos = input_header.indexOf(NL, enc_pos)) != -1) {
                String accept_encoding;
                int gzip_index;
                char c;
                if (enc_pos > 0 && (c = lowercase_input_header.charAt(enc_pos - 1)) != '\n' && c != ' ') {
                    enc_pos = -1;
                }
                if (enc_pos != -1 && (gzip_index = (accept_encoding = lowercase_input_header.substring(enc_pos + 16, e_pos)).indexOf("gzip")) != -1) {
                    gzip_reply = true;
                    if (accept_encoding.length() - gzip_index >= 8) {
                        char c2;
                        char[] chars = accept_encoding.toCharArray();
                        boolean q_value = false;
                        for (int i = gzip_index + 4; i < chars.length && (c2 = chars[i]) != ','; ++i) {
                            if (c2 == '=') {
                                q_value = true;
                                gzip_reply = false;
                                continue;
                            }
                            if (!q_value || c2 == ' ' || c2 == '0' || c2 == '.') continue;
                            gzip_reply = true;
                            break;
                        }
                    }
                }
            }
            this.setTaskState("decoding announce/scrape");
            int pos = 0;
            byte[] hash = null;
            ArrayList<byte[]> hash_list = null;
            HashWrapper peer_id = null;
            int port = 0;
            String event = null;
            long uploaded = 0L;
            long downloaded = 0L;
            long left = 0L;
            int num_want = -1;
            boolean no_peer_id = false;
            boolean compact = false;
            String key = null;
            while (pos < str.length()) {
                String token;
                int p1 = str.indexOf(38, pos);
                if (p1 == -1) {
                    token = str.substring(pos);
                } else {
                    token = str.substring(pos, p1);
                    pos = p1 + 1;
                }
                int p2 = token.indexOf(61);
                if (p2 == -1) {
                    throw new Exception("format invalid");
                }
                String lhs = token.substring(0, p2).toLowerCase();
                String rhs = URLDecoder.decode(token.substring(p2 + 1), "ISO-8859-1");
                if (lhs.equals("info_hash")) {
                    byte[] b = rhs.getBytes("ISO-8859-1");
                    if (hash == null) {
                        hash = b;
                    } else {
                        if (hash_list == null) {
                            hash_list = new ArrayList<byte[]>();
                            hash_list.add(hash);
                        }
                        hash_list.add(b);
                    }
                } else if (lhs.equals("peer_id")) {
                    peer_id = new HashWrapper(rhs.getBytes("ISO-8859-1"));
                } else if (lhs.equals("no_peer_id")) {
                    no_peer_id = rhs.equals("1");
                } else if (lhs.equals("compact")) {
                    if (this.server.isCompactEnabled()) {
                        compact = rhs.equals("1");
                    }
                } else if (lhs.equals("key")) {
                    if (this.server.isKeyEnabled()) {
                        key = rhs;
                    }
                } else if (lhs.equals("port")) {
                    port = Integer.parseInt(rhs);
                } else if (lhs.equals("event")) {
                    event = rhs;
                } else if (lhs.equals("ip")) {
                    client_ip_address = rhs;
                } else if (lhs.equals("uploaded")) {
                    uploaded = Long.parseLong(rhs);
                } else if (lhs.equals("downloaded")) {
                    downloaded = Long.parseLong(rhs);
                } else if (lhs.equals("left")) {
                    left = Long.parseLong(rhs);
                } else if (lhs.equals("numwant")) {
                    num_want = Integer.parseInt(rhs);
                }
                if (p1 != -1) continue;
            }
            Object hashes = null;
            if (hash_list != null) {
                hashes = new byte[hash_list.size()][];
                hash_list.toArray((T[])hashes);
            } else if (hash != null) {
                hashes = new byte[][]{hash};
            }
            Map[] root_out = new Map[1];
            TRTrackerServerPeerImpl[] peer_out = new TRTrackerServerPeerImpl[1];
            specific_torrent = this.processTrackerRequest(this.server, str, root_out, peer_out, request_type, (byte[][])hashes, peer_id, no_peer_id, compact, key, event, port, client_ip_address, downloaded, uploaded, left, num_want);
            root = root_out[0];
            if (root.get("_data") == null) {
                this.server.postProcess(peer_out[0], specific_torrent, request_type, str, root);
            }
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (message == null || message.length() == 0) {
                message = e.toString();
            }
            root = new HashMap<String, Object>();
            root.put("failure reason", message);
        }
        {
            this.setTaskState("writing response");
            byte[] data = (byte[])root.get("_data");
            if (data == null) {
                data = BEncoder.encode(root);
                root.put("_data", data);
            }
            if (gzip_reply) {
                byte[] gzip_data = (byte[])root.get("_gzipdata");
                if (gzip_data == null) {
                    ByteArrayOutputStream tos = new ByteArrayOutputStream(data.length);
                    GZIPOutputStream gos = new GZIPOutputStream(tos);
                    gos.write(data);
                    gos.close();
                    gzip_data = tos.toByteArray();
                    root.put("_gzipdata", gzip_data);
                }
                data = gzip_data;
            }
            this.setTaskState("writing header");
            os.write(HTTP_RESPONSE_START);
            byte[] length_bytes = String.valueOf(data.length).getBytes();
            os.write(length_bytes);
            int header_len = HTTP_RESPONSE_START.length + length_bytes.length;
            this.setTaskState("writing content");
            if (gzip_reply) {
                os.write(HTTP_RESPONSE_END_GZIP);
                header_len += HTTP_RESPONSE_END_GZIP.length;
            } else {
                os.write(HTTP_RESPONSE_END_NOGZIP);
                header_len += HTTP_RESPONSE_END_NOGZIP.length;
            }
            os.write(data);
            this.server.updateStats(specific_torrent, input_header.length(), header_len + data.length);
            return;
        }
        finally {
            this.setTaskState("final os flush");
            os.flush();
        }
    }

    protected String doAuthentication(String url_path, String header, OutputStream os, boolean tracker) throws IOException {
        boolean apply_torrent_password;
        boolean apply_web_password = !tracker && this.server.isWebPasswordEnabled();
        boolean bl = apply_torrent_password = tracker && this.server.isTrackerPasswordEnabled();
        if (apply_web_password && this.server.isWebPasswordHTTPSOnly() && !this.server.isSSL()) {
            os.write("HTTP/1.1 403 BAD\r\n\r\nAccess Denied\r\n".getBytes());
            os.flush();
            return null;
        }
        if (apply_torrent_password || apply_web_password) {
            int x = header.indexOf("Authorization:");
            if (x == -1) {
                if (this.server.hasExternalAuthorisation()) {
                    try {
                        String resource_str = (this.server.isSSL() ? "https" : "http") + "://" + this.server.getHost() + ":" + this.server.getPort() + url_path;
                        URL resource = new URL(resource_str);
                        if (this.server.performExternalAuthorisation(resource, "", "")) {
                            return "";
                        }
                    }
                    catch (MalformedURLException e) {
                        Debug.printStackTrace(e);
                    }
                }
            } else {
                int p1 = header.indexOf(32, x);
                int p2 = header.indexOf(32, p1 + 1);
                String body = header.substring(p2, header.indexOf(13, p2)).trim();
                String decoded = new String(Base64.decode(body));
                int cp = decoded.indexOf(58);
                String user = decoded.substring(0, cp);
                String pw = decoded.substring(cp + 1);
                boolean auth_failed = false;
                if (this.server.hasExternalAuthorisation()) {
                    try {
                        String resource_str = (this.server.isSSL() ? "https" : "http") + "://" + this.server.getHost() + ":" + this.server.getPort() + url_path;
                        URL resource = new URL(resource_str);
                        if (this.server.performExternalAuthorisation(resource, user, pw)) {
                            return user;
                        }
                    }
                    catch (MalformedURLException e) {
                        Debug.printStackTrace(e);
                    }
                    auth_failed = true;
                }
                if (this.server.hasInternalAuthorisation() && !auth_failed) {
                    try {
                        byte[] internal_pw;
                        SHA1Hasher hasher = new SHA1Hasher();
                        byte[] password = pw.getBytes();
                        byte[] encoded = password.length > 0 ? hasher.calculateHash(password) : new byte[]{};
                        if (user.equals("<internal>") ? Arrays.equals(internal_pw = Base64.decode(pw), this.server.getPassword()) : user.equalsIgnoreCase(this.server.getUsername()) && Arrays.equals(encoded, this.server.getPassword())) {
                            return user;
                        }
                    }
                    catch (Exception e) {
                        Debug.printStackTrace(e);
                    }
                }
            }
            os.write(("HTTP/1.1 401 BAD\r\nWWW-Authenticate: Basic realm=\"" + this.server.getName() + "\"\r\n\r\nAccess Denied\r\n").getBytes());
            os.flush();
            return null;
        }
        return "";
    }

    protected boolean handleExternalRequest(String client_address, String user, String url, String header, InputStream is, OutputStream os) throws IOException {
        URL absolute_url = new URL(this.server_url + (url.startsWith("/") ? url : "/" + url));
        return this.server.handleExternalRequest(client_address, user, url, absolute_url, header, is, os);
    }
}

