/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

public class Semaphore {
    int waiting = 0;
    int dont_wait = 0;
    int total_reserve = 0;
    int total_release = 0;
    boolean released_forever = false;

    public Semaphore() {
    }

    public Semaphore(int count) {
        this.dont_wait = count;
        this.total_release = count;
    }

    public void reserve() {
        this.reserve(0L);
    }

    public boolean reserve(long millis) {
        return this.reserveSupport(millis, 1) == 1;
    }

    public int reserveSet(int max_to_reserve) {
        return this.reserveSupport(0L, max_to_reserve);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int reserveSupport(long millis, int max_to_reserve) {
        Semaphore semaphore = this;
        synchronized (semaphore) {
            if (this.released_forever) {
                return 1;
            }
            if (this.dont_wait == 0) {
                try {
                    ++this.waiting;
                    if (millis == 0L) {
                        this.wait();
                    } else {
                        this.wait(millis);
                    }
                    if (this.total_reserve == this.total_release) {
                        --this.waiting;
                        return 0;
                    }
                    ++this.total_reserve;
                    return 1;
                }
                catch (Throwable e) {
                    --this.waiting;
                    System.err.println("**** semaphore operation interrupted ****");
                    throw new RuntimeException("Semaphore: operation interrupted");
                }
            }
            int num_to_get = max_to_reserve > this.dont_wait ? this.dont_wait : max_to_reserve;
            this.dont_wait -= num_to_get;
            this.total_reserve += num_to_get;
            return num_to_get;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Semaphore semaphore = this;
        synchronized (semaphore) {
            ++this.total_release;
            if (this.waiting != 0) {
                --this.waiting;
                this.notify();
            } else {
                ++this.dont_wait;
            }
        }
    }

    public void releaseAllWaiters() {
        int x = this.waiting;
        for (int i = 0; i < x; ++i) {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseForever() {
        Semaphore semaphore = this;
        synchronized (semaphore) {
            this.releaseAllWaiters();
            this.released_forever = true;
        }
    }

    public int getValue() {
        return this.dont_wait - this.waiting;
    }
}

