/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.plugins.utils;

import java.io.File;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.Map;
import org.gudy.azureus2.plugins.PluginException;
import org.gudy.azureus2.plugins.utils.AggregatedDispatcher;
import org.gudy.azureus2.plugins.utils.AggregatedList;
import org.gudy.azureus2.plugins.utils.AggregatedListAcceptor;
import org.gudy.azureus2.plugins.utils.ByteArrayWrapper;
import org.gudy.azureus2.plugins.utils.Formatters;
import org.gudy.azureus2.plugins.utils.LocaleUtilities;
import org.gudy.azureus2.plugins.utils.Monitor;
import org.gudy.azureus2.plugins.utils.PooledByteBuffer;
import org.gudy.azureus2.plugins.utils.Semaphore;
import org.gudy.azureus2.plugins.utils.UTTimer;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderException;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderFactory;
import org.gudy.azureus2.plugins.utils.resourceuploader.ResourceUploaderFactory;
import org.gudy.azureus2.plugins.utils.security.SESecurityManager;
import org.gudy.azureus2.plugins.utils.xml.rss.RSSFeed;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentException;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentFactory;

public interface Utilities {
    public String getAzureusUserDir();

    public String getAzureusProgramDir();

    public boolean isCVSVersion();

    public boolean isWindows();

    public boolean isLinux();

    public boolean isSolaris();

    public boolean isOSX();

    public InputStream getImageAsStream(String var1);

    public Semaphore getSemaphore();

    public Monitor getMonitor();

    public ByteBuffer allocateDirectByteBuffer(int var1);

    public void freeDirectByteBuffer(ByteBuffer var1);

    public PooledByteBuffer allocatePooledByteBuffer(int var1);

    public PooledByteBuffer allocatePooledByteBuffer(byte[] var1);

    public Formatters getFormatters();

    public LocaleUtilities getLocaleUtilities();

    public UTTimer createTimer(String var1);

    public UTTimer createTimer(String var1, boolean var2);

    public void createThread(String var1, Runnable var2);

    public void createProcess(String var1) throws PluginException;

    public ResourceDownloaderFactory getResourceDownloaderFactory();

    public ResourceUploaderFactory getResourceUploaderFactory();

    public SESecurityManager getSecurityManager();

    public SimpleXMLParserDocumentFactory getSimpleXMLParserDocumentFactory();

    public RSSFeed getRSSFeed(URL var1) throws ResourceDownloaderException, SimpleXMLParserDocumentException;

    public RSSFeed getRSSFeed(ResourceDownloader var1) throws ResourceDownloaderException, SimpleXMLParserDocumentException;

    public InetAddress getPublicAddress();

    public String reverseDNSLookup(InetAddress var1);

    public long getCurrentSystemTime();

    public ByteArrayWrapper createWrapper(byte[] var1);

    public AggregatedDispatcher createAggregatedDispatcher(long var1, long var3);

    public AggregatedList createAggregatedList(AggregatedListAcceptor var1, long var2, long var4);

    public Map readResilientBEncodedFile(File var1, String var2, boolean var3);

    public void writeResilientBEncodedFile(File var1, String var2, Map var3, boolean var4);

    public int compareVersions(String var1, String var2);
}

