/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import org.gudy.azureus2.core3.html.HTMLException;
import org.gudy.azureus2.core3.html.HTMLPage;
import org.gudy.azureus2.core3.html.HTMLPageFactory;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderException;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderListener;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderBaseImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderURLImpl;

public class ResourceDownloaderMetaRefreshImpl
extends ResourceDownloaderBaseImpl
implements ResourceDownloaderListener {
    public static final int MAX_FOLLOWS = 1;
    protected ResourceDownloaderBaseImpl delegate;
    protected ResourceDownloaderBaseImpl current_delegate;
    protected long size = -2L;
    protected boolean cancelled;
    protected ResourceDownloader current_downloader;
    protected Object result;
    protected int done_count;
    protected AESemaphore done_sem = new AESemaphore("RDMetaRefresh");

    public ResourceDownloaderMetaRefreshImpl(ResourceDownloaderBaseImpl _parent, ResourceDownloader _delegate) {
        super(_parent);
        this.delegate = (ResourceDownloaderBaseImpl)_delegate;
        this.delegate.setParent(this);
        this.current_delegate = this.delegate;
    }

    public String getName() {
        return this.delegate.getName() + ": meta-refresh";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSize() throws ResourceDownloaderException {
        if (this.size == -2L) {
            try {
                this.size = this.getSizeSupport();
                Object var2_1 = null;
                if (this.size == -2L) {
                    this.size = -1L;
                }
                this.setSize(this.size);
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                if (this.size == -2L) {
                    this.size = -1L;
                }
                this.setSize(this.size);
                throw throwable;
            }
        }
        return this.size;
    }

    protected void setSize(long l) {
        this.size = l;
        if (this.size >= 0L) {
            this.delegate.setSize(this.size);
        }
    }

    protected void setProperty(String name, Object value) {
        this.setPropertySupport(name, value);
        this.delegate.setProperty(name, value);
    }

    protected long getSizeSupport() throws ResourceDownloaderException {
        try {
            ResourceDownloaderBaseImpl x = this.delegate.getClone(this);
            this.addReportListener(x);
            HTMLPage page = HTMLPageFactory.loadPage(x.download());
            URL redirect = page.getMetaRefreshURL();
            if (redirect == null) {
                ResourceDownloaderBaseImpl c = this.delegate.getClone(this);
                this.addReportListener(c);
                long res = c.getSize();
                this.setProperties(c);
                return res;
            }
            ResourceDownloaderURLImpl c = new ResourceDownloaderURLImpl(this.getParent(), redirect);
            this.addReportListener(c);
            long res = c.getSize();
            this.setProperties(c);
            return res;
        }
        catch (HTMLException e) {
            throw new ResourceDownloaderException("getSize failed", e);
        }
    }

    public ResourceDownloaderBaseImpl getClone(ResourceDownloaderBaseImpl parent) {
        ResourceDownloaderMetaRefreshImpl c = new ResourceDownloaderMetaRefreshImpl(parent, this.delegate.getClone(this));
        c.setSize(this.size);
        c.setProperties(this);
        return c;
    }

    public InputStream download() throws ResourceDownloaderException {
        this.asyncDownload();
        this.done_sem.reserve();
        if (this.result instanceof InputStream) {
            return (InputStream)this.result;
        }
        throw (ResourceDownloaderException)this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncDownload() {
        try {
            this.this_mon.enter();
            if (this.cancelled) {
                this.done_sem.release();
                this.informFailed((ResourceDownloaderException)this.result);
            } else {
                ++this.done_count;
                this.current_downloader = this.current_delegate.getClone(this);
                this.informActivity(this.getLogIndent() + "Downloading: " + this.getName());
                this.current_downloader.addListener(this);
                this.current_downloader.asyncDownload();
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        this.setCancelled();
        try {
            this.this_mon.enter();
            this.result = new ResourceDownloaderException("Download cancelled");
            this.cancelled = true;
            this.informFailed((ResourceDownloaderException)this.result);
            this.done_sem.release();
            if (this.current_downloader != null) {
                this.current_downloader.cancel();
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    public boolean completed(ResourceDownloader downloader, InputStream data) {
        boolean complete = false;
        try {
            if (this.done_count == 1) {
                HTMLPage page;
                URL redirect;
                boolean marked = false;
                if (data instanceof ByteArrayInputStream) {
                    data.mark(data.available());
                    marked = true;
                }
                if ((redirect = (page = HTMLPageFactory.loadPage(data, !marked)).getMetaRefreshURL()) == null) {
                    if (!marked) {
                        this.failed(downloader, new ResourceDownloaderException("meta refresh tag not found and input stream not recoverable"));
                    } else {
                        data.reset();
                        complete = true;
                    }
                } else {
                    this.current_delegate = new ResourceDownloaderURLImpl(this, redirect);
                    this.asyncDownload();
                }
                if (marked && !complete) {
                    data.close();
                }
            } else {
                complete = true;
            }
            if (complete && this.informComplete(data)) {
                this.result = data;
                this.done_sem.release();
            }
        }
        catch (Throwable e) {
            this.failed(downloader, new ResourceDownloaderException("meta-refresh processing fails", e));
        }
        return true;
    }

    public void failed(ResourceDownloader downloader, ResourceDownloaderException e) {
        this.result = e;
        this.done_sem.release();
        this.informFailed(e);
    }
}

