/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt;

import com.aelitis.azureus.core.AzureusCore;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.torrentdownloader.TorrentDownloader;
import org.gudy.azureus2.core3.torrentdownloader.TorrentDownloaderCallBackInterface;
import org.gudy.azureus2.core3.torrentdownloader.TorrentDownloaderFactory;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.BufferedLabel;
import org.gudy.azureus2.ui.swt.components.shell.ShellFactory;
import org.gudy.azureus2.ui.swt.mainwindow.TorrentOpener;

public class FileDownloadWindow
implements TorrentDownloaderCallBackInterface {
    AzureusCore azureus_core;
    Display display;
    Shell shell;
    ProgressBar progressBar;
    BufferedLabel status;
    Button retry;
    Button cancel;
    TorrentDownloader downloader;
    TorrentDownloaderCallBackInterface listener;

    public FileDownloadWindow(AzureusCore _azureus_core, Shell parent, String url, String referrer) {
        this(_azureus_core, parent, url, referrer, null);
    }

    public FileDownloadWindow(AzureusCore _azureus_core, Shell parent, final String url, final String referrer, TorrentDownloaderCallBackInterface listener) {
        this.azureus_core = _azureus_core;
        this.listener = listener;
        String dirName = null;
        if (COConfigurationManager.getBooleanParameter("Save Torrent Files", true)) {
            try {
                dirName = COConfigurationManager.getDirectoryParameter("General_sDefaultTorrent_Directory");
            }
            catch (Exception egnore) {
                // empty catch block
            }
        }
        if (dirName == null) {
            DirectoryDialog dd = new DirectoryDialog(parent, 0);
            dd.setText(MessageText.getString("fileDownloadWindow.saveTorrentIn"));
            dirName = dd.open();
        }
        if (dirName == null) {
            return;
        }
        this.display = parent.getDisplay();
        this.shell = ShellFactory.createShell(parent, 2144);
        this.shell.setText(MessageText.getString("fileDownloadWindow.title"));
        Utils.setShellIcon(this.shell);
        FormLayout formLayout = new FormLayout();
        formLayout.marginHeight = 5;
        formLayout.marginWidth = 5;
        formLayout.spacing = 5;
        this.shell.setLayout((Layout)formLayout);
        Label lDownloading = new Label((Composite)this.shell, 0);
        lDownloading.setText(MessageText.getString("fileDownloadWindow.downloading"));
        Label lLocation = new Label((Composite)this.shell, 0);
        FormData data = new FormData();
        data.left = new FormAttachment((Control)lDownloading);
        data.right = new FormAttachment(100, 0);
        lLocation.setLayoutData((Object)data);
        String shortUrl = url;
        if (url.length() > 70) {
            shortUrl = DisplayFormatters.truncateString(url, 120);
        }
        lLocation.setText(shortUrl);
        lLocation.setToolTipText(url);
        this.progressBar = new ProgressBar((Composite)this.shell, 0);
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(100);
        this.progressBar.setSelection(0);
        data = new FormData();
        data.top = new FormAttachment((Control)lDownloading);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.width = 400;
        this.progressBar.setLayoutData((Object)data);
        Label lStatus = new Label((Composite)this.shell, 0);
        lStatus.setText(MessageText.getString("fileDownloadWindow.status"));
        data = new FormData();
        data.top = new FormAttachment((Control)this.progressBar);
        lStatus.setLayoutData((Object)data);
        this.status = new BufferedLabel((Composite)this.shell, 0);
        data = new FormData();
        data.top = new FormAttachment((Control)this.progressBar);
        data.left = new FormAttachment((Control)lStatus);
        data.right = new FormAttachment(100, 0);
        this.status.setLayoutData(data);
        this.retry = new Button((Composite)this.shell, 8);
        this.retry.setEnabled(false);
        this.retry.setText(MessageText.getString("fileDownloadWindow.retry"));
        final String _dirName = dirName;
        this.retry.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                FileDownloadWindow.this.retry.setEnabled(false);
                FileDownloadWindow.this.status.setText("");
                FileDownloadWindow.this.downloader.cancel();
                FileDownloadWindow.this.downloader = TorrentDownloaderFactory.create(FileDownloadWindow.this, url, referrer, _dirName);
                FileDownloadWindow.this.downloader.start();
            }
        });
        this.cancel = new Button((Composite)this.shell, 8);
        this.cancel.setText(MessageText.getString("Button.cancel"));
        this.cancel.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                FileDownloadWindow.this.downloader.cancel();
                if (!FileDownloadWindow.this.shell.isDisposed()) {
                    FileDownloadWindow.this.shell.dispose();
                }
            }
        });
        data = new FormData();
        data.top = new FormAttachment((Control)lStatus);
        data.right = new FormAttachment((Control)this.cancel);
        data.width = 100;
        this.retry.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)lStatus);
        data.right = new FormAttachment(100, 0);
        data.width = 100;
        this.cancel.setLayoutData((Object)data);
        this.shell.setDefaultButton(this.retry);
        this.shell.addListener(31, new Listener(){

            public void handleEvent(Event e) {
                if (e.character == '\u001b') {
                    FileDownloadWindow.this.downloader.cancel();
                    if (!FileDownloadWindow.this.shell.isDisposed()) {
                        FileDownloadWindow.this.shell.dispose();
                    }
                }
            }
        });
        Point p = this.shell.computeSize(-1, -1);
        if (p.x > 800) {
            p.x = 800;
        }
        this.shell.setSize(p);
        Utils.centreWindow(this.shell);
        this.shell.open();
        this.downloader = TorrentDownloaderFactory.create(this, url, referrer, dirName);
        this.downloader.start();
    }

    public void TorrentDownloaderEvent(int state, TorrentDownloader inf) {
        if (this.listener != null) {
            this.listener.TorrentDownloaderEvent(state, inf);
        }
        this.update();
    }

    private void update() {
        if (this.display != null && !this.display.isDisposed()) {
            this.display.asyncExec((Runnable)new AERunnable(){

                public void runSupport() {
                    String stateText;
                    int percentDone = FileDownloadWindow.this.downloader.getPercentDone();
                    if (FileDownloadWindow.this.progressBar != null && !FileDownloadWindow.this.progressBar.isDisposed()) {
                        FileDownloadWindow.this.progressBar.setSelection(percentDone);
                    }
                    int state = FileDownloadWindow.this.downloader.getDownloadState();
                    switch (state) {
                        case 6: {
                            if (!FileDownloadWindow.this.shell.isDisposed()) {
                                FileDownloadWindow.this.shell.dispose();
                            }
                            return;
                        }
                        case 2: {
                            stateText = MessageText.getString("fileDownloadWindow.state_downloading") + ": " + FileDownloadWindow.this.downloader.getStatus();
                            break;
                        }
                        case 4: {
                            stateText = MessageText.getString("fileDownloadWindow.state_error") + FileDownloadWindow.this.downloader.getError();
                            break;
                        }
                        default: {
                            stateText = "";
                        }
                    }
                    if (FileDownloadWindow.this.status != null && !FileDownloadWindow.this.status.isDisposed()) {
                        FileDownloadWindow.this.status.setText(DisplayFormatters.truncateString(stateText, 120));
                        FileDownloadWindow.this.status.setToolTipText(stateText);
                    }
                    if (state == 3 && FileDownloadWindow.this.shell != null && !FileDownloadWindow.this.shell.isDisposed()) {
                        FileDownloadWindow.this.shell.dispose();
                        if (FileDownloadWindow.this.listener == null) {
                            TorrentOpener.openTorrent(FileDownloadWindow.this.downloader.getFile().getAbsolutePath());
                        }
                    }
                    if (!FileDownloadWindow.this.shell.isDisposed()) {
                        if (state == 4 && !FileDownloadWindow.this.retry.isDisposed()) {
                            FileDownloadWindow.this.retry.setEnabled(true);
                        }
                        Point p = FileDownloadWindow.this.shell.computeSize(-1, -1);
                        if (p.x > 800) {
                            p.x = 800;
                        }
                        if (!FileDownloadWindow.this.shell.getSize().equals((Object)p)) {
                            FileDownloadWindow.this.shell.setSize(p);
                            Utils.centreWindow(FileDownloadWindow.this.shell);
                            FileDownloadWindow.this.shell.layout();
                        }
                    }
                }
            });
        }
    }
}

