/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncer;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.shell.ShellFactory;

public class TrackerChangerWindow {
    public TrackerChangerWindow(Display display, final TRTrackerAnnouncer trackerConnection) {
        final Shell shell = ShellFactory.createShell(display);
        shell.setText(MessageText.getString("TrackerChangerWindow.title"));
        Utils.setShellIcon(shell);
        GridLayout layout = new GridLayout();
        shell.setLayout((Layout)layout);
        Label label = new Label((Composite)shell, 0);
        Messages.setLanguageText((Widget)label, "TrackerChangerWindow.newtracker");
        GridData gridData = new GridData();
        gridData.widthHint = 200;
        label.setLayoutData((Object)gridData);
        final Text url = new Text((Composite)shell, 2048);
        gridData = new GridData(768);
        gridData.widthHint = 300;
        url.setLayoutData((Object)gridData);
        Utils.setTextLinkFromClipboard(shell, url, false);
        Composite panel = new Composite((Composite)shell, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        panel.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        panel.setLayoutData((Object)gridData);
        Button ok = new Button(panel, 8);
        ok.setText(MessageText.getString("Button.ok"));
        gridData = new GridData();
        gridData.widthHint = 70;
        ok.setLayoutData((Object)gridData);
        shell.setDefaultButton(ok);
        ok.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                try {
                    TOTorrent torrent = trackerConnection.getTorrent();
                    TorrentUtils.announceGroupsInsertFirst(torrent, url.getText());
                    TorrentUtils.writeToFile(torrent);
                    trackerConnection.resetTrackerUrl(false);
                    shell.dispose();
                }
                catch (Exception e) {
                    Debug.printStackTrace(e);
                }
            }
        });
        Button cancel = new Button(panel, 8);
        cancel.setText(MessageText.getString("Button.cancel"));
        gridData = new GridData();
        gridData.widthHint = 70;
        cancel.setLayoutData((Object)gridData);
        cancel.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                shell.dispose();
            }
        });
        shell.pack();
        Utils.createURLDropTarget((Control)shell, url);
        shell.open();
    }
}

