/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.ipchecker;

import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.ipchecker.extipchecker.ExternalIPCheckerFactory;
import org.gudy.azureus2.core3.ipchecker.extipchecker.ExternalIPCheckerService;
import org.gudy.azureus2.ui.swt.ipchecker.IpCheckerWizard;
import org.gudy.azureus2.ui.swt.ipchecker.ProgressPanel;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.wizard.AbstractWizardPanel;
import org.gudy.azureus2.ui.swt.wizard.IWizardPanel;

public class ChooseServicePanel
extends AbstractWizardPanel {
    private Combo servicesList;
    private ExternalIPCheckerService[] services;
    Label serviceDescription;
    Label serviceUrl;

    public ChooseServicePanel(IpCheckerWizard wizard, IWizardPanel previousPanel) {
        super(wizard, previousPanel);
    }

    public void show() {
        this.wizard.setTitle(MessageText.getString("ipCheckerWizard.service"));
        this.wizard.setCurrentInfo(MessageText.getString("ipCheckerWizard.chooseService"));
        Composite rootPanel = this.wizard.getPanel();
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        rootPanel.setLayout((Layout)layout);
        Label label = new Label(rootPanel, 64);
        GridData gridData = new GridData();
        gridData.widthHint = 380;
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        label.setText(MessageText.getString("ipCheckerWizard.explanations"));
        this.servicesList = new Combo(rootPanel, 8);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.servicesList.setLayoutData((Object)gridData);
        this.services = ExternalIPCheckerFactory.create().getServices();
        for (int i = 0; i < this.services.length; ++i) {
            this.servicesList.add(this.services[i].getName());
        }
        label = new Label(rootPanel, 0);
        label.setText(MessageText.getString("ipCheckerWizard.service.url"));
        Cursor handCursor = new Cursor((Device)rootPanel.getDisplay(), 21);
        this.serviceUrl = new Label(rootPanel, 0);
        gridData = new GridData(768);
        this.serviceUrl.setLayoutData((Object)gridData);
        this.serviceUrl.setForeground(Colors.blue);
        this.serviceUrl.setCursor(handCursor);
        this.serviceUrl.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent arg0) {
                Program.launch((String)((Label)arg0.widget).getText());
            }

            public void mouseDown(MouseEvent arg0) {
                Program.launch((String)((Label)arg0.widget).getText());
            }
        });
        this.servicesList.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ChooseServicePanel.this.updateInfos();
            }
        });
        this.servicesList.select(0);
        label = new Label(rootPanel, 0);
        gridData = new GridData();
        gridData.heightHint = 50;
        gridData.verticalAlignment = 2;
        label.setLayoutData((Object)gridData);
        label.setText(MessageText.getString("ipCheckerWizard.service.description"));
        this.serviceDescription = new Label(rootPanel, 64);
        gridData = new GridData(768);
        gridData.heightHint = 50;
        gridData.verticalAlignment = 2;
        this.serviceDescription.setLayoutData((Object)gridData);
        this.updateInfos();
    }

    private void updateInfos() {
        int selection = this.servicesList.getSelectionIndex();
        this.serviceDescription.setText(this.services[selection].getDescription());
        this.serviceUrl.setText(this.services[selection].getURL());
        ((IpCheckerWizard)this.wizard).selectedService = this.services[selection];
        ((IpCheckerWizard)this.wizard).setFinishEnabled(this.services[selection].supportsCheck());
    }

    public boolean isFinishEnabled() {
        return true;
    }

    public IWizardPanel getFinishPanel() {
        return new ProgressPanel((IpCheckerWizard)this.wizard, (IWizardPanel)this);
    }
}

