/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.mainwindow;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.HSLColor;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;

public class Colors
implements ParameterListener {
    private static final LogIDs LOGID = LogIDs.GUI;
    private static Colors instance = null;
    public static final int BLUES_LIGHTEST = 0;
    public static final int BLUES_DARKEST = 9;
    public static final int BLUES_MIDLIGHT = 2;
    public static final int BLUES_MIDDARK = 7;
    public static final int FADED_LIGHTEST = 0;
    public static final int FADED_DARKEST = 9;
    public static Color[] blues = new Color[10];
    public static Color[] faded = new Color[10];
    public static Color colorProgressBar;
    public static Color colorInverse;
    public static Color colorShiftLeft;
    public static Color colorShiftRight;
    public static Color colorError;
    public static Color colorAltRow;
    public static Color colorWarning;
    public static Color black;
    public static Color light_grey;
    public static Color blue;
    public static Color green;
    public static Color grey;
    public static Color red;
    public static Color fadedRed;
    public static Color yellow;
    public static Color white;
    public static Color background;
    public static Color red_ConsoleView;
    private static AEMonitor class_mon;
    private Display display;

    private void allocateBlues() {
        int r = 0;
        int g = 128;
        int b = 255;
        try {
            r = COConfigurationManager.getIntParameter("Color Scheme.red", r);
            g = COConfigurationManager.getIntParameter("Color Scheme.green", g);
            b = COConfigurationManager.getIntParameter("Color Scheme.blue", b);
            boolean bGrayScale = r == b && b == g;
            HSLColor hslColor = new HSLColor();
            Color colorTables = this.display.getSystemColor(25);
            int tR = colorTables.getRed();
            int tG = colorTables.getGreen();
            int tB = colorTables.getBlue();
            for (int i = 0; i < blues.length; ++i) {
                Color toBeDisposed = blues[i];
                hslColor.initHSLbyRGB(r, g, b);
                float blendBy = i == 0 ? 1.0f : 1.0f - (float)i / (float)(blues.length - 1);
                hslColor.blend(tR, tG, tB, blendBy);
                Colors.blues[i] = new Color((Device)this.display, hslColor.getRed(), hslColor.getGreen(), hslColor.getBlue());
                int iSat = hslColor.getSaturation();
                if (iSat != 0) {
                    hslColor.setSaturation(iSat / 2);
                } else if (bGrayScale) {
                    hslColor.brighten(0.8f);
                }
                Colors.faded[i] = new Color((Device)this.display, hslColor.getRed(), hslColor.getGreen(), hslColor.getBlue());
                if (toBeDisposed == null || toBeDisposed.isDisposed()) continue;
                toBeDisposed.dispose();
            }
            if (bGrayScale) {
                b = b > 200 ? (b -= 20) : (b += 20);
            }
            Color toBeDisposed = colorInverse;
            hslColor.initHSLbyRGB(r, g, b);
            hslColor.reverseColor();
            colorInverse = new Color((Device)this.display, hslColor.getRed(), hslColor.getGreen(), hslColor.getBlue());
            if (toBeDisposed != null && !toBeDisposed.isDisposed()) {
                toBeDisposed.dispose();
            }
            toBeDisposed = colorShiftRight;
            hslColor.initHSLbyRGB(r, g, b);
            hslColor.setHue(hslColor.getHue() + 25);
            colorShiftRight = new Color((Device)this.display, hslColor.getRed(), hslColor.getGreen(), hslColor.getBlue());
            if (toBeDisposed != null && !toBeDisposed.isDisposed()) {
                toBeDisposed.dispose();
            }
            toBeDisposed = colorShiftLeft;
            hslColor.initHSLbyRGB(r, g, b);
            hslColor.setHue(hslColor.getHue() - 25);
            colorShiftLeft = new Color((Device)this.display, hslColor.getRed(), hslColor.getGreen(), hslColor.getBlue());
            if (toBeDisposed != null && !toBeDisposed.isDisposed()) {
                toBeDisposed.dispose();
            }
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "Error allocating colors", e));
        }
    }

    public void disposeColors() {
        if (this.display == null || this.display.isDisposed()) {
            return;
        }
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (colorProgressBar != null && !colorProgressBar.isDisposed()) {
                    colorProgressBar.dispose();
                }
                for (int i = 0; i < blues.length; ++i) {
                    if (blues[i] == null || blues[i].isDisposed()) continue;
                    blues[i].dispose();
                }
                Color[] colorsToDispose = new Color[]{colorInverse, colorShiftLeft, colorShiftRight, colorError, grey, black, light_grey, blue, green, red, white, red_ConsoleView, colorAltRow, colorWarning};
                for (int i = 0; i < colorsToDispose.length; ++i) {
                    if (colorsToDispose[i] == null || colorsToDispose[i].isDisposed()) continue;
                    colorsToDispose[i].dispose();
                }
            }
        }, false);
    }

    public void setBackground(Color background) {
        if (Colors.background != null && !Colors.background.isDisposed()) {
            Color old = Colors.background;
            Colors.background = background;
            old.dispose();
        }
    }

    private void allocateColorProgressBar() {
        if (this.display == null || this.display.isDisposed()) {
            return;
        }
        colorProgressBar = new AllocateColor("progressBar", colorShiftRight, colorProgressBar).getColor();
    }

    private void allocateColorError() {
        if (this.display == null || this.display.isDisposed()) {
            return;
        }
        colorError = new AllocateColor("error", new RGB(255, 68, 68), colorError).getColor();
    }

    private void allocateColorWarning() {
        if (this.display == null || this.display.isDisposed()) {
            return;
        }
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                Color colorTables = Colors.this.display.getSystemColor(25);
                HSLColor hslBG = new HSLColor();
                hslBG.initHSLbyRGB(colorTables.getRed(), colorTables.getGreen(), colorTables.getBlue());
                int lum = hslBG.getLuminence();
                HSLColor hslColor = new HSLColor();
                hslColor.initRGBbyHSL(25, 200, 128 + (lum < 160 ? 10 : -10));
                colorWarning = new AllocateColor("warning", new RGB(hslColor.getRed(), hslColor.getGreen(), hslColor.getBlue()), colorWarning).getColor();
            }
        }, false);
    }

    private void allocateColorAltRow() {
        if (this.display == null || this.display.isDisposed()) {
            return;
        }
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                Color colorTables = Colors.this.display.getSystemColor(25);
                HSLColor hslColor = new HSLColor();
                hslColor.initHSLbyRGB(colorTables.getRed(), colorTables.getGreen(), colorTables.getBlue());
                int lum = hslColor.getLuminence();
                lum = lum > 127 ? (lum -= 10) : (lum += 30);
                hslColor.setLuminence(lum);
                colorAltRow = new AllocateColor("altRow", new RGB(hslColor.getRed(), hslColor.getGreen(), hslColor.getBlue()), colorAltRow).getColor();
            }
        }, false);
    }

    private void allocateDynamicColors() {
        if (this.display == null || this.display.isDisposed()) {
            return;
        }
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                Colors.this.allocateBlues();
                Colors.this.allocateColorProgressBar();
            }
        }, false);
    }

    private void allocateNonDynamicColors() {
        this.allocateColorWarning();
        this.allocateColorError();
        this.allocateColorAltRow();
        black = new Color((Device)this.display, new RGB(0, 0, 0));
        light_grey = new Color((Device)this.display, new RGB(192, 192, 192));
        blue = new Color((Device)this.display, new RGB(0, 0, 170));
        green = new Color((Device)this.display, new RGB(0, 170, 0));
        grey = new Color((Device)this.display, new RGB(170, 170, 170));
        red = new Color((Device)this.display, new RGB(255, 0, 0));
        fadedRed = new Color((Device)this.display, new RGB(160, 96, 96));
        yellow = new Color((Device)this.display, new RGB(255, 255, 0));
        white = new Color((Device)this.display, new RGB(255, 255, 255));
        background = new Color((Device)this.display, new RGB(248, 248, 248));
        red_ConsoleView = new Color((Device)this.display, new RGB(255, 192, 192));
    }

    public Colors() {
        instance = this;
        this.display = SWTThread.getInstance().getDisplay();
        this.allocateDynamicColors();
        this.allocateNonDynamicColors();
        this.addColorsChangedListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Colors getInstance() {
        try {
            class_mon.enter();
            if (instance == null) {
                instance = new Colors();
            }
            Colors colors = instance;
            return colors;
        }
        finally {
            class_mon.exit();
        }
    }

    public void addColorsChangedListener(ParameterListener l) {
        COConfigurationManager.addParameterListener("Color Scheme", l);
        COConfigurationManager.addParameterListener("Colors.progressBar.override", l);
        COConfigurationManager.addParameterListener("Colors.progressBar", l);
        COConfigurationManager.addParameterListener("Colors.error.override", l);
        COConfigurationManager.addParameterListener("Colors.error", l);
        COConfigurationManager.addParameterListener("Colors.warning.override", l);
        COConfigurationManager.addParameterListener("Colors.warning", l);
        COConfigurationManager.addParameterListener("Colors.altRow.override", l);
        COConfigurationManager.addParameterListener("Colors.altRow", l);
    }

    public void removeColorsChangedListener(ParameterListener l) {
        COConfigurationManager.removeParameterListener("Color Scheme", l);
        COConfigurationManager.removeParameterListener("Colors.progressBar.override", l);
        COConfigurationManager.removeParameterListener("Colors.progressBar", l);
        COConfigurationManager.removeParameterListener("Colors.error.override", l);
        COConfigurationManager.removeParameterListener("Colors.error", l);
        COConfigurationManager.removeParameterListener("Colors.warning.override", l);
        COConfigurationManager.removeParameterListener("Colors.warning", l);
        COConfigurationManager.removeParameterListener("Colors.altRow.override", l);
        COConfigurationManager.removeParameterListener("Colors.altRow", l);
    }

    public void parameterChanged(String parameterName) {
        if (parameterName.equals("Color Scheme")) {
            this.allocateDynamicColors();
        }
        if (parameterName.startsWith("Colors.progressBar")) {
            this.allocateColorProgressBar();
        }
        if (parameterName.startsWith("Colors.error")) {
            this.allocateColorError();
        }
        if (parameterName.startsWith("Colors.warning")) {
            this.allocateColorWarning();
        }
        if (parameterName.startsWith("Colors.altRow")) {
            this.allocateColorAltRow();
        }
    }

    static {
        class_mon = new AEMonitor("Colors");
    }

    private class AllocateColor
    extends AERunnable {
        private Color toBeDeleted = null;
        private String sName;
        private RGB rgbDefault;
        private Color newColor;

        public AllocateColor(String sName, RGB rgbDefault, Color colorOld) {
            this.toBeDeleted = colorOld;
            this.sName = sName;
            this.rgbDefault = rgbDefault;
        }

        public AllocateColor(String sName, Color colorDefault, Color colorOld) {
            this.toBeDeleted = colorOld;
            this.sName = sName;
            Utils.execSWTThread(new AERunnable(this, colorDefault, Colors.this){
                private final /* synthetic */ Color val$colorDefault;
                private final /* synthetic */ Colors val$this$0;
                private final /* synthetic */ AllocateColor this$1;
                {
                    this.this$1 = this$1;
                    this.val$colorDefault = val$colorDefault;
                    this.val$this$0 = val$this$0;
                }

                public void runSupport() {
                    if (!this.val$colorDefault.isDisposed()) {
                        AllocateColor.access$102(this.this$1, this.val$colorDefault.getRGB());
                    } else {
                        AllocateColor.access$102(this.this$1, new RGB(0, 0, 0));
                    }
                }
            }, false);
        }

        public Color getColor() {
            Utils.execSWTThread(this, false);
            return this.newColor;
        }

        public void runSupport() {
            if (COConfigurationManager.getBooleanParameter("Colors." + this.sName + ".override")) {
                this.newColor = new Color((Device)Colors.this.display, COConfigurationManager.getIntParameter("Colors." + this.sName + ".red", this.rgbDefault.red), COConfigurationManager.getIntParameter("Colors." + this.sName + ".green", this.rgbDefault.green), COConfigurationManager.getIntParameter("Colors." + this.sName + ".blue", this.rgbDefault.blue));
            } else {
                this.newColor = new Color((Device)Colors.this.display, this.rgbDefault);
                COConfigurationManager.setRGBParameter("Colors." + this.sName, this.rgbDefault.red, this.rgbDefault.green, this.rgbDefault.blue);
            }
            if (this.toBeDeleted != null && !this.toBeDeleted.isDisposed()) {
                this.toBeDeleted.dispose();
            }
        }

        static /* synthetic */ RGB access$102(AllocateColor x0, RGB x1) {
            x0.rgbDefault = x1;
            return x0.rgbDefault;
        }
    }
}

