/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.pluginsimpl;

import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.plugins.ui.components.UIPropertyChangeEvent;
import org.gudy.azureus2.plugins.ui.components.UIPropertyChangeListener;
import org.gudy.azureus2.plugins.ui.model.BasicPluginViewModel;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.components.BufferedLabel;
import org.gudy.azureus2.ui.swt.mainwindow.MainWindow;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEvent;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEventListener;

public class BasicPluginViewImpl
implements UISWTViewEventListener,
UIPropertyChangeListener {
    BasicPluginViewModel model;
    Display display;
    Composite panel;
    ProgressBar progress;
    BufferedLabel status;
    BufferedLabel task;
    StyledText log;
    boolean isCreated;

    public BasicPluginViewImpl(BasicPluginViewModel model) {
        this.model = model;
        this.isCreated = false;
    }

    public boolean eventOccurred(UISWTViewEvent event) {
        switch (event.getType()) {
            case 0: {
                if (this.isCreated) {
                    return false;
                }
                this.isCreated = true;
                break;
            }
            case 2: {
                this.initialize((Composite)event.getData());
                break;
            }
            case 5: {
                this.refresh();
                break;
            }
            case 7: {
                this.delete();
                this.isCreated = false;
            }
        }
        return true;
    }

    private void initialize(Composite composite) {
        String sConfigSectionID = this.model.getConfigSectionID();
        this.display = composite.getDisplay();
        this.panel = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.panel.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        this.panel.setLayoutData((Object)gridData);
        Composite topSection = new Composite(this.panel, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        topSection.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        if (sConfigSectionID == null) {
            gridData.horizontalSpan = 2;
        }
        topSection.setLayoutData((Object)gridData);
        if (this.model.getStatus().getVisible()) {
            Label statusTitle = new Label(topSection, 0);
            Messages.setLanguageText((Widget)statusTitle, "plugins.basicview.status");
            this.status = new BufferedLabel(topSection, 0);
            gridData = new GridData(768);
            this.status.setLayoutData(gridData);
        }
        if (this.model.getActivity().getVisible()) {
            Label activityTitle = new Label(topSection, 0);
            Messages.setLanguageText((Widget)activityTitle, "plugins.basicview.activity");
            this.task = new BufferedLabel(topSection, 0);
            gridData = new GridData(768);
            this.task.setLayoutData(gridData);
        }
        if (this.model.getProgress().getVisible()) {
            Label progressTitle = new Label(topSection, 0);
            Messages.setLanguageText((Widget)progressTitle, "plugins.basicview.progress");
            this.progress = new ProgressBar(this.panel, 0);
            this.progress.setMaximum(100);
            this.progress.setMinimum(0);
            gridData = new GridData(768);
            this.progress.setLayoutData((Object)gridData);
        }
        if (sConfigSectionID != null) {
            Composite configSection = new Composite(this.panel, 0);
            gridLayout = new GridLayout();
            gridLayout.numColumns = 2;
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 2;
            configSection.setLayout((Layout)gridLayout);
            gridData = new GridData(768);
            configSection.setLayoutData((Object)gridData);
            Label padding = new Label(configSection, 0);
            gridData = new GridData(768);
            padding.setLayoutData((Object)gridData);
            Button btnConfig = new Button(configSection, 8);
            Messages.setLanguageText((Widget)btnConfig, "plugins.basicview.config");
            btnConfig.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MainWindow.getWindow().showConfig(BasicPluginViewImpl.this.model.getConfigSectionID());
                }
            });
            btnConfig.setLayoutData((Object)new GridData());
        }
        if (this.model.getLogArea().getVisible()) {
            Label logTitle = new Label(topSection, 0);
            Messages.setLanguageText((Widget)logTitle, "plugins.basicview.log");
            Button button = new Button(topSection, 8);
            Messages.setLanguageText((Widget)button, "plugins.basicview.clear");
            button.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    BasicPluginViewImpl.this.model.getLogArea().setText("");
                }
            });
            this.log = new StyledText(this.panel, 2824);
            gridData = new GridData(1808);
            gridData.horizontalSpan = 2;
            this.log.setLayoutData((Object)gridData);
            this.log.setText(this.model.getLogArea().getText());
            this.model.getLogArea().addPropertyChangeListener(this);
        }
    }

    private void refresh() {
        if (this.status != null) {
            this.status.setText(this.model.getStatus().getText());
        }
        if (this.task != null) {
            this.task.setText(this.model.getActivity().getText());
        }
        if (this.progress != null) {
            this.progress.setSelection(this.model.getProgress().getPercentageComplete());
        }
    }

    public void propertyChanged(final UIPropertyChangeEvent ev) {
        if (ev.getSource() != this.model.getLogArea()) {
            return;
        }
        if (this.display == null || this.display.isDisposed()) {
            return;
        }
        if (this.log == null) {
            return;
        }
        this.display.asyncExec((Runnable)new AERunnable(){

            public void runSupport() {
                if (BasicPluginViewImpl.this.log.isDisposed()) {
                    return;
                }
                String old_value = (String)ev.getOldPropertyValue();
                String new_value = (String)ev.getNewPropertyValue();
                if (new_value.startsWith(old_value)) {
                    BasicPluginViewImpl.this.log.append(new_value.substring(old_value.length()));
                } else {
                    BasicPluginViewImpl.this.log.setText(new_value);
                }
            }
        });
    }

    private void delete() {
        this.model.getLogArea().removePropertyChangeListener(this);
    }
}

