/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.table.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.ui.swt.views.table.ITableStructureModificationListener;
import org.gudy.azureus2.ui.swt.views.table.TableColumnCore;

public class TableStructureEventDispatcher
implements ITableStructureModificationListener {
    private static Map instances = new HashMap();
    private static AEMonitor class_mon = new AEMonitor("TableStructureEventDispatcher:class");
    private List listeners;
    private AEMonitor listeners_mon = new AEMonitor("TableStructureEventDispatcher:L");

    private TableStructureEventDispatcher() {
        this.listeners = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TableStructureEventDispatcher getInstance(String sTableID) {
        try {
            class_mon.enter();
            TableStructureEventDispatcher instance = (TableStructureEventDispatcher)instances.get(sTableID);
            if (instance == null) {
                instance = new TableStructureEventDispatcher();
                instances.put(sTableID, instance);
            }
            TableStructureEventDispatcher tableStructureEventDispatcher = instance;
            return tableStructureEventDispatcher;
        }
        finally {
            class_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ITableStructureModificationListener listener) {
        try {
            this.listeners_mon.enter();
            this.listeners.add(listener);
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ITableStructureModificationListener listener) {
        try {
            this.listeners_mon.enter();
            this.listeners.remove(listener);
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tableStructureChanged() {
        try {
            this.listeners_mon.enter();
            Iterator iter = this.listeners.iterator();
            while (iter.hasNext()) {
                ITableStructureModificationListener listener = (ITableStructureModificationListener)iter.next();
                listener.tableStructureChanged();
            }
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void columnSizeChanged(TableColumnCore tableColumn) {
        try {
            this.listeners_mon.enter();
            Iterator iter = this.listeners.iterator();
            while (iter.hasNext()) {
                ITableStructureModificationListener listener = (ITableStructureModificationListener)iter.next();
                listener.columnSizeChanged(tableColumn);
            }
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void columnInvalidate(TableColumnCore tableColumn) {
        try {
            this.listeners_mon.enter();
            Iterator iter = this.listeners.iterator();
            while (iter.hasNext()) {
                ITableStructureModificationListener listener = (ITableStructureModificationListener)iter.next();
                listener.columnInvalidate(tableColumn);
            }
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void columnOrderChanged(int[] iPositions) {
        try {
            this.listeners_mon.enter();
            Iterator iter = this.listeners.iterator();
            while (iter.hasNext()) {
                ITableStructureModificationListener listener = (ITableStructureModificationListener)iter.next();
                listener.columnOrderChanged(iPositions);
            }
        }
        finally {
            this.listeners_mon.exit();
        }
    }
}

