/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.webplugin;

import com.aelitis.azureus.plugins.upnp.UPnPPlugin;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.URL;
import java.util.Arrays;
import java.util.Properties;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginConfig;
import org.gudy.azureus2.plugins.PluginException;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginListener;
import org.gudy.azureus2.plugins.ipfilter.IPRange;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.logging.LoggerChannelListener;
import org.gudy.azureus2.plugins.tracker.Tracker;
import org.gudy.azureus2.plugins.tracker.TrackerException;
import org.gudy.azureus2.plugins.tracker.web.TrackerAuthenticationAdapter;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebContext;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebPageGenerator;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebPageRequest;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebPageResponse;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.config.BooleanParameter;
import org.gudy.azureus2.plugins.ui.config.IntParameter;
import org.gudy.azureus2.plugins.ui.config.PasswordParameter;
import org.gudy.azureus2.plugins.ui.config.StringListParameter;
import org.gudy.azureus2.plugins.ui.config.StringParameter;
import org.gudy.azureus2.plugins.ui.model.BasicPluginConfigModel;
import org.gudy.azureus2.plugins.ui.model.BasicPluginViewModel;

public class WebPlugin
implements Plugin,
TrackerWebPageGenerator {
    public static final String PR_PORT = "Port";
    public static final String PR_ROOT_RESOURCE = "Root Resource";
    public static final String PR_LOG = "DefaultLoggerChannel";
    public static final String PR_CONFIG_MODEL = "DefaultConfigModel";
    public static final String PR_VIEW_MODEL = "DefaultViewModel";
    public static final String PR_HIDE_RESOURCE_CONFIG = "DefaultHideResourceConfig";
    public static final String PROPERTIES_MIGRATED = "Properties Migrated";
    public static final String CONFIG_MIGRATED = "Config Migrated";
    public static final String CONFIG_PASSWORD_ENABLE = "Password Enable";
    public final boolean CONFIG_PASSWORD_ENABLE_DEFAULT = false;
    public static final String CONFIG_USER = "User";
    public final String CONFIG_USER_DEFAULT = "";
    public static final String CONFIG_PASSWORD = "Password";
    public final byte[] CONFIG_PASSWORD_DEFAULT = new byte[0];
    public static final String CONFIG_PORT = "Port";
    public int CONFIG_PORT_DEFAULT = 8089;
    public static final String CONFIG_PROTOCOL = "Protocol";
    public final String CONFIG_PROTOCOL_DEFAULT = "HTTP";
    public static final String CONFIG_UPNP_ENABLE = "UPnP Enable";
    public final boolean CONFIG_UPNP_ENABLE_DEFAULT = true;
    public static final String CONFIG_HOME_PAGE = "Home Page";
    public final String CONFIG_HOME_PAGE_DEFAULT = "index.html";
    public static final String CONFIG_ROOT_DIR = "Root Dir";
    public final String CONFIG_ROOT_DIR_DEFAULT = "";
    public static final String CONFIG_ROOT_RESOURCE = "Root Resource";
    public String CONFIG_ROOT_RESOURCE_DEFAULT = "";
    public static final String CONFIG_MODE = "Mode";
    public static final String CONFIG_MODE_FULL = "full";
    public final String CONFIG_MODE_DEFAULT = "full";
    public static final String CONFIG_ACCESS = "Access";
    public final String CONFIG_ACCESS_DEFAULT = "all";
    protected static final String NL = "\r\n";
    protected static final String[] welcome_pages = new String[]{"index.html", "index.htm", "index.php", "index.tmpl"};
    protected static File[] welcome_files;
    protected PluginInterface plugin_interface;
    private LoggerChannel log;
    private Tracker tracker;
    private BasicPluginViewModel view_model;
    private BasicPluginConfigModel config_model;
    private String home_page;
    private String file_root;
    private String resource_root;
    private boolean ip_range_all = false;
    private IPRange ip_range;
    private Properties properties;
    static /* synthetic */ Class class$com$aelitis$azureus$plugins$upnp$UPnPPlugin;

    public WebPlugin() {
        this.properties = new Properties();
    }

    public WebPlugin(Properties defaults) {
        this.properties = defaults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(PluginInterface _plugin_interface) throws PluginException {
        File f_root;
        String pr_root_resource;
        this.plugin_interface = _plugin_interface;
        Integer pr_port = (Integer)this.properties.get("Port");
        if (pr_port != null) {
            this.CONFIG_PORT_DEFAULT = pr_port;
        }
        if ((pr_root_resource = (String)this.properties.get("Root Resource")) != null) {
            this.CONFIG_ROOT_RESOURCE_DEFAULT = pr_root_resource;
        }
        Boolean pr_hide_resource_config = (Boolean)this.properties.get(PR_HIDE_RESOURCE_CONFIG);
        this.log = (LoggerChannel)this.properties.get(PR_LOG);
        if (this.log == null) {
            this.log = this.plugin_interface.getLogger().getChannel("WebPlugin");
        }
        UIManager ui_manager = this.plugin_interface.getUIManager();
        this.view_model = (BasicPluginViewModel)this.properties.get(PR_VIEW_MODEL);
        if (this.view_model == null) {
            this.view_model = ui_manager.createBasicPluginViewModel(this.plugin_interface.getPluginName());
        }
        String sConfigSectionID = "plugins." + this.plugin_interface.getPluginID();
        this.view_model.setConfigSectionID(sConfigSectionID);
        this.view_model.getStatus().setText("Running");
        this.view_model.getActivity().setVisible(false);
        this.view_model.getProgress().setVisible(false);
        this.log.addListener(new LoggerChannelListener(){

            public void messageLogged(int type, String message) {
                WebPlugin.this.view_model.getLogArea().appendText(message + "\n");
            }

            public void messageLogged(String str, Throwable error) {
                WebPlugin.this.view_model.getLogArea().appendText(str + "\n");
                WebPlugin.this.view_model.getLogArea().appendText(error.toString() + "\n");
            }
        });
        PluginConfig plugin_config = this.plugin_interface.getPluginconfig();
        this.config_model = (BasicPluginConfigModel)this.properties.get(PR_CONFIG_MODEL);
        if (this.config_model == null) {
            this.config_model = ui_manager.createBasicPluginConfigModel("plugins", sConfigSectionID);
        }
        boolean save_needed = false;
        if (!plugin_config.getPluginBooleanParameter(CONFIG_MIGRATED, false)) {
            plugin_config.setPluginParameter(CONFIG_MIGRATED, true);
            save_needed = true;
            plugin_config.setPluginParameter(CONFIG_PASSWORD_ENABLE, plugin_config.getBooleanParameter("Tracker Password Enable Web", false));
            plugin_config.setPluginParameter(CONFIG_USER, plugin_config.getStringParameter("Tracker Username", ""));
            plugin_config.setPluginParameter(CONFIG_PASSWORD, plugin_config.getByteParameter("Tracker Password", this.CONFIG_PASSWORD_DEFAULT));
        }
        if (!plugin_config.getPluginBooleanParameter(PROPERTIES_MIGRATED, false)) {
            plugin_config.setPluginParameter(PROPERTIES_MIGRATED, true);
            Properties props = this.plugin_interface.getPluginProperties();
            if (props.getProperty("port", "").length() > 0) {
                save_needed = true;
                String prop_port = props.getProperty("port", "" + this.CONFIG_PORT_DEFAULT);
                String prop_protocol = props.getProperty("protocol", "HTTP");
                String prop_home = props.getProperty("homepage", "index.html");
                String prop_rootdir = props.getProperty("rootdir", "");
                String prop_rootres = props.getProperty("rootresource", this.CONFIG_ROOT_RESOURCE_DEFAULT);
                String prop_mode = props.getProperty("mode", CONFIG_MODE_FULL);
                String prop_access = props.getProperty("access", "all");
                int prop_port_int = this.CONFIG_PORT_DEFAULT;
                try {
                    prop_port_int = Integer.parseInt(prop_port);
                }
                catch (Throwable e) {
                    // empty catch block
                }
                plugin_config.setPluginParameter("Port", prop_port_int);
                plugin_config.setPluginParameter(CONFIG_PROTOCOL, prop_protocol);
                plugin_config.setPluginParameter(CONFIG_HOME_PAGE, prop_home);
                plugin_config.setPluginParameter(CONFIG_ROOT_DIR, prop_rootdir);
                plugin_config.setPluginParameter("Root Resource", prop_rootres);
                plugin_config.setPluginParameter(CONFIG_MODE, prop_mode);
                plugin_config.setPluginParameter(CONFIG_ACCESS, prop_access);
                File props_file = new File(this.plugin_interface.getPluginDirectoryName(), "plugin.properties");
                PrintWriter pw = null;
                try {
                    File backup = new File(this.plugin_interface.getPluginDirectoryName(), "plugin.properties.bak");
                    props_file.renameTo(backup);
                    pw = new PrintWriter(new FileWriter(props_file));
                    pw.println("plugin.class=" + props.getProperty("plugin.class"));
                    pw.println("plugin.name=" + props.getProperty("plugin.name"));
                    pw.println("plugin.version=" + props.getProperty("plugin.version"));
                    pw.println("plugin.id=" + props.getProperty("plugin.id"));
                    pw.println("");
                    pw.println("# configuration has been migrated to plugin config - see view->config->plugins");
                    pw.println("# in the SWT user interface");
                    this.log.logAlert(1, this.plugin_interface.getPluginName() + " - plugin.properties settings migrated to plugin configuration.");
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                    this.log.logAlert(3, this.plugin_interface.getPluginName() + " - plugin.properties settings migration failed.");
                }
                finally {
                    if (pw != null) {
                        pw.close();
                    }
                }
            }
        }
        if (save_needed) {
            plugin_config.save();
        }
        this.config_model.addLabelParameter2("webui.restart.info");
        IntParameter param_port = this.config_model.addIntParameter2("Port", "webui.port", this.CONFIG_PORT_DEFAULT);
        StringListParameter param_protocol = this.config_model.addStringListParameter2(CONFIG_PROTOCOL, "webui.protocol", new String[]{"http", "https"}, "HTTP");
        final BooleanParameter upnp_enable = this.config_model.addBooleanParameter2(CONFIG_UPNP_ENABLE, "webui.upnpenable", true);
        StringParameter param_home = this.config_model.addStringParameter2(CONFIG_HOME_PAGE, "webui.homepage", "index.html");
        StringParameter param_rootdir = this.config_model.addStringParameter2(CONFIG_ROOT_DIR, "webui.rootdir", "");
        StringParameter param_rootres = this.config_model.addStringParameter2("Root Resource", "webui.rootres", this.CONFIG_ROOT_RESOURCE_DEFAULT);
        if (pr_hide_resource_config != null && pr_hide_resource_config.booleanValue()) {
            param_home.setVisible(false);
            param_rootdir.setVisible(false);
            param_rootres.setVisible(false);
        }
        this.config_model.addLabelParameter2("webui.mode.info");
        StringListParameter param_mode = this.config_model.addStringListParameter2(CONFIG_MODE, "webui.mode", new String[]{CONFIG_MODE_FULL, "view"}, CONFIG_MODE_FULL);
        this.config_model.addLabelParameter2("webui.access.info");
        StringParameter param_access = this.config_model.addStringParameter2(CONFIG_ACCESS, "webui.access", "all");
        final BooleanParameter pw_enable = this.config_model.addBooleanParameter2(CONFIG_PASSWORD_ENABLE, "webui.passwordenable", false);
        final StringParameter user_name = this.config_model.addStringParameter2(CONFIG_USER, "webui.user", "");
        final PasswordParameter password = this.config_model.addPasswordParameter2(CONFIG_PASSWORD, "webui.password", 2, this.CONFIG_PASSWORD_DEFAULT);
        pw_enable.addEnabledOnSelection(user_name);
        pw_enable.addEnabledOnSelection(password);
        this.tracker = this.plugin_interface.getTracker();
        this.home_page = param_home.getValue().trim();
        if (this.home_page.length() == 0) {
            this.home_page = null;
        } else if (!this.home_page.startsWith("/")) {
            this.home_page = "/" + this.home_page;
        }
        this.resource_root = param_rootres.getValue().trim();
        if (this.resource_root.length() == 0) {
            this.resource_root = null;
        } else if (this.resource_root.startsWith("/")) {
            this.resource_root = this.resource_root.substring(1);
        }
        String root_dir = param_rootdir.getValue().trim();
        if (root_dir.length() == 0) {
            this.file_root = this.plugin_interface.getPluginDirectoryName();
            if (this.file_root == null) {
                this.file_root = SystemProperties.getUserPath() + "web";
            }
        } else {
            this.file_root = root_dir.startsWith(File.separator) || root_dir.indexOf(":") != -1 ? root_dir : SystemProperties.getUserPath() + "web" + File.separator + root_dir;
        }
        if (!(f_root = new File(this.file_root)).exists()) {
            String error = "WebPlugin: root dir '" + this.file_root + "' doesn't exist";
            this.log.log(3, error);
            throw new PluginException(error);
        }
        if (!f_root.isDirectory()) {
            String error = "WebPlugin: root dir '" + this.file_root + "' isn't a directory";
            this.log.log(3, error);
            throw new PluginException(error);
        }
        welcome_files = new File[welcome_pages.length];
        for (int i = 0; i < welcome_pages.length; ++i) {
            WebPlugin.welcome_files[i] = new File(this.file_root + File.separator + welcome_pages[i]);
        }
        final int port = param_port.getValue();
        String protocol_str = param_protocol.getValue().trim();
        int protocol = protocol_str.equalsIgnoreCase("HTTP") ? 1 : 2;
        this.log.log(1, "Initialisation: port = " + port + ", protocol = " + protocol_str + (root_dir.length() == 0 ? "" : ", root = " + root_dir));
        String access_str = param_access.getValue().trim();
        if (access_str.length() > 7 && Character.isDigit(access_str.charAt(0))) {
            this.ip_range = this.plugin_interface.getIPFilter().createRange(true);
            int sep = access_str.indexOf("-");
            if (sep == -1) {
                this.ip_range.setStartIP(access_str);
                this.ip_range.setEndIP(access_str);
            } else {
                this.ip_range.setStartIP(access_str.substring(0, sep).trim());
                this.ip_range.setEndIP(access_str.substring(sep + 1).trim());
            }
            this.ip_range.checkValid();
            if (!this.ip_range.isValid()) {
                this.log.log(3, "access parameter '" + access_str + "' is invalid");
                this.ip_range = null;
            }
        } else if (access_str.equalsIgnoreCase("all")) {
            this.ip_range_all = true;
        }
        this.log.log(1, "acceptable IP range = " + (this.ip_range == null ? (this.ip_range_all ? "all" : "local") : this.ip_range.getStartIP() + " - " + this.ip_range.getEndIP()));
        try {
            TrackerWebContext context = this.tracker.createWebContext(this.plugin_interface.getAzureusName() + " - " + this.plugin_interface.getPluginName(), port, protocol);
            context.addPageGenerator(this);
            context.addAuthenticationListener(new TrackerAuthenticationAdapter(){
                String last_pw = "";
                byte[] last_hash = new byte[0];
                AEMonitor this_mon = new AEMonitor("WebPlugin:auth");

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public boolean authenticate(URL resource, String user, String pw) {
                    try {
                        this.this_mon.enter();
                        if (!pw_enable.getValue()) {
                            boolean bl = true;
                            return bl;
                        }
                        if (!user.equals(user_name.getValue())) {
                            boolean bl = false;
                            return bl;
                        }
                        byte[] hash = this.last_hash;
                        if (!this.last_pw.equals(pw)) {
                            hash = WebPlugin.this.plugin_interface.getUtilities().getSecurityManager().calculateSHA1(pw.getBytes());
                            this.last_pw = pw;
                            this.last_hash = hash;
                        }
                        boolean bl = Arrays.equals(hash, password.getValue());
                        return bl;
                    }
                    finally {
                        this.this_mon.exit();
                    }
                }
            });
        }
        catch (TrackerException e) {
            this.log.log("Plugin Initialisation Fails", e);
        }
        this.plugin_interface.addListener(new PluginListener(){

            public void initializationComplete() {
                PluginInterface pi_upnp = WebPlugin.this.plugin_interface.getPluginManager().getPluginInterfaceByClass(class$com$aelitis$azureus$plugins$upnp$UPnPPlugin == null ? (class$com$aelitis$azureus$plugins$upnp$UPnPPlugin = WebPlugin.class$("com.aelitis.azureus.plugins.upnp.UPnPPlugin")) : class$com$aelitis$azureus$plugins$upnp$UPnPPlugin);
                if (pi_upnp == null) {
                    WebPlugin.this.log.log("No UPnP plugin available, not attempting port mapping");
                } else if (upnp_enable.getValue()) {
                    ((UPnPPlugin)pi_upnp.getPlugin()).addMapping(WebPlugin.this.plugin_interface.getPluginName(), true, port, true);
                } else {
                    WebPlugin.this.log.log("UPnP disabled for the plugin, not attempting port mapping");
                }
            }

            public void closedownInitiated() {
            }

            public void closedownComplete() {
            }
        });
    }

    public boolean generateSupport(TrackerWebPageRequest request2, TrackerWebPageResponse response) throws IOException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean generate(TrackerWebPageRequest request2, TrackerWebPageResponse response) throws IOException {
        int pos;
        if (!this.ip_range_all) {
            String client = request2.getClientAddress();
            try {
                InetAddress ia = InetAddress.getByName(client);
                if (this.ip_range == null) {
                    if (!ia.isLoopbackAddress()) {
                        this.log.log(3, "Client '" + client + "' is not local, rejecting");
                        return false;
                    }
                } else if (!this.ip_range.isInRange(ia.getHostAddress())) {
                    this.log.log(3, "Client '" + client + "' (" + ia.getHostAddress() + ") is not in range, rejecting");
                    return false;
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
                return false;
            }
        }
        if (request2.getURL().toString().endsWith(".class")) {
            System.out.println("WebPlugin::generate:" + request2.getURL());
        }
        if (this.generateSupport(request2, response)) {
            return true;
        }
        OutputStream os = response.getOutputStream();
        String url = request2.getURL();
        if (url.equals("/")) {
            if (this.home_page != null) {
                url = this.home_page;
            } else {
                for (int i = 0; i < welcome_files.length; ++i) {
                    if (!welcome_files[i].exists()) continue;
                    url = "/" + welcome_pages[i];
                    break;
                }
            }
        }
        if (response.useFile(this.file_root, url)) {
            return true;
        }
        String resource_name = url;
        if (resource_name.startsWith("/")) {
            resource_name = resource_name.substring(1);
        }
        if ((pos = resource_name.lastIndexOf(".")) != -1) {
            String type = resource_name.substring(pos + 1);
            ClassLoader cl = this.plugin_interface.getPluginClassLoader();
            InputStream is = cl.getResourceAsStream(resource_name);
            if (is == null && this.resource_root != null) {
                resource_name = this.resource_root + "/" + resource_name;
                is = cl.getResourceAsStream(resource_name);
            }
            if (is != null) {
                try {
                    response.useStream(type, is);
                }
                finally {
                    is.close();
                }
                return true;
            }
        }
        return false;
    }

    protected BasicPluginConfigModel getConfigModel() {
        return this.config_model;
    }

    protected BasicPluginViewModel getViewModel() {
        return this.view_model;
    }
}

