/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.networkmanager.VirtualChannelSelector;
import com.aelitis.azureus.core.networkmanager.impl.TCPProtocolDecoder;
import com.aelitis.azureus.core.networkmanager.impl.TCPProtocolDecoderAdapter;
import com.aelitis.azureus.core.networkmanager.impl.TCPTransportCipher;
import com.aelitis.azureus.core.networkmanager.impl.TCPTransportHelper;
import com.aelitis.azureus.core.networkmanager.impl.TCPTransportHelperFilter;
import com.aelitis.azureus.core.networkmanager.impl.TCPTransportHelperFilterStreamCipher;
import com.aelitis.azureus.core.networkmanager.impl.TCPTransportHelperFilterStreamXOR;
import com.aelitis.azureus.core.networkmanager.impl.TCPTransportHelperFilterSwitcher;
import com.aelitis.azureus.core.networkmanager.impl.TCPTransportHelperFilterTransparent;
import com.aelitis.azureus.core.util.bloom.BloomFilter;
import com.aelitis.azureus.core.util.bloom.BloomFilterFactory;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.crypto.KeyAgreement;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.SHA1Hasher;
import org.gudy.azureus2.core3.util.SystemTime;

public class TCPProtocolDecoderPHE
extends TCPProtocolDecoder
implements VirtualChannelSelector.VirtualSelectorListener {
    private static final LogIDs LOGID = LogIDs.NWMAN;
    private static final byte CRYPTO_PLAIN = 1;
    private static final byte CRYPTO_RC4 = 2;
    private static final byte CRYPTO_XOR = 4;
    private static final byte CRYPTO_AES = 8;
    private static final String DH_P = "FFFFFFFFFFFFFFFFC90FDAA22168C234C4C6628B80DC1CD129024E088A67CC74020BBEA63B139B22514A08798E3404DDEF9519B3CD3A431B302B0A6DF25F14374FE1356D6D51C245E485B576625E7EC6F44C42E9A63A36210000000000090563";
    private static final String DH_G = "02";
    private static final int DH_L = 160;
    private static final int DH_SIZE_BYTES = "FFFFFFFFFFFFFFFFC90FDAA22168C234C4C6628B80DC1CD129024E088A67CC74020BBEA63B139B22514A08798E3404DDEF9519B3CD3A431B302B0A6DF25F14374FE1356D6D51C245E485B576625E7EC6F44C42E9A63A36210000000000090563".length() / 2;
    private static final BigInteger DH_P_BI = new BigInteger("FFFFFFFFFFFFFFFFC90FDAA22168C234C4C6628B80DC1CD129024E088A67CC74020BBEA63B139B22514A08798E3404DDEF9519B3CD3A431B302B0A6DF25F14374FE1356D6D51C245E485B576625E7EC6F44C42E9A63A36210000000000090563", 16);
    private static final BigInteger DH_G_BI = new BigInteger("02", 16);
    private static KeyPairGenerator dh_key_generator;
    private static long last_dh_incoming_key_generate;
    private static final int BLOOM_RECREATE = 30000;
    private static final int BLOOM_INCREASE = 1000;
    private static BloomFilter generate_bloom;
    private static long generate_bloom_create_time;
    private static boolean crypto_ok;
    private static final String RC4_STREAM_ALG = "RC4";
    private static final String RC4_STREAM_CIPHER = "RC4";
    private static final int RC4_STREAM_KEY_SIZE = 128;
    private static final int RC4_STREAM_KEY_SIZE_BYTES = 16;
    private static final int PADDING_MAX = 512;
    private static final Random random;
    private static Map shared_secrets;
    private static final byte SUPPORTED_PROTOCOLS = 3;
    private static byte MIN_CRYPTO;
    private static VirtualChannelSelector read_selector;
    private static VirtualChannelSelector write_selector;
    private static final int PS_OUTBOUND_1 = 0;
    private static final int PS_OUTBOUND_2 = 1;
    private static final int PS_OUTBOUND_3 = 2;
    private static final int PS_OUTBOUND_4 = 3;
    private static final int PS_INBOUND_1 = 10;
    private static final int PS_INBOUND_2 = 11;
    private static final int PS_INBOUND_3 = 12;
    private static final int PS_INBOUND_4 = 13;
    public static final byte[] KEYA_IV;
    public static final byte[] KEYB_IV;
    public static final byte[] REQ1_IV;
    public static final byte[] REQ2_IV;
    public static final byte[] REQ3_IV;
    public static final byte[] VC;
    private SocketChannel channel;
    private ByteBuffer write_buffer;
    private ByteBuffer read_buffer;
    private TCPProtocolDecoderAdapter adapter;
    private KeyAgreement key_agreement;
    private byte[] dh_public_key_bytes;
    private byte[] shared_secret;
    private byte[] secret_bytes;
    private static final int OUTBOUND_IA = 0;
    private int initial_data_out_len;
    private int initial_data_in_len;
    private TCPTransportCipher write_cipher;
    private TCPTransportCipher read_cipher;
    private byte[] padding_skip_marker;
    private byte my_supported_protocols;
    private byte selected_protocol;
    private boolean outbound;
    private int protocol_state;
    private int protocol_substate;
    private boolean handshake_complete;
    private int bytes_read;
    private int bytes_written;
    private long last_read_time = SystemTime.getCurrentTime();
    private TCPTransportHelperFilter filter;
    private boolean processing_complete;
    private AEMonitor process_mon = new AEMonitor("TCPProtocolDecoder:process");

    public static boolean isCryptoOK() {
        return crypto_ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addSecretSupport(byte[] secret) {
        SHA1Hasher hasher = new SHA1Hasher();
        hasher.update(REQ2_IV);
        hasher.update(secret);
        byte[] encoded = hasher.getDigest();
        Map map = shared_secrets;
        synchronized (map) {
            shared_secrets.put(new HashWrapper(encoded), secret);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeSecretSupport(byte[] secret) {
        SHA1Hasher hasher = new SHA1Hasher();
        hasher.update(REQ2_IV);
        hasher.update(secret);
        byte[] encoded = hasher.getDigest();
        Map map = shared_secrets;
        synchronized (map) {
            shared_secrets.remove(new HashWrapper(encoded));
        }
    }

    public TCPProtocolDecoderPHE(SocketChannel _channel, byte[] _shared_secret, ByteBuffer _header, TCPProtocolDecoderAdapter _adapter) throws IOException {
        super(false);
        if (!TCPProtocolDecoderPHE.isCryptoOK()) {
            throw new IOException("PHE crypto broken");
        }
        this.channel = _channel;
        this.shared_secret = _shared_secret;
        this.adapter = _adapter;
        if (this.shared_secret == null) {
            this.shared_secret = new byte[0];
        }
        boolean bl = this.outbound = _header == null;
        if (this.outbound) {
            this.initial_data_out_len = 0;
        }
        this.my_supported_protocols = (byte)3;
        if (this.outbound) {
            this.my_supported_protocols = MIN_CRYPTO;
        } else if (NetworkManager.REQUIRE_CRYPTO_HANDSHAKE) {
            this.my_supported_protocols = MIN_CRYPTO;
        }
        this.initCrypto();
        read_selector.register(this.channel, this, null);
        write_selector.register(this.channel, this, null);
        write_selector.pauseSelects(this.channel);
        if (this.outbound) {
            this.protocol_state = 0;
            read_selector.pauseSelects(this.channel);
        } else {
            this.protocol_state = 10;
            this.read_buffer = ByteBuffer.allocate(this.dh_public_key_bytes.length);
            this.read_buffer.put(_header);
            this.bytes_read += _header.limit();
        }
        this.process();
    }

    protected void initCrypto() throws IOException {
        try {
            KeyPair key_pair = TCPProtocolDecoderPHE.generateDHKeyPair(this.channel, this.outbound);
            this.key_agreement = KeyAgreement.getInstance("DH");
            this.key_agreement.init(key_pair.getPrivate());
            DHPublicKey dh_public_key = (DHPublicKey)key_pair.getPublic();
            BigInteger dh_y = dh_public_key.getY();
            this.dh_public_key_bytes = this.bigIntegerToBytes(dh_y, DH_SIZE_BYTES);
        }
        catch (Throwable e) {
            throw new IOException(Debug.getNestedExceptionMessage(e));
        }
    }

    protected void completeDH(byte[] buffer) throws IOException {
        try {
            BigInteger other_dh_y = this.bytesToBigInteger(buffer, 0, DH_SIZE_BYTES);
            KeyFactory dh_key_factory = KeyFactory.getInstance("DH");
            PublicKey other_public_key = dh_key_factory.generatePublic(new DHPublicKeySpec(other_dh_y, DH_P_BI, DH_G_BI));
            this.key_agreement.doPhase(other_public_key, true);
            this.secret_bytes = this.key_agreement.generateSecret();
        }
        catch (Throwable e) {
            throw new IOException(Debug.getNestedExceptionMessage(e));
        }
    }

    protected void setupCrypto() throws IOException {
        try {
            SHA1Hasher hasher = new SHA1Hasher();
            hasher.update(KEYA_IV);
            hasher.update(this.secret_bytes);
            hasher.update(this.shared_secret);
            byte[] a_key = hasher.getDigest();
            hasher = new SHA1Hasher();
            hasher.update(KEYB_IV);
            hasher.update(this.secret_bytes);
            hasher.update(this.shared_secret);
            byte[] b_key = hasher.getDigest();
            SecretKeySpec secret_key_spec_a = new SecretKeySpec(a_key, "RC4");
            SecretKeySpec secret_key_spec_b = new SecretKeySpec(b_key, "RC4");
            this.write_cipher = new TCPTransportCipher("RC4", 1, this.outbound ? secret_key_spec_a : secret_key_spec_b);
            this.read_cipher = new TCPTransportCipher("RC4", 2, this.outbound ? secret_key_spec_b : secret_key_spec_a);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new IOException(Debug.getNestedExceptionMessage(e));
        }
    }

    protected void handshakeComplete() throws IOException {
        TCPTransportHelper helper = new TCPTransportHelper(this.channel);
        if (this.selected_protocol == 1) {
            this.filter = new TCPTransportHelperFilterTransparent(helper, true);
        } else if (this.selected_protocol == 4) {
            this.filter = new TCPTransportHelperFilterStreamXOR(helper, this.secret_bytes);
        } else if (this.selected_protocol == 2) {
            this.filter = new TCPTransportHelperFilterStreamCipher(helper, this.read_cipher, this.write_cipher);
        } else {
            throw new IOException("Invalid selected protocol '" + this.selected_protocol + "'");
        }
        if (this.selected_protocol != 2) {
            this.filter = new TCPTransportHelperFilterSwitcher(new TCPTransportHelperFilterStreamCipher(helper, this.read_cipher, this.write_cipher), this.filter, this.initial_data_in_len, this.initial_data_out_len);
        }
        this.handshake_complete = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process() throws IOException {
        try {
            this.process_mon.enter();
            if (this.handshake_complete) {
                Debug.out("Handshake process already completed");
                return;
            }
            boolean loop = true;
            while (loop) {
                block71: {
                    if (this.protocol_state == 0) {
                        if (this.write_buffer == null) {
                            byte[] padding_a = TCPProtocolDecoderPHE.getRandomPadding(256);
                            this.write_buffer = ByteBuffer.allocate(this.dh_public_key_bytes.length + padding_a.length);
                            this.write_buffer.put(this.dh_public_key_bytes);
                            this.write_buffer.put(padding_a);
                            this.write_buffer.flip();
                        }
                        this.write(this.write_buffer);
                        if (!this.write_buffer.hasRemaining()) {
                            this.write_buffer = null;
                            this.protocol_state = 11;
                        }
                    } else if (this.protocol_state == 10) {
                        this.read(this.read_buffer);
                        if (!this.read_buffer.hasRemaining()) {
                            this.read_buffer.flip();
                            byte[] other_dh_public_key_bytes = new byte[this.read_buffer.remaining()];
                            this.read_buffer.get(other_dh_public_key_bytes);
                            this.completeDH(other_dh_public_key_bytes);
                            this.read_buffer = null;
                            this.protocol_state = 1;
                        }
                    } else if (this.protocol_state == 1) {
                        if (this.write_buffer == null) {
                            byte[] padding_b = TCPProtocolDecoderPHE.getRandomPadding(256);
                            this.write_buffer = ByteBuffer.allocate(this.dh_public_key_bytes.length + padding_b.length);
                            this.write_buffer.put(this.dh_public_key_bytes);
                            this.write_buffer.put(padding_b);
                            this.write_buffer.flip();
                        }
                        this.write(this.write_buffer);
                        if (!this.write_buffer.hasRemaining()) {
                            this.write_buffer = null;
                            this.protocol_state = 12;
                        }
                    } else if (this.protocol_state == 11) {
                        if (this.read_buffer == null) {
                            this.read_buffer = ByteBuffer.allocate(this.dh_public_key_bytes.length);
                        }
                        this.read(this.read_buffer);
                        if (!this.read_buffer.hasRemaining()) {
                            this.read_buffer.flip();
                            byte[] other_dh_public_key_bytes = new byte[this.read_buffer.remaining()];
                            this.read_buffer.get(other_dh_public_key_bytes);
                            this.completeDH(other_dh_public_key_bytes);
                            this.setupCrypto();
                            this.read_buffer = null;
                            this.protocol_state = 2;
                        }
                    } else if (this.protocol_state == 2) {
                        if (this.write_buffer == null) {
                            byte[] padding_a = TCPProtocolDecoderPHE.getRandomPadding(256);
                            byte[] padding_c = TCPProtocolDecoderPHE.getZeroPadding();
                            this.write_buffer = ByteBuffer.allocate(padding_a.length + 20 + 20 + (VC.length + 4 + 2 + padding_c.length + 2));
                            this.write_buffer.put(padding_a);
                            SHA1Hasher hasher = new SHA1Hasher();
                            hasher.update(REQ1_IV);
                            hasher.update(this.secret_bytes);
                            byte[] sha1 = hasher.getDigest();
                            this.write_buffer.put(sha1);
                            hasher = new SHA1Hasher();
                            hasher.update(REQ2_IV);
                            hasher.update(this.shared_secret);
                            byte[] sha1_1 = hasher.getDigest();
                            hasher = new SHA1Hasher();
                            hasher.update(REQ3_IV);
                            hasher.update(this.secret_bytes);
                            byte[] sha1_2 = hasher.getDigest();
                            for (int i = 0; i < sha1_1.length; ++i) {
                                int n = i;
                                sha1_1[n] = (byte)(sha1_1[n] ^ sha1_2[i]);
                            }
                            this.write_buffer.put(sha1_1);
                            this.write_buffer.put(this.write_cipher.update(VC));
                            this.write_buffer.put(this.write_cipher.update(new byte[]{0, 0, 0, this.my_supported_protocols}));
                            this.write_buffer.put(this.write_cipher.update(new byte[]{(byte)(padding_c.length >> 8), (byte)padding_c.length}));
                            this.write_buffer.put(this.write_cipher.update(padding_c));
                            this.write_buffer.put(this.write_cipher.update(new byte[]{(byte)(this.initial_data_out_len >> 8), (byte)this.initial_data_out_len}));
                            this.write_buffer.flip();
                        }
                        this.write(this.write_buffer);
                        if (!this.write_buffer.hasRemaining()) {
                            this.write_buffer = null;
                            this.protocol_state = 13;
                        }
                    } else if (this.protocol_state == 12) {
                        if (this.read_buffer == null) {
                            this.read_buffer = ByteBuffer.allocate(532);
                            this.read_buffer.limit(20);
                            SHA1Hasher hasher = new SHA1Hasher();
                            hasher.update(REQ1_IV);
                            hasher.update(this.secret_bytes);
                            this.padding_skip_marker = hasher.getDigest();
                            this.protocol_substate = 1;
                        }
                        while (true) {
                            this.read(this.read_buffer);
                            if (this.read_buffer.hasRemaining()) break block71;
                            if (this.protocol_substate == 1) {
                                int limit = this.read_buffer.limit();
                                this.read_buffer.position(limit - 20);
                                boolean match = true;
                                for (int i = 0; i < 20; ++i) {
                                    if (this.read_buffer.get() == this.padding_skip_marker[i]) continue;
                                    match = false;
                                    break;
                                }
                                if (match) {
                                    this.read_buffer = ByteBuffer.allocate(20 + VC.length + 4 + 2);
                                    this.protocol_substate = 2;
                                    break block71;
                                }
                                if (limit == this.read_buffer.capacity()) {
                                    throw new IOException("PHE skip to SHA1 marker failed");
                                }
                                this.read_buffer.limit(limit + 1);
                                this.read_buffer.position(limit);
                                continue;
                            }
                            if (this.protocol_substate == 2) {
                                this.read_buffer.flip();
                                byte[] decode = new byte[20];
                                this.read_buffer.get(decode);
                                SHA1Hasher hasher = new SHA1Hasher();
                                hasher.update(REQ3_IV);
                                hasher.update(this.secret_bytes);
                                byte[] sha1 = hasher.getDigest();
                                for (int i = 0; i < decode.length; ++i) {
                                    int n = i;
                                    decode[n] = (byte)(decode[n] ^ sha1[i]);
                                }
                                Map i = shared_secrets;
                                synchronized (i) {
                                    this.shared_secret = (byte[])shared_secrets.get(new HashWrapper(decode));
                                }
                                if (this.shared_secret == null) {
                                    throw new IOException("No matching shared secret");
                                }
                                this.setupCrypto();
                                byte[] crypted = new byte[VC.length + 4 + 2];
                                this.read_buffer.get(crypted);
                                byte[] plain = this.read_cipher.update(crypted);
                                byte other_supported_protocols = plain[VC.length + 3];
                                int common_protocols = this.my_supported_protocols & other_supported_protocols;
                                if ((common_protocols & 1) != 0) {
                                    this.selected_protocol = 1;
                                } else if ((common_protocols & 4) != 0) {
                                    this.selected_protocol = (byte)4;
                                } else if ((common_protocols & 2) != 0) {
                                    this.selected_protocol = (byte)2;
                                } else if ((common_protocols & 8) != 0) {
                                    this.selected_protocol = (byte)8;
                                } else {
                                    throw new IOException("No crypto protocol in common: mine = " + Integer.toHexString(this.my_supported_protocols) + ", theirs = " + Integer.toHexString(other_supported_protocols));
                                }
                                int padding = ((plain[VC.length + 4] & 0xFF) << 8) + (plain[VC.length + 5] & 0xFF);
                                if (padding > 512) {
                                    throw new IOException("Invalid padding '" + padding + "'");
                                }
                                this.read_buffer = ByteBuffer.allocate(padding + 2);
                                this.protocol_substate = 3;
                                continue;
                            }
                            if (this.protocol_substate == 3) break;
                        }
                        this.read_buffer.flip();
                        byte[] data = new byte[this.read_buffer.remaining()];
                        this.read_buffer.get(data);
                        data = this.read_cipher.update(data);
                        int ia_len = 0xFFFF & ((data[data.length - 2] & 0xFF) << 8) + (data[data.length - 1] & 0xFF);
                        if (ia_len > 65535) {
                            throw new IOException("Invalid IA length '" + ia_len + "'");
                        }
                        this.initial_data_in_len = ia_len;
                        this.read_buffer = null;
                        this.protocol_state = 3;
                    } else if (this.protocol_state == 3) {
                        if (this.write_buffer == null) {
                            byte[] padding_b = TCPProtocolDecoderPHE.getRandomPadding(256);
                            byte[] padding_d = TCPProtocolDecoderPHE.getZeroPadding();
                            this.write_buffer = ByteBuffer.allocate(padding_b.length + VC.length + 4 + 2 + padding_d.length);
                            this.write_buffer.put(padding_b);
                            this.write_buffer.put(this.write_cipher.update(VC));
                            this.write_buffer.put(this.write_cipher.update(new byte[]{0, 0, 0, this.selected_protocol}));
                            this.write_buffer.put(this.write_cipher.update(new byte[]{(byte)(padding_d.length >> 8), (byte)padding_d.length}));
                            this.write_buffer.put(this.write_cipher.update(padding_d));
                            this.write_buffer.flip();
                        }
                        this.write(this.write_buffer);
                        if (!this.write_buffer.hasRemaining()) {
                            this.write_buffer = null;
                            this.handshakeComplete();
                        }
                    } else if (this.protocol_state == 13) {
                        if (this.read_buffer == null) {
                            this.read_buffer = ByteBuffer.allocate(VC.length + 512);
                            this.read_buffer.limit(VC.length);
                            this.padding_skip_marker = new byte[VC.length];
                            this.padding_skip_marker = this.read_cipher.update(this.padding_skip_marker);
                            this.protocol_substate = 1;
                        }
                        while (true) {
                            this.read(this.read_buffer);
                            if (this.read_buffer.hasRemaining()) break block71;
                            if (this.protocol_substate == 1) {
                                int limit = this.read_buffer.limit();
                                this.read_buffer.position(limit - VC.length);
                                boolean match = true;
                                for (int i = 0; i < VC.length; ++i) {
                                    if (this.read_buffer.get() == this.padding_skip_marker[i]) continue;
                                    match = false;
                                    break;
                                }
                                if (match) {
                                    this.read_buffer = ByteBuffer.allocate(6);
                                    this.protocol_substate = 2;
                                    break block71;
                                }
                                if (limit == this.read_buffer.capacity()) {
                                    throw new IOException("PHE skip to SHA1 marker failed");
                                }
                                this.read_buffer.limit(limit + 1);
                                this.read_buffer.position(limit);
                                continue;
                            }
                            if (this.protocol_substate == 2) {
                                this.read_buffer.flip();
                                byte[] crypted = new byte[6];
                                this.read_buffer.get(crypted);
                                byte[] plain = this.read_cipher.update(crypted);
                                this.selected_protocol = plain[3];
                                if ((this.selected_protocol & this.my_supported_protocols) == 0) {
                                    throw new IOException("Selected protocol has nothing in common: mine = " + Integer.toHexString(this.my_supported_protocols) + ", theirs = " + Integer.toHexString(this.selected_protocol));
                                }
                                int pad_len = 0xFFFF & ((plain[4] & 0xFF) << 8) + (plain[5] & 0xFF);
                                if (pad_len > 65535) {
                                    throw new IOException("Invalid pad length '" + pad_len + "'");
                                }
                                this.read_buffer = ByteBuffer.allocate(pad_len);
                                this.protocol_substate = 3;
                                continue;
                            }
                            if (this.protocol_substate == 3) break;
                        }
                        this.read_buffer.flip();
                        byte[] data = new byte[this.read_buffer.remaining()];
                        this.read_buffer.get(data);
                        data = this.read_cipher.update(data);
                        this.handshakeComplete();
                        this.read_buffer = null;
                    }
                }
                if (this.handshake_complete) {
                    read_selector.cancel(this.channel);
                    write_selector.cancel(this.channel);
                    loop = false;
                    this.complete();
                    continue;
                }
                if (this.read_buffer == null) {
                    read_selector.pauseSelects(this.channel);
                } else {
                    read_selector.resumeSelects(this.channel);
                    loop = false;
                }
                if (this.write_buffer == null) {
                    write_selector.pauseSelects(this.channel);
                    continue;
                }
                write_selector.resumeSelects(this.channel);
                loop = false;
            }
        }
        catch (Throwable e) {
            this.failed(e);
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(Debug.getNestedExceptionMessage(e));
        }
        finally {
            this.process_mon.exit();
        }
    }

    protected void read(ByteBuffer buffer) throws IOException {
        int len = this.channel.read(buffer);
        if (len < 0) {
            throw new IOException("end of stream on socket read - phe: " + this.getString());
        }
        this.bytes_read += len;
    }

    protected void write(ByteBuffer buffer) throws IOException {
        int len = this.channel.write(buffer);
        if (len < 0) {
            throw new IOException("bytes written < 0 ");
        }
        this.bytes_written += len;
    }

    public boolean selectSuccess(VirtualChannelSelector selector, SocketChannel sc, Object attachment) {
        try {
            boolean progress;
            int old_bytes_read = this.bytes_read;
            this.process();
            if (selector == write_selector) {
                return true;
            }
            boolean bl = progress = this.bytes_read != old_bytes_read;
            if (progress) {
                this.last_read_time = SystemTime.getCurrentTime();
            }
            return progress;
        }
        catch (Throwable e) {
            this.failed(e);
            return false;
        }
    }

    public void selectFailure(VirtualChannelSelector selector, SocketChannel sc, Object attachment, Throwable msg) {
        this.failed(msg);
    }

    protected byte[] bigIntegerToBytes(BigInteger bi, int num_bytes) {
        String str = bi.toString(16);
        while (str.length() < num_bytes * 2) {
            str = "0" + str;
        }
        return ByteFormatter.decodeString(str);
    }

    protected BigInteger bytesToBigInteger(byte[] bytes, int offset, int len) {
        return new BigInteger(ByteFormatter.encodeString(bytes, offset, len), 16);
    }

    protected static synchronized byte[] getRandomPadding(int max_len) {
        byte[] bytes = new byte[random.nextInt(max_len)];
        random.nextBytes(bytes);
        return bytes;
    }

    protected static synchronized byte[] getZeroPadding() {
        byte[] bytes = new byte[random.nextInt(512)];
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static KeyPair generateDHKeyPair(SocketChannel channel, boolean outbound) throws IOException {
        KeyPairGenerator keyPairGenerator = dh_key_generator;
        synchronized (keyPairGenerator) {
            if (!outbound) {
                int hit_count = generate_bloom.add(channel.socket().getInetAddress().getAddress());
                long now = SystemTime.getCurrentTime();
                if (generate_bloom.getSize() / generate_bloom.getEntryCount() < 10) {
                    generate_bloom = BloomFilterFactory.createAddRemove4Bit(generate_bloom.getSize() + 1000);
                    generate_bloom_create_time = now;
                    Logger.log(new LogEvent(LOGID, "PHE bloom: size increased to " + generate_bloom.getSize()));
                } else if (now < generate_bloom_create_time || now - generate_bloom_create_time > 30000L) {
                    generate_bloom = BloomFilterFactory.createAddRemove4Bit(generate_bloom.getSize());
                    generate_bloom_create_time = now;
                }
                if (hit_count >= 15) {
                    Logger.log(new LogEvent(LOGID, "PHE bloom: too many recent connection attempts from " + channel.socket().getInetAddress()));
                    throw new IOException("Too many recent connection attempts (phe)");
                }
                long since_last = now - last_dh_incoming_key_generate;
                long delay = 100L - since_last;
                if (delay > 0L && delay < 100L) {
                    try {
                        Thread.sleep(delay);
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                }
                last_dh_incoming_key_generate = now;
            }
            KeyPair res = dh_key_generator.generateKeyPair();
            return res;
        }
    }

    protected void complete() {
        this.processing_complete = true;
        this.adapter.decodeComplete(this);
    }

    protected void failed(Throwable cause) {
        this.processing_complete = true;
        read_selector.cancel(this.channel);
        write_selector.cancel(this.channel);
        this.adapter.decodeFailed(this, cause);
    }

    public boolean isComplete(long now) {
        return this.processing_complete;
    }

    public TCPTransportHelperFilter getFilter() {
        return this.filter;
    }

    public long getLastReadTime() {
        long now = SystemTime.getCurrentTime();
        if (this.last_read_time > now) {
            this.last_read_time = now;
        }
        return this.last_read_time;
    }

    public String getString() {
        return "state=" + this.protocol_state + ",sub=" + this.protocol_substate + ",in=" + this.bytes_read + ",out=" + this.bytes_written;
    }

    public SocketChannel getChannel() {
        return this.channel;
    }

    static {
        generate_bloom = BloomFilterFactory.createAddRemove4Bit(1000);
        generate_bloom_create_time = SystemTime.getCurrentTime();
        random = new SecureRandom();
        shared_secrets = new HashMap();
        try {
            DHParameterSpec dh_param_spec = new DHParameterSpec(DH_P_BI, DH_G_BI, 160);
            dh_key_generator = KeyPairGenerator.getInstance("DH");
            dh_key_generator.initialize(dh_param_spec);
            dh_key_generator.generateKeyPair();
            byte[] rc4_test_secret = new byte[16];
            SecretKeySpec rc4_test_secret_key_spec = new SecretKeySpec(rc4_test_secret, 0, 16, "RC4");
            TCPTransportCipher rc4_cipher = new TCPTransportCipher("RC4", 1, rc4_test_secret_key_spec);
            rc4_cipher = new TCPTransportCipher("RC4", 2, rc4_test_secret_key_spec);
            crypto_ok = true;
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "PHE crypto initialised"));
            }
        }
        catch (NoClassDefFoundError e) {
            Logger.log(new LogEvent(LOGID, "PHE crypto disabled as classes unavailable"));
            crypto_ok = false;
        }
        catch (Throwable e) {
            Logger.log(new LogEvent(LOGID, "PHE crypto initialisation failed", e));
            crypto_ok = false;
        }
        COConfigurationManager.addAndFireParameterListeners(new String[]{"network.transport.encrypted.min_level"}, new ParameterListener(){

            public void parameterChanged(String ignore) {
                String min;
                if (NetworkManager.REQUIRE_CRYPTO_HANDSHAKE && !TCPProtocolDecoderPHE.isCryptoOK()) {
                    Logger.log(new LogAlert(true, 3, "Connection encryption unavailable, please update your Java version"));
                }
                if ((min = COConfigurationManager.getStringParameter("network.transport.encrypted.min_level")).equals("XOR")) {
                    MIN_CRYPTO = (byte)14;
                } else if (min.equals("RC4")) {
                    MIN_CRYPTO = (byte)10;
                } else if (min.equals("AES")) {
                    MIN_CRYPTO = (byte)8;
                } else {
                    MIN_CRYPTO = (byte)15;
                }
                MIN_CRYPTO = (byte)(MIN_CRYPTO & 3);
            }
        });
        read_selector = NetworkManager.getSingleton().getReadSelector();
        write_selector = NetworkManager.getSingleton().getWriteSelector();
        KEYA_IV = "keyA".getBytes();
        KEYB_IV = "keyB".getBytes();
        REQ1_IV = "req1".getBytes();
        REQ2_IV = "req2".getBytes();
        REQ3_IV = "req3".getBytes();
        VC = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
    }
}

