/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.messaging.advanced;

import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.MessageException;
import com.aelitis.azureus.core.peermanager.messaging.advanced.ADVMessage;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.DirectByteBufferPool;

public class ADVHandshake
implements ADVMessage {
    private DirectByteBuffer buffer = null;
    private String description = null;

    private void constructBuffer() {
        this.buffer = DirectByteBufferPool.getBuffer((byte)16, 68);
    }

    public String getID() {
        return "ADV_HANDSHAKE";
    }

    public String getFeatureID() {
        return "ADV1";
    }

    public int getFeatureSubID() {
        return 0;
    }

    public int getType() {
        return 0;
    }

    public String getDescription() {
        if (this.description == null) {
            this.description = this.getID();
        }
        return this.description;
    }

    public DirectByteBuffer[] getData() {
        if (this.buffer == null) {
            this.constructBuffer();
        }
        return new DirectByteBuffer[]{this.buffer};
    }

    public Message deserialize(DirectByteBuffer data) throws MessageException {
        if (data == null) {
            throw new MessageException("[" + this.getID() + "] decode error: data == null");
        }
        if (data.remaining((byte)11) != 68) {
            throw new MessageException("[" + this.getID() + "] decode error: payload.remaining[" + data.remaining((byte)11) + "] != 68");
        }
        byte[] reserved = new byte[8];
        data.get((byte)11, reserved);
        byte[] infohash = new byte[20];
        data.get((byte)11, infohash);
        byte[] peerid = new byte[20];
        data.get((byte)11, peerid);
        data.returnToPool();
        return new ADVHandshake();
    }

    public void destroy() {
        if (this.buffer != null) {
            this.buffer.returnToPool();
        }
    }
}

